package com.ibm.able.examples.rules;
import java.io.*;


//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.rules
//
// (C) Copyright IBM Corp. 2001 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================


public class SANSystemDefinition implements Serializable {

  static final long    serialVersionUID = 1999100100000000001L;
  static final String  Copyright = "(C) Copyright IBM Corporation, 1999. All rights reserved. ";

  static int number = 0 ;

  protected String  name ;
  protected Integer id ;          // unique integer identifier
  protected String  QoS ;         // used to call approprate fuzzy rule set
  protected double allocation ;  // passed into fuzzy set
  protected double utilization ; // (% of allocation) passed into fuzzy set
  protected String  lastRecommendation ; // last fuzzy set action
  protected String  lastAction ;   // last SAN manager action

  public SANSystemDefinition() {
      name = "System" + number++ ;
  }

  public String getName() { return name ; }

  public void setSystemId(Integer theId) { id = theId; }
  public Integer getSystemId() { return id; }

  public String getQoS() { return QoS ; }

  public void setQoS(String val) { QoS = val; }

  public double getAllocation() { return allocation; }

  public void setAllocation(double val) { allocation = val; }

  public double getUtilization() { return utilization; }

  public void setUtilization(double val) { utilization = val; }

  public String getLastRecommendation() { return lastRecommendation; }

  public void setLastRecommendation(String val) { lastRecommendation =  val ; }

  public String getLastAction() { return lastAction; }

  public void setLastAction(String val) { lastAction =  val ; }

  public String toString() {
     StringBuffer buf = new StringBuffer(name + ": " + id) ;
     buf.append( " " + QoS ) ;
     buf.append( " alloc=" + allocation) ;
     buf.append( " util=" + utilization) ;
     buf.append( " " + lastRecommendation) ;
     buf.append( " " + lastAction) ;

     return buf.toString();
 
  }

}
