package com.ibm.able.examples.rules;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.rules
//
// (C) Copyright IBM Corp. 2001 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
import java.io.Serializable;

import com.ibm.able.Able;

/**
 * A ring has a name, diameter, and is on a post identified by a number.
 * @version  $Revision: 1.5 $, $Date: 2002/06/13 17:24:11 $
 */
public class Ring implements Serializable {
   /**
    * Serialized version identifier in form       YYYYMMDDVerRelModxx
    */
   static final long serialVersionUID = 2001100500100300000L;

   String name;
   int diam;
   int onPost;

   public Ring() {
      this.name = "AnonymousRing!";
   }

   public Ring(String name) {
      this.name = name;
   }

   public Ring(String name, int diam, int onPost) {
      this.name = name;
      this.diam = diam;
      this.onPost = onPost;
   }

   public void setDiam(int diam) {
      this.diam = diam;
   }
   public int getDiam() {
      return diam;
   }

   public void setOnPost(int onPost) {
      this.onPost = onPost;
   }
   public int getOnPost() {
      return onPost;
   }

   public String toString() {
      return name + "=(diam=" + diam + " onPost=" + onPost + ")";
   }
   /**
    * Determine the copyright of this class.
    *
    * @return    A String containing this class's copyright statement.
    *            <p>
    */
   private static String Copyright() {
      return Able.Copyright;
   }

}
