package com.ibm.able.examples.rules;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.rules
//
// (C) Copyright IBM Corp. 2001 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
import java.io.Serializable;

import com.ibm.able.Able;

/**
 * A Puzzle has a name, level, phase, and three posts.
 * @version  $Revision: 1.5 $, $Date: 2002/06/13 17:24:11 $
 */

public class Puzzle implements Serializable {
   /**
    * Serialized version identifier in form       YYYYMMDDVerRelModxx
    */
   static final long serialVersionUID = 2001100500100300000L;

   String name;
   int level;
   int phase;
   int sourcePost;
   int otherPost;
   int sinkPost;

   public Puzzle() {
      this.name = "AnonymousPuzzle!";
   }

   public Puzzle(String name) {
      this.name = name;
   }

   public Puzzle(String name, int level, int phase) {
      this.name = name;
      this.level = level;
      this.phase = phase;
   }

   public Puzzle(
      String name,
      int level,
      int phase,
      int sourcePost,
      int otherPost,
      int sinkPost) {
      this.name = name;
      this.level = level;
      this.phase = phase;
      this.sourcePost = sourcePost;
      this.otherPost = otherPost;
      this.sinkPost = sinkPost;
   }

   public void setLevel(int level) {
      this.level = level;
   }
   public int getLevel() {
      return level;
   }

   public void setPhase(int phase) {
      this.phase = phase;
   }
   public int getPhase() {
      return phase;
   }

   public void setSourcePost(int sourcePost) {
      this.sourcePost = sourcePost;
   }
   public int getSourcePost() {
      return sourcePost;
   }

   public void setOtherPost(int otherPost) {
      this.otherPost = otherPost;
   }
   public int getOtherPost() {
      return otherPost;
   }

   public void setSinkPost(int sinkPost) {
      this.sinkPost = sinkPost;
   }
   public int getSinkPost() {
      return sinkPost;
   }

   public String toString() {
      return name
         + "=(lvl="
         + level
         + " phase="
         + phase
         + " srcPost="
         + sourcePost
         + " otherPost="
         + otherPost
         + " sinkPost="
         + sinkPost
         + ")";
   }

   /**
    * Determine the copyright of this class.
    *
    * @return    A String containing this class's copyright statement.
    *            <p>
    */
   private static String Copyright() {
      return Able.Copyright;
   }

}
