package com.ibm.able.examples.rules;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.rules
//
// (C) Copyright IBM Corp. 2003 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
import java.io.Serializable;
import java.util.Random;


/**
 * This class contains a method that is used to calculate a Business
 * Value dynamically, based on current conditions and input.
 * Naturally, you would need to add your own specific business logic
 * here.
 *
 * <p> The method is referenced in <b>PolicyDemo.arl</b>.
 *
 * @version  $Revision: 1.1 $, $Date: 2003/11/25 17:26:54 $
 */
public class PolicyDemoBusinessValueCalculator extends Object implements Serializable {
  //                                   YYYYMMDDVerRelModxx
  static final long serialVersionUID = 2003111400100100000L;

  //==================================================================
  //
  // Class variables.
  //
  //==================================================================
  static private Random myRandom = new Random();


  //==================================================================
  //
  // Class methods.
  //
  //==================================================================
  /**
   * Calculates and returns a business value.
   *
   * @param     thePolicySection
   *            The name of the currently triggered PolicySection.
   * @param     thePolicyId
   *            The ElementId of the Policy currently under
   *            evaluation and which is in the specified
   *            PolicySection.
   * @param     theNumberOfServersInvolved
   *            The number of servers involved with the current
   *            consideration.
   * @return    The business value to use.
   */
  public static Double calcBV(String thePolicySection, String thePolicyId, Integer theNumberOfServersInvolved) {
    Double returnBV = new Double( randomInt() );
    System.out.println("BVC: Calculated business value for <" + thePolicySection +"/"+ thePolicyId + "/Servers=" + theNumberOfServersInvolved + "> is " + returnBV + ".");
    return returnBV;
  }


  // Return a random integer between 0 (inclusive) and 100
  // (inclusive).
  private static int randomInt() {
    return myRandom.nextInt(101);
  }

  // Return a random integer between 0 (inclusive) and the specified
  // number (exclusive).
  private static int randomInt(int theInt) {
    return myRandom.nextInt(theInt);
  }


  //==================================================================
  //
  // Constructos.
  //
  //==================================================================
  public PolicyDemoBusinessValueCalculator() {}

}
