package com.ibm.able.examples.rules;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.rules
//
// (C) Copyright IBM Corp. 2001 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
import com.ibm.able.Able;
import com.ibm.able.AbleLogger;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.rules.AbleClauseReferences;
import com.ibm.able.rules.AbleInferenceEngine;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleSet;

/**
 * This class extends the AbleInferenceEngine class so that it 
 * can be used as a customized pluggable inference engine. 
 * It can be used in any AbleRuleSet by specifying 
 * " using com.ibm.able.examples.rules.PluggableEngine" on the ruleblock
 * definition. 
 *
 * @version  $Revision: 1.4 $, $Date: 2001/09/27 20:59:15 $
 */
public class PluggableEngine extends AbleInferenceEngine {
   //==================================================================
   //
   // Class Variables
   //
   //==================================================================
   static final long serialVersionUID = 2000083100000000001L;

   //==================================================================
   //
   // Instance Variables
   //
   //==================================================================

   //==================================================================
   //
   // Constructors
   //
   //==================================================================
   /**
    * <b>Create</b> a new inference engine.
    *
    * @param     theRuleSet
    *            A ruleset whose context is used for inferencing
    *            by this inference engine.
    *            <p>
    * @param     theTracer
    *            A tracer object to which this inference engine can log
    *            information. This may be <i>null</i>, in which case no
    *            information is logged.
    *            <p>
    * @param     theRuleBlock
    *            A ruleblock whose rules are to be used for inferencing
    *            by this inference engine.
    *            <p>
    *
    */
   public PluggableEngine(
      AbleRuleSet theRuleSet,
      AbleLogger theTracer,
      AbleRuleBlock theRuleBlock) {
      super(theRuleSet, theTracer, theRuleBlock);
      System.out.println("CustomEngine instance created!");
   }

   //==================================================================
   //
   // Methods specific to this class (public)
   //
   //==================================================================
   /**
    * Make sure the current ruleblock is "executable" by this inference engine.
    * <p>
    *
    * Here is the place where the custom engine examines the rules
    * the user coded in this ruleblock to see if they are acceptable
    * for processing by this engine.  In this example, we simply 
    * say whatever they pass is ok for us since we are going to ignore 
    * all but assertions anyway.   
    *
    * @return    <i>true</i>,  if the ruleset is OK;
    *            <i>false</i>, if the ruleset is not executable.
    */
   public boolean isRuleBlockValid(AbleRuleBlock theRuleBlock) {
      //String lclRbName = theRuleBlock.getName();
      boolean lclReturnValue = true;

      return lclReturnValue;
   }

   /**
    * Fire the rules in the ruleset in sequential order.
    *
    * <p> The order of processing is as follows:
    * <ol>  
    * <li> All rules in the ruleblock are fired sequentially.
    * </ol>
    *
    * @param    theRuleBlock
    *            The ruleblock used by this inference engine.
    *            <p>
    * @exception AbleDataException
    *            When any error occurs.
    *
    */
   public void infer(AbleRuleBlock theRuleBlock) throws AbleDataException {

      AbleRuleBlock lclRuleBlock = theRuleBlock;

      myWorkingMemory = myRuleSet.getWorkingMemory();

      //----------------------------------------------------------------
      // Process the  rule block's rules in sequential order.
      //----------------------------------------------------------------
      if (lclRuleBlock != null) {
         processRuleBlock(lclRuleBlock);
      }

   }

   /**
    * Re-evaluate, if necessary, the specified clauses that contain a
    * reference to a variable whose current value has just changed.
    * This engine processes only antecedent clauses.
    *
    * @param     theClauseReferences
    *            A collection of clauses that reference some variable
    *            whose current value has just changed.
    *            <p>
    */
   public void reevaluateClausesWithChangedVariable(AbleClauseReferences theClauseReferences)
      throws AbleDataException {
      // do nothing in this case
   }

   /**
    *  Set the specified control parameter on this inference engine. 
    *  Both the parameter name and value must be validated in this method. 
    * 
    */
   public void setControlParameter(String theControlParameter, Object theValue)
      throws AbleDataException {
      // nothing to set 
   }

   /**
    *  Get the specified control parameter on this inference engine. 
    * 
    */
   public Object getControlParameter(String theControlParameter)
      throws AbleDataException {
      return null;
      // nothing to get 
   }

   //==================================================================
   //
   // Additional Methods.
   //
   //==================================================================

   /**
    * Determine the copyright of this class.
    *
    * @return    A String containing this class's copyright statement.
    *
    */
   private static String Copyright() {
      return Able.Copyright;
   }

}
