package com.ibm.able.examples.rules;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.rules
//
// (C) Copyright IBM Corp. 2001 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
import java.io.Serializable;

import com.ibm.able.Able;

/**
 * A monkey has a location, is on top of an object, and can hold
 * an object.
 * @version  $Revision: 1.4 $, $Date: 2001/09/27 20:59:15 $
 */

public class Monkey implements Serializable {

   /**
    * Serialized version identifier in form       YYYYMMDDVerRelModxx
    */
   static final long serialVersionUID = 2001100500100300000L;
   String location = "green-couch";
   String onTopOf = "floor";
   String holding = "blank";

   public Monkey() {
   }

   public Monkey(String location, String onTopOf, String holding) {
      this.location = location;
      this.onTopOf = onTopOf;
      this.holding = holding;
   }

   public String getLocation() {
      return location;
   }
   public void setLocation(String location) {
      this.location = location;
   }

   public String getOnTopOf() {
      return onTopOf;
   }
   public void setOnTopOf(String onTopOf) {
      this.onTopOf = onTopOf;
   }

   public String getHolding() {
      return holding;
   }
   public void setHolding(String holding) {
      this.holding = holding;
   }

   public String toString() {
      return "monkey=(location="
         + location
         + " onTopOf="
         + onTopOf
         + " holding="
         + holding
         + ")";
   }
   /**
    * Determine the copyright of this class.
    *
    * @return    A String containing this class's copyright statement.
    *            <p>
    */
   private static String Copyright() {
      return Able.Copyright;
   }

}
