package com.ibm.able.examples.rules;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.rules
//
// (C) Copyright IBM Corp. 2001 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
import java.io.Serializable;

import com.ibm.able.Able;

/**
 * A Grocery item has a name, a containerType, a size, can be frozen, 
 * can require insulation, and knows which bag in which its been placed.
 * @version  $Revision: 1.6 $, $Date: 2002/02/13 21:14:52 $
 */
public class Grocery implements Serializable {

   /**
    * Serialized version identifier in form       YYYYMMDDVerRelModxx
    */
   static final long serialVersionUID = 2001100500100300000L;
   // protected so ruleset can use object.member notation instead of bulkier object.getMember()
   protected String name;
   protected String containerType;
   protected String size;
   protected boolean frozen = false;
   protected boolean insulated = false;
   protected int bag = -1; // -1 means it has not been bagged yet

   public Grocery() {
   }

   public Grocery(
      String name,
      String containerType,
      String size,
      String frozen) {
      this.name = name;
      this.containerType = containerType;
      this.size = size;
      this.frozen = frozen.equalsIgnoreCase("yes");
   }

   public String getName() {
      return name;
   }
   public void setName(String name) {
      this.name = name;
   }

   public String getContainerType() {
      return containerType;
   }
   public void setContainerType(String containerType) {
      this.containerType = containerType;
   }

   public String getSize() {
      return size;
   }
   public void setSize(String size) {
      this.size = size;
   }

   public boolean getFrozen() {
      return frozen;
   }
   public void setFrozen(String frozen) {
      this.frozen = frozen.equalsIgnoreCase("yes");
   }

   public boolean getInsulated() {
      return insulated;
   }
   public void setInsulated(boolean insulated) {
      this.insulated = insulated;
   }

   public int getBag() {
      return bag;
   }
   public void setBag(int bag) {
      this.bag = bag;
   }

   public String toString() {
      return name
         + "=(container="
         + containerType
         + " size="
         + size
         + " frozen="
         + frozen
         + " insulated="
         + insulated
         + " bag="
         + bag
         + ")";
   }
   /**
    * Determine the copyright of this class.
    *
    * @return    A String containing this class's copyright statement.
    *            <p>
    */
   private static String Copyright() {
      return Able.Copyright;
   }

}
