package com.ibm.able.examples.rules;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.rules
//
// (C) Copyright IBM Corp. 2001 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
import java.io.Serializable;

import com.ibm.able.Able;

/**
 * Goal  (goal-is-to) in monkeys-and-bananas world
 * @version  $Revision: 1.4 $, $Date: 2001/09/27 20:59:15 $
 */
public class Goal implements Serializable {

   /**
    * Serialized version identifier in form       YYYYMMDDVerRelModxx
    */
   static final long serialVersionUID = 2001100500100300000L;
   String action;
   String argument1;
   String argument2;

   public Goal() {
   }

   public Goal(String action, String argument1) {
      this.action = action;
      this.argument1 = argument1;
   }

   public Goal(String action, String argument1, String argument2) {
      this.action = action;
      this.argument1 = argument1;
      this.argument2 = argument2;
   }

   public String getAction() {
      return action;
   }
   public void setAction(String action) {
      this.action = action;
   }

   public String getArgument1() {
      return argument1;
   }
   public void setArgument1(String argument1) {
      this.argument1 = argument1;
   }

   public String getArgument2() {
      return argument2;
   }
   public void setArgument2(String argument2) {
      this.argument2 = argument2;
   }

   public String toString() {
      return "goal=(action="
         + action
         + " argument1="
         + argument1
         + " argument2="
         + argument2
         + ")";
   }
   /**
    * Determine the copyright of this class.
    *
    * @return    A String containing this class's copyright statement.
    *            <p>
    */
   private static String Copyright() {
      return Able.Copyright;
   }
}
