package com.ibm.able.examples.rules;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.rules
//
// (C) Copyright IBM Corp. 2001 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
import java.io.Serializable;

import com.ibm.able.Able;

/**
 * A customer has a name, age, and nationality.
 * 
 * @version  $Revision: 1.4 $, $Date: 2001/09/27 20:59:15 $
 */
public class Customer implements Serializable {

   public static final int SILVER = 0;
   public static final int GOLD = 1;
   public static final int PLATINUM = 2;

   /**
    * Serialized version identifier in form       YYYYMMDDVerRelModxx
    */
   static final long serialVersionUID = 2001100500100300000L;

   String name;
   int age = 0;
   String nationality = "";
   double income = 0.0;
   int level = SILVER;

   public Customer() {
   }

   public Customer(String name, int age, String nationality) {
      this.name = name;
      this.age = age;
      this.nationality = nationality;
   }

   public Customer(String name, int age, String nationality, double income) {
      this.name = name;
      this.age = age;
      this.nationality = nationality;
      this.income = income;
   }

   public Customer(String name, int age, double income, int level) {
      this.name = name;
      this.age = age;
      this.income = income;
      this.level = level;
   }

   public String getName() {
      return name;
   }
   public void setName(String name) {
      this.name = name;
   }

   public int getAge() {
      return age;
   }
   public void setAge(int age) {
      this.age = age;
   }

   public String getNationality() {
      return nationality;
   }
   public void setNationality(String nationality) {
      this.nationality = nationality;
   }

   public double getIncome() {
      return income;
   }

   public void setIncome(double income) {
      this.income = income;
   }

   public void setLevel(int level) {
      this.level = level;
   }

   public int getLevel() {
      return level;
   }

   public static int getLevel(String level) {
      if (level.toUpperCase().equals("PLATINUM"))
         return PLATINUM;
      if (level.toUpperCase().equals("GOLD"))
         return GOLD;
      if (level.toUpperCase().equals("SILVER"))
         return SILVER;
      return -1; //UNKNOWN; 	
   }

   public static String getLevel(int level) {
      switch (level) {
         case PLATINUM :
            return "Platinum";
         case GOLD :
            return "Gold";
         case SILVER :
            return "Silver";
         default :
            return "Unknown";
      }
   }

   public String toString() {
      return name
         + "=(age="
         + age
         + " nationality="
         + nationality
         + " income="
         + income
         + " level="
         + getLevel(level)
         + ")";
   }
   /**
    * Determine the copyright of this class.
    *
    * @return    A String containing this class's copyright statement.
    *            <p>
    */
   private static String Copyright() {
      return Able.Copyright;
   }
}
