package com.ibm.able.examples.rules;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.rules
//
// (C) Copyright IBM Corp. 2001 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
import java.io.Serializable;

import com.ibm.able.Able;

/**
 * A chest has a name, contains items and knows what can unlock it.
 * 
 * @version  $Revision: 1.4 $, $Date: 2001/09/27 20:59:15 $
 */
public class Chest implements Serializable {

   /**
    * Serialized version identifier in form       YYYYMMDDVerRelModxx
    */
   static final long serialVersionUID = 2001100500100300000L;
   String name = "aChest";
   String contents = "empty";
   String unlockedBy = "?";

   public Chest() {
   }

   public Chest(String name) {
      this.name = name;
   }

   public Chest(String name, String contents, String unlockedBy) {
      this.name = name;
      this.contents = contents;
      this.unlockedBy = unlockedBy;
   }

   public String getName() {
      return name;
   }
   public void setName(String name) {
      this.name = name;
   }

   public String getContents() {
      return contents;
   }
   public void setContents(String contents) {
      this.contents = contents;
   }

   public String getUnlockedBy() {
      return unlockedBy;
   }
   public void setUnlockedBy(String unlockedBy) {
      this.unlockedBy = unlockedBy;
   }

   public String toString() {
      return name
         + "=(contents="
         + contents
         + " unlockedBy="
         + unlockedBy
         + ")";
   }
   /**
    * Determine the copyright of this class.
    *
    * @return    A String containing this class's copyright statement.
    *            <p>
    */
   private static String Copyright() {
      return Able.Copyright;
   }
}
