package com.ibm.able.examples.rules;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.ableagent
//
// (C) Copyright IBM Corp. 2000 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
import java.util.Iterator;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.rules.AbleRuleSet;

/**
 * This class illustrates reading a ruleset, initializing it, and 
 * passing data into it, and retrieving the result.
 * @version  $Revision: 1.4 $, $Date: 2001/09/27 20:59:15 $
 */
public class AnimalRuleSetApp {
   	
  	                                       
   public static void main(String[] args) {
   	 try {
   	 	// ruleset to be read - requires able.home property to be set
   	 	String rules = "%able.home%examples/rules/Animal.arl";
   	 	//String rules = "C:/able1_3e/examples/rules/Animal.arl";
   	    if (args != null && args.length > 0) rules = args[0];

   	 	// must know the structure of that agent's inputbuffer to use it this way
   	 	// note agents can have a double[] buffer if all its values are numeric
        String[][] data  = new String[][]{
        	{"no","no","no","mammal","black","4","50000","uTellME!"},
        };
        String[] input  = null;
        Object[] output = null; 
   	    
        // restore the agent 
        AbleRuleSet ruleSet = new AbleRuleSet();
        ruleSet.parseFromARL(rules);
        ruleSet.init();
        
        // prove we're not cheating by showing the current values
   	 	Able.startTraceLogging(Able.TRC_LOW,Able.MSG_NONE,null);
  	 	
        Able.TraceLog.text(Able.TRC_LOW,"Input  current: " + ruleSet.getInputBufferAsString());
        Able.TraceLog.text(Able.TRC_LOW,"Output current: " + ruleSet.getOutputBufferAsString());
        
        // pass the agent data and get the result
        output = (Object[]) ruleSet.process(input = data[0]);
        
        // show the input that was passed and the result obtained
        Able.TraceLog.text(Able.TRC_LOW,"Input  result: " + ruleSet.getInputBufferAsString());
        Able.TraceLog.text(Able.TRC_LOW,"Output result: " + ruleSet.getOutputBufferAsString());     

   	 } catch (AbleException exp) {
   	 	
   	 	if (exp.getExceptions() == null) {
   	 			System.out.println(exp.getLocalizedMessage());
   	 	} else {
   	 		Iterator it = exp.getExceptions().iterator();
   	 		while (it.hasNext()) {
   	 			Exception e = (Exception)it.next();
   	 			System.out.println(e.getLocalizedMessage());
   	 		}
   	 	}
   	 } catch (Exception exp) {
   	 	System.out.println(exp.getLocalizedMessage());
   	 	exp.printStackTrace();
   	 }
     System.exit(0);
  }

    


}

