package com.ibm.able.examples.genetic;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.genetic
//
// (C) Copyright IBM Corp. 1999 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

import com.ibm.able.*;
import com.ibm.able.beans.*;
import com.ibm.able.beans.filter.*;
import com.ibm.able.agents.*;
import java.rmi.*;


/**
*   This class shows an example of optimizing input parameters for neural networks
 * @version  $Revision: 1.5 $, $Date: 2001/09/26 20:40:59 $
*/
public class TstGeneticFunction3 extends AbleGeneticObject {

  /**
   * Serialized version identifier in form       YYYYMMDDVerRelModxx
   */
  protected static final long serialVersionUID = 2001100500100300000L;

  AbleNeuralPredictionAgent predAgent ;

  public TstGeneticFunction3() {
    chromosomeLength = 10 ;
    vocabulary = "01" ;
    chromosomeType = String.class ;

  }

  public  AbleAgent initEvaluationAgent() {

    try {
     predAgent = new AbleNeuralPredictionAgent("EvaluationAgent") ;

     // now configure it
     predAgent.setDataFileName("d:\\jbuilder2\\myprojects\\able\\test\\bin10");
     predAgent.setBufferSize(10) ;
     predAgent.setTolerance(0.0) ; // make sure network error tolerance is 0

     predAgent.setNetArch("10 0 0") ;
     predAgent.init() ;
     predAgent.setMode(AbleNetwork.NNTRAIN) ;

     // and train it and lock it ???

     for (int i=0 ; i < 500; i++ ) {
       predAgent.process() ;
     }
     predAgent.setMode(AbleNetwork.NNTEST ) ;
     evaluationAgent = predAgent ;
    } catch (RemoteException e) {
      // **FIX**
    }
     return predAgent ;
  }

  public void initBean(AbleAgent evalAgent) {
      evaluationAgent = evalAgent ;
  }


  public double getFitness() {

     return fitness   ;

  }


  public static final double factor = 0.00004768372718899898;

  /**
  *  just add up the number of ones in the chromosome
  */
  public double computeFitness() {

    // this is deterministic

    // Note: the GeneticSearchAgent has already done one or more epochs
    //       to train the network

    // get the output of the outputFilter
    try {
    AbleFilter filt1  = (AbleFilter)evaluationAgent.getBean("GenInFilter") ;
    double[] inBuf = (double[])filt1.getInputBuffer() ;
    for (int i=0 ; i < chromosomeLength ; i++) {
      if (((String)chromosome).charAt(i) == '0') {
        inBuf[i] = 0.0 ;
      } else {
        inBuf[i] = 1.0 ;
      }
    }
    evaluationAgent.process() ;
    AbleFilter filt2 = (AbleFilter)evaluationAgent.getBean("GenOutFilter") ;
    double[] outBuf = (double[])filt2.getOutputBuffer() ;
    fitness = outBuf[0] ;
    fitnessComputed = true ; // only compute value once

    } catch (RemoteException e) {}
    return fitness ;
  }

    /**
     * Determine the copyright of this class.
     *
     * @return    A String containing this class's copyright statement.
     *            <p>
     */
    private static String Copyright() {
      return Able.Copyright;
    }


}
