package com.ibm.able.examples.genetic;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.genetic
//
// (C) Copyright IBM Corp. 1999 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

import com.ibm.able.*;
import com.ibm.able.beans.*;


/**
*   This class implements the F6 function described in the first chapter
*    of The Handbook of Genetic Algorithms (Davis)
*   It uses a traditional binary string representation
 * @version  $Revision: 1.2 $, $Date: 2001/09/26 20:40:59 $
*/
public class TstGeneticFunction2 extends AbleGeneticObject {

  /**
   * Serialized version identifier in form       YYYYMMDDVerRelModxx
   */
  protected static final long serialVersionUID = 2001100500100300000L;


  public TstGeneticFunction2() {
    chromosomeLength = 44 ;
    vocabulary = "01" ;
    chromosomeType = String.class ;
  }

  public double getFitness() {

   //  System.out.println("TEST  0001 ="  + binaryToInteger("0001")) ;
   //  System.out.println("TEST  1000 =" + binaryToInteger("1000")) ;
   //  System.out.println("TEST  1001 =" + binaryToInteger("1001")) ;

   // test from page 9, and top 2 examples from page 24
   // I can't get these answers to match no matter what I try ... jpb
   // chromosome = "00001010000110000000011000101010001110111011" ; // .5050708
   // computeFitness() ;
   // chromosome = "10000000010100011011100111001101011011110110" ; // .99026249
   // computeFitness() ;
   // chromosome = "01110011000010100001101000001011001000110110" ; // .98930211
   // computeFitness() ;

   //  f6(-100, -100) ;
   //  f6(0, -100 ) ;
   //  f6 ( 100, -100 ) ;
   //  f6( -100, 0) ;
   //  f6( 0, 0) ;
   //  f6( 100, 0) ;
   //  f6(-100, 100) ;
   //  f6(0, 100) ;
   //  f6( 100, 100) ;

     return fitness   ;

  }



  public static final double factor = 0.00004768372718899898;

  /**
  *  just add up the number of ones in the chromosome
  */
  public double computeFitness() {

    // this is deterministic, if already computed,
    // no sense if re-doing work
    if (fitnessComputed) return fitness ;

    double x1, y1 ;
    String xString = ((String)chromosome).substring(0, 22) ;
    String yString = ((String)chromosome).substring(22,44) ;
    x1 = binaryToInteger(xString) ;
    y1 = binaryToInteger(yString) ;

 //  System.out.println("xString = " + xString + " " + xString.length()) ;
 //  System.out.println("yString = " + yString + " " + yString.length()) ;

    double x2, y2 ;
    x2 = x1 * factor ;
    y2 = y1 * factor ;

    x2 = x2 - 100 ;
    y2 = y2 - 100 ;


    fitness = f6(x2, y2) ;
    fitnessComputed = true;

     return fitness ;
  }




  protected double f6(double x,  double y) {


      double ans = 0.0 ;
      double xSquared  = x*x ;
      double ySquared = y*y ;
      double x2plusy2 = xSquared + ySquared ;

      double numerator =  Math.pow(Math.sin(Math.sqrt(x2plusy2)),2) - 0.5;
      double denominator = Math.pow(1.0 + (0.001 * x2plusy2),2) ;

      ans = 0.5 - numerator / denominator ;

    //  System.out.println("function f6(" + x + "," + y + ")= " + ans) ;
      return ans ;
  }

    /**
     * Determine the copyright of this class.
     *
     * @return    A String containing this class's copyright statement.
     *            <p>
     */
    private static String Copyright() {
      return Able.Copyright;
    }


}
