package com.ibm.able.examples.genetic;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.genetic
//
// (C) Copyright IBM Corp. 1999 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

import com.ibm.able.*;
import com.ibm.able.beans.*;

/**
*   This class maximizes the number of on bits (1) in a binary string
 * @version  $Revision: 1.2 $, $Date: 2001/09/26 20:40:59 $
 */
public class TstGeneticFunction1 extends AbleGeneticObject {

  /**
   * Serialized version identifier in form       YYYYMMDDVerRelModxx
   */
  protected static final long serialVersionUID = 2001100500100300000L;

  public TstGeneticFunction1() {
    chromosomeLength = 20 ;
    vocabulary = "01" ;
    chromosomeType = String.class ;
  }

  public double getFitness() {

     return fitness ;

  }


  /**
  *  just add up the number of ones in the chromosome
  */
  public double computeFitness() {

    // this is deterministic, if already computed,
    // no sense if re-doing work
    if (fitnessComputed) return fitness ;

     int size = chromosomeLength ;
     double sum = 0.0;
     for (int i=0 ; i < size ; i++) {
        if (((String)chromosome).charAt(i) =='1') sum = sum + 1.0 ;
     }
     fitness = sum ;
     fitnessComputed = true;

     return fitness ;
  }
    /**
     * Determine the copyright of this class.
     *
     * @return    A String containing this class's copyright statement.
     *            <p>
     */
    private static String Copyright() {
      return Able.Copyright;
    }
}
