/*
 * Created on Aug 20, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.ibm.able.examples.conversation;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;

import com.ibm.able.Able;
import com.ibm.able.conversation.AbleConversationGraphicView;
import com.ibm.able.conversation.AbleConversationManagerCustomizer;
import com.ibm.able.conversation.AblePlatformConversationAgent;
import com.ibm.able.conversation.AblePlatformConversationAgentCustomizer;

/**
 * @author hanson
 */
public class ChatterboxDemo2 {

	// ==============================
	// Class variables
	// ==============================

	public static final long DEFAULT_SLEEP_TIME = 1000;
	public static final int DEFAULT_PORT = 55551;
	
	// ==============================
	// Instance variables
	// ==============================
	
	private long sleepTime = DEFAULT_SLEEP_TIME;
	private int port = DEFAULT_PORT;
	private ChatterboxAgent agent1 = null;
	private ChatterboxAgent2 agent2 = null;
	
	// ==============================
	// Constructors
	// ==============================

	public ChatterboxDemo2() {
	}
	
	public ChatterboxDemo2(int newPort) {
		port = newPort;
	}
	
	// ==============================
	// Operation
	// ==============================
	
	public void initAgents() {		
		
		// Start Able platform services.
		Able.MessageLog.text(Able.MSG_INFO, this, "initAgents", "Starting platform services.");
		String portName = "" + port;
		try {
			String[] platformArgs = { portName };
			com.ibm.able.platform.AblePlatformSupportImpl.main(platformArgs);		
		}
		catch (Exception ex1) {
			System.err.println("Exception in initAgents: " + ex1.getMessage());
			ex1.printStackTrace();
		}
		
		// Create agents.
		Able.MessageLog.text(Able.MSG_INFO, this, "initAgents", "Creating agent1");
		try {
			agent1 = new ChatterboxAgent("agent1");
			agent1.setTotalConversations(2);
			agent1.setTestMessageEnabled(false);
			agent1.setConversationEnabled(true);
		}
		catch (Exception ex2) {
				System.err.println("Exception in initAgents: " + ex2.getMessage());
				ex2.printStackTrace();
			}

		Able.MessageLog.text(Able.MSG_INFO, this, "initAgents", "Creating agent2");
		try {
			agent2 = new ChatterboxAgent2("agent2");
			agent2.setTestMessageEnabled(false);
			agent2.setConversationEnabled(false);
		}
		catch (Exception ex3) {
			System.err.println("Exception in initAgents: " + ex3.getMessage());
			ex3.printStackTrace();
		}
		
		// Initialize the agents.
		Able.MessageLog.text(Able.MSG_INFO, this, "initAgents", "Initializing the agents.");
		try {
			agent1.init();
			agent2.init();
		}
		catch (Exception ex4) {
			System.err.println("Exception in initAgents: " + ex4.getMessage());
			ex4.printStackTrace();
		}
	}
	
	public void initGui() {	
		
		// Inner class for catching GUI window events
		class ExitListener extends WindowAdapter {
			AblePlatformConversationAgent agent = null;
			public ExitListener(AblePlatformConversationAgent newAgent) {
				agent = newAgent;
			}
			public void windowClosing(WindowEvent e) {
				System.out.println(agent.getName() + " Bye!");
			}
		}

		// GUI for agent1
		Component pane1 = new AbleConversationGraphicView(agent1.getConversationManager());
		JFrame frame1 = new JFrame(agent1.getName() +  " Conversation Viewer");
		frame1.getContentPane().add(pane1);
		frame1.addWindowListener(new ExitListener(agent1));
		frame1.pack();
		frame1.setVisible(true);
		frame1.toFront();

		AblePlatformConversationAgentCustomizer ac1 = new AblePlatformConversationAgentCustomizer();
		ac1.setObject(agent1);
		ac1.setVisible(true);
		
		AbleConversationManagerCustomizer cmc1 = new AbleConversationManagerCustomizer();
		cmc1.setObject(agent1.getConversationManager());
		cmc1.setVisible(true);
		
		// GUI for agent2
		Component pane2 = new AbleConversationGraphicView(agent2.getConversationManager());
		JFrame frame2 = new JFrame(agent2.getName() +  " Conversation Viewer");
		frame2.getContentPane().add(pane2);
		frame2.addWindowListener(new ExitListener(agent2));
		frame2.pack();
		frame2.setVisible(true);
		frame2.toFront();

		AblePlatformConversationAgentCustomizer ac2 = new AblePlatformConversationAgentCustomizer();
		ac2.setObject(agent2);
		ac2.setVisible(true);

		AbleConversationManagerCustomizer cmc2 = new AbleConversationManagerCustomizer();
		cmc2.setObject(agent2.getConversationManager());
		cmc2.setVisible(true);
		

	}
	
	public void run() {
		Able.MessageLog.text(Able.MSG_INFO, this, "run", null);
		
		while (true) {
			try {
				agent1.process();
				agent2.process();
				Thread.sleep(sleepTime);
			}
			catch (Exception ex1) {
				System.err.println("Exception in run: " + ex1.getMessage());
				ex1.printStackTrace();
			}
		}
	}
	
	// ===========================================
	// main
	// ===========================================

	public static void main(String[] args) {
		Able.startMessageAndTraceLogging();
		
		int port = ChatterboxDemo2.DEFAULT_PORT;
		if (args.length > 0) {
			try {
				port = Integer.parseInt(args[0]);
			}
			catch (Exception ex) {
				System.err.println("Exception in main: " + ex.getMessage());
				System.exit(1);
			}
		}
		
		ChatterboxDemo2 pool = new ChatterboxDemo2(port);
		pool.initAgents();	
		pool.initGui();
		pool.run();	
		
		System.exit(0);		
	}
}
