/*
 * Created on Aug 20, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.ibm.able.examples.conversation;

import com.ibm.able.Able;

/**
 * @author hanson
 */
public class ChatterboxDemo {

	// ==============================
	// Class variables
	// ==============================

	public static final long DEFAULT_SLEEP_TIME = 1000;
	public static final int DEFAULT_PORT = 55551;
	
	// ==============================
	// Instance variables
	// ==============================
	
	private long sleepTime = DEFAULT_SLEEP_TIME;
	private int port = DEFAULT_PORT;
	private ChatterboxAgent agent1 = null;
	private ChatterboxAgent agent2 = null;
	
	// ==============================
	// Constructors
	// ==============================

	public ChatterboxDemo() {
	}
	
	public ChatterboxDemo(int newPort) {
		port = newPort;
	}
	
	// ==============================
	// Operation
	// ==============================
	
	public void init() {		
		
		// Start Able platform services.
		Able.MessageLog.text(Able.MSG_INFO, this, "init", "Starting platform services.");
		String portName = "" + port;
		try {
			String[] platformArgs = { portName };
			com.ibm.able.platform.AblePlatformSupportImpl.main(platformArgs);		
		}
		catch (Exception ex1) {
			System.err.println("Exception in init: " + ex1.getMessage());
			ex1.printStackTrace();
		}
		
		// Create agents.
		Able.MessageLog.text(Able.MSG_INFO, this, "init", "Creating agent1");
		try {
			agent1 = new ChatterboxAgent("agent1");
			agent1.setTotalConversations(1);
			agent1.setTestMessageEnabled(false);
			agent1.setConversationEnabled(true);
		}
		catch (Exception ex2) {
				System.err.println("Exception in init: " + ex2.getMessage());
				ex2.printStackTrace();
			}

		Able.MessageLog.text(Able.MSG_INFO, this, "init", "Creating agent2");
		try {
			agent2 = new ChatterboxAgent("agent2");
			agent2.setTestMessageEnabled(false);
			agent2.setConversationEnabled(false);
		}
		catch (Exception ex3) {
			System.err.println("Exception in init: " + ex3.getMessage());
			ex3.printStackTrace();
		}
		
		// Initialize the agents.
		Able.MessageLog.text(Able.MSG_INFO, this, "init", "Initializing the agents.");
		try {
			agent1.init();
			agent2.init();
		}
		catch (Exception ex4) {
			System.err.println("Exception in init: " + ex4.getMessage());
			ex4.printStackTrace();
		}
	}
	
	public void run() {
		Able.MessageLog.text(Able.MSG_INFO, this, "run", null);
		
		while (true) {
			try {
				agent1.process();
				agent2.process();
				Thread.sleep(sleepTime);
			}
			catch (Exception ex1) {
				System.err.println("Exception in run: " + ex1.getMessage());
				ex1.printStackTrace();
			}
		}
	}
	
	// ===========================================
	// main
	// ===========================================

	public static void main(String[] args) {
		Able.startMessageAndTraceLogging();
		
		int port = ChatterboxDemo.DEFAULT_PORT;
		if (args.length > 0) {
			try {
				port = Integer.parseInt(args[0]);
			}
			catch (Exception ex) {
				System.err.println("Exception in main: " + ex.getMessage());
				System.exit(1);
			}
		}
		
		ChatterboxDemo pool = new ChatterboxDemo(port);
		pool.init();	
		pool.run();	
		
		System.exit(0);		
	}
}
