/*
 * Created on Aug 27, 2003
 * 
 * @author hanson
 */
package com.ibm.able.examples.conversation;

import java.util.Hashtable;

import javax.swing.JFrame;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.conversation.AbleOwned;
import com.ibm.conversation.Conversation;
import com.ibm.conversation.DecisionDataHandle;

/**
 * @author hanson
 */
public class AbleChat3GuiLogic extends AbleOwned {

	// ==================================
	// Instance variables
	// ==================================

	Hashtable chatPanes = null;

	// ==================================
	// Constructors
	// ==================================

	public AbleChat3GuiLogic() {
		super();
		chatPanes = new Hashtable();
	}

	public AbleChat3GuiLogic(AbleBean owner) {
		super(owner);
		chatPanes = new Hashtable();
	}

	// ==================================
	// Decision logic targets
	// ==================================

	protected AbleChat3Panel createPane(Conversation conv) {
		logMessage(Able.MSG_INFO, "createPane", "convId=" + conv.getConversationId());
		AbleChat3Panel newPane = new AbleChat3Panel(conv);
		JFrame newFrame =
			new JFrame("Chat3 -- convId=" + conv.getConversationId());
		newFrame.setContentPane(newPane);
		newFrame.pack();
		chatPanes.put(conv.getConversationId(), newPane);
		return newPane;
	}

	public void start(Conversation conv, DecisionDataHandle ddh) {
		// ROLE 1 only.
		// Inputs:
		//    "start", null
		// Possible actions:
		// 1. "begin", { String }

		logMessage(Able.MSG_INFO, "start", "context=" + conv.getContext());

//		ConversationPolicyHandler cph = conv.getActivePolicyHandler();
//		CpStateMachine cp = ((CpStateMachineHandler)cph).getStateMachine();
//		logMessage(Able.MSG_INFO, "start", "CP=" + cp.toString());

		AbleChat3Panel pane =
			(AbleChat3Panel)chatPanes.get(conv.getConversationId());
		if (pane == null) {
			pane = createPane(conv);
		}
		pane.clear();
		pane.ensureVisible();
	}

	public void role1Active(Conversation conv, DecisionDataHandle ddh) {
		logMessage(Able.MSG_INFO, "role1Active", "");

		AbleChat3Panel pane =
			(AbleChat3Panel)chatPanes.get(conv.getConversationId());
		if (pane == null) {
			pane = createPane(conv);
		}

		// String decisionName = ddh.getName();
		Object[] decisionArgs = ddh.getArgs();
		String msg = "";
		if (decisionArgs != null && decisionArgs.length == 1)
			msg = decisionArgs[0].toString();
		
		pane.appendPartnerMessage(msg);
		pane.ensureVisible();
	}

	public void role2Active(Conversation conv, DecisionDataHandle ddh) {
		logMessage(Able.MSG_INFO, "role2Active", "");

		AbleChat3Panel pane =
			(AbleChat3Panel)chatPanes.get(conv.getConversationId());
		if (pane == null) {
			pane = createPane(conv);
		}
		
		// String decisionName = ddh.getName();
		Object[] decisionArgs = ddh.getArgs();
		String msg = "";
		if (decisionArgs != null && decisionArgs.length == 1)
			msg = decisionArgs[0].toString();
			
		pane.appendPartnerMessage(msg);
		pane.ensureVisible();
	}

	public void halted(Conversation conv, DecisionDataHandle ddh) {
		logMessage(Able.MSG_INFO, "halted", "");

		AbleChat3Panel pane =
			(AbleChat3Panel)chatPanes.get(conv.getConversationId());
		if (pane == null) {
			pane = createPane(conv);
		}
		
		// String decisionName = ddh.getName();
		Object[] decisionArgs = ddh.getArgs();
		String msg = "";
		if (decisionArgs != null && decisionArgs.length == 1)
			msg = decisionArgs[0].toString();
		
		pane.appendPartnerMessage(msg);
		pane.setInputEnabled(false);
		pane.ensureVisible();
	}

}
