/*
 * Created on Aug 27, 2003
 * 
 * @author hanson
 */
package com.ibm.able.examples.conversation;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.conversation.AbleOwned;
import com.ibm.conversation.Conversation;
import com.ibm.conversation.ConversationException;
import com.ibm.conversation.ConversationPolicyHandler;
import com.ibm.conversation.CpStateMachine;
import com.ibm.conversation.CpStateMachineHandler;
import com.ibm.conversation.DecisionDataHandle;
import com.ibm.conversation.base.BasicDecisionDataHandle;

/**
 * @author hanson
 */
public class AbleChat3DummyLogic extends AbleOwned {

	// ==================================
	// Instance variables
	// ==================================

	int messageCounter = 0;
	int minToSend = 2;
	double haltProb = 0.5;
	
	// ==================================
	// Constructors
	// ==================================

	public AbleChat3DummyLogic() {
		super();
	}

	public AbleChat3DummyLogic(AbleBean owner) {
		super(owner);
	}

	// ==================================
	// Actual decision-making
	// ==================================
	
	boolean decideOnContinuing(Conversation conv) {
		if (messageCounter > minToSend && Math.random() < haltProb)	
			return false;
		else 
			return true;
	}
	
	String getNextMessage(Conversation conv) {
		return "This is chat message " + messageCounter++ + " in conversation " + conv.getConversationId();
	}
	
	// ==================================
	// Decision logic targets
	// ==================================

	public void start(Conversation conv, DecisionDataHandle ddh) {
		// ROLE 1 only.
		// Inputs:
		//    "start", null
		// Possible actions:
		// 1. "begin", { String }
		
		logMessage(Able.MSG_INFO, "start", "context=" + conv.getContext());
		
		ConversationPolicyHandler cph = conv.getActivePolicyHandler();
		CpStateMachine cp = ((CpStateMachineHandler)cph).getStateMachine();
		logMessage(Able.MSG_INFO, "start", "CP=" + cp.toString());

		String chatMsg = getNextMessage(conv);
		
		String decisionName = "begin";
		Object[] decisionArgs = new Object[] { chatMsg };
		DecisionDataHandle ddh2 = new BasicDecisionDataHandle(decisionName, decisionArgs);
		try {
			conv.processDecision(ddh2);
		}
		catch (ConversationException ex) {
			logException("start", ex);
		}
	}

	public void role1Active(Conversation conv, DecisionDataHandle ddh) {
		logMessage(Able.MSG_INFO, "role1Active", "");
		
		String decisionName = null;
		Object[] decisionArgs = null;
		
		if (decideOnContinuing(conv)) {
			decisionName = "continue1";
			String chatMsg = getNextMessage(conv);
			decisionArgs = new Object[] { chatMsg };
			logMessage(Able.MSG_INFO, "role1Active", "Sending message \"" + chatMsg + "\"");
		}
		else {
			decisionName = "halt1";
			String byeMsg = "bye for now";
			decisionArgs = new Object[] { byeMsg };
			logMessage(Able.MSG_INFO, "role1Active", "Signing off with message \"" + byeMsg + "\"");
		}
		
		DecisionDataHandle ddh2 = new BasicDecisionDataHandle(decisionName, decisionArgs);
		try {
			conv.processDecision(ddh2);
		}
		catch (ConversationException ex) {
			logException("role1Active", ex);
		}
	}

	public void role2Active(Conversation conv, DecisionDataHandle ddh) {
		logMessage(Able.MSG_INFO, "role2Active", "");
		// ROLE 2 only.
		// Inputs:
		//    "role2Active", { String }
		// Possible actions:
		// 1. "continue2", { String }
		// 1. "halt2", { String }

		String decisionName = null;
		Object[] decisionArgs = null;
		
		if (decideOnContinuing(conv)) {
			String chatMsg = getNextMessage(conv);
			decisionName = "continue2";
			decisionArgs = new Object[] { chatMsg };
			logMessage(Able.MSG_INFO, "role2Active", "Sending message \"" + chatMsg + "\"");
		}
		else {
			decisionName = "halt2";
			String byeMsg = "bye for now";
			decisionArgs = new Object[] { byeMsg };
			logMessage(Able.MSG_INFO, "role1Active", "Signing off with message \"" + byeMsg + "\"");
		}
		
		DecisionDataHandle ddh2 = new BasicDecisionDataHandle(decisionName, decisionArgs);
		try {
			conv.processDecision(ddh2);
		}
		catch (ConversationException ex) {
			logException("role2Active", ex);
		}
	}
	
	public void halted(Conversation conv, DecisionDataHandle ddh) {
		logMessage(Able.MSG_INFO, "halted", "");
		// ROLE 1 and 2.
		// Inputs:
		//    "halted", { String }
		// Possible actions:
		// 	   none
	}
	
}
