package com.ibm.able.examples.ablebean;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.ablebean
//
// (C) Copyright IBM Corp. 2000 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.SimpleBeanInfo;

import com.ibm.able.Able;
import com.ibm.able.editor.AbleEditor;
// Aug 25, 2000 DAS removed: import com.sun.java.swing.*;


/**
 * This class provides the bean info for the Simple Able Bean.
 *
 * @version  $Revision: 1.10 $, $Date: 2001/09/26 20:19:22 $
 *
 * @author   Joe Bigus
 */
public class SimpleAbleBeanBeanInfo extends SimpleBeanInfo {

  //==================================================================
  //
  // Class VariAbles
  //
  //==================================================================
  private final static Class customizerClass = com.ibm.able.examples.ablebean.SimpleAbleBeanCustomizer.class;
  /**
   * Serialized version identifier in form       YYYYMMDDVerRelModxx
   */
  protected static final long serialVersionUID = 2001100500100300000L;

  //==================================================================
  //
  // Member VariAbles
  //
  //==================================================================
  Class beanClass = SimpleAbleBean.class;
  String iconColor16x16Filename = "simplebean16.gif";
  String iconColor32x32Filename = "simplebean32.gif";
  String iconMono16x16Filename = null;
  String iconMono32x32Filename = null;

  /**
   * Default constructor
   */
  public SimpleAbleBeanBeanInfo() {
  }


  /**
   * Return a BeanDescriptor for this bean.
   *
   * @return    A bean descriptor which specifies a customizer for this
   *            bean class.
   */
  public BeanDescriptor getBeanDescriptor() {
    BeanDescriptor returnDescriptor = new BeanDescriptor(beanClass, customizerClass);
    returnDescriptor.setValue("hidden-state", Boolean.TRUE);
    returnDescriptor.setValue("able-category",AbleEditor.CAT_SAMPLES) ; // icon palette page
    returnDescriptor.setValue("able-slot", String.valueOf(AbleEditor.LEFT)) ;   // horizontal position on canvas

    return returnDescriptor;
  }


  /**
   * Return the image requested.
   *
   * @return    An Image of the requested kind.  Returns null if not found
   *            or an image is not specified.
   */
  public java.awt.Image getIcon(int iconKind) {
    switch (iconKind) {
    case BeanInfo.ICON_COLOR_16x16:
      return iconColor16x16Filename != null ? loadImage(iconColor16x16Filename) : null;
    case BeanInfo.ICON_COLOR_32x32:
      return iconColor32x32Filename != null ? loadImage(iconColor32x32Filename) : null;
    case BeanInfo.ICON_MONO_16x16:
      return iconMono16x16Filename != null ? loadImage(iconMono16x16Filename) : null;
    case BeanInfo.ICON_MONO_32x32:
      return iconMono32x32Filename != null ? loadImage(iconMono32x32Filename) : null;
    }
    return null;
  }


  /**
   * Return the BeanInfo for the super class.  Null if superclass is not found.
   *
   * @return    An array with the BeanInfo of the super class.
   */
  public BeanInfo[] getAdditionalBeanInfo() {
    Class superclass = beanClass.getSuperclass();
    try  {
      BeanInfo superBeanInfo = Introspector.getBeanInfo(superclass);
      return new BeanInfo[] { superBeanInfo };
    }
    catch (IntrospectionException ex) {
        Able.MessageLog.text(Able.MSG_WARNING,this,"getAdditionalBeanInfo",ex.getLocalizedMessage());
        if (Able.TraceLog.isLogging()) Able.TraceLog.exception(Able.TRC_LOW,this,"getAdditionalBeanInfo",ex);
      return null;
    }
  }


  /**
   * Determine the copyright of this class.
   *
   * @return    A String containing this class's copyright statement.
   *            <p>
   */
  private static String Copyright() {
    return Able.Copyright;
  }

}





