package com.ibm.able.examples.ablebean;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.ablebean
//
// (C) Copyright IBM Corp. 2000 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;
import com.ibm.able.AbleProperty;


/**
 *  This class is an example of a simple AbleBean created by extending
 *  AbleObject.
 *
 *  It copies the value of the inputBuffer to the outputBuffer.  It sets the
 *  simpleBeanColor property to the value of the first output buffer array position.
 *  <p>
 *  If no input connection exists or the inputBuffer is null, it will copy the
 *  the simpleBeanColor property to the first output buffer array value.
 *
 * @version  $Revision: 1.10 $, $Date: 2001/09/26 20:19:22 $
 *
 * @author   Joe Bigus
 */
public class SimpleAbleBean extends AbleObject {


  //==================================================================
  //
  // Class Variables
  //
  //==================================================================

  // define any class variables here
  /**
   * Serialized version identifier in form       YYYYMMDDVerRelModxx
   */
  protected static final long serialVersionUID = 2001100500100300000L;
  public final static String DefaultBeanColor = "magenta";

  //==================================================================
  //
  // Instance Variables
  //
  //==================================================================

  // define any bean-specific instance variables here
   private String simpleBeanColor ;

  //==================================================================
  //
  // Constructors
  //
  //==================================================================
  /**
   * Construct a simple AbleBean
   */
  public SimpleAbleBean() throws AbleException {
       this("SimpleBean");
  }


  /**
   * Construct a simple AbleBean with specified name.
   *
   * @param     aName
   *            A String object specifying the object name
   */
  public SimpleAbleBean(String aName) throws AbleException {
       super(aName) ;
       // need to allocate the input and output buffers here (if used)
       inputBuffer = new String[1] ;
       outputBuffer = new String[1] ;
       reset();
       init(); // in this simple case, initialize here
  }


  //------------------------------------------------------------------
  // Processing methods
  //------------------------------------------------------------------
  /**
   * Initialize the agent to a known initialized state.
   * Start processing any events enabled.
   *
   */
  public void init() throws AbleException {
       if (trace.isLogging()) trace.text(Able.TRC_LOW,this,"init","Color = " + this.simpleBeanColor);
       super.init();  // create/resume the  event queue thread
  }


  /**
   *  Reset the bean to a known initialized state.
   *  Fire a global property change event.
   *
   */
  public void reset() throws AbleException {
       // No timer processing, and no asynch events, just dataflow
       setDataFlowEnabled(true) ;
       setTimerEventProcessingEnabled(false);
       setAbleEventProcessingEnabled(Able.ProcessingDisabled_PostingDisabled);

       // Default bean properties:
       simpleBeanColor = DefaultBeanColor;  // no property change event
       // setSimpleBeanColor(DefaultBeanColor); // sends property change event
       // may want to fire a mass property changed event instead
       firePropertyChange(AbleProperty.UpdateProperties, null, null);
  }


  /**
   * Perform the standard processing function performed by this bean.
   * This typically takes data from the inputBuffer, processes it,
   * and places it in the output buffer.
   *
   * @exception AbleException
   *            either AbleException or process error
   */
  public void process() throws AbleException {
         processBufferConnections() ;   // move data into inputBuffer (if any)

         // perform the main processing here
         Object in = getInputBuffer(0) ;  // see if there is data in the input buffer
         if (in != null) {
           setSimpleBeanColor((String)getInputBuffer(0)) ; // copy to the color parameter
         }
         // Note: we either process data in the input buffer
         //       or use other data member values as inputs

         // assign output data to the outputBuffer here
         setOutputBuffer(0, simpleBeanColor) ;

         dataChanged(outputBuffer) ;  // tell any AbleEventListeners that we changed
  }

  /**
  *   Set the color attribute
  *   Also fire a propertyChange event to notify any propertyChange listeners
  */
  public void setSimpleBeanColor(String newBeanColor) throws AbleException {
       String oldBeanColor = simpleBeanColor;
       simpleBeanColor = newBeanColor ;
       firePropertyChange("simpleBeanColor", oldBeanColor, newBeanColor);
  }

  /**
  *   Get the color attribute
  */
  public String getSimpleBeanColor() { return simpleBeanColor; }

    /**
     * Determine the copyright of this class.
     *
     * @return    A String containing this class's copyright statement.
     *            <p>
     */
    private static String Copyright() {
      return Able.Copyright;
    }


}
