package com.ibm.able.examples.ablebean;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.ablebean
//
// (C) Copyright IBM Corp. 2000 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
import java.rmi.RemoteException;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

import com.ibm.able.Able;
import com.ibm.able.AbleObjectCustomizer;


/**
 * This class provides the customizer for the File Watcher tab.
 *
 * @see com.ibm.able.AbleObjectCustomizer
 * @see com.ibm.able.examples.ablebean.AbleFileWatcherPanel
 *
 * @version  $Revision: 1.5 $, $Date: 2001/09/17 21:51:36 $
 *
 * @author   Joe Bigus
 */
public class AbleFileWatcherCustomizer extends AbleObjectCustomizer {
    //-----------------------------------------------------------------
    // Class variables
    //-----------------------------------------------------------------

    //-----------------------------------------------------------------
    // Member variables
    //-----------------------------------------------------------------
    private AbleFileWatcherPanel myBeanPanel = null;

    //-----------------------------------------------------------------
    // Constructors
    //-----------------------------------------------------------------
    /**
     *  Construct a File Watcher Customizer dialog.  Dialog is
     *  not modal so other windows can be active at the same time.
     *
     * @param theFrame The frame from which the dialog is displayed.
     * @param theTitle The default name to display in the dialog's title bar.
     *              This will be replaced with the object name when the object is set.
     */
    public AbleFileWatcherCustomizer(JFrame theFrame, String theTitle) {
        super(theFrame, theTitle, false);   // non-modal
        // pass this customizer to the base customizer so OK calls this.updateObject
        setCustomizer(this);
        // create the panel;  pass this customizer so it can call this.updateObject too
        // and so it can register property listeners with the base customizer
        myBeanPanel = new AbleFileWatcherPanel(this);
        insertTab("File Watcher",    myBeanPanel, 1);
    }

    /**
     *  Construct a Customizer dialog.  Dialog is
     *  not modal so other windows can be active at the same time.
     *
     */
    public AbleFileWatcherCustomizer() {
        this(new JFrame(), "File Watcher Customizer") ;
    }

    //-----------------------------------------------------------------
        // Main method
    //-----------------------------------------------------------------
    /**
     *  The main method is provided only for testing.
     *
     */
        static public void main(String args[])
        {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            AbleFileWatcherCustomizer c = new AbleFileWatcherCustomizer();
            c.setObject(new AbleFileWatcher());
            c.setVisible(true);
            } catch (Exception e) {
            JOptionPane.showMessageDialog(
               null,                                // Parent
               e.toString(),                        // Msg
               "AbleFileWatcherCustomizer()",         // Title
               JOptionPane.ERROR_MESSAGE            // Severity
            );
            }
        }

    //--------------------------------------------------------------------
    // Methods inherited from Customizer interface
    //--------------------------------------------------------------------

    /**
     * Write the data from the object to the panel(s) provided
     * by this customizer. The panel saves a reference to the
     * bean being customized.
     * Pass the object and its data to any inherited panel.
     *
     * @param     theBean
     *            The bean that is to be changed.
     * @see com.ibm.able.AbleObjectCustomizer
     */
    public void setObject(Object theBean) {
        super.setObject(theBean);
            try {
                myBeanPanel.getDataFromBean((AbleFileWatcher) theBean);
            } catch (RemoteException e) {
            JOptionPane.showMessageDialog(
               this,                                // Parent
               e.toString(),                        // Msg
               "AbleFileWatcherCustomizer Error: setObject()",         // Title
               JOptionPane.ERROR_MESSAGE            // Severity
            );
            }
    }


    /**
     * Update the bean that is being customized.  This method is
     * called when the dialog's OK button is pressed.
     *
     * @see com.ibm.able.AbleObjectCustomizer
     * @exception RemoteException is thrown when the panel values
     *            cannot be set on the bean.
     */
    public void updateObject() throws RemoteException {
        super.updateObject();
            myBeanPanel.setDataOnBean();
    }

    /**
     * Determine the copyright of this class.
     *
     * @return    A String containing this class's copyright statement.
     *            <p>
     */
    private static String Copyright() {
      return Able.Copyright;
    }
}


