package com.ibm.able.examples.ableagent;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.ableagent
//
// (C) Copyright IBM Corp. 2000 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
 
import com.ibm.able.Able;
import com.ibm.able.AbleDefaultAgent;
import com.ibm.able.AbleException;

/**
 * This class is an example of an AbleAgent created by extending
 * AbleDefaultAgent.  It uses timer event processing to set a new value
 * in its outputBuffer, and sends a data event
 * indicating its outputBuffer contents have changed.
 *
 * @see com.ibm.able.AbleDefaultAgent
 *
 * @author   Joe Bigus
 */
public class SimpleAbleAgent extends AbleDefaultAgent {

  //==================================================================
  //
  // Class Variables
  //
  //==================================================================

  /**
   * Serialized version identifier in form       YYYYMMDDVerRelModxx
   */
  protected static final long serialVersionUID = 2001100500100300000L;
  public final static String[] colors = { "red", "orange", "yellow", "green", "blue", "indigo", "violet"};


  //==================================================================
  //
  // Instance Variables
  //
  //==================================================================

  // define any bean-specific instance variables here
  private int    colorIndex = 0 ;
  private String simpleBeanColor ;

  //==================================================================
  //
  // Constructors
  //
  //==================================================================

  /**
   * Construct a simple AbleAgent and initialize it.
   *
   */
  public SimpleAbleAgent() throws AbleException {
      this("SimpleAgent");
  }


  /**
   * Construct a simple AbleAgent with specified name.
   *
   * @param     aName
   *            A String object specifying the object name
   */
  public SimpleAbleAgent(String aName) throws AbleException {
       super(aName) ;
       // set agent defaults
       // need to allocate the input and output buffers here (if used)
       inputBuffer = new String[1] ;
       outputBuffer = new String[1] ;
       reset();
       // in the case of this example, start processing
       init();
  }


  //------------------------------------------------------------------
  // Processing methods
  //------------------------------------------------------------------
  /**
   * Initialize the agent to a known initialized state.
   * Start processing any events enabled.
   *
   */
  public void init() throws AbleException {
       if (trace.isLogging()) trace.text(Able.TRC_LOW,this,"init","Color = " + this.simpleBeanColor);
       super.init();  // create/resume the  event queue thread
  }


  /**
   * Reset the agent to default processing settings.
   *
   */
  public void reset() throws AbleException {
       setDataFlowEnabled(true) ;

       // Timer processing, but no asynch events
       setSleepTime(5000);   // call processTimerEvent() every 5 seconds
       setTimerEventProcessingEnabled(true);
       setAbleEventProcessingEnabled(Able.ProcessingDisabled_PostingDisabled);

       colorIndex = 0 ;
       simpleBeanColor = colors[colorIndex];

  }


  /**
   * Perform the standard processing function performed by this agent.
   * This typically takes data from the inputBuffer, processes it,
   * and places it in the output buffer.
   *
   * @exception AbleException
   *            either AbleException or process error
   */
  public void process() throws AbleException {

         processBufferConnections() ;   // move data into inputBuffer (if any)

         // perform the main processing here
         // for this example, just cycle through the colors
         Object in = getInputBuffer(0) ;  // see if there is data in the input buffer
         if (in != null) {
           setSimpleBeanColor((String)getInputBuffer(0)) ; // copy to the color parameter
         } else {
           colorIndex = colorIndex % colors.length ;
           setSimpleBeanColor(colors[colorIndex++]) ;
         }

         // Note: we either process data in the input buffer
         //       or use other data member values as inputs

         // assign output data to the outputBuffer here
         setOutputBuffer(0, simpleBeanColor) ;

         dataChanged(outputBuffer) ;  // tell any AbleEventListeners that we changed
  }


  /**
  *   This method gets called from the asych thread (if running)
  *   Default behavior is to just call the process() method
  *
  */
   public void processTimerEvent() throws AbleException {
        process() ;
   }


  /**
  *   Set the color attribute
  *   Also fire a propertyChange event and a dataChanged AbleEvent
  */
  public void setSimpleBeanColor(String newBeanColor) {
       String oldBeanColor = simpleBeanColor;
       simpleBeanColor = newBeanColor ;
       chgSupport.firePropertyChange("simpleBeanColor", oldBeanColor, newBeanColor);
  }

  /**
  *   Get the color attribute
  */
  public String getSimpleBeanColor() { return simpleBeanColor; }

    /**
     * Determine the copyright of this class.
     *
     * @return    A String containing this class's copyright statement.
     *            <p>
     */
    private static String Copyright() {
      return Able.Copyright;
    }

}
