package com.ibm.able.examples;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples.ablebean
//
// (C) Copyright IBM Corp. 2000 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.rmi.RemoteException;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizer;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AbleObjectCustomizer;

/**
 * This class provides the customizer for the Simple Able Bean.
 *
 * @see com.ibm.able.AbleObjectCustomizer
 * see SimpleAbleBeanPanel
 *
 * @version  $Revision: 1.2 $, $Date: 2001/09/17 21:46:30 $
 *
 * @author   Joe Bigus
 */
public class AbleBeanWrapperCustomizer extends JPanel implements AbleCustomizer, AbleCustomizerPanel {
    //-----------------------------------------------------------------
    // Class variables
    //-----------------------------------------------------------------

    //-----------------------------------------------------------------
    // Member variables
    //-----------------------------------------------------------------
    private AbleBeanWrapper  myBean      = null;
    private JTextField      myTextField = null;
    private PropertyChangeSupport myChgSupport  = null;

    //-----------------------------------------------------------------
    // Constructors
    //-----------------------------------------------------------------

    /**
     *  Construct a Simple Able Bean Customizer panel.
     *
     */
    public AbleBeanWrapperCustomizer() {
        super();
        initializePanel();
    }


    //-----------------------------------------------------------------
    // Main method
    //-----------------------------------------------------------------
    /**
     *  The main method is provided only for testing.
     *  A customizer that extends JPanel will be added to
     *  a dialog created in AbleObjectCustomizer in the
     *  Agent Editor.
     *
     */
    static public void main(String args[])
    {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            AbleBeanWrapper bean = new AbleBeanWrapper();
            AbleBeanWrapperCustomizer customizer = new AbleBeanWrapperCustomizer();
            customizer.setObject(bean);
            // minimalist way:
            //new AbleCustomizerDialog(new JFrame(), customizer, bean);
            // Able Agent Editor way:
            AbleObjectCustomizer myCustomizer = new AbleObjectCustomizer();
            myCustomizer.addPanel((AbleCustomizerPanel)customizer);
            myCustomizer.setVisible(true);
        } catch (Exception e) {
            JOptionPane.showMessageDialog(
               null,                                // Parent
               e.toString(),                        // Msg
               "AbleBeanWrapperCustomizer()",         // Title
               JOptionPane.ERROR_MESSAGE            // Severity
            );
        }
    }

    //--------------------------------------------------------------------
    // Methods inherited from Customizer interface
    //--------------------------------------------------------------------

    /**
     * Write the data from the object to the panel(s) provided
     * by this customizer. The panel saves a reference to the
     * bean being customized.
     * Pass the object and its data to any inherited panel.
     *
     * @param     theObject
     *            The Bean that is to be changed.
     * @see com.ibm.able.AbleObjectCustomizer
     */
    public void setObject(Object theObject) {
        if (myChgSupport == null)
            myChgSupport = new PropertyChangeSupport(theObject);
        myBean = (AbleBeanWrapper) theObject;
        //myTextField.setText(myBean.getSomeProperty());
    }


    /**
     * Update the bean that is being customized.  This method is
     * called when the dialog's OK button is pressed.
     *
     * @see com.ibm.able.AbleObjectCustomizer
     * @exception RemoteException is thrown when the panel values
     *            cannot be set on the bean.
     */
    public void updateObject() throws RemoteException {
        try {
            String color = myTextField.getText().trim();
            if (color.length() == 0)
                throw new RemoteException("Blank input provided on Simple Bean panel.");
           // myBean.setSomeProperty(color);
        } catch (NullPointerException e) {
            throw new RemoteException("Error on Simple Bean panel."+Able.LS + e.toString());
        }
    }

    /**
     *  This allows other objects to register when this customizer changes.
     *  @see PropertyChangeListener
     *  @see #removePropertyChangeListener
     */
     public void addPropertyChangeListener(PropertyChangeListener l) {
         myChgSupport.addPropertyChangeListener(l);
     }

    /**
     *  This allows other objects to deregister from changes to this customizer.
     *  @see PropertyChangeListener
     *  @see #addPropertyChangeListener
     */
     public void removePropertyChangeListener(PropertyChangeListener l) {
         myChgSupport.removePropertyChangeListener(l);
     }

    //------------------------------------------------------------------
    // Required by AbleCustomizerPanel interface
    //------------------------------------------------------------------

    /**
     * Get the html file name to be displayed.
     *
     * @return A String containing the html file to display in the browser.
     */
     public String getHelpFileName() { return AbleHelp.helpFilesPath +
               "examples/doc-files/AbleBeanWrapperHelp.html" ; }

    /** Get the URL file context to be displayed. Able.HomeUrl is the
     * Able context.
     *
     * @see Able
     *
     * @return A URL containing the html file to display in the browser.
     */
     public URL getHelpContext() { return Able.HomeUrl; }


        /**
         * Initialize the panel.
         *
         */
        private void initializePanel() {
            this.add(new JLabel("Color:"));
            myTextField = new JTextField(10);
            this.add(myTextField);

            JButton resetButton = new JButton("Reset");
            resetButton.addActionListener(new ActionListener() {
                    public void actionPerformed(ActionEvent e) {
                        ResetButton_actionPerformed(e);
                   }});
            resetButton.setToolTipText("Reset");
            this.add(resetButton);
        }



        //-----------------------------------------------------------------
        // Action methods
        //-----------------------------------------------------------------


        /**
         *  Perform the reset on the object.
         *
         *  @param theEvent the button pressed event.
         */
        void ResetButton_actionPerformed(ActionEvent theEvent) {
            try {
                updateObject();
                myBean.reset() ;
                setObject(myBean);
            } catch (RemoteException exc) {
                JOptionPane.showMessageDialog(
                    this,                                // Parent
                    exc.toString(),                        // Msg
                    "AbleBeanWrapperCustomizer Error: ResetButton()",         // Title
                    JOptionPane.ERROR_MESSAGE            // Severity
                );
            }
        }


    /**
     * Determine the copyright of this class.
     *
     * @return    A String containing this class's copyright statement.
     *            <p>
     */
    private static String Copyright() {
      return Able.Copyright;
    }

}


