package com.ibm.able.examples;

//====================================================================
//
// Licensed Materials - Property of IBM
//
// "Restricted Materials of IBM"
//
// Product: com.ibm.able.examples
//
// (C) Copyright IBM Corp. 2000 All Rights Reserved.
//
// US Government Users Restricted Rights - Use, duplication or
// disclosure restricted by GSA ADP Schedule Contract with
// IBM Corp.
//
//
//                             DISCLAIMER
//                             ----------
//
// This material contains programming source code for your consideration.
// These examples have not been thoroughly tested under all conditions.
// IBM, therefore, cannot guarantee or imply reliability, serviceability,
// performance or function of these programs.  All programs contained
// herein are provided to you "AS IS".  THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY
// DISCLAIMED.
//
//====================================================================

//====================================================================
// Imports
//====================================================================
 

import com.ibm.able.AbleEvent;
import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;


/**
 *  This class is a wrapper for custom algorithms.  Its intended to
 *  allow the developer to implement the interfaces needed to incorporate
 *  an algorithm in Able with minimal changes to the original class.
 *  To use this class, substitute your own package in place of
 *  com\ibm\able\examples, and globally change the string <i>BeanWrapper</i>
 *  with the name of your algorithm's class in these class and html files.
 *  This class should include an instance variable for your custom algorithm,
 *  called <i>myBeanWrapper</i> in this template.
 *
 * @version  $Revision: 1.5 $, $Date: 2001/09/26 20:17:01 $
 *
 * @author   Joe Bigus
 */
 public class AbleBeanWrapper extends AbleObject {


  //==================================================================
  //
  // Class Variables
  //
  //==================================================================

  /**
   *  Required for serializable.  When a bean is read from a serialized
   *  form, this variable can be used to determine its version id.
   *  Change this value when changes are made to this class that make
   *  previous versions incompatible.
   * Serialized version identifier in form       YYYYMMDDVerRelModxx
   */
  protected static final long serialVersionUID = 2001100500100300000L;

  /**
   *  Provide a copyright statement for your package to satisfy
   *  intellectual property requirements.  Declare it in this
   *  class and reference it from others.
   */
   public static final String  Copyright = "(C) Copyright IBM Corporation 1999, 2001.";

  //==================================================================
  //
  // Instance Variables
  //
  //==================================================================

  /**
   *  BeanWrapper is the algorithm that processes the data.
   */
   //private BeanWrapper myBeanWrapper = null;

  //==================================================================
  //
  // Constructors
  //
  //==================================================================
  /**
   * Construct an AbleBeanWrapper.
   */
   public AbleBeanWrapper() throws AbleException {
    // may want to get this from a resource bundle
       this("AbleBeanWrapper");
   }


  /**
   * Construct an AbleBeanWrapper with specified name.
   * The constructor:
   * <ol>
   *    <li>Calls the super constructor.
   *    <li>Constructs the underlying custom algorithm object <i>myBeanWrapper</i>.
   *    <li>Allocates the <i>inputBuffer</i> and <i>outputBuffer</i> arrays,
   *        if the size is fixed or can be determined at this time.
   *    <li>Calls the reset method to specify default property values
   *        and property options.
   *    <li>Calls the init method if it is
   *        desired to have the bean up and running when it is constructed,
   *        and all parameters are known at the time of construction.
   * </ol>
   * @param     aName
   *            A String object specifying the object name
   *            <p>
   * @see       AbleBeanWrapper#reset
   */
   public AbleBeanWrapper(String aName) throws AbleException {
       super(aName) ;
       /*-------------------------------------------------------
         Construct the wrapped object
       /*------------------------------------------------------*/
       // myBeanWrapper = new BeanWrapper();

       reset(); // set default properties and processing options
       /*-------------------------------------------------------
         Are you using data buffers?
         If so, allocate the AbleObject input and output buffers here,
         select the array types (String, double, etc).  Enable
         processing in the reset method. */
         //inputBuffer = new String[1];  // inherited from AbleObject
         //outputBuffer = new String[1]; // inherited from AbleObject
       /* -----------------------------------------------------*/
       // init();  // if the bean is ready as soon as constructed
   }


  //------------------------------------------------------------------
  // Processing methods
  //------------------------------------------------------------------
  /**
   * Call any methods in BeanWrapper to initialize the algorithm.
   * Send an event to listeners indicating this bean's state has changed.
   */
   public void init() throws AbleException {
       /*=======================================================
         Initialize the BeanWrapper with methods you've provided. */
         //myBeanWrapper.setSomeProperty("new");
         //myBeanWrapper.init1();
         //myBeanWrapper.init2();
       /*======================================================*/


       /* Show we are ready to process */
       // super.init(); // super class will set state and start threads or
       // setState(AbleState.Initiated); // just say we're ready
   }


  /**
   *  The <b>Reset</b> method sets default property values and
   *  processing options.  These include:
   *  <ol>
   *     <li>Properties of the <i>myBeanWrapper</i> object.
   *     <li>Call any methods unique to <i>myBeanWrapper</i>.
   *     <li>Set or enable Able processing options, including:
   *         <ol>
   *             <li>Timer processing and interval
   *             <li>Data flow processing
   *             <li>Event queue posting and processing
   *         </ol>
   *     <li>May wish to fire a global property change event.
   *  </ol>
   *
   */
   public void reset() throws AbleException {
       /*=======================================================
         Reset BeanWrapper values with methods you've provided.
         You may wish to call the same methods called in init,
         or you may wish to call init directly.*/
         //myBeanWrapper.setSomeProperty("reset");
         //myBeanWrapper.reset();
       /*-------------------------------------------------------
         Are you using timer events?
         If so, set the interval time in milliseconds and enable
         processing. */
         //setSleepTime(1000);
         //setTimerEventProcessingEnabled(false);
       /*------------------------------------------------------*/
       /*-------------------------------------------------------
         Are you using data flow processing?
         If so, set the option as desired. */
         //setDataFlowEnabled(false);
       /*-------------------------------------------------------
         Are you using Able events?
         If so, set the processing and posting options as desired. */
         //setAbleEventProcessingEnabled(Able.ProcessingDisabled_PostingDisabled);
       /*------------------------------------------------------*/
       /*======================================================*/

       /*-------------------------------------------------------
         Notification:
         If you didn't call this bean's init method or you changed
         member variables directly, you may wish to inform listeners
         that a bunch of properties have changed. */
         // firePropertyChange(AbleProperty.UpdateProperties, null, null);
       /*------------------------------------------------------*/

   }


  /**
   * Perform the bean processing function for data buffers.
   *
   * @exception  AbleException
   */
   public void process() throws AbleException {
       /*------------------------------------------------------
         Are you using data buffers?
         If so, */
       /*1. get the data from the input buffer: */
         //processBufferConnections();
       /*======================================================*/
       /*2. process it, and put it in the outputbuffer:
           a. If you have lots of logic to be handled inside your algorithm: */
         //outputBuffer = myBeanWrapper.process(inputBuffer);
       /*  b. If you just want to update a property or two: */
         //Object in = getInputBuffer(0);
         //if (in != null) {
         //   myBeanWrapper.setSomeProperty((String)in);
              //   or set values from buffer directly
         //   setOutputBuffer(0,(String)in);}
       /*======================================================*/
       /*3. tell any AbleEventListeners that we changed */
         //dataChanged(this);
       /* -----------------------------------------------------*/

   }


  /**
   * Perform the bean processing function to do when the timer interval expires.
   *
   * @exception  AbleException
   */
   public void processTimerEvent() throws AbleException {
       /*-------------------------------------------------------
         Are you using timer events?
         Either implement process and call it from this method,
         or use process as a template to follow but provide the
         additional calls to the BeanWrapper as you require. */
         //process();
       /* -----------------------------------------------------*/

   }

  /**
   *  Process an AbleEvent sent by another Able bean.
   *  The super method handles both synchronous and asynchronous processing,
   *  and calls processAbleEvent if the event is synchronous;  if asynchronous,
   *  it posts the event to the queue.
   *
   */
   public void handleAbleEvent(AbleEvent theEvent) throws AbleException {
       /*-------------------------------------------------------
         Are you using Able events?                            */
       //Object theObject = theEvent.getGenSource();
       super.handleAbleEvent(theEvent);   // or if you don't handle the event here
       /*------------------------------------------------------*/

       //
   }

  /**
   *  Process an AbleEvent sent by another Able bean.
   *  The super method handles only synchronous.
   */
   public void processAbleEvent(AbleEvent theEvent) throws AbleException {
       /*-------------------------------------------------------
         Are you using Able events?                            */
       //Object theObject = theEvent.getGenSource();
       if (theEvent.getAction() != null) {
         super.processAbleEvent(theEvent);   // let him handle action events
       } else { // you handle data events
         //process(theEvent.getGenSource());   // you write this method or enter the logic here
       }
      /*------------------------------------------------------*/
   }


  //------------------------------------------------------------------
  // Get/Set methods for accessing class member values in BeanWrapper
  //------------------------------------------------------------------

  /**
   *   Set the value for some String property in BeanWrapper, and fire a
   *   propertyChange event to notify any propertyChange listeners.
   */
   public void setSomeProperty(String newValue) throws AbleException {
       //String oldValue = myBeanWrapper.getSomeProperty();
       //myBeanWrapper.setSomeProperty(newValue);
       //firePropertyChange("someProperty", oldValue, newValue);
   }

  /**
   *   Get the value for some String property from the BeanWrapper
   *   <i>SomeProperty</i> will be visible from an inspector.
   */
   public String getSomeProperty() {
       return null; //myBeanWrapper.getSomeProperty();
   }

  //------------------------------------------------------------------
  // Miscellaneous methods
  //------------------------------------------------------------------

  /**
   * Determine the copyright of this class.
   *
   * @return    A String containing this class's copyright statement.
   *            <p>
   */
   private static String Copyright() {
       return AbleBeanWrapper.Copyright;
   }


}
