/*----------------------------------------------------------------------------
#
#  Run the ABLE JAS Platform on the specified port.
#
#---------------------------------------------------------------------------*/
    Parse Arg a_Port;

    If a_Port = '' then
      Do;
        Say "Port number is required."
        Exit 28;
      End;

    /*----------------------------------------------------------------------*/
    /* Get the current directory:                                           */
    /*----------------------------------------------------------------------*/
    w_Dir = DIRECTORY();

    /*----------------------------------------------------------------------*/
    /* Parse out the directory:                                             */
    /*----------------------------------------------------------------------*/
    w_Dir2 = Translate(w_Dir," ","\")                                  /* " */

    wPos      = Words(w_Dir2);
    w_DirBin  = Word( w_Dir2, wPos    );
    w_DirAble = Word( w_Dir2, wPos - 1);
    w_DirAble = SubStr(w_DirAble, 1, 4, ' ');

    /*----------------------------------------------------------------------*/
    /* We must be in a recognisable directory:                              */
    /*----------------------------------------------------------------------*/
    If Translate(w_DirAble) <> 'ABLE' then
      Do;
        Say "Directory is" w_DirAble
        Say "You must cd to the able/bin directory to run this command file."
        Exit 28;
      End;

    /*----------------------------------------------------------------------*/
    /* Parse out more from the directory:                                   */
    /*----------------------------------------------------------------------*/
    wLPos       = LastPos('\', w_Dir);                                 /* ' */
    w_AbleHome  = Left(w_Dir,wLPos-1);
    w_AbleLib   = w_AbleHome"\lib"
    w_AblePref  = w_AbleHome"\.."
    w_Classpath = value("CLASSPATH",,"ENVIRONMENT");
    w_JavaHome  = value("JAVA_HOME",,"ENVIRONMENT");

    /*Say "DirBin is   <"||w_DirBin||">"       */
    /*Say "AbleBin is  <"||w_DirAble||">"      */
    /*Say "AbleHome is <"||w_AbleHome||">"     */
    /*Say "AbleLib is  <"||w_AbleLib||">"      */
    /*Say "Classpath is  <"||w_Classpath||">"  */

    /*----------------------------------------------------------------------*/
    /* Set up the classpath:                                                */
    /*----------------------------------------------------------------------*/
    w_cls = '.;';
    w_cls = w_cls||w_AbleLib'\able.jar;'
    w_cls = w_cls||w_AbleLib'\ableplatform.jar;'
    w_cls = w_cls||w_AbleLib'\amabLogic.jar;'
    w_cls = w_cls||w_AbleLib'\jas.jar;'
    w_cls = w_cls||w_AbleLib'\JLog.jar;'
    w_cls = w_cls||w_Classpath;

    /*----------------------------------------------------------------------*/
    /* Set up the command:                                                  */
    /*----------------------------------------------------------------------*/
    w_cmd = '';
    w_cmd = w_cmd 'java.exe'
    w_cmd = w_cmd ' -Dable.home='w_AbleHome
    w_cmd = w_cmd ' -Dable.prefdir='w_AblePref
    w_cmd = w_cmd ' -classpath' '"'w_cls'"'
    w_cmd = w_cmd ' com.ibm.able.platform.AblePlatformSupportImpl'
    w_cmd = w_cmd a_Port

    /*----------------------------------------------------------------------*/
    /* Echo back a warm fuzzy to the caller:                                */
    /*----------------------------------------------------------------------*/
/*    Say w_cmd;*/

    /*----------------------------------------------------------------------*/
    /* Execute the command:                                                 */
    /*----------------------------------------------------------------------*/
    Address CMD w_cmd;

    /*----------------------------------------------------------------------*/
    /* Return to caller:                                                    */
    /*----------------------------------------------------------------------*/
    Exit 0;

/**/
/* NOTE: ---------------------------------------------------------------    */
/* The following comments are used by the emacs editor; they are            */
/* here for no other purpose, and must appear on the last page of a         */
/* source file.                                                             */
/* ---------------------------------------------------------------------    */
/* Local Variables:                                                         */
/* mode:           rexx                                                     */
/* abbrev-mode:    t                                                        */
/* End:                                                                     */
