/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging.mgr;

import com.ibm.logging.IConstants;
import com.ibm.logging.IGate;
import com.ibm.logging.IHandler;
import com.ibm.logging.ILogger;
import com.ibm.logging.LogUtil;
import com.ibm.logging.mgr.Config;
import com.ibm.logging.mgr.IManageable;
import com.ibm.logging.mgr.LogManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Group
extends Hashtable
implements IConstants {
    private static final String CR = "(C) Copyright IBM Corp. 1998, 1999.";
    static final long serialVersionUID = 3318254944961583139L;
    private boolean modified = false;
    private String desc = "";
    private String name = "";

    public Group(String string) throws IllegalArgumentException {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException(LogUtil.getLogMessage("ERR_GROUP_NAME"));
        }
        this.setName(string);
    }

    public Group(String string, String string2) throws IllegalArgumentException {
        this(string);
        this.setDescription(string2);
    }

    public void addConfig(Config config) throws IllegalArgumentException {
        if (config != null) {
            String string = config.getProperty("name");
            if (string == null) {
                throw new IllegalArgumentException(LogUtil.getLogMessage("ERR_CONFIG_NAME", this.getName()));
            }
            String string2 = this.getClass().getName();
            if (!((Hashtable)config).containsKey("group") && !string2.equals("com.ibm.logging.mgr.BaseGroup")) {
                ((Hashtable)config).put("group", this.getName());
            }
            this.put(string, config);
        }
    }

    public Config getConfig(String string) {
        Config config = null;
        if (string != null) {
            config = (Config)this.get(string);
        }
        return config;
    }

    public Enumeration getConfigs() {
        return this.elements();
    }

    public Enumeration getConfigs(String string) {
        Vector<Config> vector = new Vector<Config>();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Config config = (Config)enumeration.nextElement();
            if (!((Hashtable)config).containsKey(string)) continue;
            vector.addElement(config);
        }
        return vector.elements();
    }

    public Enumeration getConfigs(String string, String string2) {
        Vector<Config> vector = new Vector<Config>();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Config config = (Config)enumeration.nextElement();
            String string3 = config.getProperty(string);
            if (string3 == null || !string3.equals(string2)) continue;
            vector.addElement(config);
        }
        return vector.elements();
    }

    public String getDescription() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    public synchronized boolean isModified() {
        return this.modified;
    }

    public void removeConfig(Config config) {
        if (config != null) {
            this.removeConfig(config.getProperty("name"));
        }
    }

    public void removeConfig(String string) {
        if (string != null) {
            this.remove(string);
        }
    }

    public void setDescription(String string) {
        if (string != null) {
            this.desc = string;
        }
    }

    public synchronized void setModified(boolean bl) {
        this.modified = bl;
    }

    public void setName(String string) {
        if (string != null && !string.equals("")) {
            this.name = string;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Group:  " + this.getName() + "\r\n");
        if (this.isEmpty()) {
            stringBuffer.append("  Empty");
        } else {
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                Config config = (Config)enumeration.nextElement();
                stringBuffer.append(config.toString());
            }
        }
        return stringBuffer.toString();
    }

    public void update(Group group, LogManager logManager) {
        if (group != null) {
            Enumeration enumeration = group.getConfigs();
            while (enumeration.hasMoreElements()) {
                Config config = (Config)enumeration.nextElement();
                String string = config.getProperty("name");
                Config config2 = this.getConfig(string);
                if (config2 == null) {
                    this.addConfig(config);
                    continue;
                }
                config2.update(config);
                IManageable iManageable = config2.getObject();
                if (iManageable == null) continue;
                if (iManageable instanceof ILogger) {
                    logManager.addHandlers((ILogger)iManageable, config2, this);
                    logManager.addFilters((IGate)iManageable, config2, this);
                    continue;
                }
                if (!(iManageable instanceof IHandler)) continue;
                logManager.addFormatters((IHandler)iManageable, config2, this);
                logManager.addFilters((IGate)iManageable, config2, this);
            }
        }
    }
}

