/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging;

import com.ibm.logging.ILogRecord;
import com.ibm.logging.LogUtil;
import com.ibm.logging.MultiFileHandler;
import com.ibm.logging.NestedException;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;

public class SerialFileHandler
extends MultiFileHandler {
    private static final String CR = "(C) Copyright IBM Corp. 1999.";
    static final long serialVersionUID = -3739196948239217286L;
    private transient File outputFile = null;
    private transient FileDescriptor outputFileDesc = null;
    private transient ObjectOutput objectOutput = null;

    public SerialFileHandler() {
    }

    public SerialFileHandler(String string) {
        super(string);
    }

    public SerialFileHandler(String string, String string2) {
        super(string, string2);
    }

    public SerialFileHandler(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public void closeDevice() {
        Object object = this.deviceLock;
        synchronized (object) {
            super.closeDevice();
            try {
                if (this.objectOutput != null) {
                    this.objectOutput.close();
                }
            }
            catch (Exception exception) {}
            this.outputFile = null;
            this.objectOutput = null;
        }
    }

    protected void openFile() throws NestedException {
        long l = -1L;
        long l2 = this.getMaxFileSize() * 1024;
        int n = this.getMaxFiles();
        try {
            boolean bl;
            if (n > 1 && this.outputFile != null) {
                this.outputFileDesc.sync();
                l = this.outputFile.length();
            }
            boolean bl2 = bl = n != 1 && l >= l2;
            if (!this.deviceOpen || bl) {
                Object object;
                this.closeDevice();
                String string = this.getFileName();
                LogUtil.makePath(string);
                if (bl) {
                    object = this.getDirList(this.fileDir);
                    object = this.deleteExtraFiles((Vector)object, this.fileDir);
                    this.renameFiles((Vector)object, this.fileDir);
                }
                object = new FileOutputStream(string, true);
                this.objectOutput = new ObjectOutputStream((OutputStream)object);
                this.outputFile = new File(string);
                this.outputFileDesc = ((FileOutputStream)object).getFD();
                this.deviceOpen = true;
            }
        }
        catch (Exception exception) {
            String string = LogUtil.getLogMessage("ERR_OPEN_FILE", this.fileName);
            throw new NestedException(string, exception);
        }
    }

    private Vector readRecords() throws ClassNotFoundException, FileNotFoundException, IOException, StreamCorruptedException {
        ObjectInput objectInput = null;
        String string = null;
        Vector<ILogRecord> vector = new Vector<ILogRecord>();
        Object object = this.deviceLock;
        synchronized (object) {
            this.closeDevice();
            Vector vector2 = this.getDirList(this.fileDir);
            try {
                int n = 0;
                while (n < vector2.size()) {
                    string = String.valueOf(this.fileDir) + vector2.elementAt(n);
                    objectInput = new ObjectInputStream(new FileInputStream(string));
                    boolean bl = false;
                    while (!bl) {
                        try {
                            vector.addElement((ILogRecord)objectInput.readObject());
                        }
                        catch (EOFException eOFException) {
                            bl = true;
                        }
                    }
                    objectInput.close();
                    ++n;
                }
                objectInput = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (objectInput != null) {
                    try {
                        objectInput.close();
                    }
                    catch (Exception exception) {
                        LogUtil.errorMsg(LogUtil.getLogMessage("ERR_CLOSE_STREAM", this.getName(), string));
                        exception.printStackTrace();
                    }
                }
                throw throwable;
            }
            Object var8_10 = null;
            if (objectInput != null) {
                try {
                    objectInput.close();
                }
                catch (Exception exception) {
                    LogUtil.errorMsg(LogUtil.getLogMessage("ERR_CLOSE_STREAM", this.getName(), string));
                    exception.printStackTrace();
                }
            }
        }
        return vector;
    }

    public Vector readSerializedRecords() throws Exception, AccessControlException {
        Vector vector;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            vector = this.readRecords();
        } else {
            try {
                vector = (Vector)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return SerialFileHandler.this.readRecords();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        }
        return vector;
    }

    protected void writeRecord(ILogRecord iLogRecord) throws NestedException {
        this.openDevice();
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.deviceOpen) {
                try {
                    this.objectOutput.writeObject(iLogRecord);
                    this.objectOutput.flush();
                }
                catch (Exception exception) {
                    this.closeDevice();
                    String string = LogUtil.getLogMessage("ERR_WRITE_MSG", this.getName());
                    throw new NestedException(string, exception);
                }
            }
        }
    }
}

