/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging;

import com.ibm.logging.IConstants;
import com.ibm.logging.ILogObject;
import com.ibm.logging.ILogRecord;
import com.ibm.logging.LogUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public abstract class LogObject
implements Cloneable,
IConstants,
ILogObject {
    private static final String CR = "(C) Copyright IBM Corp. 1998, 1999.";
    private transient boolean managed;
    private String className;
    private String desc;
    private String group;
    private String name;
    private String type;
    private Vector recordClasses;

    public LogObject() {
        this.init();
    }

    public LogObject(String string) {
        this();
        this.setName(string);
    }

    public LogObject(String string, String string2) {
        this(string);
        this.setDescription(string2);
    }

    public void addRecordClass(String string) {
        if (string != null && !this.recordClasses.contains(string)) {
            this.recordClasses.addElement(string);
        }
    }

    public synchronized Object clone() {
        try {
            LogObject logObject = (LogObject)super.clone();
            return logObject;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Properties getConfig() {
        Properties properties = new Properties();
        if (!this.getName().equals("")) {
            ((Hashtable)properties).put("name", this.getName());
        }
        if (!this.getDescription().equals("")) {
            ((Hashtable)properties).put("description", this.getDescription());
        }
        if (this.className.equals("")) {
            ((Hashtable)properties).put("className", this.getClass().getName());
        } else {
            ((Hashtable)properties).put("className", this.className);
        }
        if (!this.getGroup().equals("")) {
            ((Hashtable)properties).put("group", this.getGroup());
        }
        if (!this.getType().equals("")) {
            ((Hashtable)properties).put("objectType", this.getType());
        }
        ((Hashtable)properties).put("recordClasses", LogUtil.vectorToString(this.recordClasses));
        return properties;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public Enumeration getRecordClasses() {
        return this.recordClasses.elements();
    }

    public String getType() {
        return this.type;
    }

    public void init() {
        this.setManaged(false);
        this.className = "";
        this.setDescription("");
        this.setGroup("");
        this.setName("");
        this.setType("");
        if (this.recordClasses == null) {
            this.recordClasses = new Vector();
        } else {
            this.recordClasses.removeAllElements();
        }
        this.addRecordClass("com.ibm.logging.LogRecord");
    }

    public boolean isManaged() {
        return this.managed;
    }

    public long maskLongValue(String string) {
        long l = 0L;
        if (string != null) {
            Enumeration enumeration = this.getRecordClasses();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                ILogRecord iLogRecord = (ILogRecord)LogUtil.createObject(string2);
                if (iLogRecord == null) continue;
                l |= iLogRecord.maskLongValue(string);
            }
        }
        return l;
    }

    public String maskToString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.getRecordClasses();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ILogRecord iLogRecord = (ILogRecord)LogUtil.createObject(string);
            if (iLogRecord == null) continue;
            stringBuffer.append(iLogRecord.maskToString(l));
            stringBuffer.append(" ");
        }
        return stringBuffer.toString().trim();
    }

    public void removeRecordClass(String string) {
        if (string != null && this.recordClasses.contains(string)) {
            this.recordClasses.removeElement(string);
        }
    }

    public void setConfig(Properties properties) {
        String string = properties.getProperty("name");
        if (string != null) {
            this.setName(string);
        }
        if ((string = properties.getProperty("description")) != null) {
            this.setDescription(string);
        }
        if ((string = properties.getProperty("group")) != null) {
            this.setGroup(string);
        }
        if ((string = properties.getProperty("className")) != null) {
            this.className = string;
        }
        if ((string = properties.getProperty("objectType")) != null) {
            this.setType(string);
        }
        if ((string = properties.getProperty("recordClasses")) != null) {
            this.recordClasses = LogUtil.stringToVector(string);
        }
    }

    public void setDescription(String string) {
        if (string != null) {
            this.desc = string;
        }
    }

    public void setGroup(String string) {
        if (string != null) {
            this.group = string;
        }
    }

    public void setManaged(boolean bl) {
        this.managed = bl;
    }

    public void setName(String string) {
        if (string != null) {
            this.name = string;
        }
    }

    public void setType(String string) {
        if (string != null) {
            this.type = string;
        }
    }

    public String toString() {
        String string = this.getName();
        if (string.equals("")) {
            string = "(none)";
        }
        return "name=" + string + ", class=" + this.getClass().getName();
    }
}

