/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging;

import com.ibm.logging.IFilter;
import com.ibm.logging.IGate;
import com.ibm.logging.ILogRecord;
import com.ibm.logging.LogObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public abstract class Gate
extends LogObject
implements IGate {
    private static final String CR = "(C) Copyright IBM Corp. 1999.";
    public boolean isLogging;
    protected transient long loggedRecordCount;
    private String filterNames;
    private Vector filters;

    public Gate() {
    }

    public Gate(String string) {
        super(string);
    }

    public Gate(String string, String string2) {
        super(string, string2);
    }

    public void addFilter(IFilter iFilter) {
        if (iFilter != null && !this.filters.contains(iFilter)) {
            this.filters.addElement(iFilter);
        }
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        ((Hashtable)properties).put("isLogging", new Boolean(this.isLogging).toString());
        if (!this.filterNames.equals("")) {
            ((Hashtable)properties).put("filterNames", this.filterNames);
        }
        return properties;
    }

    public Enumeration getFilters() {
        return this.filters.elements();
    }

    public void init() {
        super.init();
        this.setLogging(true);
        this.loggedRecordCount = 0L;
        this.filterNames = "";
        if (this.filters == null) {
            this.filters = new Vector();
        } else {
            this.filters.removeAllElements();
        }
    }

    public boolean isLoggable(ILogRecord iLogRecord) {
        boolean bl = false;
        if (this.isLogging) {
            bl = true;
            Enumeration enumeration = this.getFilters();
            while (bl && enumeration.hasMoreElements()) {
                IFilter iFilter = (IFilter)enumeration.nextElement();
                bl = iFilter.isLoggable(iLogRecord);
            }
        }
        return bl;
    }

    public boolean isLogging() {
        return this.isLogging;
    }

    public void removeAllFilters() {
        this.filters.removeAllElements();
    }

    public void removeFilter(IFilter iFilter) {
        if (iFilter != null && this.filters.contains(iFilter)) {
            this.filters.removeElement(iFilter);
        }
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("isLogging");
        if (string != null) {
            this.isLogging = new Boolean(string);
        }
        if ((string = properties.getProperty("filterNames")) != null) {
            this.filterNames = string;
        }
    }

    public void setLogging(boolean bl) {
        this.isLogging = bl;
    }

    public String toString() {
        String string = super.toString();
        return String.valueOf(string) + ", isLogging=" + this.isLogging() + ", loggedRecords=" + this.loggedRecordCount;
    }
}

