/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging;

import com.ibm.logging.Handler;
import com.ibm.logging.IConstants;
import com.ibm.logging.LogUtil;
import com.ibm.logging.NestedException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Properties;

public class FileHandler
extends Handler
implements IConstants {
    private static final String CR = "(C) Copyright IBM Corp. 1998.";
    static final long serialVersionUID = 6304371609654288622L;
    private String encoding;
    protected String fileName;
    protected String orgFileName;

    public FileHandler() {
    }

    public FileHandler(String string) {
        super(string);
    }

    public FileHandler(String string, String string2) {
        super(string, string2);
    }

    public FileHandler(String string, String string2, String string3) {
        super(string, string2);
        this.setFileName(string3);
    }

    public FileHandler(String string, String string2, String string3, String string4) {
        this(string, string2, string3);
        this.setEncoding(string4);
    }

    private void deleteFile() {
        File file;
        String string = this.getFileName();
        if (string != null && (file = new File(string)).exists() && !file.delete()) {
            LogUtil.errorMsg(LogUtil.getLogMessage("ERR_DELETE_FILE", string));
        }
    }

    public void deleteLog() {
        Object object = this.deviceLock;
        synchronized (object) {
            this.closeDevice();
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                this.deleteFile();
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        FileHandler.this.deleteFile();
                        return null;
                    }
                });
            }
        }
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        if (this.orgFileName != null) {
            ((Hashtable)properties).put("fileName", this.orgFileName);
        }
        if (this.getEncoding() != null) {
            ((Hashtable)properties).put("encoding", this.getEncoding());
        }
        return properties;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void init() {
        super.init();
        this.setEncoding(null);
        this.fileName = null;
        this.orgFileName = null;
    }

    public void openDevice() throws NestedException, AccessControlException {
        Object object = this.deviceLock;
        synchronized (object) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                this.openFile();
            } else {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            FileHandler.this.openFile();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (NestedException)privilegedActionException.getException();
                }
            }
        }
    }

    protected void openFile() throws NestedException {
        this.closeDevice();
        String string = this.getFileName();
        try {
            LogUtil.makePath(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string, true);
            String string2 = this.getEncoding();
            OutputStreamWriter outputStreamWriter = string2 == null ? new OutputStreamWriter(fileOutputStream) : new OutputStreamWriter((OutputStream)fileOutputStream, string2);
            this.pWriter = new PrintWriter((Writer)new BufferedWriter(outputStreamWriter), true);
            this.deviceOpen = true;
        }
        catch (Exception exception) {
            String string3 = LogUtil.getLogMessage("ERR_OPEN_FILE", string);
            throw new NestedException(string3, exception);
        }
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("fileName");
        if (string != null) {
            this.setFileName(string);
        }
        if ((string = properties.getProperty("encoding")) != null) {
            this.setEncoding(string);
        }
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setFileName(String string) {
        if (string != null) {
            this.orgFileName = string;
            this.fileName = string.replace('/', File.separatorChar);
        }
    }

    public String toString() {
        String string = super.toString();
        return String.valueOf(string) + ", fileName=" + this.getFileName();
    }
}

