/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.platform;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.platform.AbleBasicService;
import com.ibm.able.platform.AblePersistenceSupport;
import com.ibm.able.platform.AblePersistenceSupportProcessor;
import com.ibm.able.platform.AblePlatform;
import com.ibm.able.platform.AblePlatformPreferences;
import com.ibm.able.platform.AblePlatformServiceEventListener;
import com.ibm.able.platform.AblePlatformSupport;
import com.ibm.able.platform.AblePlatformSupportImpl;
import com.ibm.able.platform.AbleSecureKey;
import com.ibm.able.platform.AgentLifeCycleException;
import com.ibm.able.platform.AgentLifeCycleFailure;
import com.ibm.able.platform.AgentLifeCycleService;
import com.ibm.able.platform.PlatformSupportService;
import com.ibm.able.platform.PlatformSupportServiceException;
import com.ibm.able.platform.RmiPlatformSupportService;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.agent.service.ServiceProperties;
import javax.agent.service.ServiceRoot;
import javax.agent.service.naming.NamingException;

public final class RmiPlatformSupportServiceSystem
extends AbleBasicService
implements RmiPlatformSupportService,
AblePersistenceSupportProcessor {
    private boolean myPersistenceFlag = false;
    private AblePersistenceSupport myPrsSppt = null;
    private boolean myPrsSpptIsDone = false;

    private boolean persistenceIsOn() {
        return this.myPersistenceFlag;
    }

    public RmiPlatformSupportServiceSystem() throws Exception {
        this.setState(2);
    }

    public RmiPlatformSupportServiceSystem(ServiceProperties serviceProperties) throws Exception {
        super(serviceProperties);
        AblePlatformPreferences.ServiceEntry_ serviceEntry_ = AblePlatform.Preferences.getServiceEntry("agent-naming-service");
        this.myPersistenceFlag = serviceEntry_.getPersistenceFlag();
        if (this.persistenceIsOn()) {
            this.setState(3);
            String[] stringArray = PlatformSupportService.COLUMN_NAMES;
            String[] stringArray2 = PlatformSupportService.COLUMN_TYPES;
            this.myPrsSppt = new AblePersistenceSupport(serviceEntry_.getPersistenceDatabase(), serviceEntry_.getPersistenceTable() + "PlatformSupportServiceEventListeners", serviceEntry_.getPersistenceSchema(), new String[]{stringArray[0]}, new String[]{stringArray2[0]}, serviceEntry_.getPersistenceRetry(), this, this.mySecSppt);
        } else {
            this.setState(2);
        }
        this.bindServiceToRegistry();
    }

    public String getBindingName() {
        return "platform-support-service";
    }

    public void addAblePlatformServiceEventListener(AblePlatformServiceEventListener ablePlatformServiceEventListener) throws AbleException {
        super.addAblePlatformServiceEventListener(ablePlatformServiceEventListener);
        if (this.persistenceIsOn()) {
            this.myPrsSppt.insert(new Serializable[]{(Serializable)((Object)ablePlatformServiceEventListener)});
        }
    }

    public void removeAblePlatformServiceEventListener(AblePlatformServiceEventListener ablePlatformServiceEventListener) throws AbleException {
        super.removeAblePlatformServiceEventListener(ablePlatformServiceEventListener);
        if (this.persistenceIsOn()) {
            HashMap<String, AblePlatformServiceEventListener> hashMap = new HashMap<String, AblePlatformServiceEventListener>();
            hashMap.put(this.myPrsSppt.getTableColumnNames()[0], ablePlatformServiceEventListener);
            this.myPrsSppt.delete(hashMap);
        }
    }

    public void terminateService(AbleSecureKey ableSecureKey) throws AbleException, NamingException {
        String string = "terminateService";
        if (Able.Preferences.isSecure()) {
            this.mySecSppt.verifyKey(ableSecureKey);
            this.mySecSppt.verifyTrustLevel(ableSecureKey, string);
        }
        if (this.myPrsSppt != null) {
            this.myPrsSppt.quitAll();
        }
        super.terminateService(Able.Preferences.isSecure() ? this.mySecSppt.generateKey(ableSecureKey) : null);
        this.terminateZapInternals();
    }

    private void terminateZapInternals() {
        this.myPrsSppt = null;
    }

    public void quiesceAgentPool(String string, AbleSecureKey ableSecureKey) throws RemoteException, PlatformSupportServiceException {
        String string2 = "quiesceAgentPool(String,AbleSecureKey)";
        boolean bl = Able.Preferences.isSecure();
        if (bl) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (AbleException ableException) {
                throw this.unableToVerifyKey(string2, ableSecureKey, (Exception)((Object)ableException));
            }
            catch (NamingException namingException) {
                throw this.unableToVerifyKey(string2, ableSecureKey, (Exception)((Object)namingException));
            }
        }
        ServiceRoot serviceRoot = null;
        AgentLifeCycleService agentLifeCycleService = null;
        serviceRoot = AblePlatform.getServiceRoot(null);
        agentLifeCycleService = (AgentLifeCycleService)serviceRoot.getService("agent-life-cycle-service");
        try {
            agentLifeCycleService.quiesceAgentPool(string, ableSecureKey);
        }
        catch (AgentLifeCycleException agentLifeCycleException) {
            throw this.unableToPerformService(string2, (Exception)((Object)agentLifeCycleException), "PSS_Ex_FailedToQuiesceAgentPool", new Object[]{string});
        }
        catch (AgentLifeCycleFailure agentLifeCycleFailure) {
            throw this.unableToPerformService(string2, (Exception)((Object)agentLifeCycleFailure), "PSS_Ex_FailedToQuiesceAgentPool", new Object[]{string});
        }
        catch (NamingException namingException) {
            throw this.unableToPerformService(string2, (Exception)((Object)namingException), "PSS_Ex_FailedToQuiesceAgentPool", new Object[]{string});
        }
        if (this.myServiceEventListeners.size() > 0) {
            this.thenNotifyAblePlatformServiceEventListeners(string2, 401, AblePlatform.NlsMsg("PSS_AgentPoolQuiesced", new Object[]{string}), null, null, this.myPrsSppt, this.myPrsSppt == null ? null : this.myPrsSppt.getTableColumnNames()[0]);
        }
    }

    public void recoverAgentPool(String string, AbleSecureKey ableSecureKey) throws RemoteException, PlatformSupportServiceException {
        String string2 = "recoverAgentPool(String,AbleSecureKey)";
        boolean bl = Able.Preferences.isSecure();
        if (bl) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (AbleException ableException) {
                throw this.unableToVerifyKey(string2, ableSecureKey, (Exception)((Object)ableException));
            }
            catch (NamingException namingException) {
                throw this.unableToVerifyKey(string2, ableSecureKey, (Exception)((Object)namingException));
            }
        }
        ServiceRoot serviceRoot = null;
        AgentLifeCycleService agentLifeCycleService = null;
        serviceRoot = AblePlatform.getServiceRoot(null);
        agentLifeCycleService = (AgentLifeCycleService)serviceRoot.getService("agent-life-cycle-service");
        try {
            agentLifeCycleService.recoverAgentPool(string, ableSecureKey);
        }
        catch (AgentLifeCycleException agentLifeCycleException) {
            throw this.unableToPerformService(string2, (Exception)((Object)agentLifeCycleException), "PSS_Ex_FailedToQuiesceAgentPool", new Object[]{string});
        }
        catch (AgentLifeCycleFailure agentLifeCycleFailure) {
            throw this.unableToPerformService(string2, (Exception)((Object)agentLifeCycleFailure), "PSS_Ex_FailedToQuiesceAgentPool", new Object[]{string});
        }
        catch (NamingException namingException) {
            throw this.unableToPerformService(string2, (Exception)((Object)namingException), "PSS_Ex_FailedToQuiesceAgentPool", new Object[]{string});
        }
        if (this.myServiceEventListeners.size() > 0) {
            this.thenNotifyAblePlatformServiceEventListeners(string2, 406, AblePlatform.NlsMsg("PSS_AgentPoolRecovered", new Object[]{string}), null, null, this.myPrsSppt, this.myPrsSppt == null ? null : this.myPrsSppt.getTableColumnNames()[0]);
        }
    }

    public void terminateAgentPool(String string, AbleSecureKey ableSecureKey) throws RemoteException, PlatformSupportServiceException {
        String string2 = "terminateAgentPool(String,AbleSecureKey)";
        boolean bl = Able.Preferences.isSecure();
        if (bl) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (AbleException ableException) {
                throw this.unableToVerifyKey(string2, ableSecureKey, (Exception)((Object)ableException));
            }
            catch (NamingException namingException) {
                throw this.unableToVerifyKey(string2, ableSecureKey, (Exception)((Object)namingException));
            }
        }
        this.quiesceAgentPool(string, ableSecureKey);
        AblePlatformSupport ablePlatformSupport = this.getAgentPoolByAlias(string, string2);
        try {
            ablePlatformSupport.terminatePlatformSupport(ableSecureKey);
        }
        catch (NamingException namingException) {
            throw this.unableToPerformService(string2, (Exception)((Object)namingException), "PSS_Ex_FailedToTerminateAgentPool", new Object[]{string});
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.myServiceEventListeners.size() > 0) {
            this.thenNotifyAblePlatformServiceEventListeners(string2, 404, AblePlatform.NlsMsg("PSS_AgentPoolTerminated", new Object[]{string}), null, null, this.myPrsSppt, this.myPrsSppt == null ? null : this.myPrsSppt.getTableColumnNames()[0]);
        }
    }

    public void terminatePlatform(AbleSecureKey ableSecureKey) throws RemoteException, PlatformSupportServiceException {
        Object object;
        Serializable serializable;
        String string = "terminatePlatform(AbleSecureKey)";
        boolean bl = Able.Preferences.isSecure();
        if (bl) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (AbleException ableException) {
                throw this.unableToVerifyKey(string, ableSecureKey, (Exception)((Object)ableException));
            }
            catch (NamingException namingException) {
                throw this.unableToVerifyKey(string, ableSecureKey, (Exception)((Object)namingException));
            }
        }
        AblePlatformSupport ablePlatformSupport = null;
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        AblePlatformSupport ablePlatformSupport2 = null;
        boolean bl3 = false;
        String string4 = null;
        String string5 = null;
        AblePlatformSupport ablePlatformSupport3 = null;
        ServiceRoot serviceRoot = null;
        AgentLifeCycleService agentLifeCycleService = null;
        serviceRoot = AblePlatform.getServiceRoot(null);
        agentLifeCycleService = (AgentLifeCycleService)serviceRoot.getService("agent-life-cycle-service");
        Hashtable hashtable = AblePlatform.Preferences.getAgentPools();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            serializable = (AblePlatformPreferences.AgentPoolEntry_)enumeration.nextElement();
            object = ((AblePlatformPreferences.AgentPoolEntry_)serializable).getAgentPoolAlias();
            String string6 = ((AblePlatformPreferences.AgentPoolEntry_)serializable).getIpAddress();
            String string7 = ((AblePlatformPreferences.AgentPoolEntry_)serializable).getPort();
            try {
                ablePlatformSupport = AblePlatformSupportImpl.getAblePlatformSupportOn(string6, string7);
            }
            catch (RemoteException remoteException) {
                this.myTrcLog.text(0x100000L, (Object)this, string, "Cannot connect to system <" + string6 + "> on port <" + string7 + ">. System ignored.");
                continue;
            }
            try {
                this.myTrcLog.text(0x100000L, (Object)this, string, "  Quiescing agent pool <" + (String)object + ">.");
                agentLifeCycleService.quiesceAgentPool((String)object, this.secureKeyOrNull());
            }
            catch (AgentLifeCycleException agentLifeCycleException) {
                this.myMsgLog.text(1L, (Object)this, string, "Exception: " + (Object)((Object)agentLifeCycleException));
            }
            catch (AgentLifeCycleFailure agentLifeCycleFailure) {
                this.myMsgLog.text(1L, (Object)this, string, "Failure: " + (Object)((Object)agentLifeCycleFailure));
            }
            catch (NamingException namingException) {
                this.myMsgLog.text(1L, (Object)this, string, "Exception: " + (Object)((Object)namingException));
            }
            Vector vector = AblePlatform.Preferences.configuredServices((String)object);
            if (vector.isEmpty()) {
                try {
                    this.myTrcLog.text(0x100000L, (Object)this, string, "Terminating agent pool on system <" + string6 + ">, port <" + string7 + ">. (No services.)");
                    ablePlatformSupport.terminatePlatformSupport(this.secureKeyOrNull());
                }
                catch (UnmarshalException unmarshalException) {
                }
                catch (NamingException namingException) {
                    this.unableToPerformService(string, (Exception)((Object)namingException), "PSS_ErrorTerminatingPlatformSupportImpl", new Object[]{string6, string7});
                }
                continue;
            }
            boolean bl4 = true;
            for (int i = 0; i < vector.size(); ++i) {
                AblePlatformPreferences.ServiceEntry_ serviceEntry_ = (AblePlatformPreferences.ServiceEntry_)vector.elementAt(i);
                String string8 = serviceEntry_.getServiceType();
                if (string8.equalsIgnoreCase("agent-life-cycle-service")) {
                    bl4 = false;
                    bl2 = true;
                    string2 = string6;
                    string3 = string7;
                    ablePlatformSupport2 = ablePlatformSupport;
                    continue;
                }
                if (!string8.equalsIgnoreCase("agent-naming-service")) continue;
                bl4 = false;
                bl3 = true;
                string4 = string6;
                string5 = string7;
                ablePlatformSupport3 = ablePlatformSupport;
            }
            if (!bl4) continue;
            try {
                this.myTrcLog.text(0x100000L, (Object)this, string, "Terminating agent pool on system <" + string6 + ">, port <" + string7 + ">. (No essential services.)");
                ablePlatformSupport.terminatePlatformSupport(this.secureKeyOrNull());
            }
            catch (UnmarshalException unmarshalException) {
            }
            catch (NamingException namingException) {
                this.unableToPerformService(string, (Exception)((Object)namingException), "PSS_ErrorTerminatingPlatformSupportImpl", new Object[]{string6, string7});
            }
        }
        serializable = this.secureKeyOrNull();
        object = this.secureKeyOrNull();
        if (bl2) {
            try {
                this.myTrcLog.text(0x100000L, (Object)this, string, "Terminating agent pool on system <" + string2 + ">, port <" + string3 + ">. (Contains AgentLifecycleService.)");
                ablePlatformSupport2.terminatePlatformSupport((AbleSecureKey)serializable);
            }
            catch (UnmarshalException unmarshalException) {
            }
            catch (NamingException namingException) {
                this.unableToPerformService(string, (Exception)((Object)namingException), "PSS_ErrorTerminatingPlatformSupportImpl", new Object[]{string2, string3});
            }
        }
        if (!(!bl3 || string4.equalsIgnoreCase(string2) && string5.equalsIgnoreCase(string3))) {
            try {
                this.myTrcLog.text(0x100000L, (Object)this, string, "Terminating agent pool on system <" + string4 + ">, port <" + string5 + ">. (Contains AgentNamingService.)");
                ablePlatformSupport3.terminatePlatformSupport((AbleSecureKey)object);
            }
            catch (UnmarshalException unmarshalException) {
            }
            catch (NamingException namingException) {
                this.unableToPerformService(string, (Exception)((Object)namingException), "PSS_ErrorTerminatingPlatformSupportImpl", new Object[]{string4, string5});
            }
        }
        if (this.myServiceEventListeners.size() > 0) {
            this.thenNotifyAblePlatformServiceEventListeners(string, 405, AblePlatform.NlsMsg("PSS_PlatformTerminated"), null, null, this.myPrsSppt, this.myPrsSppt == null ? null : this.myPrsSppt.getTableColumnNames()[0]);
        }
    }

    public void refreshAgentPoolPreferences(String string, AbleSecureKey ableSecureKey) throws RemoteException, PlatformSupportServiceException {
        String string2 = "refreshAgentPoolPreferences(String,AbleSecureKey)";
        boolean bl = Able.Preferences.isSecure();
        if (bl) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (AbleException ableException) {
                throw this.unableToVerifyKey(string2, ableSecureKey, (Exception)((Object)ableException));
            }
            catch (NamingException namingException) {
                throw this.unableToVerifyKey(string2, ableSecureKey, (Exception)((Object)namingException));
            }
        }
        AblePlatformSupport ablePlatformSupport = this.getAgentPoolByAlias(string, string2);
        try {
            ablePlatformSupport.refreshPreferences(ableSecureKey);
        }
        catch (NamingException namingException) {
            throw this.unableToPerformService(string2, (Exception)((Object)namingException), "PSS_Ex_FailedToRefreshAgentPoolPrefs", new Object[]{string});
        }
        if (this.myServiceEventListeners.size() > 0) {
            this.thenNotifyAblePlatformServiceEventListeners(string2, 402, AblePlatform.NlsMsg("PSS_AgentPoolPrefsRefreshed", new Object[]{string}), null, null, this.myPrsSppt, this.myPrsSppt == null ? null : this.myPrsSppt.getTableColumnNames()[0]);
        }
    }

    public void refreshAgentPoolPreferences(String string, AblePlatformPreferences ablePlatformPreferences, AbleSecureKey ableSecureKey) throws RemoteException, PlatformSupportServiceException {
        String string2 = "refreshAgentPoolPreferences(String,AblePlatformPreferences,AbleSecureKey)";
        boolean bl = Able.Preferences.isSecure();
        if (bl) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (AbleException ableException) {
                throw this.unableToVerifyKey(string2, ableSecureKey, (Exception)((Object)ableException));
            }
            catch (NamingException namingException) {
                throw this.unableToVerifyKey(string2, ableSecureKey, (Exception)((Object)namingException));
            }
        }
        AblePlatformSupport ablePlatformSupport = this.getAgentPoolByAlias(string, string2);
        try {
            ablePlatformSupport.refreshPreferences(ablePlatformPreferences, ableSecureKey);
        }
        catch (NamingException namingException) {
            throw this.unableToPerformService(string2, (Exception)((Object)namingException), "PSS_Ex_FailedToRefreshAgentPoolPrefsFromPrefs", new Object[]{string});
        }
        if (this.myServiceEventListeners.size() > 0) {
            this.thenNotifyAblePlatformServiceEventListeners(string2, 402, AblePlatform.NlsMsg("PSS_AgentPoolPrefsRefreshed", new Object[]{string}), null, null, this.myPrsSppt, this.myPrsSppt == null ? null : this.myPrsSppt.getTableColumnNames()[0]);
        }
    }

    public void refreshAgentPoolPreferencesFromFileLocalToAgentPool(String string, String string2, AbleSecureKey ableSecureKey) throws RemoteException, PlatformSupportServiceException {
        String string3 = "refreshAgentPoolPreferencesFromFileLocalToAgentPool(String,String,AbleSecureKey)";
        boolean bl = Able.Preferences.isSecure();
        if (bl) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (AbleException ableException) {
                throw this.unableToVerifyKey(string3, ableSecureKey, (Exception)((Object)ableException));
            }
            catch (NamingException namingException) {
                throw this.unableToVerifyKey(string3, ableSecureKey, (Exception)((Object)namingException));
            }
        }
        AblePlatformSupport ablePlatformSupport = this.getAgentPoolByAlias(string, string3);
        try {
            ablePlatformSupport.refreshPreferences(string2, ableSecureKey);
        }
        catch (NamingException namingException) {
            throw this.unableToPerformService(string3, (Exception)((Object)namingException), "PSS_Ex_FailedToRefreshAgentPoolPrefsFromFile", new Object[]{string, string2});
        }
        if (this.myServiceEventListeners.size() > 0) {
            this.thenNotifyAblePlatformServiceEventListeners(string3, 402, AblePlatform.NlsMsg("PSS_AgentPoolPrefsRefreshed", new Object[]{string}), null, null, this.myPrsSppt, this.myPrsSppt == null ? null : this.myPrsSppt.getTableColumnNames()[0]);
        }
    }

    public void refreshAgentPoolPreferencesFromFileLocalToService(String string, String string2, AbleSecureKey ableSecureKey) throws RemoteException, PlatformSupportServiceException {
        String string3 = "refreshAgentPoolPreferencesFromFileLocalToService(String,String,AbleSecureKey)";
        boolean bl = Able.Preferences.isSecure();
        if (bl) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (AbleException ableException) {
                throw this.unableToVerifyKey(string3, ableSecureKey, (Exception)((Object)ableException));
            }
            catch (NamingException namingException) {
                throw this.unableToVerifyKey(string3, ableSecureKey, (Exception)((Object)namingException));
            }
        }
        AblePlatformSupport ablePlatformSupport = this.getAgentPoolByAlias(string, string3);
        AblePlatformPreferences ablePlatformPreferences = new AblePlatformPreferences(string2);
        try {
            ablePlatformSupport.refreshPreferences(ablePlatformPreferences, ableSecureKey);
        }
        catch (NamingException namingException) {
            throw this.unableToPerformService(string3, (Exception)((Object)namingException), "PSS_Ex_FailedToRefreshAgentPoolPrefsFromFile", new Object[]{string, string2});
        }
        if (this.myServiceEventListeners.size() > 0) {
            this.thenNotifyAblePlatformServiceEventListeners(string3, 402, AblePlatform.NlsMsg("PSS_AgentPoolPrefsRefreshed", new Object[]{string}), null, null, this.myPrsSppt, this.myPrsSppt == null ? null : this.myPrsSppt.getTableColumnNames()[0]);
        }
    }

    public void refreshPlatformPreferences(AbleSecureKey ableSecureKey) throws RemoteException, PlatformSupportServiceException {
        String string = "refreshPlatformPreferences(AbleSecureKey)";
        boolean bl = Able.Preferences.isSecure();
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (AbleException ableException) {
                throw this.unableToVerifyKey(string, ableSecureKey, (Exception)((Object)ableException));
            }
            catch (NamingException namingException) {
                throw this.unableToVerifyKey(string, ableSecureKey, (Exception)((Object)namingException));
            }
        }
        AblePlatformSupport ablePlatformSupport = null;
        Hashtable hashtable = AblePlatform.Preferences.getAgentPools();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            AblePlatformPreferences.AgentPoolEntry_ agentPoolEntry_ = (AblePlatformPreferences.AgentPoolEntry_)enumeration.nextElement();
            String string2 = agentPoolEntry_.getAgentPoolAlias();
            String string3 = agentPoolEntry_.getIpAddress();
            String string4 = agentPoolEntry_.getPort();
            try {
                ablePlatformSupport = AblePlatformSupportImpl.getAblePlatformSupportOn(string3, string4);
            }
            catch (RemoteException remoteException) {
                this.myTrcLog.text(0x100000L, (Object)this, string, "Cannot connect to agent pool <" + string2 + "> on system <" + string3 + ">, port <" + string4 + ">. Ignored.");
                bl2 = true;
                stringBuffer.append("\nAgent pool <" + string2 + ">:\n\t");
                stringBuffer.append(remoteException.getLocalizedMessage());
                continue;
            }
            try {
                this.myTrcLog.text(0x100000L, (Object)this, string, "  Refreshing preferences in agent pool <" + string2 + ">.");
                ablePlatformSupport.refreshPreferences(ableSecureKey);
            }
            catch (NamingException namingException) {
                bl2 = true;
                stringBuffer.append("\nAgent pool <" + string2 + ">:\n\t");
                stringBuffer.append(namingException.getLocalizedMessage());
            }
        }
        if (bl2) {
            this.myMsgLog.text(4L, (Object)this, string, "Errors refreshing platform preferences:\n" + stringBuffer.toString());
        }
        if (this.myServiceEventListeners.size() > 0) {
            this.thenNotifyAblePlatformServiceEventListeners(string, 403, AblePlatform.NlsMsg("PSS_PlatformPrefsRefreshed"), null, null, this.myPrsSppt, this.myPrsSppt == null ? null : this.myPrsSppt.getTableColumnNames()[0]);
        }
    }

    public void refreshPlatformPreferences(AblePlatformPreferences ablePlatformPreferences, AbleSecureKey ableSecureKey) throws RemoteException, PlatformSupportServiceException {
        String string = "refreshPlatformPreferences(AblePlatformPreferences,AbleSecureKey)";
        boolean bl = Able.Preferences.isSecure();
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (AbleException ableException) {
                throw this.unableToVerifyKey(string, ableSecureKey, (Exception)((Object)ableException));
            }
            catch (NamingException namingException) {
                throw this.unableToVerifyKey(string, ableSecureKey, (Exception)((Object)namingException));
            }
        }
        AblePlatformSupport ablePlatformSupport = null;
        Hashtable hashtable = AblePlatform.Preferences.getAgentPools();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            AblePlatformPreferences.AgentPoolEntry_ agentPoolEntry_ = (AblePlatformPreferences.AgentPoolEntry_)enumeration.nextElement();
            String string2 = agentPoolEntry_.getAgentPoolAlias();
            String string3 = agentPoolEntry_.getIpAddress();
            String string4 = agentPoolEntry_.getPort();
            try {
                ablePlatformSupport = AblePlatformSupportImpl.getAblePlatformSupportOn(string3, string4);
            }
            catch (RemoteException remoteException) {
                this.myTrcLog.text(0x100000L, (Object)this, string, "Cannot connect to agent pool <" + string2 + "> on system <" + string3 + ">, port <" + string4 + ">. Ignored.");
                bl2 = true;
                stringBuffer.append("\nAgent pool <" + string2 + ">:\n\t");
                stringBuffer.append(remoteException.getLocalizedMessage());
                continue;
            }
            try {
                this.myTrcLog.text(0x100000L, (Object)this, string, "  Refreshing preferences in agent pool <" + string2 + ">.");
                ablePlatformSupport.refreshPreferences(ablePlatformPreferences, ableSecureKey);
            }
            catch (NamingException namingException) {
                bl2 = true;
                stringBuffer.append("\nAgent pool <" + string2 + ">:\n\t");
                stringBuffer.append(namingException.getLocalizedMessage());
            }
        }
        if (bl2) {
            this.myMsgLog.text(4L, (Object)this, string, "Errors refreshing platform preferences:\n" + stringBuffer.toString());
        }
        if (this.myServiceEventListeners.size() > 0) {
            this.thenNotifyAblePlatformServiceEventListeners(string, 403, AblePlatform.NlsMsg("PSS_PlatformPrefsRefreshed"), null, null, this.myPrsSppt, this.myPrsSppt == null ? null : this.myPrsSppt.getTableColumnNames()[0]);
        }
    }

    public void refreshPlatformPreferencesFromFileLocalToAgentPool(String string, AbleSecureKey ableSecureKey) throws RemoteException, PlatformSupportServiceException {
        String string2 = "refreshPlatformPreferencesFromFileLocalToAgentPool(String,AbleSecureKey)";
        boolean bl = Able.Preferences.isSecure();
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (AbleException ableException) {
                throw this.unableToVerifyKey(string2, ableSecureKey, (Exception)((Object)ableException));
            }
            catch (NamingException namingException) {
                throw this.unableToVerifyKey(string2, ableSecureKey, (Exception)((Object)namingException));
            }
        }
        AblePlatformPreferences ablePlatformPreferences = new AblePlatformPreferences(string);
        AblePlatformSupport ablePlatformSupport = null;
        Hashtable hashtable = AblePlatform.Preferences.getAgentPools();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            AblePlatformPreferences.AgentPoolEntry_ agentPoolEntry_ = (AblePlatformPreferences.AgentPoolEntry_)enumeration.nextElement();
            String string3 = agentPoolEntry_.getAgentPoolAlias();
            String string4 = agentPoolEntry_.getIpAddress();
            String string5 = agentPoolEntry_.getPort();
            try {
                ablePlatformSupport = AblePlatformSupportImpl.getAblePlatformSupportOn(string4, string5);
            }
            catch (RemoteException remoteException) {
                this.myTrcLog.text(0x100000L, (Object)this, string2, "Cannot connect to agent pool <" + string3 + "> on system <" + string4 + ">, port <" + string5 + ">. Ignored.");
                bl2 = true;
                stringBuffer.append("\nAgent pool <" + string3 + ">:\n\t");
                stringBuffer.append(remoteException.getLocalizedMessage());
                continue;
            }
            try {
                this.myTrcLog.text(0x100000L, (Object)this, string2, "  Refreshing preferences in agent pool <" + string3 + ">.");
                ablePlatformSupport.refreshPreferences(string, ableSecureKey);
            }
            catch (NamingException namingException) {
                bl2 = true;
                stringBuffer.append("\nAgent pool <" + string3 + ">:\n\t");
                stringBuffer.append(namingException.getLocalizedMessage());
            }
        }
        if (bl2) {
            this.myMsgLog.text(4L, (Object)this, string2, "Errors refreshing platform preferences:\n" + stringBuffer.toString());
        }
        if (this.myServiceEventListeners.size() > 0) {
            this.thenNotifyAblePlatformServiceEventListeners(string2, 403, AblePlatform.NlsMsg("PSS_PlatformPrefsRefreshed"), null, null, this.myPrsSppt, this.myPrsSppt == null ? null : this.myPrsSppt.getTableColumnNames()[0]);
        }
    }

    public void refreshPlatformPreferencesFromFileLocalToService(String string, AbleSecureKey ableSecureKey) throws RemoteException, PlatformSupportServiceException {
        String string2 = "refreshPlatformPreferencesFromFileLocalToService(String,AbleSecureKey)";
        boolean bl = Able.Preferences.isSecure();
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (AbleException ableException) {
                throw this.unableToVerifyKey(string2, ableSecureKey, (Exception)((Object)ableException));
            }
            catch (NamingException namingException) {
                throw this.unableToVerifyKey(string2, ableSecureKey, (Exception)((Object)namingException));
            }
        }
        AblePlatformPreferences ablePlatformPreferences = new AblePlatformPreferences(string);
        AblePlatformSupport ablePlatformSupport = null;
        Hashtable hashtable = AblePlatform.Preferences.getAgentPools();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            AblePlatformPreferences.AgentPoolEntry_ agentPoolEntry_ = (AblePlatformPreferences.AgentPoolEntry_)enumeration.nextElement();
            String string3 = agentPoolEntry_.getAgentPoolAlias();
            String string4 = agentPoolEntry_.getIpAddress();
            String string5 = agentPoolEntry_.getPort();
            try {
                ablePlatformSupport = AblePlatformSupportImpl.getAblePlatformSupportOn(string4, string5);
            }
            catch (RemoteException remoteException) {
                this.myTrcLog.text(0x100000L, (Object)this, string2, "Cannot connect to agent pool <" + string3 + "> on system <" + string4 + ">, port <" + string5 + ">. Ignored.");
                bl2 = true;
                stringBuffer.append("\nAgent pool <" + string3 + ">:\n\t");
                stringBuffer.append(remoteException.getLocalizedMessage());
                continue;
            }
            try {
                this.myTrcLog.text(0x100000L, (Object)this, string2, "  Refreshing preferences in agent pool <" + string3 + ">.");
                ablePlatformSupport.refreshPreferences(ablePlatformPreferences, ableSecureKey);
            }
            catch (NamingException namingException) {
                bl2 = true;
                stringBuffer.append("\nAgent pool <" + string3 + ">:\n\t");
                stringBuffer.append(namingException.getLocalizedMessage());
            }
        }
        if (bl2) {
            this.myMsgLog.text(4L, (Object)this, string2, "Errors refreshing platform preferences:\n" + stringBuffer.toString());
        }
        if (this.myServiceEventListeners.size() > 0) {
            this.thenNotifyAblePlatformServiceEventListeners(string2, 403, AblePlatform.NlsMsg("PSS_PlatformPrefsRefreshed"), null, null, this.myPrsSppt, this.myPrsSppt == null ? null : this.myPrsSppt.getTableColumnNames()[0]);
        }
    }

    private PlatformSupportServiceException unableToVerifyKey(String string, AbleSecureKey ableSecureKey, Exception exception) {
        String string2 = AblePlatform.NlsMsg("SecOn_UnableToVerifyKey", new Object[]{ableSecureKey == null ? "null" : ableSecureKey.getVan().getName(), ableSecureKey == null ? "null" : ableSecureKey.getExpriationID()});
        this.myMsgLog.text(4L, (Object)this, string, string2);
        this.myMsgLog.text(4L, (Object)this, string, exception.getLocalizedMessage());
        if (this.myTrcLog.isLogging()) {
            this.myTrcLog.exception(262144L, (Object)this, string, (Throwable)exception);
        }
        return new PlatformSupportServiceException(string2, exception);
    }

    private PlatformSupportServiceException unableToPerformService(String string, Exception exception, String string2, Object[] objectArray) {
        String string3 = null;
        string3 = objectArray == null ? AblePlatform.NlsMsg(string2) : AblePlatform.NlsMsg(string2, objectArray);
        this.myMsgLog.text(4L, (Object)this, string, string3);
        if (exception == null) {
            return new PlatformSupportServiceException(string3);
        }
        this.myMsgLog.text(4L, (Object)this, string, exception.getLocalizedMessage());
        if (this.myTrcLog.isLogging()) {
            this.myTrcLog.exception(262144L, (Object)this, string, (Throwable)exception);
        }
        return new PlatformSupportServiceException(string3, exception);
    }

    private AbleSecureKey secureKeyOrNull() throws PlatformSupportServiceException {
        String string = "secureKeyOrNull";
        AbleSecureKey ableSecureKey = null;
        if (Able.Preferences.isSecure()) {
            try {
                ableSecureKey = this.mySecSppt.generateKey();
            }
            catch (NamingException namingException) {
                this.myMsgLog.text(4L, (Object)this, string, namingException.getLocalizedMessage());
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.exception(262144L, (Object)this, string, (Throwable)namingException);
                }
                ableSecureKey = null;
                throw new PlatformSupportServiceException("Cannot get secure key.", (Exception)((Object)namingException));
            }
        }
        return ableSecureKey;
    }

    private AblePlatformSupport getAgentPoolByAlias(String string, String string2) throws RemoteException, PlatformSupportServiceException {
        AblePlatformPreferences.AgentPoolEntry_ agentPoolEntry_ = AblePlatform.Preferences.getAgentPool(string);
        if (agentPoolEntry_ == null) {
            throw this.unableToPerformService(string2, null, "PSS_Ex_FailedToGetAgentPool", new Object[]{string});
        }
        String string3 = agentPoolEntry_.getIpAddress();
        String string4 = agentPoolEntry_.getPort();
        AblePlatformSupport ablePlatformSupport = AblePlatformSupportImpl.getAblePlatformSupportOn(string3, string4);
        return ablePlatformSupport;
    }

    public void refreshLocalFromPersistence(AblePersistenceSupport ablePersistenceSupport, Object[] objectArray) throws Exception {
        String string = "refreshLocalFromPersistence";
        if (ablePersistenceSupport == this.myPrsSppt) {
            this.refreshServiceEventListenersFromPersistence(objectArray);
            this.myPrsSpptIsDone = true;
        }
        if (this.myPrsSpptIsDone) {
            this.setState(2);
        }
        if (this.myTrcLog.isLogging()) {
            this.myTrcLog.text(262144L, (Object)this, string, "Refreshed local from persistence.");
        }
    }

    private void refreshServiceEventListenersFromPersistence(Object[] objectArray) throws Exception {
        String string = "refreshServiceEventListenersFromPersistence";
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.getState() == 4) {
                return;
            }
            Object[] objectArray2 = (Object[])objectArray[i];
            AblePlatformServiceEventListener ablePlatformServiceEventListener = (AblePlatformServiceEventListener)objectArray2[0];
            if (this.myServiceEventListeners.contains(ablePlatformServiceEventListener)) continue;
            this.myServiceEventListeners.add(ablePlatformServiceEventListener);
            this.myMsgLog.text(1L, (Object)this, string, AblePlatform.NlsMsg("PPSO_SuccessfullyLoadedFromPersistence", new Object[]{"AblePlatformServiceEventListener"}));
        }
    }
}

