/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.platform;

import com.ibm.able.Able;
import com.ibm.able.platform.RmiPlatformSupportService;
import com.ibm.able.platform.RmiPlatformSupportServiceProxy;
import com.ibm.able.platform.RmiPlatformSupportServiceSystem;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import javax.agent.service.Service;
import javax.agent.service.ServiceException;
import javax.agent.service.ServiceProperties;
import org.jagent.service.spi.ServiceFactory;
import org.jagent.service.util.RMIUtility;
import org.jagent.util.URIUtility;

public class RmiPlatformSupportServiceFactory
implements ServiceFactory {
    public Service getService(ServiceProperties serviceProperties) throws ServiceException {
        String string;
        RmiPlatformSupportService rmiPlatformSupportService = null;
        boolean bl = true;
        InetAddress inetAddress = null;
        String string2 = null;
        InetAddress inetAddress2 = null;
        String string3 = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            throw new ServiceException("Cannot obtain local host address.", (Exception)unknownHostException);
        }
        if (serviceProperties.containsKey("javax.agent.service.ip.service-host")) {
            string2 = (String)serviceProperties.get("javax.agent.service.ip.service-host");
            try {
                inetAddress2 = InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                throw new ServiceException("Cannot obtain local host's name.", (Exception)unknownHostException);
            }
            String string4 = (String)serviceProperties.get("com.ibm.able.platform.requestors-port");
            string = (String)serviceProperties.get("javax.agent.service.ip.service-port");
            if (inetAddress.equals(inetAddress2) && string4 != null && string4.equalsIgnoreCase(string)) {
                bl = true;
                string3 = string2;
                if (string2.equalsIgnoreCase("localhost")) {
                    string3 = inetAddress.getHostName();
                }
            } else {
                bl = false;
                string3 = string2;
            }
        } else {
            bl = true;
            string3 = inetAddress.getHostName();
        }
        int n = 1099;
        if (serviceProperties.containsKey("javax.agent.service.ip.service-port")) {
            n = Integer.parseInt((String)serviceProperties.get("javax.agent.service.ip.service-port"));
        } else {
            serviceProperties.set("javax.agent.service.ip.service-port", (Object)String.valueOf(n));
        }
        string = "platform-support-service";
        String string5 = URIUtility.buildURI((String)"rmi", (String)string3, (int)n, (String)string);
        Registry registry = null;
        if (bl) {
            try {
                registry = RMIUtility.getLocalRegistry((int)n);
            }
            catch (RemoteException remoteException) {
                throw new ServiceException("Could not obtain or create registry at port <" + n + ">.", (Exception)remoteException);
            }
            try {
                rmiPlatformSupportService = (RmiPlatformSupportService)registry.lookup(string5);
            }
            catch (NotBoundException notBoundException) {
                try {
                    rmiPlatformSupportService = new RmiPlatformSupportServiceSystem(serviceProperties);
                }
                catch (AlreadyBoundException alreadyBoundException) {
                    try {
                        rmiPlatformSupportService = (RmiPlatformSupportService)registry.lookup(string5);
                    }
                    catch (Exception exception) {
                        throw new ServiceException("Exhausted all means to create or find the Platform Support Service.", exception);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new ServiceException("Could not create the Platform Support service object.", exception);
                }
            }
            catch (RemoteException remoteException) {
                throw new ServiceException("Remote exception looking up local Platform Support Service.", (Exception)remoteException);
            }
        } else {
            try {
                RMISocketFactory rMISocketFactory = Able.GetSocketFactory();
                registry = rMISocketFactory == null ? LocateRegistry.getRegistry(string3, n) : LocateRegistry.getRegistry(string3, n, rMISocketFactory);
            }
            catch (RemoteException remoteException) {
                throw new ServiceException("Cannot access remote RMI Registry on <" + string3 + ":" + n + ">.", (Exception)remoteException);
            }
            try {
                rmiPlatformSupportService = (RmiPlatformSupportService)registry.lookup(string5);
            }
            catch (NotBoundException notBoundException) {
                throw new ServiceException("Platform Support Service on <" + string3 + ":" + n + "> is not bound to registry.", (Exception)notBoundException);
            }
            catch (RemoteException remoteException) {
                throw new ServiceException("Remote exception looking up remote Platform Support Service.", (Exception)remoteException);
            }
        }
        return new RmiPlatformSupportServiceProxy(rmiPlatformSupportService, registry, string5);
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

