/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.platform;

import com.ibm.able.Able;
import com.ibm.able.AbleEvent;
import com.ibm.able.AbleEventQueue;
import com.ibm.able.AbleException;
import com.ibm.able.beans.AbleDBExport;
import com.ibm.able.beans.AbleDBImport;
import com.ibm.able.beans.AbleDBTable;
import com.ibm.able.platform.AbleBasicService;
import com.ibm.able.platform.AblePersistenceSupport;
import com.ibm.able.platform.AblePlatform;
import com.ibm.able.platform.AbleSecureKey;
import com.ibm.able.platform.AbleSecuritySupport;
import com.ibm.able.platform.PlatformPersistenceException;
import com.ibm.able.platform.RmiPlatformPersistenceService;
import com.ibm.able.platform.VerifiableAgentName;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.agent.service.ServiceProperties;
import javax.agent.service.naming.NamingException;

public final class RmiPlatformPersistenceSystem
extends AbleBasicService
implements RmiPlatformPersistenceService {
    private String driver;
    private String protocol;
    private String subProtocol;
    private String userid;
    private String password;
    private long DBFlushTime;
    private boolean DBResetAllFlag = false;
    private String BLOBType = "BLOB";
    private Hashtable wrapperedImportBeans = new Hashtable();
    private Hashtable wrapperedExportBeans = new Hashtable();

    public RmiPlatformPersistenceSystem() throws Exception {
        this.ctorHelper();
    }

    public RmiPlatformPersistenceSystem(ServiceProperties serviceProperties) throws Exception {
        super(serviceProperties);
        this.ctorHelper();
        this.bindServiceToRegistry();
    }

    public void terminateService(AbleSecureKey ableSecureKey) throws AbleException, NamingException {
        String string;
        String string2 = "terminateService";
        if (Able.Preferences.isSecure()) {
            this.mySecSppt.verifyKey(ableSecureKey);
            this.mySecSppt.verifyTrustLevel(ableSecureKey, string2);
        }
        Enumeration enumeration = this.wrapperedExportBeans.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            ((AbleDBExportWrapper_)((Object)this.wrapperedExportBeans.get(string))).quitAll();
            ((AbleDBImportWrapper_)((Object)this.wrapperedImportBeans.get(string))).quitAll();
        }
        string = Able.Preferences.isSecure() ? this.mySecSppt.generateKey(ableSecureKey) : null;
        super.terminateService((AbleSecureKey)((Object)string));
    }

    public String getBindingName() {
        return "persistence-service";
    }

    public void createTableConnection(String string, String string2, String string3, String[] stringArray, String[] stringArray2, AbleSecureKey ableSecureKey, boolean bl) throws AbleException, RemoteException, PlatformPersistenceException {
        Object object;
        String string4 = "createTableConnection";
        if (string == null) {
            throw new PlatformPersistenceException("The Database Name must not be null");
        }
        if (string2 == null) {
            throw new PlatformPersistenceException("The Table Name must not be null");
        }
        if (stringArray == null) {
            throw new PlatformPersistenceException("The Column Names must not be null");
        }
        if (stringArray2 == null) {
            throw new PlatformPersistenceException("The Column Types must not be null");
        }
        if (stringArray2.length != stringArray.length) {
            throw new PlatformPersistenceException("The Column Types and Column Names arrays must be of the same length");
        }
        if (Able.Preferences.isSecure()) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (Exception exception) {
                String string5 = AblePlatform.NlsMsg("SecOn_UnableToVerifyKey", new Object[]{ableSecureKey == null ? "null" : ableSecureKey.getVan().getName(), ableSecureKey == null ? "null" : ableSecureKey.getExpriationID()});
                this.myMsgLog.text(4L, (Object)this, string4, string5);
                this.myMsgLog.text(4L, (Object)this, string4, exception.getLocalizedMessage());
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.exception(262144L, (Object)this, string4, (Throwable)exception);
                }
                throw new PlatformPersistenceException(string5, exception);
            }
        }
        if (this.wrapperedExportBeans.containsKey(string + ":" + string2)) {
            return;
        }
        AbleDBExportWrapper_ ableDBExportWrapper_ = new AbleDBExportWrapper_(Able.Preferences.isSecure() ? ableSecureKey.getVan() : null);
        ableDBExportWrapper_.setDriver(this.driver);
        ableDBExportWrapper_.setProtocol(this.protocol);
        ableDBExportWrapper_.setSubprotocol(this.subProtocol);
        if (this.userid != null) {
            ableDBExportWrapper_.setUserid(this.userid);
        }
        if (this.password != null) {
            ableDBExportWrapper_.setPassword(this.password);
        }
        ableDBExportWrapper_.setDatabase(string);
        ableDBExportWrapper_.setTable(string2.toUpperCase());
        ableDBExportWrapper_.setSchema(string3);
        ableDBExportWrapper_.setCreatable(true);
        try {
            ableDBExportWrapper_.init();
        }
        catch (AbleException ableException) {
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.exception(262144L, (Object)this, string4, (Throwable)ableException);
                this.myTrcLog.text(262144L, (Object)this, string4, "Error calling init() on exportDB for " + string + ":" + string2);
                if (ableDBExportWrapper_.getConnection() == null) {
                    String string6 = "Unable to establish a Connection to " + string + ":" + string2;
                    this.myMsgLog.text(4L, (Object)this, string4, string6);
                    throw new PlatformPersistenceException(string6);
                }
            }
        }
        catch (Throwable throwable) {
            String string7 = "Error creating export DB: " + string + ":" + string2 + "\nERROR = " + throwable;
            this.myMsgLog.text(4L, (Object)this, string4, string7);
            throw new PlatformPersistenceException(string7);
        }
        try {
            ResultSet resultSet;
            object = ableDBExportWrapper_.getConnection().getMetaData();
            String string8 = ableDBExportWrapper_.getSchema();
            if (string8 == null || string8.length() == 0) {
                string8 = object.getUserName();
            }
            if ((resultSet = object.getTables(null, string8, ableDBExportWrapper_.getTable().toUpperCase(), null)).next()) {
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.text(0x100000L, (Object)this, string4, "Existing table " + resultSet.getString("TABLE_NAME"));
                }
            } else {
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.text(0x100000L, (Object)this, string4, "No existing table " + ableDBExportWrapper_.getTable());
                }
                StringBuffer stringBuffer = new StringBuffer("CREATE TABLE " + ableDBExportWrapper_.getSchemaTable() + " (");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string9 = stringArray2[i];
                    if (string9.equalsIgnoreCase("blob-type")) {
                        string9 = this.BLOBType;
                    }
                    stringBuffer.append(" " + stringArray[i] + " " + string9);
                    if (stringArray.length <= i + 1) continue;
                    stringBuffer.append(",");
                }
                stringBuffer.append(")");
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.text(0x100000L, (Object)this, string4, "Attempting to run create statement: " + stringBuffer.toString());
                }
                ableDBExportWrapper_.getConnection().createStatement().execute(stringBuffer.toString());
                this.myMsgLog.text(1L, (Object)this, string4, AblePlatform.NlsMsg("PPS_SuccessfullyCreatedTable", new Object[]{string2, string}));
            }
            ableDBExportWrapper_.setNumberOfInputs(stringArray.length);
            resultSet.close();
        }
        catch (SQLException sQLException) {
            String string10 = AblePlatform.NlsMsg("PPS_ErrorCreatingTable", new Object[]{string2, string});
            this.myMsgLog.text(4L, (Object)this, string4, string10);
            this.myMsgLog.text(4L, (Object)this, string4, sQLException.getLocalizedMessage());
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.exception(262144L, (Object)this, string4, (Throwable)sQLException);
            }
            throw new PlatformPersistenceException(string10);
        }
        if (this.DBResetAllFlag) {
            ableDBExportWrapper_.delete("");
        }
        this.wrapperedExportBeans.put(string + ":" + string2, ableDBExportWrapper_);
        object = new AbleDBImportWrapper_();
        object.setDriver(this.driver);
        object.setProtocol(this.protocol);
        object.setSubprotocol(this.subProtocol);
        object.setUserid(this.userid);
        object.setPassword(this.password);
        object.setDatabase(string);
        object.setTable(string2.toUpperCase());
        object.setSchema(string3);
        object.init();
        this.wrapperedImportBeans.put(string + ":" + string2, object);
    }

    public void insert(String string, String string2, Serializable[] serializableArray, AbleSecureKey ableSecureKey) throws RemoteException, PlatformPersistenceException, AbleException {
        AbleDBExportWrapper_ ableDBExportWrapper_;
        String string3 = "insert";
        if (serializableArray == null) {
            throw new PlatformPersistenceException("The insertData must not be null");
        }
        if (Able.Preferences.isSecure()) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (Exception exception) {
                String string4 = AblePlatform.NlsMsg("SecOn_UnableToVerifyKey", new Object[]{ableSecureKey == null ? "null" : ableSecureKey.getVan().getName(), ableSecureKey == null ? "null" : ableSecureKey.getExpriationID()});
                this.myMsgLog.text(4L, (Object)this, string3, string4);
                this.myMsgLog.text(4L, (Object)this, string3, exception.getLocalizedMessage());
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.exception(262144L, (Object)this, string3, (Throwable)exception);
                }
                throw new PlatformPersistenceException(string4, exception);
            }
        }
        if ((ableDBExportWrapper_ = (AbleDBExportWrapper_)((Object)this.wrapperedExportBeans.get(string + ":" + string2))) == null) {
            String string5 = AblePlatform.NlsMsg("PPS_TableConnectionNotFound", new Object[]{string2, string});
            this.myMsgLog.text(4L, (Object)this, string3, string5);
            throw new PlatformPersistenceException(string5);
        }
        if (Able.Preferences.isSecure() && AbleSecuritySupport.lowerTrustLevelLogged(ableDBExportWrapper_.getCreateVan(), ableSecureKey, string3)) {
            String string6 = AblePlatform.NlsMsg("PPS_RequestNotAuthorized", new Object[]{string3, string2, string});
            this.myMsgLog.text(4L, (Object)this, string3, string6);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string3, string6);
            }
            throw new PlatformPersistenceException(string6);
        }
        ableDBExportWrapper_.postPersistEvent(1, serializableArray);
    }

    public void update(String string, String string2, Map map, Map hashMap, AbleSecureKey ableSecureKey) throws RemoteException, PlatformPersistenceException {
        AbleDBExportWrapper_ ableDBExportWrapper_;
        String string3 = "update";
        if (map == null) {
            throw new PlatformPersistenceException("The updateMap must not be null");
        }
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        if (Able.Preferences.isSecure()) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (Exception exception) {
                String string4 = AblePlatform.NlsMsg("SecOn_UnableToVerifyKey", new Object[]{ableSecureKey == null ? "null" : ableSecureKey.getVan().getName(), ableSecureKey == null ? "null" : ableSecureKey.getExpriationID()});
                this.myMsgLog.text(4L, (Object)this, string3, string4);
                this.myMsgLog.text(4L, (Object)this, string3, exception.getLocalizedMessage());
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.exception(262144L, (Object)this, string3, (Throwable)exception);
                }
                throw new PlatformPersistenceException(string4, exception);
            }
        }
        if ((ableDBExportWrapper_ = (AbleDBExportWrapper_)((Object)this.wrapperedExportBeans.get(string + ":" + string2))) == null) {
            String string5 = AblePlatform.NlsMsg("PPS_TableConnectionNotFound", new Object[]{string2, string});
            this.myMsgLog.text(4L, (Object)this, string3, string5);
            throw new PlatformPersistenceException(string5);
        }
        if (Able.Preferences.isSecure() && AbleSecuritySupport.lowerTrustLevelLogged(ableDBExportWrapper_.getCreateVan(), ableSecureKey, string3)) {
            String string6 = AblePlatform.NlsMsg("PPS_RequestNotAuthorized", new Object[]{string3, string2, string});
            this.myMsgLog.text(4L, (Object)this, string3, string6);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string3, string6);
            }
            throw new PlatformPersistenceException(string6);
        }
        ableDBExportWrapper_.postPersistEvent(2, new Object[]{map, hashMap});
    }

    public void delete(String string, String string2, Object object, AbleSecureKey ableSecureKey) throws RemoteException, PlatformPersistenceException {
        AbleDBExportWrapper_ ableDBExportWrapper_;
        String string3 = "delete";
        if (Able.Preferences.isSecure()) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (Exception exception) {
                String string4 = AblePlatform.NlsMsg("SecOn_UnableToVerifyKey", new Object[]{ableSecureKey == null ? "null" : ableSecureKey.getVan().getName(), ableSecureKey == null ? "null" : ableSecureKey.getExpriationID()});
                this.myMsgLog.text(4L, (Object)this, string3, string4);
                this.myMsgLog.text(4L, (Object)this, string3, exception.getLocalizedMessage());
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.exception(262144L, (Object)this, string3, (Throwable)exception);
                }
                throw new PlatformPersistenceException(string4, exception);
            }
        }
        if ((ableDBExportWrapper_ = (AbleDBExportWrapper_)((Object)this.wrapperedExportBeans.get(string + ":" + string2))) == null) {
            String string5 = AblePlatform.NlsMsg("PPS_TableConnectionNotFound", new Object[]{string2, string});
            this.myMsgLog.text(4L, (Object)this, string3, string5);
            throw new PlatformPersistenceException(string5);
        }
        if (Able.Preferences.isSecure() && AbleSecuritySupport.lowerTrustLevelLogged(ableDBExportWrapper_.getCreateVan(), ableSecureKey, string3)) {
            String string6 = AblePlatform.NlsMsg("PPS_RequestNotAuthorized", new Object[]{string3, string2, string});
            this.myMsgLog.text(4L, (Object)this, string3, string6);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string3, string6);
            }
            throw new PlatformPersistenceException(string6);
        }
        ableDBExportWrapper_.postPersistEvent(3, object);
    }

    public Object[] select(String string, String string2, String string3, String string4, AbleSecureKey ableSecureKey) throws AbleException, RemoteException, PlatformPersistenceException {
        String string5 = "select";
        if (Able.Preferences.isSecure()) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (Exception exception) {
                String string6 = AblePlatform.NlsMsg("SecOn_UnableToVerifyKey", new Object[]{ableSecureKey == null ? "null" : ableSecureKey.getVan().getName(), ableSecureKey == null ? "null" : ableSecureKey.getExpriationID()});
                this.myMsgLog.text(4L, (Object)this, string5, string6);
                this.myMsgLog.text(4L, (Object)this, string5, exception.getLocalizedMessage());
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.exception(262144L, (Object)this, string5, (Throwable)exception);
                }
                throw new PlatformPersistenceException(string6, exception);
            }
        }
        Vector<Serializable[]> vector = new Vector<Serializable[]>();
        AbleDBImportWrapper_ ableDBImportWrapper_ = (AbleDBImportWrapper_)((Object)this.wrapperedImportBeans.get(string + ":" + string2));
        if (ableDBImportWrapper_ == null) {
            String string7 = AblePlatform.NlsMsg("PPS_TableConnectionNotFound", new Object[]{string2, string});
            this.myMsgLog.text(4L, (Object)this, string5, string7);
            throw new PlatformPersistenceException(string7);
        }
        AbleDBExportWrapper_ ableDBExportWrapper_ = (AbleDBExportWrapper_)((Object)this.wrapperedExportBeans.get(string + ":" + string2));
        if (Able.Preferences.isSecure() && AbleSecuritySupport.lowerTrustLevelLogged(ableDBExportWrapper_.getCreateVan(), ableSecureKey, string5)) {
            String string8 = AblePlatform.NlsMsg("PPS_RequestNotAuthorized", new Object[]{string5, string2, string});
            this.myMsgLog.text(4L, (Object)this, string5, string8);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string5, string8);
            }
            throw new PlatformPersistenceException(string8);
        }
        String string9 = string3;
        if (string3 == null || string3.trim().equalsIgnoreCase("")) {
            string9 = "*";
        }
        ableDBImportWrapper_.setSelectionColumns(string9);
        ableDBImportWrapper_.setSelectionWhere(string4);
        ableDBImportWrapper_.open();
        if (ableDBImportWrapper_.getNumRecords() > 0L) {
            do {
                ableDBImportWrapper_.process();
                Object[] objectArray = (Object[])ableDBImportWrapper_.getOutputBuffer();
                Serializable[] serializableArray = new Serializable[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object;
                    if (objectArray[i] instanceof Blob) {
                        try {
                            object = ((Blob)objectArray[i]).getBytes(1L, (int)((Blob)objectArray[i]).length());
                            serializableArray[i] = AblePersistenceSupport.Deserialize(object);
                            continue;
                        }
                        catch (SQLException sQLException) {
                            String string10 = AblePlatform.NlsMsg("PPS_ErrorDeserializingFromBlob", new Object[]{string5, string2, string, string3, string4});
                            this.myMsgLog.text(4L, (Object)this, string5, string10);
                            if (this.myTrcLog.isLogging()) {
                                this.myTrcLog.text(262144L, (Object)this, string5, string10);
                            }
                            throw new PlatformPersistenceException(string10);
                        }
                    }
                    if (objectArray[i] instanceof byte[]) {
                        try {
                            serializableArray[i] = AblePersistenceSupport.Deserialize((byte[])objectArray[i]);
                        }
                        catch (Exception exception) {
                            serializableArray[i] = (byte[])objectArray[i];
                        }
                        continue;
                    }
                    if (objectArray[i] instanceof Serializable) {
                        serializableArray[i] = (Serializable)objectArray[i];
                        continue;
                    }
                    object = AblePlatform.NlsMsg("PPS_PersistedDataIsWrongType", new Object[]{string5, string2, string, string3, string4});
                    this.myMsgLog.text(4L, (Object)this, string5, (String)object);
                    if (this.myTrcLog.isLogging()) {
                        this.myTrcLog.text(262144L, (Object)this, string5, (String)object);
                    }
                    throw new PlatformPersistenceException((String)object);
                }
                vector.add(serializableArray);
            } while (!ableDBImportWrapper_.eof());
        }
        return vector.toArray();
    }

    public void close(String string, String string2, AbleSecureKey ableSecureKey) throws AbleException, RemoteException, PlatformPersistenceException {
        String string3 = "close";
        if (Able.Preferences.isSecure()) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (Exception exception) {
                String string4 = AblePlatform.NlsMsg("SecOn_UnableToVerifyKey", new Object[]{ableSecureKey == null ? "null" : ableSecureKey.getVan().getName(), ableSecureKey == null ? "null" : ableSecureKey.getExpriationID()});
                this.myMsgLog.text(4L, (Object)this, string3, string4);
                this.myMsgLog.text(4L, (Object)this, string3, exception.getLocalizedMessage());
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.exception(262144L, (Object)this, string3, (Throwable)exception);
                }
                throw new PlatformPersistenceException(string4, exception);
            }
        }
        AbleDBExportWrapper_ ableDBExportWrapper_ = (AbleDBExportWrapper_)((Object)this.wrapperedExportBeans.get(string + ":" + string2));
        AbleDBImportWrapper_ ableDBImportWrapper_ = (AbleDBImportWrapper_)((Object)this.wrapperedImportBeans.get(string + ":" + string2));
        if (ableDBImportWrapper_ == null || ableDBExportWrapper_ == null) {
            String string5 = AblePlatform.NlsMsg("PPS_TableConnectionNotFound", new Object[]{string2, string});
            this.myMsgLog.text(4L, (Object)this, string3, string5);
            throw new PlatformPersistenceException(string5);
        }
        if (Able.Preferences.isSecure() && AbleSecuritySupport.lowerTrustLevelLogged(ableDBExportWrapper_.getCreateVan(), ableSecureKey, string3)) {
            String string6 = AblePlatform.NlsMsg("PPS_RequestNotAuthorized", new Object[]{string3, string2, string});
            this.myMsgLog.text(4L, (Object)this, string3, string6);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string3, string6);
            }
            throw new PlatformPersistenceException(string6);
        }
        this.wrapperedExportBeans.remove(string + ":" + string2);
        this.wrapperedImportBeans.remove(string + ":" + string2);
        ableDBExportWrapper_.quitAll();
        ableDBImportWrapper_.quitAll();
    }

    private void ctorHelper() throws Exception {
        Enumeration enumeration = this.myServiceProperties.getAll().keys();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof String)) continue;
            if (((String)e).equalsIgnoreCase("persistence-driver")) {
                this.driver = (String)this.myServiceProperties.get((String)e);
                continue;
            }
            if (((String)e).equalsIgnoreCase("persistence-protocol")) {
                this.protocol = (String)this.myServiceProperties.get((String)e);
                continue;
            }
            if (((String)e).equalsIgnoreCase("persistence-subProtocol")) {
                this.subProtocol = (String)this.myServiceProperties.get((String)e);
                continue;
            }
            if (((String)e).equalsIgnoreCase("blob-type")) {
                this.BLOBType = (String)this.myServiceProperties.get((String)e);
                continue;
            }
            if (((String)e).equalsIgnoreCase("persistence-dbFlushTime")) {
                this.DBFlushTime = new Long((String)this.myServiceProperties.get((String)e));
                continue;
            }
            if (((String)e).equalsIgnoreCase("persistence-dbResetAll")) {
                this.DBResetAllFlag = ((String)this.myServiceProperties.get((String)e)).trim().equalsIgnoreCase("on");
                continue;
            }
            if (((String)e).equalsIgnoreCase("persistence-userid")) {
                this.userid = (String)this.myServiceProperties.get((String)e);
                continue;
            }
            if (!((String)e).equalsIgnoreCase("persistence-password")) continue;
            this.password = (String)this.myServiceProperties.get((String)e);
        }
        this.setState(2);
    }

    private static String getCopyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    private class AbleDBExportWrapper_
    extends AbleDBExport {
        private VerifiableAgentName createVan = null;

        public AbleDBExportWrapper_(VerifiableAgentName verifiableAgentName) throws AbleException {
            this.createVan = verifiableAgentName;
        }

        public VerifiableAgentName getCreateVan() {
            return this.createVan;
        }

        public void init() throws AbleException {
            this.setTimerEventProcessingEnabled(true);
            this.setSleepTime(RmiPlatformPersistenceSystem.this.DBFlushTime);
            this.setAbleEventProcessingEnabled(1);
            this.setDataFlowEnabled(false);
            super.init();
        }

        public synchronized void processTimerEvent() {
            block10: {
                String string = "processTimerEvent";
                try {
                    AbleEvent ableEvent = this.eventQueue.getEvent();
                    while (ableEvent != null) {
                        switch (ableEvent.getId()) {
                            case 1: {
                                this.processAbleEvent(ableEvent);
                                break;
                            }
                            case 2: {
                                Object[] objectArray = (Object[])ableEvent.getArgObject();
                                this.update((Map)objectArray[0], (Map)objectArray[1]);
                                break;
                            }
                            case 3: {
                                Object object = ableEvent.getArgObject();
                                if (object instanceof String) {
                                    this.delete((String)object);
                                    break;
                                }
                                if (object instanceof Map) {
                                    this.delete((Map)object);
                                    break;
                                }
                                this.delete("");
                            }
                        }
                        ableEvent = this.eventQueue.getEvent();
                    }
                }
                catch (AbleException ableException) {
                    RmiPlatformPersistenceSystem.this.myMsgLog.text(4L, (Object)this, string, ableException.getLocalizedMessage());
                    if (!RmiPlatformPersistenceSystem.this.myTrcLog.isLogging()) break block10;
                    RmiPlatformPersistenceSystem.this.myTrcLog.exception(262144L, (Object)this, string, (Throwable)ableException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postPersistEvent(int n, Object object) throws AbleException {
            AbleEventQueue ableEventQueue = this.eventQueue;
            synchronized (ableEventQueue) {
                switch (n) {
                    case 1: {
                        Serializable[] serializableArray = (Serializable[])object;
                        Object[] objectArray = new Object[serializableArray.length];
                        for (int i = 0; i < serializableArray.length; ++i) {
                            objectArray[i] = AblePersistenceSupport.isBaseSQLObject(serializableArray[i]) ? serializableArray[i] : (Object)AblePersistenceSupport.Serialize(serializableArray[i]);
                        }
                        this.eventQueue.postEvent(new AbleEvent((Object)this, (Object)objectArray, n));
                        break;
                    }
                    case 2: {
                        Serializable serializable;
                        Object k;
                        HashMap hashMap = new HashMap();
                        HashMap hashMap2 = new HashMap();
                        Map map = (Map)((Object[])object)[0];
                        Map map2 = (Map)((Object[])object)[1];
                        Iterator iterator = map.keySet().iterator();
                        while (iterator.hasNext()) {
                            serializable = (Serializable)map.get(k = iterator.next());
                            hashMap.put(k, AblePersistenceSupport.isBaseSQLObject(serializable) ? serializable : (Object)AblePersistenceSupport.Serialize(serializable));
                        }
                        iterator = map2.keySet().iterator();
                        while (iterator.hasNext()) {
                            serializable = (Serializable)map2.get(k = iterator.next());
                            hashMap2.put(k, AblePersistenceSupport.isBaseSQLObject(serializable) ? serializable : (Object)AblePersistenceSupport.Serialize(serializable));
                        }
                        this.eventQueue.postEvent(new AbleEvent((Object)this, (Object)new Object[]{hashMap, hashMap2}, n));
                        break;
                    }
                    case 3: {
                        if (object instanceof Map) {
                            HashMap hashMap = new HashMap();
                            Map map = (Map)object;
                            Iterator iterator = map.keySet().iterator();
                            while (iterator.hasNext()) {
                                Object k;
                                Serializable serializable = (Serializable)map.get(k = iterator.next());
                                hashMap.put(k, AblePersistenceSupport.isBaseSQLObject(serializable) ? serializable : (Object)AblePersistenceSupport.Serialize(serializable));
                            }
                            this.eventQueue.postEvent(new AbleEvent((Object)this, hashMap, n));
                            break;
                        }
                        this.eventQueue.postEvent(new AbleEvent((Object)this, object, n));
                    }
                }
            }
        }
    }

    private class AbleDBImportWrapper_
    extends AbleDBImport {
        public void open() throws AbleException {
            Vector vector = null;
            if (this.importData != null) {
                this.importData.close();
            }
            vector = (Vector)this.fieldList.clone();
            String string = "SELECT " + this.selectionColumns + " FROM ";
            if (this.schema != null && this.schema.trim().length() > 0) {
                string = string + this.schema + this.schemaSeparator;
            }
            string = string + this.table;
            if (this.selectionWhere != null && !this.selectionWhere.trim().equals("")) {
                string = string + " where " + this.selectionWhere;
            }
            this.importData = new AbleDBTable(this.connection, string);
            this.ableAbstractImportOpen();
            this.updateFieldUsage(vector);
        }

        public void process() throws AbleException {
            if (this.importData == null || !this.importData.isReady()) {
                return;
            }
            this.outputBuffer = this.outSym = this.getNextTextRecord();
            this.dataChanged(this.outputBuffer);
            ++this.recordsRead;
            if (this.trace.isLogging()) {
                this.trace.text(0x100000L, (Object)this, "process", "Processed record <" + this.recordIndex + "> of <" + this.numRecords + ">; <" + this.recordsRead + "> records read; total epochs <" + this.numEpochs + ">.");
            }
            if (this.recordsRead >= this.numRecords) {
                this.recordsRead = 0L;
                this.endOfFile();
            }
        }

        private void ableAbstractImportOpen() throws AbleException {
            if (this.importData != null) {
                this.importData.setBufferSize(this.bufferSize);
                if (this.computeStatistics) {
                    this.fieldList.removeAllElements();
                    this.importData.setFieldList(this.fieldList);
                    this.importData.open();
                    this.fieldList = this.importData.getFieldList();
                    this.computeStatistics = false;
                } else {
                    this.fieldList = this.getAgentFieldList();
                    this.importData.open();
                    this.importData.setFieldList(this.fieldList);
                }
                this.numRecords = this.importData.getNumRecords();
                this.numFieldsPerRecord = this.importData.getNumFieldsPerRec();
                this.bufferSize = this.importData.getBufferSize();
                this.generateRandomIndices(this.bufferSize);
                this.textData = this.importData.getTextData();
                this.outputBuffer = new Object[this.numFieldsPerRecord];
                for (int i = 0; i < this.numFieldsPerRecord; ++i) {
                    ((Object[])this.outputBuffer)[i] = "null";
                }
                this.recordsRead = 0L;
                this.recordIndex = -1L;
                this.bufferRecordIndex = -1;
            }
            if (!this.dataFlowEnabled) {
                this.setDataFlowEnabled(true);
            }
            this.chgSupport.firePropertyChange("dataSource", null, null);
            this.dataChanged(this.outputBuffer);
        }
    }
}

