/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.platform;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.AbleMessageContainer;
import com.ibm.able.platform.AbleAgentCapability;
import com.ibm.able.platform.AbleAgentSituation;
import com.ibm.able.platform.AbleAgentSituationReport;
import com.ibm.able.platform.AbleBasicService;
import com.ibm.able.platform.AblePersistenceSupport;
import com.ibm.able.platform.AblePersistenceSupportProcessor;
import com.ibm.able.platform.AblePlatform;
import com.ibm.able.platform.AblePlatformAgent;
import com.ibm.able.platform.AblePlatformPreferences;
import com.ibm.able.platform.AblePlatformServiceEventListener;
import com.ibm.able.platform.AbleSecureKey;
import com.ibm.able.platform.AbleSecuritySupport;
import com.ibm.able.platform.AgentLoggingException;
import com.ibm.able.platform.AgentLoggingService;
import com.ibm.able.platform.RmiAgentLoggingService;
import com.ibm.able.platform.VerifiableAgentDirectoryService;
import com.ibm.able.platform.VerifiableAgentName;
import java.io.Serializable;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.sql.Date;
import java.sql.Time;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.agent.AgentName;
import javax.agent.Locator;
import javax.agent.service.ServiceProperties;
import javax.agent.service.directory.AgentDescription;
import javax.agent.service.naming.NamingException;

public final class RmiAgentLoggingSystem
extends AbleBasicService
implements RmiAgentLoggingService,
AblePersistenceSupportProcessor {
    private Vector Situations;
    private AblePersistenceSupport myPrstSppt;
    private AblePersistenceSupport myPrstSpptLog;
    private VerifiableAgentDirectoryService myVerifiableDirectoryService = null;
    private int historyLogMax = -1;

    public RmiAgentLoggingSystem() throws Exception {
        this.ctorHelper();
        this.bindServiceToRegistry();
    }

    public RmiAgentLoggingSystem(ServiceProperties serviceProperties) throws Exception {
        super(serviceProperties);
        this.ctorHelper();
        this.bindServiceToRegistry();
    }

    public String getBindingName() {
        return "agent-logging-service";
    }

    public void addAblePlatformServiceEventListener(AblePlatformServiceEventListener ablePlatformServiceEventListener) throws AbleException {
        super.addAblePlatformServiceEventListener(ablePlatformServiceEventListener);
        if (this.myPrstSppt != null) {
            this.myPrstSppt.insert(new Serializable[]{(Serializable)((Object)ablePlatformServiceEventListener)});
        }
    }

    public void removeAblePlatformServiceEventListener(AblePlatformServiceEventListener ablePlatformServiceEventListener) throws AbleException {
        super.removeAblePlatformServiceEventListener(ablePlatformServiceEventListener);
        if (this.myPrstSppt != null) {
            HashMap<String, AblePlatformServiceEventListener> hashMap = new HashMap<String, AblePlatformServiceEventListener>();
            hashMap.put(this.myPrstSppt.getTableColumnNames()[0], ablePlatformServiceEventListener);
            this.myPrstSppt.delete(hashMap);
        }
    }

    public void terminateService(AbleSecureKey ableSecureKey) throws AbleException, NamingException {
        String string = "terminateService";
        if (Able.Preferences.isSecure()) {
            this.mySecSppt.verifyKey(ableSecureKey);
            this.mySecSppt.verifyTrustLevel(ableSecureKey, string);
        }
        if (this.myPrstSppt != null) {
            this.myPrstSppt.quitAll();
        }
        if (this.myPrstSpptLog != null) {
            this.myPrstSpptLog.quitAll();
        }
        AbleSecureKey ableSecureKey2 = Able.Preferences.isSecure() ? this.mySecSppt.generateKey(ableSecureKey) : null;
        super.terminateService(ableSecureKey2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshLocalFromPersistence(AblePersistenceSupport ablePersistenceSupport, Object[] objectArray) throws Exception {
        String string = "refreshLocalFromPersistence";
        if (ablePersistenceSupport != this.myPrstSppt && ablePersistenceSupport != this.myPrstSpptLog) {
            String string2 = AblePlatform.NlsMsg("PPSO_CallerMustMatchLocalPersistenceSupport", null);
            this.myMsgLog.text(4L, (Object)this, string, string2);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string2);
            }
            throw new NamingException(string2);
        }
        Vector vector = this.Situations;
        synchronized (vector) {
            if (ablePersistenceSupport == this.myPrstSppt) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (this.getState() == 4) {
                        return;
                    }
                    Object[] objectArray2 = (Object[])objectArray[i];
                    if (objectArray2[0] instanceof AbleAgentSituationReport) {
                        if (this.Situations.contains(objectArray2[0])) continue;
                        this.Situations.add(objectArray2[0]);
                        this.myMsgLog.text(1L, (Object)this, string, AblePlatform.NlsMsg("PPSO_SuccessfullyLoadedFromPersistence", new Object[]{"AbleAgentSituationReport"}));
                        if (!this.myTrcLog.isLogging()) continue;
                        this.myTrcLog.text(0x100000L, (Object)this, string, ((AbleAgentSituationReport)objectArray2[0]).debugString());
                        continue;
                    }
                    if (objectArray2[0] instanceof AblePlatformServiceEventListener) {
                        if (this.myServiceEventListeners.contains(objectArray2[0])) continue;
                        this.myServiceEventListeners.add(objectArray2[0]);
                        this.myMsgLog.text(1L, (Object)this, string, AblePlatform.NlsMsg("PPSO_SuccessfullyLoadedFromPersistence", new Object[]{"AblePlatformServiceEventListener"}));
                        continue;
                    }
                    this.myMsgLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("PPS_UnexpectedTypeFromPersistence", new Object[]{"com.ibm.able.platform.AbleAgentSituationReport, com.ibm.able.platform.AblePlatformServiceEventListener"}));
                }
                this.removeOverflowHistoryLogsForAllAgents(string);
            }
        }
        this.setState(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logAgentSituationReport(AbleAgentSituationReport ableAgentSituationReport, AbleSecureKey ableSecureKey) throws RemoteException, AgentLoggingException {
        String string = "logAgentSituationReport";
        if (ableAgentSituationReport == null || ableAgentSituationReport.getAgentName() == null) {
            String string2 = ableAgentSituationReport == null ? "Unable to log a null AbleAgentSituationReport" : "Unable to log an AbleAgentSituationReport with a null AgentName";
            this.myMsgLog.text(4L, (Object)this, string, string2);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string2);
            }
            throw new AgentLoggingException(string2);
        }
        if (Able.Preferences.isSecure()) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (Exception exception) {
                String string3 = AblePlatform.NlsMsg("SecOn_UnableToVerifyKey", new Object[]{ableSecureKey == null ? "null" : ableSecureKey.getVan().getName(), ableSecureKey == null ? "null" : ableSecureKey.getExpriationID()});
                this.myMsgLog.text(4L, (Object)this, string, string3);
                this.myMsgLog.text(4L, (Object)this, string, exception.getLocalizedMessage());
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.exception(262144L, (Object)this, string, (Throwable)exception);
                }
                throw new AgentLoggingException(string3, exception);
            }
        }
        Vector vector = this.Situations;
        synchronized (vector) {
            if (this.Situations.contains(ableAgentSituationReport)) {
                String string4 = AblePlatform.NlsMsg("LOG_ErrorLoggingSameLogTwice");
                this.myMsgLog.text(4L, (Object)this, string, string4);
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.text(262144L, (Object)this, string, string4);
                }
                throw new AgentLoggingException(string4);
            }
            if (this.myPrstSppt != null) {
                this.myPrstSppt.insert(new Serializable[]{ableAgentSituationReport});
            }
            if (this.myPrstSpptLog != null && !ableAgentSituationReport.getProblemState()) {
                long l = ableAgentSituationReport.getTimeCreated();
                String string5 = new Date(l).toString() + " " + new Time(l).toString();
                this.myPrstSpptLog.insert(new Serializable[]{this.myPrstSpptLog.nextId("ID"), string5, ableAgentSituationReport.getAgentDescription(), ableAgentSituationReport.getResponseTaken().toString(), ableAgentSituationReport.getResultsSummary().toString()});
            }
            this.Situations.add(ableAgentSituationReport);
            this.removeOverflowHistoryLogs(ableAgentSituationReport.getAgentName(), string);
        }
        this.thenNotifyAblePlatformServiceEventListeners(this + ":" + string + "(): ", 301, AblePlatform.NlsMsg("LOG_LoggedAgentSituationReport"), ableAgentSituationReport, null, this.myPrstSppt, this.myPrstSppt == null ? null : this.myPrstSppt.getTableColumnNames()[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAgentSituationReport(AbleAgentSituationReport ableAgentSituationReport, AbleAgentSituationReport ableAgentSituationReport2, AbleSecureKey ableSecureKey) throws RemoteException, AgentLoggingException {
        String string = "updateAgentSituationReport";
        if (ableAgentSituationReport2 == null || ableAgentSituationReport2.getAgentName() == null) {
            String string2 = ableAgentSituationReport2 == null ? "Unable to update to a null AbleAgentSituationReport" : "Unable to update to an AbleAgentSituationReport with a null AgentName";
            this.myMsgLog.text(4L, (Object)this, string, string2);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string2);
            }
            throw new AgentLoggingException(string2);
        }
        if (Able.Preferences.isSecure()) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (Exception exception) {
                String string3 = AblePlatform.NlsMsg("SecOn_UnableToVerifyKey", new Object[]{ableSecureKey == null ? "null" : ableSecureKey.getVan().getName(), ableSecureKey == null ? "null" : ableSecureKey.getExpriationID()});
                this.myMsgLog.text(4L, (Object)this, string, string3);
                this.myMsgLog.text(4L, (Object)this, string, exception.getLocalizedMessage());
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.exception(262144L, (Object)this, string, (Throwable)exception);
                }
                throw new AgentLoggingException(string3, exception);
            }
        }
        Vector vector = this.Situations;
        synchronized (vector) {
            if (!this.Situations.contains(ableAgentSituationReport)) {
                String string4 = AblePlatform.NlsMsg("LOG_ErrorAbsentLog", new Object[]{string});
                this.myMsgLog.text(4L, (Object)this, string, string4);
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.text(262144L, (Object)this, string, string4);
                }
                throw new AgentLoggingException(string4);
            }
            if (this.Situations.contains(ableAgentSituationReport2)) {
                String string5 = AblePlatform.NlsMsg("LOG_ErrorUpdatingToExistingLog");
                this.myMsgLog.text(4L, (Object)this, string, string5);
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.text(262144L, (Object)this, string, string5);
                }
                throw new AgentLoggingException(string5);
            }
            if (!ableAgentSituationReport.getProblemState()) {
                String string6 = AblePlatform.NlsMsg("LOG_ErrorUpdatingHistoryLog");
                this.myMsgLog.text(4L, (Object)this, string, string6);
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.text(262144L, (Object)this, string, string6);
                }
                throw new AgentLoggingException(string6);
            }
            if (Able.Preferences.isSecure() && ableAgentSituationReport.getAgentName() instanceof VerifiableAgentName && !ableAgentSituationReport.getAgentName().equals(ableSecureKey.getVan())) {
                String string7 = AblePlatform.NlsMsg("LOG_RequestNotAuthorized", new Object[]{string});
                this.myMsgLog.text(4L, (Object)this, string, string7);
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.text(262144L, (Object)this, string, string7);
                }
                throw new AgentLoggingException(string7);
            }
            if (this.myPrstSppt != null) {
                HashMap<String, AbleAgentSituationReport> hashMap = new HashMap<String, AbleAgentSituationReport>();
                hashMap.put(this.myPrstSppt.getTableColumnNames()[0], ableAgentSituationReport2);
                HashMap<String, AbleAgentSituationReport> hashMap2 = new HashMap<String, AbleAgentSituationReport>();
                hashMap2.put(this.myPrstSppt.getTableColumnNames()[0], ableAgentSituationReport);
                this.myPrstSppt.update(hashMap, hashMap2);
            }
            this.Situations.remove(ableAgentSituationReport);
            this.Situations.add(ableAgentSituationReport2);
            this.thenNotifyAblePlatformServiceEventListeners(this + ":" + string + "(): ", 303, AblePlatform.NlsMsg("LOG_UpdatedAgentSituationReport"), ableAgentSituationReport, ableAgentSituationReport2, this.myPrstSppt, this.myPrstSppt == null ? null : this.myPrstSppt.getTableColumnNames()[0]);
            this.removeOverflowHistoryLogs(ableAgentSituationReport2.getAgentName(), string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAgentSituationReports(Vector vector, AbleSecureKey ableSecureKey) throws RemoteException, AgentLoggingException {
        String string = "removeAgentSituationReports";
        if (vector == null) {
            String string2 = "Error removing AbleAgentSituationReports with a null remove Vector";
            this.myMsgLog.text(4L, (Object)this, string, string2);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string2);
            }
            throw new AgentLoggingException(string2);
        }
        Vector vector2 = this.Situations;
        synchronized (vector2) {
            Object object;
            Object object2;
            int n;
            for (n = 0; n < vector.size(); ++n) {
                object2 = (AbleAgentSituationReport)vector.get(n);
                if (this.Situations.contains(object2)) continue;
                String string3 = AblePlatform.NlsMsg("LOG_ErrorAbsentLog", new Object[]{string});
                this.myMsgLog.text(4L, (Object)this, string, string3);
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.text(262144L, (Object)this, string, string3);
                }
                throw new AgentLoggingException(string3);
            }
            if (Able.Preferences.isSecure()) {
                try {
                    this.mySecSppt.verifyKey(ableSecureKey);
                }
                catch (Exception exception) {
                    object2 = AblePlatform.NlsMsg("SecOn_UnableToVerifyKey", new Object[]{ableSecureKey == null ? "null" : ableSecureKey.getVan().getName(), ableSecureKey == null ? "null" : ableSecureKey.getExpriationID()});
                    this.myMsgLog.text(4L, (Object)this, string, (String)object2);
                    this.myMsgLog.text(4L, (Object)this, string, exception.getLocalizedMessage());
                    if (this.myTrcLog.isLogging()) {
                        this.myTrcLog.exception(262144L, (Object)this, string, (Throwable)exception);
                    }
                    throw new AgentLoggingException((String)object2, exception);
                }
                for (n = 0; n < vector.size(); ++n) {
                    object2 = (AbleAgentSituationReport)vector.get(n);
                    if (!(((AbleAgentSituationReport)object2).getAgentName() instanceof VerifiableAgentName)) continue;
                    if (((AbleAgentSituationReport)object2).getProblemState()) {
                        if (((AbleAgentSituationReport)object2).getAgentName().equals(ableSecureKey.getVan())) continue;
                        object = AblePlatform.NlsMsg("LOG_RequestNotAuthorized", new Object[]{string});
                        this.myMsgLog.text(4L, (Object)this, string, (String)object);
                        if (this.myTrcLog.isLogging()) {
                            this.myTrcLog.text(262144L, (Object)this, string, (String)object);
                        }
                        throw new AgentLoggingException((String)object);
                    }
                    object = (VerifiableAgentName)((AbleAgentSituationReport)object2).getAgentName();
                    if (!AbleSecuritySupport.lowerTrustLevelLogged((VerifiableAgentName)object, ableSecureKey, string)) continue;
                    String string4 = AblePlatform.NlsMsg("CallerTrustLevelTooLowToRunMethod", new Object[]{ableSecureKey.getVan().getKerbPrincipal(), ableSecureKey.getVan().getLevel(), string, object.getLevel()});
                    this.myMsgLog.text(4L, (Object)this, string, string4);
                    if (this.myTrcLog != null) {
                        this.myTrcLog.text(262144L, (Object)this, string, string4);
                    }
                    throw new AgentLoggingException(string4);
                }
            }
            for (n = 0; n < vector.size(); ++n) {
                object2 = (AbleAgentSituationReport)vector.get(n);
                if (this.myPrstSppt != null) {
                    object = new HashMap<String, Object>();
                    object.put(this.myPrstSppt.getTableColumnNames()[0], object2);
                    this.myPrstSppt.delete((Map)object);
                }
                this.Situations.remove(object2);
            }
        }
        this.thenNotifyAblePlatformServiceEventListeners(this + ":" + string + "(): ", 302, AblePlatform.NlsMsg("LOG_RemovedAgentSituationReport"), vector, null, this.myPrstSppt, this.myPrstSppt == null ? null : this.myPrstSppt.getTableColumnNames()[0]);
    }

    public Vector getAllLogs() throws RemoteException {
        return this.Situations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllProblems() throws RemoteException {
        Vector<AbleAgentSituationReport> vector = new Vector<AbleAgentSituationReport>();
        Vector vector2 = this.Situations;
        synchronized (vector2) {
            for (int i = 0; i < this.Situations.size(); ++i) {
                AbleAgentSituationReport ableAgentSituationReport = (AbleAgentSituationReport)this.Situations.get(i);
                if (!ableAgentSituationReport.getProblemState()) continue;
                vector.add(ableAgentSituationReport);
            }
        }
        return vector;
    }

    public Vector getAgentHistory(AgentName agentName) throws RemoteException {
        return this.getLogs(agentName, false);
    }

    public Vector getAgentProblems(AgentName agentName) throws RemoteException {
        return this.getLogs(agentName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getLogs(AgentName agentName, boolean bl) {
        String string = "getLogs";
        Vector<AbleAgentSituationReport> vector = new Vector<AbleAgentSituationReport>();
        Vector vector2 = this.Situations;
        synchronized (vector2) {
            for (int i = 0; i < this.Situations.size(); ++i) {
                AbleAgentSituationReport ableAgentSituationReport = (AbleAgentSituationReport)this.Situations.get(i);
                if (!ableAgentSituationReport.getAgentName().equals(agentName) || !(bl ? ableAgentSituationReport.getProblemState() : !ableAgentSituationReport.getProblemState())) continue;
                vector.add(ableAgentSituationReport);
            }
        }
        return vector;
    }

    public void answerAgentRequest(AbleAgentSituationReport ableAgentSituationReport, AbleSecureKey ableSecureKey) throws AbleException, RemoteException, AgentLoggingException {
        String string = "answerAgentRequest";
        if (ableAgentSituationReport == null) {
            String string2 = "Unable to answer a request with a null AbleAgentSituationReport";
            this.myMsgLog.text(4L, (Object)this, string, string2);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string2);
            }
            throw new AgentLoggingException(string2);
        }
        if (Able.Preferences.isSecure()) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (Exception exception) {
                String string3 = AblePlatform.NlsMsg("SecOn_UnableToVerifyKey", new Object[]{ableSecureKey == null ? "null" : ableSecureKey.getVan().getName(), ableSecureKey == null ? "null" : ableSecureKey.getExpriationID()});
                this.myMsgLog.text(4L, (Object)this, string, string3);
                this.myMsgLog.text(4L, (Object)this, string, exception.getLocalizedMessage());
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.exception(262144L, (Object)this, string, (Throwable)exception);
                }
                throw new AgentLoggingException(string3, exception);
            }
        }
        AbleAgentSituationReport ableAgentSituationReport2 = new AbleAgentSituationReport(ableAgentSituationReport);
        ableAgentSituationReport2.setResponseTaken(null);
        Vector vector = this.search(ableAgentSituationReport2);
        if (vector.isEmpty()) {
            String string4 = AblePlatform.NlsMsg("LOG_ErrorAbsentLog", new Object[]{string});
            this.myMsgLog.text(4L, (Object)this, string, string4);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string4);
            }
            throw new AgentLoggingException(string4);
        }
        if (!ableAgentSituationReport.getProblemState()) {
            String string5 = "History logs may not be used to answer a request";
            this.myMsgLog.text(4L, (Object)this, string, string5);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string5);
            }
            throw new AgentLoggingException(string5);
        }
        AblePlatformAgent ablePlatformAgent = null;
        try {
            Locator locator;
            int n;
            this.myVerifiableDirectoryService = (VerifiableAgentDirectoryService)AblePlatform.getService((String)this.myServiceProperties.get("javax.agent.service.ip.service-port"), "agent-directory-service");
            AgentDescription agentDescription = this.myVerifiableDirectoryService.createAgentDescription();
            agentDescription.setAgentName(ableAgentSituationReport.getAgentName());
            AgentDescription[] agentDescriptionArray = null;
            try {
                agentDescriptionArray = this.myVerifiableDirectoryService.search(agentDescription);
                if (agentDescriptionArray.length <= 0) {
                    throw new Exception(AblePlatform.NlsMsg("LOG_NoMatchingDesc"));
                }
            }
            catch (Exception exception) {
                String string6 = AblePlatform.NlsMsg("LOG_UnableToLocateAgent");
                this.myMsgLog.text(4L, (Object)this, string, string6);
                this.myMsgLog.text(4L, (Object)this, string, exception.getLocalizedMessage());
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.exception(262144L, (Object)this, string, (Throwable)exception);
                }
                throw new AgentLoggingException(string6);
            }
            Locator[] locatorArray = agentDescriptionArray[0].getLocators();
            Vector<Locator> vector2 = new Vector<Locator>();
            Vector<Locator> vector3 = new Vector<Locator>();
            for (n = 0; n < locatorArray.length; ++n) {
                if (locatorArray[n].getType().equalsIgnoreCase("com.ibm.able.platform.able-direct-locator")) {
                    vector2.add(locatorArray[n]);
                    continue;
                }
                vector3.add(locatorArray[n]);
            }
            for (n = 0; n < vector2.size() && (ablePlatformAgent = (AblePlatformAgent)(locator = (Locator)vector2.get(n)).get("com.ibm.able.platform.able-direct-object")) == null; ++n) {
            }
            if (ablePlatformAgent == null) {
                for (n = 0; n < vector3.size(); ++n) {
                    locator = (Locator)vector3.get(n);
                    try {
                        ablePlatformAgent = (AblePlatformAgent)((Object)Naming.lookup(locator.getAddress()));
                        if (ablePlatformAgent == null) continue;
                        break;
                    }
                    catch (Exception exception) {
                        if (n < vector3.size() - 1) continue;
                        throw new RemoteException(exception.getLocalizedMessage());
                    }
                }
                if (ablePlatformAgent == null) {
                    String string7 = AblePlatform.NlsMsg("LOG_UnableToLocateAgent");
                    this.myMsgLog.text(4L, (Object)this, string, string7);
                    if (this.myTrcLog.isLogging()) {
                        this.myTrcLog.text(262144L, (Object)this, string, string7);
                    }
                    throw new AgentLoggingException(string7);
                }
            }
            AbleSecureKey ableSecureKey2 = null;
            if (Able.Preferences.isSecure()) {
                ableSecureKey2 = this.mySecSppt.generateKey(ableSecureKey);
            }
            ablePlatformAgent.handleAnsweredRequest(ableAgentSituationReport, ableSecureKey2);
        }
        catch (RemoteException remoteException) {
            this.myMsgLog.text(4L, (Object)this, string, remoteException.getLocalizedMessage());
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.exception(262144L, (Object)this, string, (Throwable)remoteException);
            }
            if (remoteException instanceof ServerException && remoteException.detail instanceof AbleException) {
                throw (AbleException)remoteException.detail;
            }
            if (remoteException instanceof AbleException) {
                throw (AbleException)((Object)remoteException);
            }
            throw new AgentLoggingException(remoteException.detail.getLocalizedMessage(), remoteException);
        }
        catch (NamingException namingException) {
            String string8 = AblePlatform.NlsMsg("SecOn_SecureKeyNotGenerated");
            this.myMsgLog.text(4L, (Object)this, string, string8);
            this.myMsgLog.text(4L, (Object)this, string, namingException.getLocalizedMessage());
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.exception(262144L, (Object)this, string, (Throwable)namingException);
            }
            throw new AgentLoggingException(string8, (Exception)((Object)namingException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAgentLogs(AgentName agentName, AbleSecureKey ableSecureKey) throws RemoteException, AgentLoggingException {
        String string = "removeAgentLogs";
        if (agentName == null) {
            String string2 = "Unable to remove agent logs of a null AgentName";
            this.myMsgLog.text(4L, (Object)this, string, string2);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string2);
            }
            throw new AgentLoggingException(string2);
        }
        if (Able.Preferences.isSecure()) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (Exception exception) {
                String string3 = AblePlatform.NlsMsg("SecOn_UnableToVerifyKey", new Object[]{ableSecureKey == null ? "null" : ableSecureKey.getVan().getName(), ableSecureKey == null ? "null" : ableSecureKey.getExpriationID()});
                this.myMsgLog.text(4L, (Object)this, string, string3);
                this.myMsgLog.text(4L, (Object)this, string, exception.getLocalizedMessage());
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.exception(262144L, (Object)this, string, (Throwable)exception);
                }
                throw new AgentLoggingException(string3, exception);
            }
        }
        Vector vector = this.Situations;
        synchronized (vector) {
            Vector<AbleAgentSituationReport> vector2 = new Vector<AbleAgentSituationReport>();
            for (int i = 0; i < this.Situations.size(); ++i) {
                Object object;
                AbleAgentSituationReport ableAgentSituationReport = (AbleAgentSituationReport)this.Situations.get(i);
                if (!ableAgentSituationReport.getAgentName().equals(agentName)) continue;
                if (Able.Preferences.isSecure() && (object = (VerifiableAgentName)ableAgentSituationReport.getAgentName()) != null && !object.equals(ableSecureKey.getVan())) {
                    String string4 = AblePlatform.NlsMsg("LOG_RequestNotAuthorized", new Object[]{string});
                    this.myMsgLog.text(4L, (Object)this, string, string4);
                    if (!this.myTrcLog.isLogging()) continue;
                    this.myTrcLog.text(262144L, (Object)this, string, string4);
                    continue;
                }
                this.Situations.remove(i--);
                if (this.myPrstSppt != null) {
                    object = new HashMap();
                    object.put(this.myPrstSppt.getTableColumnNames()[0], ableAgentSituationReport);
                    this.myPrstSppt.delete((Map)object);
                }
                vector2.add(ableAgentSituationReport);
            }
            this.thenNotifyAblePlatformServiceEventListeners(this + ":" + string + "(): ", 302, AblePlatform.NlsMsg("LOG_RemovedAgentSituationReport"), vector2, null, this.myPrstSppt, this.myPrstSppt == null ? null : this.myPrstSppt.getTableColumnNames()[0]);
        }
    }

    private void ctorHelper() {
        this.Situations = new Vector();
        AblePlatformPreferences.ServiceEntry_ serviceEntry_ = AblePlatform.Preferences.getServiceEntry(this.getBindingName());
        if (serviceEntry_.getPersistenceFlag()) {
            this.myPrstSppt = new AblePersistenceSupport(serviceEntry_.getPersistenceDatabase(), serviceEntry_.getPersistenceTable(), serviceEntry_.getPersistenceSchema(), AgentLoggingService.COLUMN_NAMES, AgentLoggingService.COLUMN_TYPES, serviceEntry_.getPersistenceRetry(), this, this.mySecSppt, false);
            if ("on".equalsIgnoreCase((String)serviceEntry_.getServiceProperties().get("History-Log-Text"))) {
                this.myPrstSpptLog = new AblePersistenceSupport(serviceEntry_.getPersistenceDatabase(), "AblePlatformLog", serviceEntry_.getPersistenceSchema(), new String[]{"ID", "itemDate", "AgentDescription", "Response", "Results"}, new String[]{"INTEGER", "DATETIME", "VARCHAR(132)", "VARCHAR(256)", "VARCHAR(256)"}, serviceEntry_.getPersistenceRetry(), this, this.mySecSppt, true);
            }
        }
        Enumeration enumeration = this.myServiceProperties.getAll().keys();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof String) || !((String)e).equalsIgnoreCase("history-log-max")) continue;
            this.historyLogMax = new Integer((String)this.myServiceProperties.get((String)e));
        }
        if (serviceEntry_.getPersistenceFlag()) {
            this.setState(3);
        } else {
            this.setState(2);
        }
    }

    private void removeOverflowHistoryLogsForAllAgents(String string) {
        int n;
        Vector<AgentName> vector = new Vector<AgentName>();
        for (n = 0; n < this.Situations.size(); ++n) {
            AbleAgentSituationReport ableAgentSituationReport = (AbleAgentSituationReport)this.Situations.get(n);
            if (ableAgentSituationReport.getProblemState() || vector.contains(ableAgentSituationReport.getAgentName())) continue;
            vector.add(ableAgentSituationReport.getAgentName());
        }
        for (n = 0; n < vector.size(); ++n) {
            this.removeOverflowHistoryLogs((AgentName)vector.get(n), string);
        }
    }

    private void removeOverflowHistoryLogs(AgentName agentName, String string) {
        if (agentName == null) {
            return;
        }
        Vector<Object> vector = this.getLogs(agentName, false);
        int n = vector.size();
        if (this.historyLogMax < 0 || n <= 0) {
            return;
        }
        int n2 = vector.size() - this.historyLogMax;
        if (n2 > 0) {
            LoggingSystemMaxHistoryComparator_ loggingSystemMaxHistoryComparator_ = new LoggingSystemMaxHistoryComparator_();
            Object[] objectArray = vector.toArray();
            Arrays.sort(objectArray, loggingSystemMaxHistoryComparator_);
            vector = new Vector<Object>(Arrays.asList(objectArray));
            Vector<AbleAgentSituationReport> vector2 = new Vector<AbleAgentSituationReport>();
            for (int i = 0; i < n2; ++i) {
                AbleAgentSituationReport ableAgentSituationReport = (AbleAgentSituationReport)vector.get(i);
                if (this.myPrstSppt != null) {
                    HashMap<String, AbleAgentSituationReport> hashMap = new HashMap<String, AbleAgentSituationReport>();
                    hashMap.put(this.myPrstSppt.getTableColumnNames()[0], ableAgentSituationReport);
                    this.myPrstSppt.delete(hashMap);
                }
                this.Situations.remove(ableAgentSituationReport);
                vector2.add(ableAgentSituationReport);
            }
            this.thenNotifyAblePlatformServiceEventListeners(this + ":" + string + "(): ", 302, AblePlatform.NlsMsg("LOG_RemovedAgentSituationReport"), vector2, null, this.myPrstSppt, this.myPrstSppt == null ? null : this.myPrstSppt.getTableColumnNames()[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector search(AbleAgentSituationReport ableAgentSituationReport) throws RemoteException, AgentLoggingException {
        String string = "search";
        if (ableAgentSituationReport == null) {
            String string2 = "Unable to search for a null AbleAgentSituationReport";
            this.myMsgLog.text(4L, (Object)this, string, string2);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string2);
            }
            throw new AgentLoggingException(string2);
        }
        Vector<AbleAgentSituationReport> vector = new Vector<AbleAgentSituationReport>();
        AbleAgentCapability ableAgentCapability = ableAgentSituationReport.getCapability();
        AbleAgentSituation ableAgentSituation = ableAgentSituationReport.getSituation();
        boolean bl = ableAgentSituationReport.getProblemState();
        AbleMessageContainer ableMessageContainer = ableAgentSituationReport.getResponseTaken();
        AbleMessageContainer ableMessageContainer2 = ableAgentSituationReport.getResultsSummary();
        AbleMessageContainer ableMessageContainer3 = ableAgentSituationReport.getSuggestedResponse();
        AgentName agentName = ableAgentSituationReport.getAgentName();
        String string3 = ableAgentSituationReport.getAgentDescription();
        long l = ableAgentSituationReport.getTimeCreated();
        String string4 = ableAgentSituationReport.getSystemName();
        Serializable serializable = ableAgentSituationReport.getIdentifier();
        Vector vector2 = this.Situations;
        synchronized (vector2) {
            for (int i = 0; i < this.Situations.size(); ++i) {
                AbleAgentSituationReport ableAgentSituationReport2 = (AbleAgentSituationReport)this.Situations.get(i);
                if (ableAgentCapability != null && !ableAgentCapability.equals(ableAgentSituationReport2.getCapability()) || ableAgentSituation != null && !ableAgentSituation.equals(ableAgentSituationReport2.getSituation()) || bl != ableAgentSituationReport2.getProblemState() || ableMessageContainer != null && !ableMessageContainer.equals((Object)ableAgentSituationReport2.getResponseTaken()) || ableMessageContainer2 != null && !ableMessageContainer2.equals((Object)ableAgentSituationReport2.getResultsSummary()) || ableMessageContainer3 != null && !ableMessageContainer3.equals((Object)ableAgentSituationReport2.getSuggestedResponse()) || agentName != null && !agentName.equals(ableAgentSituationReport2.getAgentName()) || string3 != null && !string3.equalsIgnoreCase(ableAgentSituationReport2.getAgentDescription()) || l != 0L && l != ableAgentSituationReport2.getTimeCreated() || string4 != null && !string4.equalsIgnoreCase(ableAgentSituationReport2.getSystemName()) || serializable != null && !serializable.equals(ableAgentSituationReport2.getIdentifier())) continue;
                vector.add(ableAgentSituationReport2);
            }
        }
        return vector;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    private class LoggingSystemMaxHistoryComparator_
    implements Comparator {
        static final String COPYRIGHT = " Licensed Materials - Property of IBM, 5722-SS1 (C) COPYRIGHT 1999, 2003 All Rights Reserved. US Government Users restricted Rights - Use, Duplication or Disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        private LoggingSystemMaxHistoryComparator_() {
        }

        public int compare(Object object, Object object2) {
            long l;
            long l2 = ((AbleAgentSituationReport)object).getTimeCreated();
            if (l2 == (l = ((AbleAgentSituationReport)object2).getTimeCreated())) {
                return 0;
            }
            if (l2 < l) {
                return -1;
            }
            return 1;
        }

        public boolean equals(Object object) {
            return this.equals(object);
        }
    }
}

