/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.platform;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.platform.AbleBasicService;
import com.ibm.able.platform.AblePersistenceSupport;
import com.ibm.able.platform.AblePersistenceSupportProcessor;
import com.ibm.able.platform.AblePlatform;
import com.ibm.able.platform.AblePlatformPreferences;
import com.ibm.able.platform.AbleSecureKey;
import com.ibm.able.platform.AbleSecuritySupport;
import com.ibm.able.platform.RMIVerifiableNamingService;
import com.ibm.able.platform.VerifiableAgentName;
import com.ibm.able.platform.VerifiableAgentNameImpl;
import com.ibm.able.platform.VerifiableAgentNamingService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.dgc.VMID;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.agent.AgentName;
import javax.agent.service.ServiceProperties;
import javax.agent.service.naming.NamingException;
import javax.agent.service.naming.NamingFailure;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import org.jagent.acr.AcrAgentName;
import org.jagent.service.util.IPUtility;
import org.jagent.util.URIUtility;

public final class RMIVerifiableNamingSystem
extends AbleBasicService
implements RMIVerifiableNamingService,
AblePersistenceSupportProcessor {
    private Map lclVANs;
    private String bindingAddr;
    private Map conversations;
    private Map vanConversations;
    private Map expirationIDs;
    private Object manager;
    private AblePersistenceSupport myPrstSppt;

    public RMIVerifiableNamingSystem(ServiceProperties serviceProperties) throws Exception {
        super(serviceProperties);
        int n;
        Object object;
        if (serviceProperties != null && serviceProperties.containsKey("javax.agent.service.ip.service-port")) {
            object = (String)serviceProperties.get("javax.agent.service.ip.service-port");
            n = Integer.parseInt((String)object);
        } else {
            n = IPUtility.getOpenPort();
        }
        this.bindingAddr = URIUtility.buildURI((String)"rmi", (String)IPUtility.getLocalHost(), (int)n, (String)this.getBindingName());
        if (Able.Preferences.isSecure()) {
            this.manager = GSSManager.getInstance();
            this.conversations = new HashMap();
            this.vanConversations = new HashMap();
            this.expirationIDs = new HashMap();
            this.lclVANs = new HashMap();
            this.myVerifiableAgentName = this.createAgentName(this.myKeyPair.getPublic(), this.myPrincipal, this.getBindingName(), this.getBindingName());
            this.mySecSppt = new AbleSecuritySupport(this.myKeyPair, this.myVerifiableAgentName, this.myVerifiableNamingService, this.myMsgLog, this.myTrcLog);
        }
        if (((AblePlatformPreferences.ServiceEntry_)(object = AblePlatform.Preferences.getServiceEntry(this.getBindingName()))).getPersistenceFlag()) {
            this.myPrstSppt = new AblePersistenceSupport(((AblePlatformPreferences.ServiceEntry_)object).getPersistenceDatabase(), ((AblePlatformPreferences.ServiceEntry_)object).getPersistenceTable(), ((AblePlatformPreferences.ServiceEntry_)object).getPersistenceSchema(), VerifiableAgentNamingService.COLUMN_NAMES, VerifiableAgentNamingService.COLUMN_TYPES, ((AblePlatformPreferences.ServiceEntry_)object).getPersistenceRetry(), this, this.mySecSppt);
        }
        if (((AblePlatformPreferences.ServiceEntry_)object).getPersistenceFlag()) {
            this.setState(3);
        } else {
            this.setState(2);
        }
        this.bindServiceToRegistry();
    }

    public String getBindingName() {
        return "agent-naming-service";
    }

    public void terminateService(AbleSecureKey ableSecureKey) throws AbleException, NamingException {
        Iterator iterator;
        String string = "terminateService";
        if (Able.Preferences.isSecure()) {
            this.mySecSppt.verifyKey(ableSecureKey);
            this.mySecSppt.verifyTrustLevel(ableSecureKey, string);
        }
        if (this.myPrstSppt != null) {
            this.myPrstSppt.quitAll();
        }
        if (Able.Preferences.isSecure()) {
            iterator = this.conversations.keySet().iterator();
            while (iterator.hasNext()) {
                try {
                    ((GSSContext)this.conversations.get(iterator.next())).dispose();
                }
                catch (Exception exception) {
                    this.myMsgLog.text(4L, (Object)this, string, exception.getLocalizedMessage());
                    if (!this.myTrcLog.isLogging()) continue;
                    this.myTrcLog.exception(262144L, (Object)this, string + " disposing GSSContext", (Throwable)exception);
                }
            }
        }
        iterator = Able.Preferences.isSecure() ? this.mySecSppt.generateKey(ableSecureKey) : null;
        super.terminateService((AbleSecureKey)((Object)iterator));
    }

    public void refreshLocalFromPersistence(AblePersistenceSupport ablePersistenceSupport, Object[] objectArray) throws Exception {
        String string = "refreshLocalFromPersistence";
        if (!Able.Preferences.isSecure()) {
            return;
        }
        if (ablePersistenceSupport != this.myPrstSppt) {
            String string2 = AblePlatform.NlsMsg("PPSO_CallerMustMatchLocalPersistenceSupport", null);
            this.myMsgLog.text(4L, (Object)this, string, string2);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string2);
            }
            throw new NamingException(string2);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.getState() == 4) {
                return;
            }
            Object[] objectArray2 = (Object[])objectArray[i];
            if (objectArray2[1] instanceof VerifiableAgentName) {
                if (!this.lclVANs.containsKey(objectArray2[0])) {
                    this.lclVANs.put(objectArray2[0], objectArray2[1]);
                }
                this.myMsgLog.text(1L, (Object)this, string, AblePlatform.NlsMsg("PPSO_SuccessfullyLoadedFromPersistence", new Object[]{"VerifiableAgentName"}));
                if (!this.myTrcLog.isLogging()) continue;
                this.myTrcLog.text(0x100000L, (Object)this, string, ((VerifiableAgentNameImpl)objectArray2[1]).debugString());
                continue;
            }
            this.myMsgLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("PPS_UnexpectedTypeFromPersistence", new Object[]{"com.ibm.able.platform.VerifiableAgentName"}));
        }
        this.setState(2);
    }

    public String openConversation() throws RemoteException, NamingException {
        GSSContext gSSContext;
        Object object;
        Object object2;
        String string = "openConversation()";
        if (this.myTrcLog.isLogging()) {
            this.myTrcLog.entry(0x100000L, (Object)this, string);
        }
        if (!Able.Preferences.isSecure()) {
            String string2 = AblePlatform.NlsMsg("SecOn_PlatformMustBeSecure", new Object[]{this + "." + string + "()"});
            this.myMsgLog.text(4L, (Object)this, string, string2);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string2);
            }
            throw new NamingException(string2);
        }
        String string3 = AblePlatform.Preferences.principalOfService("agent-naming-service");
        try {
            object2 = ((GSSManager)this.manager).createName(string3, GSSName.NT_USER_NAME);
            object = ((GSSManager)this.manager).createCredential((GSSName)object2, 0, new Oid("1.2.840.113554.1.2.2"), 2);
            gSSContext = ((GSSManager)this.manager).createContext((GSSCredential)object);
        }
        catch (Exception exception) {
            String string4 = AblePlatform.NlsMsg("VANS_ErrorCreatingContextCredentials");
            this.myMsgLog.text(4L, (Object)this, string, string4);
            this.myMsgLog.text(4L, (Object)this, string, exception.getLocalizedMessage());
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.exception(262144L, (Object)this, string, (Throwable)exception);
            }
            throw new NamingException(string4, exception);
        }
        object2 = new VMID();
        object = ((VMID)object2).toString();
        this.conversations.put(object, gSSContext);
        if (this.myTrcLog.isLogging()) {
            this.myTrcLog.exit(0x100000L, (Object)this, string + ": opened convId: " + (String)object);
        }
        return object;
    }

    public byte[] pushAndPull(String string, byte[] byArray) throws RemoteException, NamingException, NamingFailure {
        String string2 = "pushAndPull";
        if (this.myTrcLog.isLogging()) {
            this.myTrcLog.entry(0x100000L, (Object)this, string2 + "(convId = " + string + " token = " + byArray + ")");
        }
        if (!Able.Preferences.isSecure()) {
            throw new NamingException(AblePlatform.NlsMsg("SecOn_PlatformMustBeSecure", new Object[]{this + "." + string2 + "()"}));
        }
        GSSContext gSSContext = (GSSContext)this.conversations.get(string);
        if (gSSContext == null) {
            String string3 = AblePlatform.NlsMsg("VANS_ConversationIdNotFound", new Object[]{string});
            this.myMsgLog.text(4L, (Object)this, string2, string3);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string2, string3);
            }
            throw new NamingFailure(string3);
        }
        if (!gSSContext.isEstablished()) {
            try {
                byArray = gSSContext.acceptSecContext(byArray, 0, byArray.length);
                this.myMsgLog.text(1L, (Object)this, string2, AblePlatform.NlsMsg("VANS_SuccessfullyAcceptedSecureContext", new Object[]{string, gSSContext.getSrcName()}));
            }
            catch (Exception exception) {
                String string4 = AblePlatform.NlsMsg("VANS_ErrorEstablishingSecureContext");
                this.myMsgLog.text(4L, (Object)this, string2, string4);
                this.myMsgLog.text(4L, (Object)this, string2, exception.getLocalizedMessage());
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.exception(262144L, (Object)this, string2 + " convId = " + string, (Throwable)exception);
                }
                throw new NamingException(string4, exception);
            }
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.exit(0x100000L, (Object)this, string2 + " securing context, convId = " + string);
            }
            return byArray;
        }
        MessageProp messageProp = new MessageProp(true);
        try {
            byte[] byArray2 = gSSContext.unwrap(byArray, 0, byArray.length, messageProp);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            PublicKey publicKey = (PublicKey)objectInputStream.readObject();
            String string5 = (String)objectInputStream.readObject();
            String string6 = (String)objectInputStream.readObject();
            try {
                String string7 = ((Object)gSSContext.getSrcName()).toString();
                if (string5 == null) {
                    string5 = string7;
                } else if (!string5.equalsIgnoreCase(string7)) {
                    Object object;
                    boolean bl = false;
                    Hashtable hashtable = AblePlatform.Preferences.getAgentPools();
                    Iterator iterator = hashtable.keySet().iterator();
                    while (iterator.hasNext()) {
                        object = (AblePlatformPreferences.AgentPoolEntry_)hashtable.get(iterator.next());
                        if (!((AblePlatformPreferences.AgentPoolEntry_)object).getPrincipal().equalsIgnoreCase(string7)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        object = AblePlatform.NlsMsg("VANS_RequestingPrincMustMatchNewVanPrinc", new Object[]{string5, string7});
                        this.myMsgLog.text(4L, (Object)this, string2, (String)object);
                        if (this.myTrcLog.isLogging()) {
                            this.myTrcLog.text(262144L, (Object)this, string2, (String)object);
                        }
                        throw new NamingException((String)object);
                    }
                }
                VerifiableAgentName verifiableAgentName = this.createAgentName(publicKey, string5, string, string6);
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.exit(0x100000L, (Object)this, string2 + " Created VAN for convId = " + string);
                }
                return this.serializeAndWrap(gSSContext, (Serializable)((Object)verifiableAgentName));
            }
            catch (Exception exception) {
                String string8 = AblePlatform.NlsMsg("VANS_ErrorWrappingReturnMessage");
                this.myMsgLog.text(4L, (Object)this, string2, string8);
                this.myMsgLog.text(4L, (Object)this, string2, exception.getLocalizedMessage());
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.exception(262144L, (Object)this, string2 + " convId = " + string + " error wrapping result of a create VAN", (Throwable)exception);
                }
                throw new NamingException(string8, exception);
            }
        }
        catch (IOException iOException) {
            this.myMsgLog.text(4L, (Object)this, string2, iOException.getLocalizedMessage());
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.exception(262144L, (Object)this, string2 + " convId = " + string, (Throwable)iOException);
            }
            throw new NamingException(this + "." + string2 + "(): ", (Exception)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.myMsgLog.text(4L, (Object)this, string2, classNotFoundException.getLocalizedMessage());
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.exception(262144L, (Object)this, string2 + " convId = " + string, (Throwable)classNotFoundException);
            }
            throw new NamingException(this + "." + string2 + "(): ", (Exception)classNotFoundException);
        }
        catch (Exception exception) {
            this.myMsgLog.text(4L, (Object)this, string2, exception.getLocalizedMessage());
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.exception(262144L, (Object)this, string2 + " convId = " + string, (Throwable)exception);
            }
            throw new NamingException(this + "." + string2 + "(): ", exception);
        }
    }

    public void closeConversation(String string, AbleSecureKey ableSecureKey) throws RemoteException, NamingException {
        String string2 = "closeConversation";
        if (!Able.Preferences.isSecure()) {
            String string3 = AblePlatform.NlsMsg("SecOn_PlatformMustBeSecure", new Object[]{this + "." + string2 + "()"});
            this.myMsgLog.text(4L, (Object)this, string2, string3);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string2, string3);
            }
            throw new NamingException(string3);
        }
        this.mySecSppt.verifyKey(ableSecureKey);
        GSSContext gSSContext = (GSSContext)this.conversations.get(string);
        if (gSSContext == null) {
            String string4 = AblePlatform.NlsMsg("VANS_ConversationIdNotFound", new Object[]{string});
            this.myMsgLog.text(4L, (Object)this, string2, string4);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string2, string4);
            }
            throw new NamingException(string4);
        }
        String string5 = (String)this.vanConversations.get(ableSecureKey.getVan().getName());
        if (!string.equalsIgnoreCase(string5)) {
            String string6 = AblePlatform.NlsMsg("VANS_CloseRequestNotAuthorized");
            this.myMsgLog.text(4L, (Object)this, string2, string6);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string2, string6);
            }
            throw new NamingException(string6);
        }
        try {
            String string7 = ((Object)((GSSContext)this.conversations.get(string)).getSrcName()).toString();
            this.conversations.remove(string);
            gSSContext.dispose();
            this.myMsgLog.text(1L, (Object)this, string2, AblePlatform.NlsMsg("VANS_CloseRequestComplete", new Object[]{string, string7, ableSecureKey.getVan().getName()}));
        }
        catch (Exception exception) {
            this.myMsgLog.text(4L, (Object)this, string2, exception.getLocalizedMessage());
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.exception(262144L, (Object)this, string2, (Throwable)exception);
            }
            throw new NamingException(this + "." + string2 + "(): ", exception);
        }
    }

    public AgentName createInsecureName() {
        VMID vMID = new VMID();
        return new AcrAgentName(vMID.toString());
    }

    public VerifiableAgentName createAgentName(PublicKey publicKey, String string, String string2, AbleSecureKey ableSecureKey) throws RemoteException, NamingException {
        String string3 = "createAgentName";
        if (this.myTrcLog.isLogging()) {
            this.myTrcLog.entry(0x100000L, (Object)this, string3);
        }
        if (!Able.Preferences.isSecure()) {
            String string4 = AblePlatform.NlsMsg("SecOn_PlatformMustBeSecure", new Object[]{this + "." + string3 + "()"});
            this.myMsgLog.text(4L, (Object)this, string3, string4);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string3, string4);
            }
            throw new NamingException(string4);
        }
        this.mySecSppt.verifyKey(ableSecureKey);
        if (string == null) {
            throw new NamingException(AblePlatform.NlsMsg("VANS_PROXY_InvalidPrincipalInCreateVAN"));
        }
        if (publicKey == null) {
            throw new NamingException(AblePlatform.NlsMsg("VANS_PROXY_InvalidPublicKeyInCreateVAN"));
        }
        if (!string.equalsIgnoreCase(ableSecureKey.getVan().getKerbPrincipal())) {
            Object object;
            boolean bl = false;
            Hashtable hashtable = AblePlatform.Preferences.getAgentPools();
            Iterator iterator = hashtable.keySet().iterator();
            while (iterator.hasNext()) {
                object = (AblePlatformPreferences.AgentPoolEntry_)hashtable.get(iterator.next());
                if (!((AblePlatformPreferences.AgentPoolEntry_)object).getPrincipal().equalsIgnoreCase(ableSecureKey.getVan().getKerbPrincipal())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                object = AblePlatform.NlsMsg("VANS_RequestingPrincMustMatchNewVanPrinc", new Object[]{string, ableSecureKey.getVan().getKerbPrincipal()});
                this.myMsgLog.text(4L, (Object)this, string3, (String)object);
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.text(262144L, (Object)this, string3, (String)object);
                }
                throw new NamingException((String)object);
            }
        }
        VerifiableAgentName verifiableAgentName = this.createAgentName(publicKey, string, null, string2);
        if (this.myTrcLog.isLogging()) {
            this.myTrcLog.exit(0x100000L, (Object)this, string3 + " Created VAN using key with principal: " + ableSecureKey.getVan().getKerbPrincipal());
        }
        if (this.myTrcLog.isLogging()) {
            this.myTrcLog.exit(0x100000L, (Object)this, string3);
        }
        return verifiableAgentName;
    }

    public void releaseAgentName(AbleSecureKey ableSecureKey) throws RemoteException, NamingException {
        String string = "releaseAgentName";
        if (this.myTrcLog.isLogging()) {
            this.myTrcLog.entry(0x100000L, (Object)this, string);
        }
        if (!Able.Preferences.isSecure()) {
            String string2 = AblePlatform.NlsMsg("SecOn_PlatformMustBeSecure", new Object[]{this + "." + string + "()"});
            this.myMsgLog.text(4L, (Object)this, string, string2);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string2);
            }
            throw new NamingException(string2);
        }
        this.mySecSppt.verifyKey(ableSecureKey);
        if (this.myPrstSppt != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(this.myPrstSppt.getTableColumnNames()[0], ableSecureKey.getVan().getName());
            this.myPrstSppt.delete(hashMap);
        }
        this.lclVANs.remove(ableSecureKey.getVan().getName());
        this.vanConversations.remove(ableSecureKey.getVan().getName());
        this.myMsgLog.text(1L, (Object)this, string, AblePlatform.NlsMsg("VANS_ReleaseRequestComplete", new Object[]{ableSecureKey.getVan().getKerbPrincipal(), ableSecureKey.getVan().getName()}));
        if (this.myTrcLog.isLogging()) {
            this.myTrcLog.exit(0x100000L, (Object)this, string);
        }
    }

    public boolean isVerified(VerifiableAgentName verifiableAgentName, String string) {
        Object object;
        Object object2;
        String string2 = "isVerified";
        if (verifiableAgentName == null) {
            return false;
        }
        for (VerifiableAgentName verifiableAgentName2 = verifiableAgentName; verifiableAgentName2 != null; verifiableAgentName2 = verifiableAgentName2.getPreviousVan()) {
            object2 = (VerifiableAgentName)this.lclVANs.get(verifiableAgentName2.getName());
            if (object2 == null) {
                object = AblePlatform.NlsMsg("VANS_OriginalVanNotFound", new Object[]{verifiableAgentName2.getName()});
                this.myMsgLog.text(4L, (Object)this, string2, (String)object);
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.text(0x100000L, (Object)this, string2, (String)object);
                }
                return false;
            }
            object = new VerifiableAgentNameImpl(verifiableAgentName2);
            object.setPreviousVan(null);
            if (object2.equals(object) && object2.getPublicKey().equals(object.getPublicKey())) continue;
            String string3 = AblePlatform.NlsMsg("VANS_NotVerifiedMismatchParts");
            this.myMsgLog.text(4L, (Object)this, string2, string3);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(0x100000L, (Object)this, string2, string3);
                this.myTrcLog.text(0x100000L, (Object)this, string2, "vanToVerify = \n" + ((VerifiableAgentNameImpl)verifiableAgentName2).debugString());
                this.myTrcLog.text(0x100000L, (Object)this, string2, "origVan = \n" + ((VerifiableAgentNameImpl)object2).debugString());
            }
            return false;
        }
        if (string != null && string.length() > 0) {
            object2 = (String)this.expirationIDs.get(string);
            if (object2 == null || ((String)object2).length() <= 0) {
                object = AblePlatform.NlsMsg("VANS_ExistingExpirationIDNotFound", new Object[]{string});
                this.myMsgLog.text(4L, (Object)this, string2, (String)object);
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.text(0x100000L, (Object)this, string2, (String)object);
                }
                return false;
            }
            if (!((String)object2).equalsIgnoreCase(verifiableAgentName.getName())) {
                object = AblePlatform.NlsMsg("VANS_WrongVANUsingExpirationID", new Object[]{object2, string});
                this.myMsgLog.text(4L, (Object)this, string2, (String)object);
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.text(0x100000L, (Object)this, string2, (String)object);
                }
                return false;
            }
            this.expirationIDs.remove(string);
        }
        return true;
    }

    public String getExpirationID(VerifiableAgentName verifiableAgentName) throws RemoteException, NamingException {
        String string = "getExpirationID";
        if (!this.isVerified(verifiableAgentName, null)) {
            String string2 = AblePlatform.NlsMsg("VANS_BadVanInGetExpirationID", new Object[]{verifiableAgentName == null ? "null" : verifiableAgentName.getName()});
            this.myMsgLog.text(4L, (Object)this, string, string2);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string2);
            }
            throw new NamingException(string2);
        }
        String string3 = null;
        while (string3 == null || this.expirationIDs.containsKey(string3)) {
            string3 = new VMID().toString();
        }
        this.expirationIDs.put(string3, verifiableAgentName.getName());
        return string3;
    }

    private VerifiableAgentName createAgentName(PublicKey publicKey, String string, String string2, String string3) throws NamingException {
        String string4;
        String string5 = "createAgentName";
        if (string3 != null && this.lclVANs.get(string3) != null && !string.equalsIgnoreCase(string4 = ((VerifiableAgentName)this.lclVANs.get(string3)).getKerbPrincipal())) {
            String string6 = AblePlatform.NlsMsg("VANS_PrincipalMismatchInCreateVAN", new Object[]{string3, string, string4});
            this.myMsgLog.text(4L, (Object)this, string5, string6);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string5, string6);
            }
            throw new NamingException(string6);
        }
        if (string3 == null) {
            while (string3 == null || this.lclVANs.containsKey(string3)) {
                string3 = new VMID().toString();
            }
        }
        if ((string4 = AblePlatform.Preferences.trustLevelOfPrincipal(string)) == null) {
            String string7 = AblePlatform.NlsMsg("VANS_ErrorLookingUpPrincipalLevel", new Object[]{string});
            this.myMsgLog.text(4L, (Object)this, string5, string7);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string5, string7);
            }
            throw new NamingException(string7);
        }
        VerifiableAgentNameImpl verifiableAgentNameImpl = new VerifiableAgentNameImpl(string3, publicKey, this.bindingAddr, string, string4, null);
        if (this.myPrstSppt != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(this.myPrstSppt.getTableColumnNames()[0], string3);
            this.myPrstSppt.delete(hashMap);
            this.myPrstSppt.insert(new Serializable[]{verifiableAgentNameImpl.getName(), verifiableAgentNameImpl});
        }
        this.lclVANs.put(verifiableAgentNameImpl.getName(), verifiableAgentNameImpl);
        if (string2 != null) {
            this.vanConversations.put(verifiableAgentNameImpl.getName(), string2);
        }
        this.myMsgLog.text(1L, (Object)this, string5, AblePlatform.NlsMsg("VANS_CreateVANSuccessful", new Object[]{string3, string, string4}));
        return verifiableAgentNameImpl;
    }

    private byte[] serializeAndWrap(Object object, Serializable serializable) throws IOException, AbleException {
        if (Able.Preferences.isSecure()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            try {
                return ((GSSContext)object).wrap(byArray, 0, byArray.length, new MessageProp(true));
            }
            catch (Exception exception) {
                throw new AbleException(exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return null;
    }
}

