/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.platform;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.AbleLogger;
import com.ibm.able.platform.AblePlatform;
import com.ibm.able.platform.AblePlatformServiceEventListener;
import com.ibm.able.platform.AbleSecureKey;
import com.ibm.able.platform.RMIVerifiableNamingService;
import com.ibm.able.platform.VerifiableAgentName;
import com.ibm.able.platform.VerifiableAgentNamingService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.registry.Registry;
import java.security.PublicKey;
import java.util.Hashtable;
import java.util.Vector;
import javax.agent.AgentName;
import javax.agent.service.ServiceProperties;
import javax.agent.service.naming.NamingException;
import javax.agent.service.naming.NamingFailure;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class RMIVerifiableNamingProxy
implements VerifiableAgentNamingService,
Serializable {
    static final long serialVersionUID = 2003052100000000001L;
    private RMIVerifiableNamingService myDelegate;
    private transient Object manager;
    private final String ansPrincipal;
    private transient Hashtable establishedPrincipalConnections = null;
    private transient Hashtable savedContexts = null;
    private final AbleLogger logger = Able.MessageLog;
    private final AbleLogger trace = Able.TraceLog;
    private Object krb5Mech;
    private Registry myRegistry = null;
    private String myAddress = null;

    public RMIVerifiableNamingProxy(RMIVerifiableNamingService rMIVerifiableNamingService, String string, Registry registry, String string2) {
        if (rMIVerifiableNamingService == null) {
            throw new NullPointerException(AblePlatform.NlsMsg("PROXY_DelegateInConstructorIsNull", new Object[]{"RMIVerifiableNamingProxy"}));
        }
        if (Able.Preferences.isSecure() && (string == null || string.length() == 0)) {
            throw new IllegalArgumentException(AblePlatform.NlsMsg("VANS_PROXY_InvalidPrincipalInConstructor"));
        }
        this.establishedPrincipalConnections = new Hashtable();
        this.savedContexts = new Hashtable();
        this.myDelegate = rMIVerifiableNamingService;
        this.ansPrincipal = string;
        this.myRegistry = registry;
        this.myAddress = string2;
    }

    public AgentName createAgentName() throws NamingException, NamingFailure {
        try {
            return this.myDelegate.createInsecureName();
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                return this.myDelegate.createInsecureName();
            }
            catch (RemoteException remoteException2) {
                throw new NamingException(AblePlatform.NlsMsg("VANS_PROXY_ErrorCreatingVAN"), (Exception)remoteException2);
            }
        }
    }

    public VerifiableAgentName createAgentName(PublicKey publicKey, String string, String string2) throws NamingException {
        String string3 = "requestVanFromAns princ = " + string;
        if (this.trace.isLogging()) {
            this.trace.entry(0x100000L, (Object)this, string3);
        }
        if (string == null) {
            throw new NamingException(AblePlatform.NlsMsg("VANS_PROXY_InvalidPrincipalInCreateVAN"));
        }
        if (publicKey == null) {
            throw new NamingException(AblePlatform.NlsMsg("VANS_PROXY_InvalidPublicKeyInCreateVAN"));
        }
        try {
            GSSContext gSSContext = null;
            if (this.establishedPrincipalConnections == null || !this.establishedPrincipalConnections.containsKey(string)) {
                this.logger.text(1L, (Object)this, string3, AblePlatform.NlsMsg("VANS_PROXY_CreatingNewContext", new Object[]{string}));
                gSSContext = this.init(string);
            } else {
                this.logger.text(1L, (Object)this, string3, AblePlatform.NlsMsg("VANS_PROXY_ExistingContextWillBeUsed", new Object[]{string}));
                gSSContext = (GSSContext)this.savedContexts.get(this.establishedPrincipalConnections.get(string));
            }
            byte[] byArray = this.wrap(new Serializable[]{publicKey, string, string2}, gSSContext);
            String string4 = (String)this.establishedPrincipalConnections.get(string);
            if (this.trace.isLogging()) {
                this.trace.text(0x100000L, (Object)this, string3, "Attempting to create a VAN with convId = " + string4);
            }
            byte[] byArray2 = null;
            try {
                try {
                    byArray2 = this.myDelegate.pushAndPull(string4, byArray);
                }
                catch (RemoteException remoteException) {
                    this.refreshDelegate(remoteException);
                    byArray2 = this.myDelegate.pushAndPull(string4, byArray);
                }
            }
            catch (NamingFailure namingFailure) {
                ((GSSContext)this.savedContexts.remove(this.establishedPrincipalConnections.get(string))).dispose();
                this.establishedPrincipalConnections.remove(string);
                gSSContext = this.init(string);
                byArray = this.wrap(new Serializable[]{publicKey, string, string2}, gSSContext);
                string4 = (String)this.establishedPrincipalConnections.get(string);
                try {
                    byArray2 = this.myDelegate.pushAndPull(string4, byArray);
                }
                catch (RemoteException remoteException) {
                    this.refreshDelegate(remoteException);
                    byArray2 = this.myDelegate.pushAndPull(string4, byArray);
                }
            }
            if (this.trace.isLogging()) {
                this.trace.exit(0x100000L, (Object)this, string3);
            }
            return this.unwrapToAgentName(byArray2, gSSContext);
        }
        catch (RemoteException remoteException) {
            this.logger.text(4L, (Object)this, string3, remoteException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, string3, (Throwable)remoteException);
            }
            throw new NamingException(this + "." + string3 + "(): " + remoteException.getLocalizedMessage(), (Exception)remoteException);
        }
        catch (IOException iOException) {
            this.logger.text(4L, (Object)this, string3, iOException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, string3, (Throwable)iOException);
            }
            throw new NamingException(this + "." + string3 + "(): " + iOException.getLocalizedMessage(), (Exception)iOException);
        }
        catch (NamingFailure namingFailure) {
            this.logger.text(4L, (Object)this, string3, namingFailure.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, string3, (Throwable)namingFailure);
            }
            throw new NamingException(this + "." + string3 + "(): " + namingFailure.getLocalizedMessage(), (Exception)((Object)namingFailure));
        }
        catch (Exception exception) {
            this.logger.text(4L, (Object)this, string3, exception.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, string3, (Throwable)exception);
            }
            throw new NamingException(this + "." + string3 + "(): " + exception.getLocalizedMessage(), exception);
        }
    }

    public VerifiableAgentName createAgentName(PublicKey publicKey, String string, String string2, AbleSecureKey ableSecureKey) throws NamingException {
        if (string == null) {
            throw new NamingException(AblePlatform.NlsMsg("VANS_PROXY_InvalidPrincipalInCreateVAN"));
        }
        if (publicKey == null) {
            throw new NamingException(AblePlatform.NlsMsg("VANS_PROXY_InvalidPublicKeyInCreateVAN"));
        }
        try {
            return this.myDelegate.createAgentName(publicKey, string, string2, ableSecureKey);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                return this.myDelegate.createAgentName(publicKey, string, string2, ableSecureKey);
            }
            catch (RemoteException remoteException2) {
                throw new NamingException(AblePlatform.NlsMsg("VANS_PROXY_ErrorCreatingVAN"), (Exception)remoteException2);
            }
        }
    }

    public boolean isVerified(VerifiableAgentName verifiableAgentName) throws NamingException {
        try {
            return this.myDelegate.isVerified(verifiableAgentName, null);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                return this.myDelegate.isVerified(verifiableAgentName, null);
            }
            catch (RemoteException remoteException2) {
                throw new NamingException(AblePlatform.NlsMsg("VANS_PROXY_ErrorVerifyingVAN"), (Exception)remoteException2);
            }
        }
    }

    public boolean isVerified(VerifiableAgentName verifiableAgentName, String string) throws NamingException {
        if (string == null) {
            throw new NamingException(AblePlatform.NlsMsg("VANS_PROXY_ExpirationIDToVerifyIsNull"));
        }
        try {
            return this.myDelegate.isVerified(verifiableAgentName, string);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                return this.myDelegate.isVerified(verifiableAgentName, string);
            }
            catch (RemoteException remoteException2) {
                throw new NamingException(AblePlatform.NlsMsg("VANS_PROXY_ErrorVerifyingVAN"), (Exception)remoteException2);
            }
        }
    }

    public void releaseAgentName(AbleSecureKey ableSecureKey) throws NamingException {
        try {
            this.myDelegate.releaseAgentName(ableSecureKey);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                this.myDelegate.releaseAgentName(ableSecureKey);
            }
            catch (RemoteException remoteException2) {
                throw new NamingException(AblePlatform.NlsMsg("VANS_PROXY_ErrorReleasingVAN"), (Exception)remoteException2);
            }
        }
    }

    public String getExpirationID(VerifiableAgentName verifiableAgentName) throws NamingException {
        try {
            return this.myDelegate.getExpirationID(verifiableAgentName);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                return this.myDelegate.getExpirationID(verifiableAgentName);
            }
            catch (RemoteException remoteException2) {
                throw new NamingException(AblePlatform.NlsMsg("VANS_PROXY_ErrorGettingExpirationID", new Object[]{verifiableAgentName == null ? "null" : verifiableAgentName.getName()}), (Exception)remoteException2);
            }
        }
    }

    public void closeConversation(String string, AbleSecureKey ableSecureKey) throws NamingException {
        String string2 = "closeConversation";
        String string3 = (String)this.establishedPrincipalConnections.get(string);
        if (string3 == null) {
            if (this.trace.isLogging()) {
                this.trace.text(0x100000L, (Object)this, string2, "A context does not exist for principal " + string + ", the call to closeConversation will be aborted.");
            }
            return;
        }
        try {
            this.myDelegate.closeConversation(string3, ableSecureKey);
            this.establishedPrincipalConnections.remove(string);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                this.myDelegate.closeConversation(string3, ableSecureKey);
                this.establishedPrincipalConnections.remove(string);
            }
            catch (RemoteException remoteException2) {
                throw new NamingException(AblePlatform.NlsMsg("VANS_PROXY_ErrorClosingConversation", new Object[]{string}), (Exception)remoteException2);
            }
        }
    }

    public void terminateService(AbleSecureKey ableSecureKey) throws AbleException, NamingException {
        try {
            this.myDelegate.terminateService(ableSecureKey);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                this.myDelegate.terminateService(ableSecureKey);
            }
            catch (RemoteException remoteException2) {
                throw new AbleException(AblePlatform.NlsMsg("PROXY error terminating service."), (Throwable)remoteException2);
            }
        }
    }

    public int getState() throws AbleException {
        try {
            return this.myDelegate.getState();
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                return this.myDelegate.getState();
            }
            catch (RemoteException remoteException2) {
                throw new AbleException(AblePlatform.NlsMsg("PROXY error getting state of service."), (Throwable)remoteException2);
            }
        }
    }

    public ServiceProperties getServiceProperties() {
        return null;
    }

    public void setServiceProperties(ServiceProperties serviceProperties) {
    }

    public void addAblePlatformServiceEventListener(AblePlatformServiceEventListener ablePlatformServiceEventListener) throws AbleException {
        try {
            this.myDelegate.addAblePlatformServiceEventListener(ablePlatformServiceEventListener);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                this.myDelegate.addAblePlatformServiceEventListener(ablePlatformServiceEventListener);
            }
            catch (RemoteException remoteException2) {
                throw new AbleException(AblePlatform.NlsMsg("PROXY_ErrorAddingServiceEventListener"), (Throwable)remoteException2);
            }
        }
    }

    public void removeAblePlatformServiceEventListener(AblePlatformServiceEventListener ablePlatformServiceEventListener) throws AbleException {
        try {
            this.myDelegate.removeAblePlatformServiceEventListener(ablePlatformServiceEventListener);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                this.myDelegate.removeAblePlatformServiceEventListener(ablePlatformServiceEventListener);
            }
            catch (RemoteException remoteException2) {
                throw new AbleException(AblePlatform.NlsMsg("PROXY_ErrorRemovingServiceEventListener"), (Throwable)remoteException2);
            }
        }
    }

    public Vector getAblePlatformServiceEventListeners() throws AbleException {
        try {
            return this.myDelegate.getAblePlatformServiceEventListeners();
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                return this.myDelegate.getAblePlatformServiceEventListeners();
            }
            catch (RemoteException remoteException2) {
                throw new AbleException(AblePlatform.NlsMsg("PROXY_ErrorGettingServiceEventListener"), (Throwable)remoteException2);
            }
        }
    }

    private GSSContext init(String string) throws RemoteException, NamingException {
        String string2 = "init(" + string + ")";
        if (this.trace.isLogging()) {
            this.trace.entry(0x100000L, (Object)this, string2);
        }
        GSSContext gSSContext = null;
        if (this.establishedPrincipalConnections == null) {
            this.establishedPrincipalConnections = new Hashtable();
            this.savedContexts = new Hashtable();
        }
        try {
            String string3 = null;
            try {
                string3 = this.myDelegate.openConversation();
            }
            catch (RemoteException remoteException) {
                this.refreshDelegate(remoteException);
                string3 = this.myDelegate.openConversation();
            }
            this.manager = GSSManager.getInstance();
            this.krb5Mech = new Oid("1.2.840.113554.1.2.2");
            GSSName gSSName = ((GSSManager)this.manager).createName(string, GSSName.NT_USER_NAME);
            GSSCredential gSSCredential = ((GSSManager)this.manager).createCredential(gSSName, 0, (Oid)this.krb5Mech, 1);
            Oid oid = new Oid("1.2.840.113554.1.2.2.1");
            GSSName gSSName2 = ((GSSManager)this.manager).createName(this.ansPrincipal, oid);
            gSSContext = ((GSSManager)this.manager).createContext(gSSName2, (Oid)this.krb5Mech, gSSCredential, 0);
            byte[] byArray = new byte[]{};
            if (this.trace.isLogging()) {
                this.trace.text(0x100000L, (Object)this, string2, "Is the context established? " + gSSContext.isEstablished());
            }
            while (!gSSContext.isEstablished()) {
                if (this.trace.isLogging()) {
                    this.trace.text(0x100000L, (Object)this, string2, AblePlatform.NlsMsg("VANS_PROXY_ContextNotEstablished", new Object[]{string3}));
                }
                byte[] byArray2 = gSSContext.initSecContext(byArray, 0, byArray.length);
                if (this.trace.isLogging()) {
                    this.trace.text(0x100000L, (Object)this, string2, AblePlatform.NlsMsg("VANS_PROXY_AttemptingToSecureContext", new Object[]{string3, new Boolean(byArray2 == null)}));
                }
                if (byArray2 != null) {
                    try {
                        byArray = this.myDelegate.pushAndPull(string3, byArray2);
                    }
                    catch (RemoteException remoteException) {
                        this.refreshDelegate(remoteException);
                        byArray = this.myDelegate.pushAndPull(string3, byArray2);
                    }
                }
                this.establishedPrincipalConnections.put(string, string3);
                this.savedContexts.put(string3, gSSContext);
            }
        }
        catch (NamingException namingException) {
            throw new NamingException(namingException.getLocalizedMessage(), (Exception)((Object)namingException));
        }
        catch (NamingFailure namingFailure) {
            throw new NamingException(namingFailure.getLocalizedMessage(), (Exception)((Object)namingFailure));
        }
        catch (Exception exception) {
            String string4 = AblePlatform.NlsMsg("VANS_ErrorEstablishingSecureContext");
            this.logger.text(4L, (Object)this, string2, string4);
            this.logger.text(4L, (Object)this, string2, exception.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, string2, (Throwable)exception);
            }
            throw new NamingException(this + "." + string2 + "(): " + string4, exception);
        }
        if (this.trace.isLogging()) {
            this.trace.exit(0x100000L, (Object)this, string2);
        }
        return gSSContext;
    }

    private byte[] wrap(Serializable[] serializableArray, GSSContext gSSContext) throws IOException, AbleException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        for (int i = 0; i < serializableArray.length; ++i) {
            objectOutputStream.writeObject(serializableArray[i]);
        }
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        MessageProp messageProp = new MessageProp(true);
        try {
            return gSSContext.wrap(byArray, 0, byArray.length, messageProp);
        }
        catch (Exception exception) {
            throw new AbleException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private VerifiableAgentName unwrapToAgentName(byte[] byArray, GSSContext gSSContext) throws IOException, AbleException {
        String string = "unwrapToAgentName";
        MessageProp messageProp = new MessageProp(true);
        byte[] byArray2 = null;
        try {
            byArray2 = gSSContext.unwrap(byArray, 0, byArray.length, messageProp);
        }
        catch (Exception exception) {
            throw new AbleException(exception.getLocalizedMessage(), (Throwable)exception);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2, 0, byArray2.length);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        try {
            return (VerifiableAgentName)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.text(4L, (Object)this, string, classNotFoundException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, string, (Throwable)classNotFoundException);
            }
            throw new IllegalStateException(classNotFoundException.getLocalizedMessage());
        }
    }

    private void refreshDelegate(RemoteException remoteException) throws RemoteException {
        String string = "refreshDelegate";
        try {
            Throwable throwable = remoteException.detail;
            if (throwable instanceof ServerException) {
                throwable = ((ServerException)throwable).detail;
            }
            if (throwable instanceof AbleException) {
                throw remoteException;
            }
            this.myDelegate = this.myRegistry != null ? (RMIVerifiableNamingService)this.myRegistry.lookup(this.myAddress) : (RMIVerifiableNamingService)Naming.lookup(this.myAddress);
        }
        catch (NotBoundException notBoundException) {
            String string2 = AblePlatform.NlsMsg("PROXY_ErrorRefreshingDelegate");
            this.logger.text(4L, (Object)this, string, string2);
            this.logger.text(4L, (Object)this, string, notBoundException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, string, (Throwable)notBoundException);
            }
            throw new RemoteException(string2, notBoundException);
        }
        catch (MalformedURLException malformedURLException) {
            String string3 = AblePlatform.NlsMsg("PROXY_ErrorRefreshingDelegate");
            this.logger.text(4L, (Object)this, string, string3);
            this.logger.text(4L, (Object)this, string, malformedURLException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, string, (Throwable)malformedURLException);
            }
            throw new RemoteException(string3, malformedURLException);
        }
    }

    public String toString() {
        String string = "";
        String string2 = "";
        String string3 = this.getClass().getName();
        for (int i = 0; i < Able.IndentLevel; ++i) {
            string = string + " ";
        }
        Able.IndentLevel += 2;
        string2 = string2 + super.toString() + "\n";
        string2 = string2 + string + string3 + "------------------------------\n";
        string2 = string2 + string + "  Delegate   : \t" + this.myDelegate + "\n";
        string2 = string2 + string + "--End " + string3 + "------------------------------\n";
        Able.IndentLevel -= 2;
        return string2;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

