/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.platform;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.platform.AbleBasicService;
import com.ibm.able.platform.AblePersistenceSupport;
import com.ibm.able.platform.AblePersistenceSupportProcessor;
import com.ibm.able.platform.AblePlatform;
import com.ibm.able.platform.AblePlatformPreferences;
import com.ibm.able.platform.AblePlatformServiceEventListener;
import com.ibm.able.platform.AbleSecureKey;
import com.ibm.able.platform.RMIVerifiableDirectoryService;
import com.ibm.able.platform.VerifiableAgentDirectoryService;
import com.ibm.able.platform.VerifiableAgentName;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.agent.service.ServiceProperties;
import javax.agent.service.directory.AgentDescription;
import javax.agent.service.directory.AgentDirectoryService;
import javax.agent.service.directory.AlreadyRegisteredException;
import javax.agent.service.directory.DirectoryFailure;
import javax.agent.service.directory.NotRegisteredException;
import javax.agent.service.directory.SearchException;
import javax.agent.service.naming.NamingException;
import org.jagent.service.directory.BasicAgentDescription;
import org.jagent.service.directory.BasicDirectoryService;

public final class RMIVerifiableDirectorySystem
extends AbleBasicService
implements RMIVerifiableDirectoryService,
AblePersistenceSupportProcessor {
    private AgentDirectoryService ads;
    private AblePersistenceSupport myPrstSppt1;
    private AblePersistenceSupport myPrstSppt2;
    private boolean isPrstSppt1Done = false;
    private boolean isPrstSppt2Done = false;

    public RMIVerifiableDirectorySystem() throws Exception {
        this.ctorHelper();
    }

    public RMIVerifiableDirectorySystem(ServiceProperties serviceProperties) throws Exception {
        super(serviceProperties);
        this.ctorHelper();
        this.bindServiceToRegistry();
    }

    public String getBindingName() {
        return "agent-directory-service";
    }

    public void addAblePlatformServiceEventListener(AblePlatformServiceEventListener ablePlatformServiceEventListener) throws AbleException {
        super.addAblePlatformServiceEventListener(ablePlatformServiceEventListener);
        if (this.myPrstSppt2 != null) {
            this.myPrstSppt2.insert(new Serializable[]{(Serializable)((Object)ablePlatformServiceEventListener)});
        }
    }

    public void removeAblePlatformServiceEventListener(AblePlatformServiceEventListener ablePlatformServiceEventListener) throws AbleException {
        super.removeAblePlatformServiceEventListener(ablePlatformServiceEventListener);
        if (this.myPrstSppt2 != null) {
            HashMap<String, AblePlatformServiceEventListener> hashMap = new HashMap<String, AblePlatformServiceEventListener>();
            hashMap.put(this.myPrstSppt2.getTableColumnNames()[0], ablePlatformServiceEventListener);
            this.myPrstSppt2.delete(hashMap);
        }
    }

    public void terminateService(AbleSecureKey ableSecureKey) throws AbleException, NamingException {
        String string = "terminateService";
        if (Able.Preferences.isSecure()) {
            this.mySecSppt.verifyKey(ableSecureKey);
            this.mySecSppt.verifyTrustLevel(ableSecureKey, string);
        }
        if (this.myPrstSppt1 != null) {
            this.myPrstSppt1.quitAll();
            this.myPrstSppt2.quitAll();
        }
        AbleSecureKey ableSecureKey2 = Able.Preferences.isSecure() ? this.mySecSppt.generateKey(ableSecureKey) : null;
        super.terminateService(ableSecureKey2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshLocalFromPersistence(AblePersistenceSupport ablePersistenceSupport, Object[] objectArray) throws Exception {
        String string = "refreshLocalFromPersistence";
        if (ablePersistenceSupport == this.myPrstSppt1) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.getState() == 4) {
                    return;
                }
                Object[] objectArray2 = (Object[])objectArray[i];
                if (objectArray2[0] instanceof String && objectArray2[1] instanceof AgentDescription) {
                    try {
                        AgentDirectoryService agentDirectoryService = this.ads;
                        synchronized (agentDirectoryService) {
                            this.ads.register((AgentDescription)objectArray2[1]);
                        }
                        this.myMsgLog.text(1L, (Object)this, string, AblePlatform.NlsMsg("PPSO_SuccessfullyLoadedFromPersistence", new Object[]{"AgentDescription"}));
                        if (!this.myTrcLog.isLogging()) continue;
                        this.myTrcLog.text(0x100000L, (Object)this, string, objectArray2[0].toString());
                    }
                    catch (AlreadyRegisteredException alreadyRegisteredException) {}
                    continue;
                }
                this.myMsgLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("PPS_UnexpectedTypeFromPersistence", new Object[]{"javax.agent.service.directory.AgentDescription"}));
            }
            this.isPrstSppt1Done = true;
        } else if (ablePersistenceSupport == this.myPrstSppt2) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.getState() == 4) {
                    return;
                }
                Object[] objectArray3 = (Object[])objectArray[i];
                if (objectArray3[0] instanceof AblePlatformServiceEventListener) {
                    if (this.myServiceEventListeners.contains(objectArray3[0])) continue;
                    this.myServiceEventListeners.add(objectArray3[0]);
                    this.myMsgLog.text(1L, (Object)this, string, AblePlatform.NlsMsg("PPSO_SuccessfullyLoadedFromPersistence", new Object[]{"AblePlatformServiceEventListener"}));
                    continue;
                }
                this.myMsgLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("PPS_UnexpectedTypeFromPersistence", new Object[]{"com.ibm.able.platform.AblePlatformServiceEventListener"}));
            }
            this.isPrstSppt2Done = true;
        } else {
            String string2 = AblePlatform.NlsMsg("PPSO_CallerMustMatchLocalPersistenceSupport", null);
            this.myMsgLog.text(4L, (Object)this, string, string2);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string2);
            }
            throw new NamingException(string2);
        }
        if (this.isPrstSppt1Done && this.isPrstSppt2Done) {
            this.setState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(AgentDescription agentDescription, AbleSecureKey ableSecureKey) throws RemoteException, AlreadyRegisteredException, DirectoryFailure {
        String string = "register";
        if (agentDescription == null) {
            String string2 = "Unable to register null Agent Description";
            this.myMsgLog.text(4L, (Object)this, string, string2);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string2);
            }
            throw new DirectoryFailure(string2);
        }
        if (Able.Preferences.isSecure()) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
                if (agentDescription.getAgentName() instanceof VerifiableAgentName && !ableSecureKey.getVan().equals(agentDescription.getAgentName())) {
                    String string3 = AblePlatform.NlsMsg("VADS_MustBeSameVANAsInVerAgentDesc", new Object[]{string});
                    this.myMsgLog.text(4L, (Object)this, string, string3);
                    if (this.myTrcLog.isLogging()) {
                        this.myTrcLog.text(262144L, (Object)this, string, string3);
                    }
                    throw new DirectoryFailure(string3);
                }
            }
            catch (Exception exception) {
                String string4 = AblePlatform.NlsMsg("SecOn_UnableToVerifyKey", new Object[]{ableSecureKey == null ? "null" : ableSecureKey.getVan().getName(), ableSecureKey == null ? "null" : ableSecureKey.getExpriationID()});
                this.myMsgLog.text(4L, (Object)this, string, string4);
                this.myMsgLog.text(4L, (Object)this, string, exception.getLocalizedMessage());
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.exception(262144L, (Object)this, string, (Throwable)exception);
                }
                throw new DirectoryFailure(string4, exception);
            }
        }
        Object object = this.ads;
        synchronized (object) {
            this.ads.register(agentDescription);
        }
        if (this.myPrstSppt1 != null) {
            object = agentDescription.getAgentName().toString();
            this.myPrstSppt1.insert(new Serializable[]{object, (Serializable)agentDescription});
        }
        this.thenNotifyAblePlatformServiceEventListeners(this + ":" + string + "(): ", 101, AblePlatform.NlsMsg("VADS_registeredAgentDescription"), agentDescription, null, this.myPrstSppt2, this.myPrstSppt2 == null ? null : this.myPrstSppt2.getTableColumnNames()[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(AgentDescription agentDescription, AbleSecureKey ableSecureKey) throws RemoteException, NotRegisteredException, DirectoryFailure {
        String string = "deregister";
        if (agentDescription == null) {
            String string2 = "Unable to deregister null Agent Description";
            this.myMsgLog.text(4L, (Object)this, string, string2);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string2);
            }
            throw new DirectoryFailure(string2);
        }
        if (Able.Preferences.isSecure()) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
                if (agentDescription.getAgentName() instanceof VerifiableAgentName && !ableSecureKey.getVan().equals(agentDescription.getAgentName())) {
                    String string3 = AblePlatform.NlsMsg("VADS_MustBeSameVANAsInVerAgentDesc", new Object[]{string});
                    this.myMsgLog.text(4L, (Object)this, string, string3);
                    if (this.myTrcLog.isLogging()) {
                        this.myTrcLog.text(262144L, (Object)this, string, string3);
                    }
                    throw new DirectoryFailure(string3);
                }
            }
            catch (Exception exception) {
                String string4 = AblePlatform.NlsMsg("SecOn_UnableToVerifyKey", new Object[]{ableSecureKey == null ? "null" : ableSecureKey.getVan().getName(), ableSecureKey == null ? "null" : ableSecureKey.getExpriationID()});
                this.myMsgLog.text(4L, (Object)this, string, string4);
                this.myMsgLog.text(4L, (Object)this, string, exception.getLocalizedMessage());
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.exception(262144L, (Object)this, string, (Throwable)exception);
                }
                throw new DirectoryFailure(string4, exception);
            }
        }
        Object object = this.ads;
        synchronized (object) {
            this.ads.deregister(agentDescription);
        }
        if (this.myPrstSppt1 != null) {
            object = agentDescription.getAgentName().toString();
            HashMap<String, AgentDirectoryService> hashMap = new HashMap<String, AgentDirectoryService>();
            hashMap.put(this.myPrstSppt1.getTableColumnNames()[0], (AgentDirectoryService)object);
            this.myPrstSppt1.delete(hashMap);
        }
        this.thenNotifyAblePlatformServiceEventListeners(this + ":" + string + "(): ", 102, AblePlatform.NlsMsg("VADS_deregisteredAgentDescription"), agentDescription, null, this.myPrstSppt2, this.myPrstSppt2 == null ? null : this.myPrstSppt2.getTableColumnNames()[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(AgentDescription agentDescription, AbleSecureKey ableSecureKey) throws RemoteException, NotRegisteredException, DirectoryFailure {
        Object object;
        Object object2;
        String string = "modify";
        if (agentDescription == null) {
            String string2 = "Unable to modify null Agent Description";
            this.myMsgLog.text(4L, (Object)this, string, string2);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string2);
            }
            throw new DirectoryFailure(string2);
        }
        if (Able.Preferences.isSecure()) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
                if (agentDescription.getAgentName() instanceof VerifiableAgentName && !ableSecureKey.getVan().equals(agentDescription.getAgentName())) {
                    String string3 = AblePlatform.NlsMsg("VADS_MustBeSameVANAsInVerAgentDesc", new Object[]{string});
                    this.myMsgLog.text(4L, (Object)this, string, string3);
                    if (this.myTrcLog.isLogging()) {
                        this.myTrcLog.text(262144L, (Object)this, string, string3);
                    }
                    throw new DirectoryFailure(string3);
                }
            }
            catch (Exception exception) {
                String string4 = AblePlatform.NlsMsg("SecOn_UnableToVerifyKey", new Object[]{ableSecureKey == null ? "null" : ableSecureKey.getVan().getName(), ableSecureKey == null ? "null" : ableSecureKey.getExpriationID()});
                this.myMsgLog.text(4L, (Object)this, string, string4);
                this.myMsgLog.text(4L, (Object)this, string, exception.getLocalizedMessage());
                if (this.myTrcLog.isLogging()) {
                    this.myTrcLog.exception(262144L, (Object)this, string, (Throwable)exception);
                }
                throw new DirectoryFailure(string4, exception);
            }
        }
        AgentDescription agentDescription2 = this.ads.createAgentDescription();
        agentDescription2.setAgentName(agentDescription.getAgentName());
        if (this.myPrstSppt1 != null) {
            try {
                object2 = null;
                object = this.ads;
                synchronized (object) {
                    object2 = this.ads.search(agentDescription2);
                }
                if (((AgentDescription[])object2).length <= 0) {
                    throw new NotRegisteredException();
                }
                agentDescription2 = object2[0];
            }
            catch (SearchException searchException) {
                throw new NotRegisteredException(searchException.getLocalizedMessage());
            }
        }
        object2 = this.ads;
        synchronized (this.ads) {
            this.ads.modify(agentDescription);
            // ** MonitorExit[var5_9 /* !! */ ] (shouldn't be in output)
            if (this.myPrstSppt1 != null) {
                object2 = agentDescription.getAgentName().toString();
                object = new HashMap();
                object.put(this.myPrstSppt1.getTableColumnNames()[0], object2);
                object.put(this.myPrstSppt1.getTableColumnNames()[1], agentDescription);
                String string5 = agentDescription2.getAgentName().toString();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(this.myPrstSppt1.getTableColumnNames()[0], string5);
                this.myPrstSppt1.update((Map)object, hashMap);
            }
            this.thenNotifyAblePlatformServiceEventListeners(this + ":" + string + "(): ", 103, AblePlatform.NlsMsg("VADS_modifiedAgentDescription"), agentDescription, null, this.myPrstSppt2, this.myPrstSppt2 == null ? null : this.myPrstSppt2.getTableColumnNames()[0]);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(AgentDescription agentDescription) throws RemoteException, AlreadyRegisteredException, DirectoryFailure {
        String string = "register";
        if (agentDescription == null) {
            String string2 = "Unable to register null Agent Description";
            this.myMsgLog.text(4L, (Object)this, string, string2);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string2);
            }
            throw new DirectoryFailure(string2);
        }
        Object object = this.ads;
        synchronized (object) {
            this.ads.register(agentDescription);
        }
        if (this.myPrstSppt1 != null) {
            object = agentDescription.getAgentName().toString();
            this.myPrstSppt1.insert(new Serializable[]{object, (BasicAgentDescription)agentDescription});
        }
        this.thenNotifyAblePlatformServiceEventListeners(this + ":" + string + "(): ", 101, AblePlatform.NlsMsg("VADS_registeredAgentDescription"), agentDescription, null, this.myPrstSppt2, this.myPrstSppt2 == null ? null : this.myPrstSppt2.getTableColumnNames()[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(AgentDescription agentDescription) throws RemoteException, NotRegisteredException, DirectoryFailure {
        String string = "deregister";
        if (agentDescription == null) {
            String string2 = "Unable to deregister null Agent Description";
            this.myMsgLog.text(4L, (Object)this, string, string2);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string2);
            }
            throw new DirectoryFailure(string2);
        }
        if (this.affectsOnlyLegacy(agentDescription)) {
            Object object = this.ads;
            synchronized (object) {
                this.ads.deregister(agentDescription);
            }
            if (this.myPrstSppt1 != null) {
                object = agentDescription.getAgentName().toString();
                HashMap<String, AgentDirectoryService> hashMap = new HashMap<String, AgentDirectoryService>();
                hashMap.put(this.myPrstSppt1.getTableColumnNames()[0], (AgentDirectoryService)object);
                this.myPrstSppt1.delete(hashMap);
            }
            this.thenNotifyAblePlatformServiceEventListeners(this + ":" + string + "(): ", 102, AblePlatform.NlsMsg("VADS_deregisteredAgentDescription"), agentDescription, null, this.myPrstSppt2, this.myPrstSppt2 == null ? null : this.myPrstSppt2.getTableColumnNames()[0]);
            return;
        }
        String string3 = AblePlatform.NlsMsg("VADS_legacyDeregisterOnNonLegacy");
        this.myMsgLog.text(4L, (Object)this, string, string3);
        if (this.myTrcLog.isLogging()) {
            this.myTrcLog.text(262144L, (Object)this, string, string3);
        }
        throw new DirectoryFailure(this + "." + string + "(): " + AblePlatform.NlsMsg("VADS_legacyDeregisterOnNonLegacy"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(AgentDescription agentDescription) throws RemoteException, NotRegisteredException, DirectoryFailure {
        String string = "modify";
        if (agentDescription == null) {
            String string2 = "Unable to modify null Agent Description";
            this.myMsgLog.text(4L, (Object)this, string, string2);
            if (this.myTrcLog.isLogging()) {
                this.myTrcLog.text(262144L, (Object)this, string, string2);
            }
            throw new DirectoryFailure(string2);
        }
        if (this.affectsOnlyLegacy(agentDescription)) {
            Object object;
            Object object2;
            AgentDescription agentDescription2 = this.ads.createAgentDescription();
            agentDescription2.setAgentName(agentDescription.getAgentName());
            if (this.myPrstSppt1 != null) {
                try {
                    object2 = null;
                    object = this.ads;
                    synchronized (object) {
                        object2 = this.ads.search(agentDescription2);
                    }
                    if (((AgentDescription[])object2).length <= 0) {
                        throw new NotRegisteredException();
                    }
                    agentDescription2 = object2[0];
                }
                catch (SearchException searchException) {
                    throw new NotRegisteredException(searchException.getLocalizedMessage());
                }
            }
            object2 = this.ads;
            synchronized (this.ads) {
                this.ads.modify(agentDescription);
                // ** MonitorExit[var4_6 /* !! */ ] (shouldn't be in output)
                if (this.myPrstSppt1 != null) {
                    object2 = agentDescription.getAgentName().toString();
                    object = new HashMap();
                    object.put(this.myPrstSppt1.getTableColumnNames()[0], object2);
                    object.put(this.myPrstSppt1.getTableColumnNames()[1], agentDescription);
                    String string3 = agentDescription2.getAgentName().toString();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(this.myPrstSppt1.getTableColumnNames()[0], string3);
                    this.myPrstSppt1.update((Map)object, hashMap);
                }
                this.thenNotifyAblePlatformServiceEventListeners(this + ":" + string + "(): ", 103, AblePlatform.NlsMsg("VADS_modifiedAgentDescription"), agentDescription, null, this.myPrstSppt2, this.myPrstSppt2 == null ? null : this.myPrstSppt2.getTableColumnNames()[0]);
                return;
            }
        }
        String string4 = AblePlatform.NlsMsg("VADS_legacyModifyOnNonLegacy");
        this.myMsgLog.text(4L, (Object)this, string, string4);
        if (this.myTrcLog.isLogging()) {
            this.myTrcLog.text(262144L, (Object)this, string, string4);
        }
        throw new DirectoryFailure(string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentDescription[] search(AgentDescription agentDescription) throws RemoteException, SearchException, DirectoryFailure {
        AgentDirectoryService agentDirectoryService = this.ads;
        synchronized (agentDirectoryService) {
            return this.ads.search(agentDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentDescription[] search(AgentDescription agentDescription, int n) throws RemoteException, SearchException, DirectoryFailure {
        AgentDirectoryService agentDirectoryService = this.ads;
        synchronized (agentDirectoryService) {
            return this.ads.search(agentDescription, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentDescription createAgentDescription() throws RemoteException {
        AgentDirectoryService agentDirectoryService = this.ads;
        synchronized (agentDirectoryService) {
            return this.ads.createAgentDescription();
        }
    }

    private void ctorHelper() throws Exception {
        this.ads = new BasicDirectoryService();
        AblePlatformPreferences.ServiceEntry_ serviceEntry_ = AblePlatform.Preferences.getServiceEntry(this.getBindingName());
        if (serviceEntry_.getPersistenceFlag()) {
            String[] stringArray = VerifiableAgentDirectoryService.COLUMN_NAMES;
            String[] stringArray2 = VerifiableAgentDirectoryService.COLUMN_TYPES;
            this.myPrstSppt1 = new AblePersistenceSupport(serviceEntry_.getPersistenceDatabase(), serviceEntry_.getPersistenceTable(), serviceEntry_.getPersistenceSchema(), new String[]{stringArray[0], stringArray[1]}, new String[]{stringArray2[0], stringArray2[1]}, serviceEntry_.getPersistenceRetry(), this, this.mySecSppt);
            this.myPrstSppt2 = new AblePersistenceSupport(serviceEntry_.getPersistenceDatabase(), serviceEntry_.getPersistenceTable() + "ServiceEventListeners", serviceEntry_.getPersistenceSchema(), new String[]{stringArray[2]}, new String[]{stringArray2[2]}, serviceEntry_.getPersistenceRetry(), this, this.mySecSppt);
        }
        if (serviceEntry_.getPersistenceFlag()) {
            this.setState(3);
        } else {
            this.setState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean affectsOnlyLegacy(AgentDescription agentDescription) {
        try {
            AgentDescription agentDescription2 = this.ads.createAgentDescription();
            agentDescription2.setAgentName(agentDescription.getAgentName());
            AgentDescription[] agentDescriptionArray = null;
            AgentDirectoryService agentDirectoryService = this.ads;
            synchronized (agentDirectoryService) {
                agentDescriptionArray = this.ads.search(agentDescription2);
            }
            if (agentDescriptionArray != null) {
                for (int i = 0; i < agentDescriptionArray.length; ++i) {
                    if (!(agentDescriptionArray[i].getAgentName() instanceof VerifiableAgentName)) continue;
                    return false;
                }
            }
            return true;
        }
        catch (DirectoryFailure directoryFailure) {
            return false;
        }
        catch (SearchException searchException) {
            return false;
        }
    }
}

