/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.platform;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.platform.AblePlatform;
import com.ibm.able.platform.AblePlatformServiceEventListener;
import com.ibm.able.platform.AbleSecureKey;
import com.ibm.able.platform.RMIVerifiableDirectoryService;
import com.ibm.able.platform.VerifiableAgentDirectoryService;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.registry.Registry;
import java.util.Vector;
import javax.agent.service.ServiceProperties;
import javax.agent.service.directory.AgentDescription;
import javax.agent.service.directory.AlreadyRegisteredException;
import javax.agent.service.directory.DirectoryFailure;
import javax.agent.service.directory.NotRegisteredException;
import javax.agent.service.directory.SearchException;
import javax.agent.service.naming.NamingException;

public class RMIVerifiableDirectoryProxy
implements VerifiableAgentDirectoryService,
Serializable {
    static final long serialVersionUID = 2003052100000000001L;
    private RMIVerifiableDirectoryService myDelegate;
    private Registry myRegistry = null;
    private String myAddress = null;

    public RMIVerifiableDirectoryProxy(RMIVerifiableDirectoryService rMIVerifiableDirectoryService, Registry registry, String string) {
        if (rMIVerifiableDirectoryService == null) {
            throw new NullPointerException(AblePlatform.NlsMsg("PROXY_DelegateInConstructorIsNull", new Object[]{"RMIVerifiableDirectoryProxy"}));
        }
        this.myDelegate = rMIVerifiableDirectoryService;
        this.myRegistry = registry;
        this.myAddress = string;
    }

    public void register(AgentDescription agentDescription, AbleSecureKey ableSecureKey) throws AlreadyRegisteredException, DirectoryFailure {
        try {
            this.myDelegate.register(agentDescription, ableSecureKey);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                this.myDelegate.register(agentDescription, ableSecureKey);
            }
            catch (RemoteException remoteException2) {
                throw new DirectoryFailure(AblePlatform.NlsMsg("VADS_PROXY_ErrorRegisteringAgentDesc"), (Exception)remoteException2);
            }
        }
    }

    public void deregister(AgentDescription agentDescription, AbleSecureKey ableSecureKey) throws NotRegisteredException, DirectoryFailure {
        try {
            this.myDelegate.deregister(agentDescription, ableSecureKey);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                this.myDelegate.deregister(agentDescription, ableSecureKey);
            }
            catch (RemoteException remoteException2) {
                throw new DirectoryFailure(AblePlatform.NlsMsg("VADS_PROXY_ErrorDeregisteringAgentDesc"), (Exception)remoteException2);
            }
        }
    }

    public void modify(AgentDescription agentDescription, AbleSecureKey ableSecureKey) throws NotRegisteredException, DirectoryFailure {
        try {
            this.myDelegate.modify(agentDescription, ableSecureKey);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                this.myDelegate.modify(agentDescription, ableSecureKey);
            }
            catch (RemoteException remoteException2) {
                throw new DirectoryFailure(AblePlatform.NlsMsg("VADS_PROXY_ErrorModifyingAgentDesc"), (Exception)remoteException2);
            }
        }
    }

    public void register(AgentDescription agentDescription) throws AlreadyRegisteredException, DirectoryFailure {
        try {
            this.myDelegate.register(agentDescription);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                this.myDelegate.register(agentDescription);
            }
            catch (RemoteException remoteException2) {
                throw new DirectoryFailure(AblePlatform.NlsMsg("VADS_PROXY_ErrorRegisteringAgentDesc"), (Exception)remoteException2);
            }
        }
    }

    public void deregister(AgentDescription agentDescription) throws NotRegisteredException, DirectoryFailure {
        try {
            this.myDelegate.deregister(agentDescription);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                this.myDelegate.deregister(agentDescription);
            }
            catch (RemoteException remoteException2) {
                throw new DirectoryFailure(AblePlatform.NlsMsg("VADS_PROXY_ErrorDeregisteringAgentDesc"), (Exception)remoteException2);
            }
        }
    }

    public void modify(AgentDescription agentDescription) throws NotRegisteredException, DirectoryFailure {
        try {
            this.myDelegate.modify(agentDescription);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                this.myDelegate.modify(agentDescription);
            }
            catch (RemoteException remoteException2) {
                throw new DirectoryFailure(AblePlatform.NlsMsg("VADS_PROXY_ErrorModifyingAgentDesc"), (Exception)remoteException2);
            }
        }
    }

    public AgentDescription[] search(AgentDescription agentDescription) throws SearchException, DirectoryFailure {
        try {
            return this.myDelegate.search(agentDescription);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                return this.myDelegate.search(agentDescription);
            }
            catch (RemoteException remoteException2) {
                throw new DirectoryFailure(AblePlatform.NlsMsg("VADS_PROXY_ErrorSearchingForAgentDescs"), (Exception)remoteException2);
            }
        }
    }

    public AgentDescription[] search(AgentDescription agentDescription, int n) throws SearchException, DirectoryFailure {
        try {
            return this.myDelegate.search(agentDescription, n);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                return this.myDelegate.search(agentDescription, n);
            }
            catch (RemoteException remoteException2) {
                throw new DirectoryFailure(AblePlatform.NlsMsg("VADS_PROXY_ErrorSearchingForAgentDesc"), (Exception)remoteException2);
            }
        }
    }

    public AgentDescription createAgentDescription() {
        try {
            return this.myDelegate.createAgentDescription();
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                return this.myDelegate.createAgentDescription();
            }
            catch (RemoteException remoteException2) {
                return null;
            }
        }
    }

    public void terminateService(AbleSecureKey ableSecureKey) throws AbleException, NamingException {
        try {
            this.myDelegate.terminateService(ableSecureKey);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                this.myDelegate.terminateService(ableSecureKey);
            }
            catch (RemoteException remoteException2) {
                throw new AbleException(AblePlatform.NlsMsg("Ex_Prxy_CannotTerminateService", new Object[]{"VerifiableDirectoryService"}), (Throwable)remoteException2);
            }
        }
    }

    public int getState() throws AbleException {
        try {
            return this.myDelegate.getState();
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                return this.myDelegate.getState();
            }
            catch (RemoteException remoteException2) {
                throw new AbleException(AblePlatform.NlsMsg("Ex_Prxy_CannotGetStateOfService", new Object[]{"VerifiableDirectoryService"}), (Throwable)remoteException2);
            }
        }
    }

    public void addAblePlatformServiceEventListener(AblePlatformServiceEventListener ablePlatformServiceEventListener) throws AbleException {
        try {
            this.myDelegate.addAblePlatformServiceEventListener(ablePlatformServiceEventListener);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                this.myDelegate.addAblePlatformServiceEventListener(ablePlatformServiceEventListener);
            }
            catch (RemoteException remoteException2) {
                throw new AbleException(AblePlatform.NlsMsg("PROXY_ErrorAddingServiceEventListener"), (Throwable)remoteException2);
            }
        }
    }

    public void removeAblePlatformServiceEventListener(AblePlatformServiceEventListener ablePlatformServiceEventListener) throws AbleException {
        try {
            this.myDelegate.removeAblePlatformServiceEventListener(ablePlatformServiceEventListener);
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                this.myDelegate.removeAblePlatformServiceEventListener(ablePlatformServiceEventListener);
            }
            catch (RemoteException remoteException2) {
                throw new AbleException(AblePlatform.NlsMsg("PROXY_ErrorRemovingServiceEventListener"), (Throwable)remoteException2);
            }
        }
    }

    public Vector getAblePlatformServiceEventListeners() throws AbleException {
        try {
            return this.myDelegate.getAblePlatformServiceEventListeners();
        }
        catch (RemoteException remoteException) {
            try {
                this.refreshDelegate(remoteException);
                return this.myDelegate.getAblePlatformServiceEventListeners();
            }
            catch (RemoteException remoteException2) {
                throw new AbleException(AblePlatform.NlsMsg("PROXY_ErrorGettingServiceEventListener"), (Throwable)remoteException2);
            }
        }
    }

    public ServiceProperties getServiceProperties() {
        return null;
    }

    public void setServiceProperties(ServiceProperties serviceProperties) {
    }

    private void refreshDelegate(RemoteException remoteException) throws RemoteException {
        String string = "refreshDelegate";
        try {
            Throwable throwable = remoteException.detail;
            if (throwable instanceof ServerException) {
                throwable = ((ServerException)throwable).detail;
            }
            if (throwable instanceof AbleException) {
                throw remoteException;
            }
            this.myDelegate = this.myRegistry != null ? (RMIVerifiableDirectoryService)this.myRegistry.lookup(this.myAddress) : (RMIVerifiableDirectoryService)Naming.lookup(this.myAddress);
        }
        catch (NotBoundException notBoundException) {
            String string2 = AblePlatform.NlsMsg("PROXY_ErrorRefreshingDelegate");
            Able.MessageLog.text(4L, (Object)this, string, string2);
            Able.MessageLog.text(4L, (Object)this, string, notBoundException.getLocalizedMessage());
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.exception(262144L, (Object)this, string, (Throwable)notBoundException);
            }
            throw new RemoteException(string2, notBoundException);
        }
        catch (MalformedURLException malformedURLException) {
            String string3 = AblePlatform.NlsMsg("PROXY_ErrorRefreshingDelegate");
            Able.MessageLog.text(4L, (Object)this, string, string3);
            Able.MessageLog.text(4L, (Object)this, string, malformedURLException.getLocalizedMessage());
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.exception(262144L, (Object)this, string, (Throwable)malformedURLException);
            }
            throw new RemoteException(string3, malformedURLException);
        }
    }

    public String toString() {
        String string = "";
        String string2 = "";
        String string3 = this.getClass().getName();
        for (int i = 0; i < Able.IndentLevel; ++i) {
            string = string + " ";
        }
        Able.IndentLevel += 2;
        string2 = string2 + super.toString() + "\n";
        string2 = string2 + string + string3 + "------------------------------\n";
        string2 = string2 + string + "  Delegate   : \t" + this.myDelegate + "\n";
        string2 = string2 + string + "--End " + string3 + "------------------------------\n";
        Able.IndentLevel -= 2;
        return string2;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

