/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.platform;

import com.ibm.able.Able;
import com.ibm.able.platform.AblePlatform;
import com.ibm.able.platform.RMIVerifiableNamingProxy;
import com.ibm.able.platform.VerifiableAgentName;
import com.ibm.able.platform.VerifiableAgentNameImpl;
import com.ibm.able.platform.VerifiableAgentNamingService;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignedObject;
import javax.agent.service.naming.NamingException;

public final class AbleSecureKey
implements Serializable {
    static final long serialVersionUID = 2003052100000000001L;
    private final VerifiableAgentName van;
    private transient VerifiableAgentNamingService ans;
    private SignedObject signedVanAndExpID = null;
    private transient Signature signingEngine = null;
    private String algorithm = null;
    private String provider = null;
    private String expirationID = null;

    public AbleSecureKey(VerifiableAgentName verifiableAgentName, String string, PrivateKey privateKey) throws NamingException {
        if (verifiableAgentName == null) {
            throw new NamingException(AblePlatform.NlsMsg("SecOn_VanMustNotBeNull"));
        }
        this.van = verifiableAgentName;
        if (string == null) {
            throw new NamingException(AblePlatform.NlsMsg("SecOn_ExpirationIDIsInvalid"));
        }
        this.expirationID = string;
        this.signVanAndID(privateKey);
    }

    public AbleSecureKey(VerifiableAgentName verifiableAgentName, String string, PrivateKey privateKey, String string2, String string3) throws NamingException {
        if (verifiableAgentName == null) {
            throw new NamingException(AblePlatform.NlsMsg("SecOn_VanMustNotBeNull"));
        }
        this.van = verifiableAgentName;
        if (string == null) {
            throw new NamingException(AblePlatform.NlsMsg("SecOn_ExpirationIDIsInvalid"));
        }
        this.expirationID = string;
        this.algorithm = string2;
        this.provider = string3;
        this.signVanAndID(privateKey);
    }

    public VerifiableAgentName getVan() {
        return this.van;
    }

    public String getExpriationID() {
        return this.expirationID;
    }

    private void createSignature() throws NamingException {
        String string = "createSignature";
        if (this.algorithm == null && this.provider == null) {
            this.algorithm = AblePlatform.Preferences.getCryptographyAlgorithm();
            this.provider = AblePlatform.Preferences.getCryptographyProvider();
        }
        try {
            this.signingEngine = this.provider != null && this.provider.length() > 0 ? Signature.getInstance(this.algorithm, this.provider) : Signature.getInstance(this.algorithm);
        }
        catch (Exception exception) {
            String string2 = AblePlatform.NlsMsg("SecOn_ErrorCreatingSignature");
            Able.MessageLog.text(4L, (Object)this, string, string2);
            Able.MessageLog.text(4L, (Object)this, string, exception.getLocalizedMessage());
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.exception(262144L, (Object)this, string, (Throwable)exception);
            }
            throw new NamingException(this + "." + string + "(): " + string2, exception);
        }
    }

    private void signVanAndID(PrivateKey privateKey) throws NamingException {
        String string = "signVanAndID";
        if (this.signingEngine == null) {
            this.createSignature();
        }
        try {
            this.signedVanAndExpID = new SignedObject((Serializable)new Serializable[]{(VerifiableAgentNameImpl)this.van, this.expirationID}, privateKey, this.signingEngine);
        }
        catch (Exception exception) {
            String string2 = AblePlatform.NlsMsg("SecOn_ErrorSigning");
            Able.MessageLog.text(4L, (Object)this, string, string2);
            Able.MessageLog.text(4L, (Object)this, string, exception.getLocalizedMessage());
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.exception(262144L, (Object)this, string, (Throwable)exception);
            }
            throw new NamingException(this + "." + string + "(): " + string2, exception);
        }
    }

    public void verifyKey(VerifiableAgentNamingService verifiableAgentNamingService) throws NamingException {
        String string = "verifyKey";
        if (verifiableAgentNamingService != null) {
            this.ans = verifiableAgentNamingService;
        }
        if (this.signingEngine == null) {
            this.createSignature();
        }
        try {
            if (!this.signedVanAndExpID.verify(this.van.getPublicKey(), this.signingEngine)) {
                throw new NamingException("Platform security is on: unable to verify the signed VAN and expirationID in the AbleSecureKey with a VerifiableAgentName of " + this.van.getName());
            }
            Serializable[] serializableArray = (Serializable[])this.signedVanAndExpID.getObject();
            VerifiableAgentNameImpl verifiableAgentNameImpl = (VerifiableAgentNameImpl)serializableArray[0];
            this.expirationID = (String)((Object)serializableArray[1]);
            if (this.expirationID == null || this.expirationID.length() <= 0) {
                throw new NamingException(AblePlatform.NlsMsg("SecOn_ExpirationIDInvalid", new Object[]{this.van.getName()}));
            }
            if (verifiableAgentNamingService == null) {
                verifiableAgentNamingService = (RMIVerifiableNamingProxy)AblePlatform.getServiceRoot(null).getAgentNamingService();
            }
            if (!verifiableAgentNamingService.isVerified(this.van, this.expirationID)) {
                throw new NamingException(AblePlatform.NlsMsg("SecOn_UnableToVerifyKey", new Object[]{this.van.getName(), this.expirationID}));
            }
            if (!verifiableAgentNameImpl.equals(this.van)) {
                throw new NamingException(AblePlatform.NlsMsg("SecOn_SignedVANDoesNotMatchVisibleVAN", new Object[]{verifiableAgentNameImpl.getName(), this.van.getName()}));
            }
        }
        catch (Exception exception) {
            if (exception instanceof NamingException) {
                throw (NamingException)((Object)exception);
            }
            String string2 = AblePlatform.NlsMsg("SecOn_ErrorUnsigningVAN");
            Able.MessageLog.text(4L, (Object)this, string, string2);
            Able.MessageLog.text(4L, (Object)this, string, exception.getLocalizedMessage());
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.exception(262144L, (Object)this, string, (Throwable)exception);
            }
            throw new NamingException(this + "." + string + "(): " + string2, exception);
        }
    }
}

