/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.platform;

import com.ibm.able.Able;
import com.ibm.able.AbleLogger;
import com.ibm.able.platform.AblePlatform;
import com.ibm.able.platform.AblePlatformDefaultAgent;
import com.ibm.able.platform.AblePlatformPreferences;
import com.ibm.able.platform.AblePlatformService;
import com.ibm.able.platform.AblePlatformSupport;
import com.ibm.able.platform.AbleSecureKey;
import com.ibm.able.platform.AbleSecuritySupport;
import com.ibm.able.platform.VerifiableAgentName;
import com.ibm.able.platform.VerifiableAgentNamingService;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.security.KeyPair;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.agent.service.Service;
import javax.agent.service.ServiceException;
import javax.agent.service.ServiceProperties;
import javax.agent.service.ServiceRoot;
import javax.agent.service.naming.NamingException;
import javax.agent.service.naming.NamingFailure;
import org.jagent.service.ServicePropertiesImpl;
import org.jagent.service.spi.ServiceManager;

public final class AblePlatformSupportImpl
extends UnicastRemoteObject
implements AblePlatformSupport,
Serializable {
    static final long serialVersionUID = 2002020800000000001L;
    private static String lclC = "com.ibm.able.platform.AblePlatformSupportImpl";
    private static Hashtable myKnownAblePlatformSupports = new Hashtable();
    private static VerifiableAgentName myVerifiableAgentName = null;
    private static String myTrustLevel = "";
    private static KeyPair myKeyPair = null;
    private static VerifiableAgentNamingService myVerifiableAgentNamingService = null;
    private static AbleSecuritySupport mySecSppt = null;
    private static AbleLogger myMsgLog = Able.MessageLog;
    private static AbleLogger myTrcLog = Able.TraceLog;
    Registry myRegistry = null;
    String mySupportObjectName = null;
    String myAgentPoolAlias = null;
    String myIpName = null;
    String myPort = null;

    public static AblePlatformSupport getAblePlatformSupportOn(String string, String string2) throws RemoteException {
        String string3 = "getAblePlatformSupportOn";
        String string4 = string + ":" + string2;
        AblePlatformSupport ablePlatformSupport = null;
        if (myKnownAblePlatformSupports.containsKey(string4)) {
            ablePlatformSupport = (AblePlatformSupport)myKnownAblePlatformSupports.get(string4);
            try {
                ablePlatformSupport.getPlatformName();
                return ablePlatformSupport;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        try {
            String string5 = "rmi://" + string4 + "/" + "AblePlatformSupport";
            if (myTrcLog.isLogging()) {
                myTrcLog.text(0x100000L, (Object)lclC, string3, "\nLooking for <" + string5 + ">\n");
            }
            int n = Integer.parseInt(string2);
            if (myTrcLog.isLogging()) {
                myTrcLog.text(0x100000L, (Object)lclC, string3, "\nLooking for port <" + n + ">\n");
            }
            Registry registry = LocateRegistry.getRegistry(string, n);
            if (myTrcLog.isLogging()) {
                myTrcLog.text(0x100000L, (Object)lclC, string3, "\nRegistry is <" + registry + ">\n");
            }
            if (myTrcLog.isLogging()) {
                String[] stringArray = registry.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    myTrcLog.text(0x100000L, (Object)lclC, string3, "Reg entry <" + i + "> is <" + stringArray[i] + ">.");
                }
            }
            ablePlatformSupport = (AblePlatformSupport)registry.lookup(string5);
            myKnownAblePlatformSupports.put(string4, ablePlatformSupport);
        }
        catch (Exception exception) {
            myMsgLog.text(4L, (Object)lclC, string3, exception.getLocalizedMessage());
            if (myTrcLog.isLogging()) {
                myTrcLog.exception(262144L, (Object)lclC, string3, (Throwable)exception);
            }
            throw new RemoteException(exception.toString());
        }
        return ablePlatformSupport;
    }

    public static Object getObjectOn(String string, String string2, String string3, Object[] objectArray, AbleSecureKey ableSecureKey) throws RemoteException, NamingException {
        String string4 = "getObjectOn";
        Object object = null;
        AblePlatformSupport ablePlatformSupport = AblePlatformSupportImpl.getAblePlatformSupportOn(string, string2);
        object = ablePlatformSupport.getPlatformSecurity() ? ablePlatformSupport.getNewObject(string, string2, string3, objectArray, ableSecureKey) : ablePlatformSupport.getNewObject(string3, objectArray, ableSecureKey);
        return object;
    }

    private AblePlatformSupportImpl(Registry registry, String string, String string2, String string3, String string4) throws RemoteException {
        this.ctorHelper(registry, string, string2, string3, string4);
    }

    private AblePlatformSupportImpl(Registry registry, String string, String string2, String string3, String string4, RMISocketFactory rMISocketFactory, RMISocketFactory rMISocketFactory2) throws RemoteException {
        super(0, rMISocketFactory, rMISocketFactory2);
        this.ctorHelper(registry, string, string2, string3, string4);
    }

    private void ctorHelper(Registry registry, String string, String string2, String string3, String string4) {
        String string5 = "AblePlatformSupportImpl";
        this.myRegistry = registry;
        this.mySupportObjectName = string;
        this.myAgentPoolAlias = string2;
        this.myIpName = string3;
        this.myPort = string4;
    }

    public Object getNewObject(String string, AbleSecureKey ableSecureKey) throws RemoteException, NamingException {
        String string2 = "getNewObject(String,AbleSecureKey)";
        if (this.getPlatformSecurity()) {
            mySecSppt.verifyKey(ableSecureKey);
            mySecSppt.verifyTrustLevel(ableSecureKey, string2);
        }
        return this.loadAndInstantiateClass(string, null, ableSecureKey);
    }

    public Object getNewObject(String string, Object[] objectArray, AbleSecureKey ableSecureKey) throws RemoteException, NamingException {
        String string2 = "getNewObject(String,Object[],AbleSecureKey)";
        if (this.getPlatformSecurity()) {
            mySecSppt.verifyKey(ableSecureKey);
            mySecSppt.verifyTrustLevel(ableSecureKey, string2);
        }
        return this.loadAndInstantiateClass(string, objectArray, ableSecureKey);
    }

    public Object getNewObject(String string, String string2, String string3, Object[] objectArray, AbleSecureKey ableSecureKey) throws RemoteException, NamingException {
        String string4 = "getNewObject(String,String,String,Object[],AbleSecureKey)";
        if (this.getPlatformSecurity()) {
            mySecSppt.verifyKey(ableSecureKey);
            mySecSppt.verifyTrustLevel(ableSecureKey, string4);
        }
        return this.loadAndInstantiateClass(string3, objectArray, ableSecureKey);
    }

    public String getPlatformCryptographyAlgorithm() throws RemoteException {
        return AblePlatform.getPlatformCryptographyAlgorithm();
    }

    public String getPlatformCryptographyProvider() throws RemoteException {
        return AblePlatform.getPlatformCryptographyProvider();
    }

    public String getPlatformName() throws RemoteException {
        return AblePlatform.getPlatformName();
    }

    public boolean getPlatformSecurity() throws RemoteException {
        return Able.Preferences.getSecurity();
    }

    public Service getPlatformService(String string, String string2) throws RemoteException {
        return AblePlatform.getService(string, string2);
    }

    public ServiceRoot getPlatformServiceRoot(String string) throws RemoteException {
        return AblePlatform.getServiceRoot(string);
    }

    public Hashtable getPlatformAgentPools() throws RemoteException {
        return (Hashtable)AblePlatform.Preferences.getAgentPools().clone();
    }

    public void terminatePlatformSupport(AbleSecureKey ableSecureKey) throws RemoteException, NamingException {
        boolean bl;
        String string;
        block25: {
            string = "terminatePlatformSupport";
            bl = false;
            if (myTrcLog.isLogging()) {
                myTrcLog.text(262144L, (Object)this, string, "Terminating PlatformSupport object.");
            }
            if (this.getPlatformSecurity()) {
                mySecSppt.verifyKey(ableSecureKey);
                if (mySecSppt.lowerTrustLevelLogged(ableSecureKey, string)) {
                    return;
                }
            }
            AblePlatformService ablePlatformService = null;
            AblePlatformService ablePlatformService2 = null;
            Vector vector = AblePlatform.Preferences.configuredServices(this.myAgentPoolAlias);
            if (myTrcLog.isLogging()) {
                myTrcLog.text(262144L, (Object)this, string, "There are <" + vector.size() + "> services in this agent pool.");
            }
            for (int i = 0; i < vector.size(); ++i) {
                AblePlatformPreferences.ServiceEntry_ serviceEntry_ = (AblePlatformPreferences.ServiceEntry_)vector.elementAt(i);
                String string2 = serviceEntry_.getServiceType();
                Service service = AblePlatform.getService(this.myPort, string2);
                if (string2.equalsIgnoreCase("agent-life-cycle-service")) {
                    if (myTrcLog.isLogging()) {
                        myTrcLog.text(262144L, (Object)this, string, "Caching " + string2 + " service reference <" + service + ">.");
                    }
                    ablePlatformService = (AblePlatformService)service;
                    continue;
                }
                if (string2.equalsIgnoreCase("agent-naming-service")) {
                    if (myTrcLog.isLogging()) {
                        myTrcLog.text(262144L, (Object)this, string, "Caching " + string2 + " service reference <" + service + ">.");
                    }
                    ablePlatformService2 = (AblePlatformService)service;
                    continue;
                }
                if (service instanceof AblePlatformService) {
                    if (myTrcLog.isLogging()) {
                        myTrcLog.text(262144L, (Object)this, string, "Terminating nonessential service <" + string2 + ">; reference <" + service + ">.");
                    }
                    ((AblePlatformService)service).terminateService(this.getPlatformSecurity() ? mySecSppt.generateKey(ableSecureKey) : null);
                    continue;
                }
                if (!myTrcLog.isLogging()) continue;
                myTrcLog.text(262144L, (Object)this, string, "Would shutdown nonessential service <" + string2 + ">; reference <" + service + ">, but JAS gives no way to do it!");
            }
            if (ablePlatformService != null) {
                if (myTrcLog.isLogging()) {
                    myTrcLog.text(262144L, (Object)this, string, "Terminating ALS service <" + ablePlatformService + ">.");
                }
                ablePlatformService.terminateService(this.getPlatformSecurity() ? mySecSppt.generateKey(ableSecureKey) : null);
            }
            if (ablePlatformService2 != null) {
                if (myTrcLog.isLogging()) {
                    myTrcLog.text(262144L, (Object)this, string, "Terminating ANS service <" + ablePlatformService2 + ">.");
                }
                ablePlatformService2.terminateService(this.getPlatformSecurity() ? mySecSppt.generateKey(ableSecureKey) : null);
            }
            try {
                if (myTrcLog.isLogging()) {
                    myTrcLog.text(262144L, (Object)this, string, "Unbinding from RMI.");
                }
                this.myRegistry.unbind(this.mySupportObjectName);
                myMsgLog.text(1L, (Object)this, string, AblePlatform.NlsMsg("PlatSupport_UnboundFromRmi", new Object[]{this.mySupportObjectName}));
            }
            catch (AccessException accessException) {
                bl = true;
                myMsgLog.text(1L, (Object)this, string, AblePlatform.NlsMsg("PlatSupport_CannotUnbind"));
                myMsgLog.text(1L, (Object)this, string, accessException.getLocalizedMessage());
                if (myTrcLog.isLogging()) {
                    myTrcLog.exception(262144L, (Object)this, string, (Throwable)accessException);
                }
            }
            catch (RemoteException remoteException) {
                bl = true;
                myMsgLog.text(1L, (Object)this, string, AblePlatform.NlsMsg("PlatSupport_CannotUnbind"));
                myMsgLog.text(1L, (Object)this, string, remoteException.getLocalizedMessage());
                if (myTrcLog.isLogging()) {
                    myTrcLog.exception(262144L, (Object)this, string, (Throwable)remoteException);
                }
            }
            catch (NotBoundException notBoundException) {
                bl = true;
                myMsgLog.text(1L, (Object)this, string, AblePlatform.NlsMsg("PlatSupport_CannotUnbind"));
                myMsgLog.text(1L, (Object)this, string, notBoundException.getLocalizedMessage());
                if (!myTrcLog.isLogging()) break block25;
                myTrcLog.exception(262144L, (Object)this, string, (Throwable)notBoundException);
            }
        }
        if (myTrcLog.isLogging()) {
            myTrcLog.text(262144L, (Object)this, string, "Exiting the VM.");
        }
        if (bl) {
            System.exit(255);
        } else {
            System.exit(0);
        }
    }

    public void refreshPreferences(AbleSecureKey ableSecureKey) throws RemoteException, NamingException {
        String string = "refreshPreferences()";
        if (myTrcLog.isLogging()) {
            myTrcLog.text(262144L, (Object)this, string, "Refreshing platform preferences in agent pool.");
        }
        if (this.getPlatformSecurity()) {
            mySecSppt.verifyKey(ableSecureKey);
            if (mySecSppt.lowerTrustLevelLogged(ableSecureKey, string)) {
                return;
            }
        }
        AblePlatform.Preferences.readPropertiesFile();
    }

    public void refreshPreferences(AblePlatformPreferences ablePlatformPreferences, AbleSecureKey ableSecureKey) throws RemoteException, NamingException {
        String string = "refreshPreferences(AblePlatformPreferences)";
        if (myTrcLog.isLogging()) {
            myTrcLog.text(262144L, (Object)this, string, "Refreshing platform preferences in agent pool.");
        }
        if (this.getPlatformSecurity()) {
            mySecSppt.verifyKey(ableSecureKey);
            if (mySecSppt.lowerTrustLevelLogged(ableSecureKey, string)) {
                return;
            }
        }
        AblePlatform.Preferences.updatePreferenceVariables(ablePlatformPreferences);
    }

    public void refreshPreferences(String string, AbleSecureKey ableSecureKey) throws RemoteException, NamingException {
        String string2 = "refreshPreferences(String)";
        if (myTrcLog.isLogging()) {
            myTrcLog.text(262144L, (Object)this, string2, "Refreshing platform preferences in agent pool.");
        }
        if (this.getPlatformSecurity()) {
            mySecSppt.verifyKey(ableSecureKey);
            if (mySecSppt.lowerTrustLevelLogged(ableSecureKey, string2)) {
                return;
            }
        }
        AblePlatformPreferences ablePlatformPreferences = new AblePlatformPreferences(string);
        AblePlatform.Preferences.updatePreferenceVariables(ablePlatformPreferences);
    }

    public AblePlatformPreferences getPlatformPreferences(AbleSecureKey ableSecureKey) throws RemoteException {
        String string = "getPlatformPreferences()";
        if (myTrcLog.isLogging()) {
            myTrcLog.text(262144L, (Object)this, string, "Returning platform preferences.");
        }
        if (this.getPlatformSecurity()) {
            try {
                mySecSppt.verifyKey(ableSecureKey);
                if (mySecSppt.lowerTrustLevelLogged(ableSecureKey, string)) {
                    return null;
                }
            }
            catch (NamingException namingException) {
                return null;
            }
        }
        return AblePlatform.Preferences;
    }

    /*
     * Unable to fully structure code
     */
    private Object loadAndInstantiateClass(String var1_1, Object[] var2_2, AbleSecureKey var3_3) throws RemoteException, NamingException {
        var4_4 = "loadAndInstantiateClass";
        var5_5 = null;
        var6_6 = null;
        var7_7 = null;
        if (AblePlatformSupportImpl.myTrcLog.isLogging()) {
            this.logTrace(AblePlatform.NlsMsg("Tr_LoadAndInstantiateEnter", new Object[]{var1_1}));
        }
        try {
            var5_5 = Class.forName(var1_1);
        }
        catch (ClassNotFoundException var8_8) {
            this.logException(var4_4, var8_8);
            this.logTrace(AblePlatform.NlsMsg("Tr_LoadAndInstantiateExitError", new Object[]{"ClassNotFoundException", var1_1}));
            throw new RemoteException(AblePlatform.NlsMsg("Ex_ClassNotFound", new Object[]{var1_1}), var8_8);
        }
        if (var2_2 == null) {
            try {
                var6_6 = var5_5.newInstance();
                if (!this.getPlatformSecurity() || !(var6_6 instanceof AblePlatformDefaultAgent)) ** GOTO lbl62
                var8_9 = AblePlatform.Preferences.principalOfLocalAgentPool();
                var9_13 = var3_3.getVan().getVanOfInitiator();
                ((AblePlatformDefaultAgent)var6_6).setRequestKey(AblePlatformSupportImpl.mySecSppt.generateKey());
                ((AblePlatformDefaultAgent)var6_6).setPrincipal(var9_13.getKerbPrincipal());
            }
            catch (InstantiationException var8_10) {
                this.logException(var4_4, var8_10);
                this.logTrace(AblePlatform.NlsMsg("Tr_LoadAndInstantiateExitError", new Object[]{"InstantiationException", var1_1}));
                throw new RemoteException(AblePlatform.NlsMsg("Ex_ClassNotInstantiated", new Object[]{var1_1}), var8_10);
            }
            catch (IllegalAccessException var8_11) {
                this.logException(var4_4, var8_11);
                this.logTrace(AblePlatform.NlsMsg("Tr_LoadAndInstantiateExitError", new Object[]{"IllegalAccessException", var1_1}));
                throw new RemoteException(AblePlatform.NlsMsg("Ex_ClassIllegalAccess", new Object[]{var1_1}), var8_11);
            }
        } else {
            var8_12 = new Class[var2_2.length];
            for (var9_14 = 0; var9_14 < var2_2.length; ++var9_14) {
                var8_12[var9_14] = var2_2[var9_14].getClass();
            }
            try {
                var7_7 = var5_5.getConstructor(var8_12);
            }
            catch (NoSuchMethodException var9_15) {
                this.logException(var4_4, var9_15);
                this.logTrace(AblePlatform.NlsMsg("Tr_LoadAndInstantiateExitError", new Object[]{"NoSuchMethodException", var1_1}));
                throw new RemoteException(AblePlatform.NlsMsg("Ex_ClassConstructorNotFound", new Object[]{var1_1}), var9_15);
            }
            try {
                var6_6 = var7_7.newInstance(var2_2);
                if (this.getPlatformSecurity() && var6_6 instanceof AblePlatformDefaultAgent) {
                    var9_16 = AblePlatform.Preferences.principalOfLocalAgentPool();
                    var10_20 = var3_3.getVan().getVanOfInitiator();
                    ((AblePlatformDefaultAgent)var6_6).setRequestKey(AblePlatformSupportImpl.mySecSppt.generateKey());
                    ((AblePlatformDefaultAgent)var6_6).setPrincipal(var10_20.getKerbPrincipal());
                }
            }
            catch (InstantiationException var9_17) {
                this.logException(var4_4, var9_17);
                this.logTrace(AblePlatform.NlsMsg("Tr_LoadAndInstantiateExitError", new Object[]{"InstantiationException", var1_1}));
                throw new RemoteException(AblePlatform.NlsMsg("Ex_ClassNotInstantiated", new Object[]{var1_1}), var9_17);
            }
            catch (IllegalAccessException var9_18) {
                this.logException(var4_4, var9_18);
                this.logTrace(AblePlatform.NlsMsg("Tr_LoadAndInstantiateExitError", new Object[]{"IllegalAccessException", var1_1}));
                throw new RemoteException(AblePlatform.NlsMsg("Ex_ClassIllegalAccess", new Object[]{var1_1}), var9_18);
            }
            catch (InvocationTargetException var9_19) {
                this.logException(var4_4, var9_19);
                this.logTrace(AblePlatform.NlsMsg("Tr_LoadAndInstantiateExitError", new Object[]{"InvocationTargetException", var1_1}));
                throw new RemoteException(AblePlatform.NlsMsg("Ex_ClassInvocationTarget", new Object[]{var1_1}), var9_19);
            }
        }
lbl62:
        // 3 sources

        if (AblePlatformSupportImpl.myTrcLog.isLogging()) {
            this.logTrace(AblePlatform.NlsMsg("Tr_LoadAndInstantiateExitNormal", new Object[]{var1_1}));
        }
        return var6_6;
    }

    private void logException(String string, Exception exception) {
        myMsgLog.text(4L, (Object)this, string, exception.getLocalizedMessage());
        myTrcLog.exception(262144L, (Object)this, string, (Throwable)exception);
    }

    private void logTrace(String string) {
        myTrcLog.text(262144L, (Object)this, "loadAndInstantiateClass", string);
    }

    public static void main(String[] stringArray) {
        String string = "main";
        Able.startMessageAndTraceLogging();
        String string2 = "";
        String string3 = "1099";
        if (stringArray.length == 0) {
            myMsgLog.text(4L, (Object)lclC, string, AblePlatform.NlsMsg("PlatSupport_NoPortSpecified"));
            System.exit(255);
        }
        if (stringArray.length >= 1 && (string2 = stringArray[0]) != null && string2.trim().length() != 0) {
            string3 = string2.trim();
        }
        if (AblePlatformSupportImpl.initialize(string3)) {
            myMsgLog.text(1L, (Object)lclC, string, AblePlatform.NlsMsg("PlatSupport_ActivationOk", new Object[]{string3}));
        } else {
            myMsgLog.text(1L, (Object)lclC, string, AblePlatform.NlsMsg("PlatSupport_ActivationFailed", new Object[]{string3}));
            System.exit(255);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean initialize(String string) {
        Object object;
        Map.Entry entry;
        Object object2;
        Object object3;
        Object object4;
        Serializable serializable;
        Object object5;
        Object object6;
        String string2 = "initialize";
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            myMsgLog.text(4L, (Object)lclC, string2, AblePlatform.NlsMsg("PlatSupport_InvalidPortNumber", new Object[]{string}));
            if (!myTrcLog.isLogging()) return false;
            myTrcLog.exception(262144L, (Object)lclC, string2, (Throwable)numberFormatException);
            return false;
        }
        InetAddress inetAddress = null;
        String string3 = null;
        String string4 = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            myMsgLog.text(4L, (Object)lclC, string2, AblePlatform.NlsMsg("PlatSupport_CannotObtainIPAddress"));
            myMsgLog.text(4L, (Object)lclC, string2, unknownHostException.getLocalizedMessage());
            if (!myTrcLog.isLogging()) return false;
            myTrcLog.exception(262144L, (Object)lclC, string2, (Throwable)unknownHostException);
            return false;
        }
        string3 = inetAddress.getHostAddress();
        string4 = inetAddress.getHostName();
        AblePlatformPreferences.AgentPoolEntry_ agentPoolEntry_ = AblePlatform.Preferences.configuredHostPort(string4, string3, string);
        if (myTrcLog.isLogging()) {
            myTrcLog.text(0x100000L, (Object)"AblePlatformSupportImpl", string2, "lclHostName...... <" + string4 + ">.");
            myTrcLog.text(0x100000L, (Object)"AblePlatformSupportImpl", string2, "lclHostAddress... <" + string3 + ">.");
            myTrcLog.text(0x100000L, (Object)"AblePlatformSupportImpl", string2, "thePort.......... <" + string + ">.");
            myTrcLog.text(0x100000L, (Object)"AblePlatformSupportImpl", string2, "AgentPoolEntry_.. <" + agentPoolEntry_ + ">.");
        }
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        if (agentPoolEntry_ == null) {
            myMsgLog.text(4L, (Object)lclC, string2, AblePlatform.NlsMsg("PlatSupport_HostNotConfigured"));
            return false;
        }
        AblePlatform.Preferences.setLocalAgentPool(agentPoolEntry_);
        string5 = agentPoolEntry_.getAgentPoolAlias();
        string6 = agentPoolEntry_.getIpAddress();
        string7 = agentPoolEntry_.getPort();
        string8 = agentPoolEntry_.getPrincipal();
        Registry registry = null;
        try {
            registry = Able.GetSocketFactory() == null ? LocateRegistry.createRegistry(n) : LocateRegistry.createRegistry(n, Able.GetSocketFactory(), Able.GetSocketFactory());
        }
        catch (RemoteException remoteException) {
            myMsgLog.text(1L, (Object)lclC, string2, AblePlatform.NlsMsg("PlatSupport_CannotCreateRmiRegistry", new Object[]{string}));
            myMsgLog.text(1L, (Object)lclC, string2, remoteException.getLocalizedMessage());
            if (myTrcLog.isLogging()) {
                myTrcLog.exception(262144L, (Object)lclC, string2, (Throwable)remoteException);
            }
            try {
                object6 = Able.GetSocketFactory();
                registry = object6 == null ? LocateRegistry.getRegistry(n) : LocateRegistry.getRegistry(string6, n, (RMIClientSocketFactory)object6);
            }
            catch (RemoteException remoteException2) {
                myMsgLog.text(4L, (Object)lclC, string2, AblePlatform.NlsMsg("PlatSupport_CannotLocateRmiRegistry", new Object[]{string}));
                myMsgLog.text(4L, (Object)lclC, string2, remoteException2.getLocalizedMessage());
                if (!myTrcLog.isLogging()) return false;
                myTrcLog.exception(262144L, (Object)lclC, string2, (Throwable)remoteException2);
                return false;
            }
        }
        String string9 = "rmi://" + string6 + ":" + string7 + "/" + "AblePlatformSupport";
        object6 = null;
        try {
            object6 = Able.GetSocketFactory() == null ? new AblePlatformSupportImpl(registry, string9, string5, string6, string7) : new AblePlatformSupportImpl(registry, string9, string5, string6, string7, Able.GetSocketFactory(), Able.GetSocketFactory());
        }
        catch (RemoteException remoteException) {
            myMsgLog.text(4L, (Object)lclC, string2, AblePlatform.NlsMsg("PlatSupport_CannotCreatePlatformSupport"));
            myMsgLog.text(4L, (Object)lclC, string2, remoteException.getLocalizedMessage());
            if (!myTrcLog.isLogging()) return false;
            myTrcLog.exception(262144L, (Object)lclC, string2, (Throwable)remoteException);
            return false;
        }
        try {
            registry.rebind(string9, (Remote)object6);
            myMsgLog.text(1L, (Object)lclC, string2, AblePlatform.NlsMsg("PlatSupport_PlatformSupportBound", new Object[]{string9}));
        }
        catch (RemoteException remoteException) {
            myMsgLog.text(4L, (Object)lclC, string2, AblePlatform.NlsMsg("PlatSupport_PlatformSupportBindFailed"));
            myMsgLog.text(4L, (Object)lclC, string2, remoteException.getLocalizedMessage());
            if (!myTrcLog.isLogging()) return false;
            myTrcLog.exception(262144L, (Object)lclC, string2, (Throwable)remoteException);
            return false;
        }
        Vector vector = AblePlatform.Preferences.configuredForAns(string5);
        boolean bl = (Boolean)vector.elementAt(0);
        AblePlatformPreferences.ServiceEntry_ serviceEntry_ = (AblePlatformPreferences.ServiceEntry_)vector.elementAt(1);
        AblePlatformPreferences.AgentPoolEntry_ agentPoolEntry_2 = serviceEntry_.getAgentPoolInfo();
        String string10 = agentPoolEntry_2.getAgentPoolAlias();
        String string11 = agentPoolEntry_2.getPort();
        String string12 = agentPoolEntry_2.getIpAddress();
        String string13 = agentPoolEntry_2.getPrincipal();
        Service service = null;
        if (bl || Able.Preferences.isSecure()) {
            if (myTrcLog.isLogging()) {
                myTrcLog.text(0x100000L, (Object)lclC, string2, "Creating or locating ANS on <" + string10 + ">.");
            }
            object5 = serviceEntry_.getServiceAlias();
            String string14 = serviceEntry_.getFactoryClassName();
            serializable = serviceEntry_.getServiceProperties();
            object4 = new ServicePropertiesImpl();
            object4.set("javax.agent.service.service-factory", (Object)string14);
            object4.set("javax.agent.service.ip.service-port", (Object)string11);
            object4.set("javax.agent.service.ip.service-host", (Object)string12);
            object4.set("com.ibm.able.platform.principal-of-ans-host", (Object)string13);
            object4.set("com.ibm.able.platform.principal-of-local-host", (Object)string8);
            object4.set("com.ibm.able.platform.requestors-port", (Object)string);
            if (Able.GetSocketFactory() != null) {
                object4.set("platform-socket-factory", (Object)Able.GetSocketFactory());
            }
            if (serializable != null) {
                object3 = serializable.entrySet();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    entry = (Map.Entry)object2.next();
                    String string15 = (String)entry.getKey();
                    object = (String)entry.getValue();
                    object4.set(string15, object);
                }
            }
            try {
                if (bl) {
                    myMsgLog.text(1L, (Object)lclC, string2, AblePlatform.NlsMsg("Creating_service", new Object[]{object5, string14}));
                } else {
                    myMsgLog.text(1L, (Object)lclC, string2, AblePlatform.NlsMsg("Locating_service", new Object[]{object5, string14}));
                }
                service = ServiceManager.getService((ServiceProperties)object4);
            }
            catch (ServiceException serviceException) {
                if (bl) {
                    myMsgLog.text(4L, (Object)lclC, string2, AblePlatform.NlsMsg("Could_not_create_service", new Object[]{object5, string14}));
                } else {
                    myMsgLog.text(4L, (Object)lclC, string2, AblePlatform.NlsMsg("Could_not_locate_service", new Object[]{object5, string14}));
                }
                myMsgLog.text(4L, (Object)lclC, string2, serviceException.getLocalizedMessage());
                if (!myTrcLog.isLogging()) return false;
                myTrcLog.exception(262144L, (Object)lclC, string2, (Throwable)serviceException);
                return false;
            }
        } else if (myTrcLog.isLogging()) {
            myTrcLog.text(0x100000L, (Object)lclC, string2, "Don't need to create or locate ANS.");
        }
        if (Able.Preferences.isSecure()) {
            if (string8.trim().length() == 0) {
                myMsgLog.text(4L, (Object)lclC, string2, AblePlatform.NlsMsg("SecOn_NoPrincipalForHost", new Object[]{string5}));
                return false;
            }
            if (string13.trim().length() == 0) {
                myMsgLog.text(4L, (Object)lclC, string2, AblePlatform.NlsMsg("SecOn_NoPrincipalForAns"));
                return false;
            }
            try {
                myKeyPair = AblePlatform.generateKeyPair();
                myVerifiableAgentNamingService = (VerifiableAgentNamingService)service;
                myVerifiableAgentName = myVerifiableAgentNamingService.createAgentName(myKeyPair.getPublic(), string8, null);
                myTrustLevel = myVerifiableAgentName.getLevel();
                mySecSppt = new AbleSecuritySupport(myKeyPair, myVerifiableAgentName, myVerifiableAgentNamingService, myMsgLog, myTrcLog);
            }
            catch (NamingException namingException) {
                myMsgLog.text(4L, (Object)lclC, string2, AblePlatform.NlsMsg("UnableToObtainVan"));
                if (!myTrcLog.isLogging()) return false;
                myTrcLog.exception(262144L, (Object)lclC, string2, (Throwable)namingException);
                return false;
            }
            catch (NamingFailure namingFailure) {
                myMsgLog.text(4L, (Object)lclC, string2, AblePlatform.NlsMsg("UnableToObtainVan"));
                myMsgLog.text(4L, (Object)lclC, string2, namingFailure.getLocalizedMessage());
                if (!myTrcLog.isLogging()) return false;
                myTrcLog.exception(262144L, (Object)lclC, string2, (Throwable)namingFailure);
                return false;
            }
        }
        if (((Vector)(object5 = AblePlatform.Preferences.configuredServices(string5))).isEmpty()) return true;
        for (int i = 0; i < ((Vector)object5).size(); ++i) {
            serializable = (AblePlatformPreferences.ServiceEntry_)((Vector)object5).elementAt(i);
            object4 = ((AblePlatformPreferences.ServiceEntry_)serializable).getServiceAlias();
            object3 = ((AblePlatformPreferences.ServiceEntry_)serializable).getFactoryClassName();
            object2 = ((AblePlatformPreferences.ServiceEntry_)serializable).getServiceProperties();
            if (((String)object4).equalsIgnoreCase("agent-naming-service")) continue;
            entry = null;
            ServicePropertiesImpl servicePropertiesImpl = new ServicePropertiesImpl();
            servicePropertiesImpl.set("javax.agent.service.service-factory", object3);
            servicePropertiesImpl.set("javax.agent.service.ip.service-port", (Object)string7);
            servicePropertiesImpl.set("javax.agent.service.ip.service-host", (Object)string6);
            servicePropertiesImpl.set("com.ibm.able.platform.principal-of-local-host", (Object)string8);
            servicePropertiesImpl.set("com.ibm.able.platform.principal-of-ans-host", (Object)string13);
            servicePropertiesImpl.set("com.ibm.able.platform.requestors-port", (Object)string);
            if (Able.GetSocketFactory() != null) {
                servicePropertiesImpl.set("platform-socket-factory", (Object)Able.GetSocketFactory());
            }
            if (object2 != null) {
                object = object2.entrySet();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)iterator.next();
                    String string16 = (String)entry2.getKey();
                    String string17 = (String)entry2.getValue();
                    servicePropertiesImpl.set(string16, (Object)string17);
                }
            }
            try {
                myMsgLog.text(1L, (Object)lclC, string2, AblePlatform.NlsMsg("Creating_service", new Object[]{object4, object3}));
                entry = ServiceManager.getService((ServiceProperties)servicePropertiesImpl);
                continue;
            }
            catch (ServiceException serviceException) {
                myMsgLog.text(4L, (Object)lclC, string2, AblePlatform.NlsMsg("Could_not_create_service", new Object[]{object4, object3}));
                myMsgLog.text(4L, (Object)lclC, string2, serviceException.getLocalizedMessage());
                if (!myTrcLog.isLogging()) return false;
                myTrcLog.exception(262144L, (Object)lclC, string2, (Throwable)serviceException);
                return false;
            }
        }
        if (!myTrcLog.isLogging()) return true;
        try {
            String[] stringArray = registry.list();
            for (int i = 0; i < stringArray.length; ++i) {
                myTrcLog.text(262144L, (Object)"AblePlatformSupportImpl", string2, "Reg entry <" + i + "> is <" + stringArray[i] + ">.");
            }
            return true;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

