/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.platform;

import com.ibm.able.Able;
import com.ibm.able.platform.AbleAgentClassDescription;
import com.ibm.able.platform.AblePlatform;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

public final class AblePlatformPreferences
implements Serializable {
    static final long serialVersionUID = 2002080100000000001L;
    private String myPropertiesFile = "";
    Properties myProperties = null;
    private static AgentPoolEntry_ myLocalAgentPool = null;
    public static final int TRUSTLEVEL_EQUAL_TO = 1;
    public static final int TRUSTLEVEL_LESS_THAN = 2;
    public static final int TRUSTLEVEL_LESS_THAN_OR_EQUAL_TO = 3;
    public static final int TRUSTLEVEL_GREATER_THAN = 4;
    public static final int TRUSTLEVEL_GREATER_THAN_OR_EQUAL_TO = 5;
    public static final int TRUSTLEVEL_NOT_EQUAL_TO = 6;
    private String myPlatformName = "ABLE default platform";
    private String myCryptographyAlgorithm = "DSA";
    private String myCryptographyProvider = "";
    private Hashtable myPrincipals = new Hashtable();
    private Vector myPrincipalOrder = new Vector();
    private Hashtable myTrustLevels = new Hashtable();
    private Vector myTrustLevelOrder = new Vector();
    private Hashtable myAgentPools = new Hashtable();
    private Vector myAgentPoolOrder = new Vector();
    private Vector myServices = new Vector();
    private Hashtable myServiceList = new Hashtable();
    private Hashtable myPermittedAgents = new Hashtable();
    private Vector myPermittedAgentOrder = new Vector();

    final void setLocalAgentPool(AgentPoolEntry_ agentPoolEntry_) {
        String string = "setLocalAgentPool(AgentPoolEntry_)";
        if (Able.Preferences.isSecure()) {
            if (myLocalAgentPool == null) {
                myLocalAgentPool = agentPoolEntry_;
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("PlatSetup_JvmHostInfoSetTo", new Object[]{agentPoolEntry_.prettyPrint()}));
                System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("PlatSetup_CredsOnlySetTo"));
            } else {
                Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("PlatSetup_JvmHostInfoResetIgnored"));
            }
        } else {
            myLocalAgentPool = agentPoolEntry_;
            Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("PlatSetup_JvmHostInfoSetTo", new Object[]{agentPoolEntry_.prettyPrint()}));
            System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
            Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("PlatSetup_CredsOnlySetTo"));
        }
    }

    public final void setLocalAgentPool(String string) {
        String string2 = "setLocalAgentPool(String)";
        AgentPoolEntry_ agentPoolEntry_ = (AgentPoolEntry_)this.myAgentPools.get(string);
        if (agentPoolEntry_ != null) {
            this.setLocalAgentPool(agentPoolEntry_);
        } else {
            Able.MessageLog.text(4L, (Object)this, string2, AblePlatform.NlsMsg("PlatSetup_JvmHostInfoSetIgnored"));
        }
    }

    public final String getPlatformName() {
        return this.myPlatformName;
    }

    private final String cvtPlatformName() {
        return this.myPlatformName;
    }

    private final void setPlatformName(String string) {
        this.myPlatformName = string;
    }

    public final String getCryptographyAlgorithm() {
        return this.myCryptographyAlgorithm;
    }

    private final String cvtCryptographyAlgorithm() {
        return this.myCryptographyAlgorithm;
    }

    private final void setCryptographyAlgorithm(String string) {
        this.myCryptographyAlgorithm = string;
    }

    public final String getCryptographyProvider() {
        return this.myCryptographyProvider;
    }

    private final String cvtCryptographyProvider() {
        return this.myCryptographyProvider;
    }

    private final void setCryptographyProvider(String string) {
        this.myCryptographyProvider = string;
    }

    public final Hashtable getPrincipals() {
        return this.myPrincipals;
    }

    private final void cvtPrincipals(Properties properties) {
        this.principalsToProperties(properties, this.myPrincipalOrder, this.myPrincipals);
    }

    private final void setPrincipals(Hashtable hashtable) {
        this.myPrincipals = hashtable;
    }

    private final void setPrincipals(Properties properties) {
        this.myPrincipals = this.principalsFromProperties(properties);
    }

    public final Hashtable getTrustLevels() {
        return this.myTrustLevels;
    }

    private final void cvtTrustLevels(Properties properties) {
        this.trustLevelsToProperties(properties, this.myTrustLevelOrder, this.myTrustLevels);
    }

    private final void setTrustLevels(Hashtable hashtable) {
        this.myTrustLevels = hashtable;
    }

    private final void setTrustLevels(Properties properties) {
        this.myTrustLevels = this.trustLevelsFromProperties(properties);
    }

    public final Hashtable getAgentPools() {
        return this.myAgentPools;
    }

    private final void cvtAgentPools(Properties properties) {
        this.agentPoolsToProperties(properties, this.myAgentPoolOrder, this.myAgentPools);
    }

    private final void setAgentPools(Hashtable hashtable) {
        this.myAgentPools = hashtable;
    }

    private final void setAgentPools(Properties properties) {
        this.myAgentPools = this.agentPoolsFromProperties(properties);
    }

    public final Vector getServices() {
        return this.myServices;
    }

    private final String cvtServices() {
        return this.servicesToString(this.myServices);
    }

    private final void setServices(Vector vector) {
        this.myServices = vector;
    }

    private final void setServices(String string) {
        this.myServices = this.servicesFromString(string);
    }

    public final Hashtable getServiceList() {
        return this.myServiceList;
    }

    private final void cvtServiceList(Properties properties) {
        this.serviceListToProperties(properties, this.myServices, this.myServiceList);
    }

    private final void setServiceList(Hashtable hashtable) {
        this.myServiceList = hashtable;
    }

    private final void setServiceList(Properties properties) {
        this.myServiceList = this.serviceListFromProperties(properties, this.myServices);
    }

    public final Hashtable getPermittedAgents() {
        return this.myPermittedAgents;
    }

    private final void cvtPermittedAgents(Properties properties) {
        this.permittedAgentsToProperties(properties, this.myPermittedAgentOrder, this.myPermittedAgents);
    }

    private final void setPermittedAgents(Hashtable hashtable) {
        this.myPermittedAgents = hashtable;
    }

    private final void setPermittedAgents(Properties properties) {
        this.myPermittedAgents = this.permittedAgentsFromProperties(properties);
    }

    public AblePlatformPreferences() {
        String string = System.getProperty("able.prefdir", "");
        String string2 = System.getProperty("user.home");
        this.myPropertiesFile = string.trim().length() == 0 ? string2 + File.separator + "ableplatform.preferences" : string + File.separator + "ableplatform.preferences";
        this.readPropertiesFile();
    }

    public AblePlatformPreferences(String string) {
        this.myPropertiesFile = string;
        this.readPropertiesFile();
    }

    public void readPropertiesFile() {
        this.myProperties = new Properties();
        try {
            this.myProperties.load(new BufferedInputStream(new FileInputStream(this.myPropertiesFile)));
            this.movePropertiesToPreferenceVariables(this.myProperties);
        }
        catch (Exception exception) {
            this.movePreferenceVariablesToProperties(this.myProperties);
            this.writePropertiesFile();
        }
    }

    public void writePropertiesFile() {
        if (this.myProperties == null) {
            this.myProperties = new Properties();
        }
        try {
            this.movePreferenceVariablesToProperties(this.myProperties);
            this.myProperties.store(new FileOutputStream(this.myPropertiesFile), "IBM ABLE Platform Preferences File");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updatePreferenceVariablesAndWritePropertiesFile(AblePlatformPreferences ablePlatformPreferences) {
        if (Able.Preferences.isSecure()) {
            return;
        }
        this.updatePreferenceVariables(ablePlatformPreferences);
        this.writePropertiesFile();
    }

    public void updatePreferenceVariables(AblePlatformPreferences ablePlatformPreferences) {
        if (Able.Preferences.isSecure()) {
            return;
        }
        this.setPlatformName(ablePlatformPreferences.getPlatformName());
        this.setCryptographyAlgorithm(ablePlatformPreferences.getCryptographyAlgorithm());
        this.setCryptographyProvider(ablePlatformPreferences.getCryptographyProvider());
        this.setPrincipals(ablePlatformPreferences.getPrincipals());
        this.setTrustLevels(ablePlatformPreferences.getTrustLevels());
        this.setAgentPools(ablePlatformPreferences.getAgentPools());
        this.setServices(ablePlatformPreferences.getServices());
        this.setServiceList(ablePlatformPreferences.getServiceList());
        this.setPermittedAgents(ablePlatformPreferences.getPermittedAgents());
    }

    private void movePropertiesToPreferenceVariables(Properties properties) {
        block6: {
            String string = "";
            try {
                string = properties.getProperty("PlatformName");
                if (string != null) {
                    this.setPlatformName(string);
                }
                if ((string = properties.getProperty("CryptographyAlgorithm")) != null) {
                    this.setCryptographyAlgorithm(string);
                }
                if ((string = properties.getProperty("CryptographyProvider")) != null) {
                    this.setCryptographyProvider(string);
                }
                this.setPrincipals(properties);
                this.setTrustLevels(properties);
                this.setAgentPools(properties);
                string = properties.getProperty("Services");
                if (string != null) {
                    this.setServices(string);
                }
                this.setServiceList(properties);
                this.setPermittedAgents(properties);
            }
            catch (Exception exception) {
                this.debugTrace("Cannot load preferences. Exception is " + exception.getLocalizedMessage());
                if (Able.TraceLog == null || !Able.TraceLog.isLogging()) break block6;
                Able.TraceLog.exception(262144L, (Object)this, "movePropertiesToPreferenceVariables()", (Throwable)exception);
            }
        }
    }

    private void movePreferenceVariablesToProperties(Properties properties) {
        properties.setProperty("PlatformName", this.cvtPlatformName());
        properties.setProperty("CryptographyAlgorithm", this.cvtCryptographyAlgorithm());
        properties.setProperty("CryptographyProvider", this.cvtCryptographyProvider());
        this.cvtPrincipals(properties);
        this.cvtTrustLevels(properties);
        this.cvtAgentPools(properties);
        properties.setProperty("Services", this.cvtServices());
        this.cvtServiceList(properties);
        this.cvtPermittedAgents(properties);
    }

    public final Vector configuredForAns(String string) {
        Vector<Serializable> vector = new Vector<Serializable>();
        boolean bl = false;
        ServiceEntry_ serviceEntry_ = null;
        String string2 = null;
        for (int i = 0; i < this.myServices.size() && !(string2 = (String)this.myServices.elementAt(i)).equalsIgnoreCase("agent-naming-service"); ++i) {
        }
        if (string2 != null) {
            ServiceEntry_ serviceEntry_2 = (ServiceEntry_)this.myServiceList.get(string2);
            String string3 = serviceEntry_2.getAgentPoolAlias();
            if (string.equalsIgnoreCase(string3)) {
                bl = true;
            }
            serviceEntry_ = new ServiceEntry_(serviceEntry_2);
        }
        vector.addElement(new Boolean(bl));
        vector.addElement(serviceEntry_);
        return vector;
    }

    public final AgentPoolEntry_ configuredHostPort(String string, String string2, String string3) {
        String string4 = "configuredHostPort";
        AgentPoolEntry_ agentPoolEntry_ = null;
        for (int i = 0; i < this.myAgentPoolOrder.size(); ++i) {
            String string5 = (String)this.myAgentPoolOrder.elementAt(i);
            AgentPoolEntry_ agentPoolEntry_2 = (AgentPoolEntry_)this.myAgentPools.get(string5);
            String string6 = agentPoolEntry_2.getPort();
            String string7 = agentPoolEntry_2.getIpAddress();
            if (string3.equalsIgnoreCase(string6)) {
                if (Able.TraceLog.isLogging()) {
                    Able.TraceLog.text(0x100000L, (Object)this, string4, "Ports match.");
                }
                if (string.equalsIgnoreCase(string7)) {
                    if (Able.TraceLog.isLogging()) {
                        Able.TraceLog.text(0x100000L, (Object)this, string4, "Host names match.");
                    }
                    agentPoolEntry_ = new AgentPoolEntry_(agentPoolEntry_2);
                    break;
                }
                if (Able.TraceLog.isLogging()) {
                    Able.TraceLog.text(0x100000L, (Object)this, string4, "Host names do not match: <" + string + ">, <" + string7 + ">.");
                }
                InetAddress inetAddress = null;
                String string8 = null;
                try {
                    inetAddress = InetAddress.getByName(string7);
                    string8 = inetAddress.getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    if (!Able.TraceLog.isLogging()) continue;
                    Able.TraceLog.text(0x100000L, (Object)this, string4, "Unknown host <" + string7 + ">.  Looking at next entry.");
                    continue;
                }
                if (string2.equalsIgnoreCase(string8)) {
                    if (Able.TraceLog.isLogging()) {
                        Able.TraceLog.text(0x100000L, (Object)this, string4, "IP addresses match.");
                    }
                    agentPoolEntry_ = new AgentPoolEntry_(agentPoolEntry_2);
                    break;
                }
                if (!Able.TraceLog.isLogging()) continue;
                Able.TraceLog.text(0x100000L, (Object)this, string4, "IP addresses do not match: <" + string2 + ">, <" + string8 + ">.");
                continue;
            }
            if (!Able.TraceLog.isLogging()) continue;
            Able.TraceLog.text(0x100000L, (Object)this, string4, "Ports do not match: <" + string3 + ">, <" + string6 + ">.");
        }
        return agentPoolEntry_;
    }

    public final Vector configuredServices() {
        Vector<ServiceEntry_> vector = new Vector<ServiceEntry_>();
        for (int i = 0; i < this.myServices.size(); ++i) {
            String string = (String)this.myServices.elementAt(i);
            ServiceEntry_ serviceEntry_ = (ServiceEntry_)this.myServiceList.get(string);
            vector.addElement(new ServiceEntry_(serviceEntry_));
        }
        return vector;
    }

    public final Vector configuredServices(String string) {
        Vector<ServiceEntry_> vector = new Vector<ServiceEntry_>();
        for (int i = 0; i < this.myServices.size(); ++i) {
            String string2 = (String)this.myServices.elementAt(i);
            ServiceEntry_ serviceEntry_ = (ServiceEntry_)this.myServiceList.get(string2);
            String string3 = serviceEntry_.getAgentPoolAlias();
            String string4 = serviceEntry_.getFactoryClassName();
            if (!string.equalsIgnoreCase(string3)) continue;
            vector.addElement(new ServiceEntry_(serviceEntry_));
        }
        return vector;
    }

    public final String principalOfAgentPool(String string) {
        String string2 = "";
        String string3 = null;
        for (int i = 0; i < this.myAgentPoolOrder.size() && !(string3 = (String)this.myAgentPoolOrder.elementAt(i)).equalsIgnoreCase(string); ++i) {
        }
        if (string3 != null) {
            AgentPoolEntry_ agentPoolEntry_ = (AgentPoolEntry_)this.myAgentPools.get(string3);
            string2 = agentPoolEntry_.getPrincipal();
        }
        return string2;
    }

    public final String principalOfLocalAgentPool() {
        if (myLocalAgentPool != null) {
            return myLocalAgentPool.getPrincipal();
        }
        return "";
    }

    public final String portOfLocalAgentPool() {
        if (myLocalAgentPool != null) {
            return myLocalAgentPool.getPort();
        }
        return "";
    }

    public final String aliasOfLocalAgentPool() {
        if (myLocalAgentPool != null) {
            return myLocalAgentPool.getAgentPoolAlias();
        }
        return "";
    }

    public final String principalOfService(String string) {
        String string2 = "";
        String string3 = null;
        for (int i = 0; i < this.myServices.size() && !(string3 = (String)this.myServices.elementAt(i)).equalsIgnoreCase(string); ++i) {
        }
        if (string3 != null) {
            ServiceEntry_ serviceEntry_ = (ServiceEntry_)this.myServiceList.get(string3);
            AgentPoolEntry_ agentPoolEntry_ = serviceEntry_.getAgentPoolInfo();
            string2 = agentPoolEntry_.getPrincipal();
        }
        return string2;
    }

    public final String getServiceFactoryClassName(String string) {
        ServiceEntry_ serviceEntry_ = this.getServiceEntry(string);
        return serviceEntry_.getFactoryClassName();
    }

    public final String getServiceIpAddress(String string) {
        AgentPoolEntry_ agentPoolEntry_ = this.getAgentPoolForService(string);
        return agentPoolEntry_.getIpAddress();
    }

    public final String getServicePort(String string) {
        AgentPoolEntry_ agentPoolEntry_ = this.getAgentPoolForService(string);
        return agentPoolEntry_.getPort();
    }

    public final String trustLevelOfPrincipal(String string) {
        String string2 = "";
        for (int i = 0; i < this.myTrustLevelOrder.size(); ++i) {
            TrustLevelEntry_ trustLevelEntry_ = (TrustLevelEntry_)this.myTrustLevels.get((String)this.myTrustLevelOrder.get(i));
            for (int j = 0; j < trustLevelEntry_.myPrincipalAliases.size(); ++j) {
                PrincipalEntry_ principalEntry_ = (PrincipalEntry_)this.myPrincipals.get(trustLevelEntry_.myPrincipalAliases.get(j));
                if (!principalEntry_.getPrincipal().equalsIgnoreCase(string)) continue;
                return trustLevelEntry_.myTrustLevelAlias;
            }
        }
        return null;
    }

    public final boolean compareTrustLevel(String string, int n, String string2) {
        String string3 = "compareTrustLevel(String,int,String)";
        boolean bl = false;
        TrustLevelEntry_ trustLevelEntry_ = null;
        TrustLevelEntry_ trustLevelEntry_2 = null;
        trustLevelEntry_ = (TrustLevelEntry_)this.myTrustLevels.get(string);
        trustLevelEntry_2 = (TrustLevelEntry_)this.myTrustLevels.get(string2);
        if (trustLevelEntry_ == null) {
            bl = true;
            Able.MessageLog.text(2L, (Object)this, string3, AblePlatform.NlsMsg("TrustLvl_Compare_AliasNotDefined", new Object[]{string}));
        }
        if (trustLevelEntry_2 == null) {
            bl = true;
            Able.MessageLog.text(2L, (Object)this, string3, AblePlatform.NlsMsg("TrustLvl_Compare_AliasNotDefined", new Object[]{string2}));
        }
        if (bl) {
            Able.MessageLog.text(2L, (Object)this, string3, AblePlatform.NlsMsg("TrustLvl_Compare_Failed"));
            return false;
        }
        int n2 = trustLevelEntry_.getTrustLevelRank();
        int n3 = trustLevelEntry_2.getTrustLevelRank();
        switch (n) {
            case 1: {
                if (n2 != n3) break;
                return true;
            }
            case 4: {
                if (n2 >= n3) break;
                return true;
            }
            case 5: {
                if (n2 > n3) break;
                return true;
            }
            case 2: {
                if (n2 <= n3) break;
                return true;
            }
            case 3: {
                if (n2 < n3) break;
                return true;
            }
            case 6: {
                if (n2 == n3) break;
                return true;
            }
            default: {
                Able.MessageLog.text(2L, (Object)this, string3, AblePlatform.NlsMsg("TrustLvl_Compare_InvalidOperator", new Object[]{new Integer(n)}));
                return false;
            }
        }
        return false;
    }

    public AgentPoolEntry_ getAgentPool(String string) {
        return (AgentPoolEntry_)this.myAgentPools.get(string);
    }

    private AgentPoolEntry_ getAgentPoolForService(String string) {
        ServiceEntry_ serviceEntry_ = this.getServiceEntry(string);
        String string2 = serviceEntry_.getAgentPoolAlias();
        AgentPoolEntry_ agentPoolEntry_ = (AgentPoolEntry_)this.myAgentPools.get(string2);
        return agentPoolEntry_;
    }

    private PrincipalEntry_ getPrincipalEntry(String string) {
        return (PrincipalEntry_)this.myPrincipals.get(string);
    }

    ServiceEntry_ getServiceEntry(String string) {
        ServiceEntry_ serviceEntry_ = null;
        Enumeration enumeration = this.myServiceList.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            serviceEntry_ = (ServiceEntry_)this.myServiceList.get(string2);
            break;
        }
        return serviceEntry_;
    }

    public final SortedSet configuredAgentSystems() {
        TreeSet<String> treeSet = new TreeSet<String>();
        Enumeration enumeration = this.myAgentPools.elements();
        while (enumeration.hasMoreElements()) {
            AgentPoolEntry_ agentPoolEntry_ = (AgentPoolEntry_)enumeration.nextElement();
            treeSet.add(agentPoolEntry_.getIpAddress());
        }
        return treeSet;
    }

    public final SortedSet configuredAgentTypes() {
        TreeSet<String> treeSet = new TreeSet<String>();
        Enumeration enumeration = this.myPermittedAgents.elements();
        while (enumeration.hasMoreElements()) {
            AbleAgentClassDescription ableAgentClassDescription = (AbleAgentClassDescription)enumeration.nextElement();
            treeSet.add(ableAgentClassDescription.getType());
        }
        return treeSet;
    }

    private void principalsToProperties(Properties properties, Vector vector, Hashtable hashtable) {
        String string = "Principal.";
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = string + (i + 1);
            String string3 = (String)vector.elementAt(i);
            PrincipalEntry_ principalEntry_ = (PrincipalEntry_)hashtable.get(string3);
            properties.setProperty(string2 + ".Alias", principalEntry_.getPrincipalAlias());
            properties.setProperty(string2 + ".Principal", principalEntry_.getPrincipal());
        }
    }

    private Hashtable principalsFromProperties(Properties properties) {
        String string = "principalsFromProperties(Properties)";
        String string2 = "Principal.";
        Vector<String> vector = new Vector<String>();
        Hashtable<String, PrincipalEntry_> hashtable = new Hashtable<String, PrincipalEntry_>();
        int n = 1;
        String string3 = string2 + n;
        String string4 = string3 + ".Alias";
        String string5 = properties.getProperty(string4);
        while (string5 != null) {
            String string6 = string5.trim();
            String string7 = "";
            string4 = string3 + ".Principal";
            string5 = properties.getProperty(string4);
            if (string5 != null) {
                string7 = string5.trim();
            } else {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string4}));
            }
            vector.addElement(string6);
            hashtable.put(string6, new PrincipalEntry_(string6, string7));
            string3 = string2 + ++n;
            string4 = string3 + ".Alias";
            string5 = properties.getProperty(string4);
        }
        this.myPrincipalOrder = vector;
        return hashtable;
    }

    private void agentPoolsToProperties(Properties properties, Vector vector, Hashtable hashtable) {
        String string = "AgentPool.";
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = string + (i + 1);
            String string3 = (String)vector.elementAt(i);
            AgentPoolEntry_ agentPoolEntry_ = (AgentPoolEntry_)hashtable.get(string3);
            properties.setProperty(string2 + ".Alias", agentPoolEntry_.getAgentPoolAlias());
            properties.setProperty(string2 + ".IpAddress", agentPoolEntry_.getIpAddress());
            properties.setProperty(string2 + ".Port", agentPoolEntry_.getPort());
            properties.setProperty(string2 + ".Principal", agentPoolEntry_.getPrincipalAlias());
        }
    }

    private Hashtable agentPoolsFromProperties(Properties properties) {
        String string = "agentPoolsFromProperties(Properties)";
        String string2 = "AgentPool.";
        Vector<String> vector = new Vector<String>();
        Hashtable<String, AgentPoolEntry_> hashtable = new Hashtable<String, AgentPoolEntry_>();
        int n = 1;
        String string3 = string2 + n;
        String string4 = string3 + ".Alias";
        String string5 = properties.getProperty(string4);
        while (string5 != null) {
            String string6 = string5.trim();
            String string7 = "";
            String string8 = "";
            String string9 = "";
            string4 = string3 + ".IpAddress";
            string5 = properties.getProperty(string4).toLowerCase();
            if (string5 != null) {
                string7 = string5.trim();
            } else {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string4}));
            }
            string4 = string3 + ".Port";
            string5 = properties.getProperty(string4);
            if (string5 != null) {
                string8 = string5.trim();
            } else {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string4}));
            }
            string4 = string3 + ".Principal";
            string5 = properties.getProperty(string4);
            if (string5 != null) {
                string9 = string5.trim();
            } else {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string4}));
            }
            vector.addElement(string6);
            hashtable.put(string6, new AgentPoolEntry_(string6, string7, string8, string9));
            string3 = string2 + ++n;
            string4 = string3 + ".Alias";
            string5 = properties.getProperty(string4);
        }
        this.myAgentPoolOrder = vector;
        return hashtable;
    }

    private void trustLevelsToProperties(Properties properties, Vector vector, Hashtable hashtable) {
        String string = "TrustLevel.";
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = string + (i + 1);
            String string3 = (String)vector.elementAt(i);
            TrustLevelEntry_ trustLevelEntry_ = (TrustLevelEntry_)hashtable.get(string3);
            properties.setProperty(string2 + ".Alias", trustLevelEntry_.getTrustLevelAlias());
            properties.setProperty(string2 + ".Principals", this.propertyEntriesToString(trustLevelEntry_.getPrincipalAliases()));
        }
    }

    private Hashtable trustLevelsFromProperties(Properties properties) {
        String string = "trustLevelsFromProperties(Properties)";
        String string2 = "TrustLevel.";
        Vector<String> vector = new Vector<String>();
        Hashtable<String, TrustLevelEntry_> hashtable = new Hashtable<String, TrustLevelEntry_>();
        int n = 1;
        String string3 = string2 + n;
        String string4 = string3 + ".Alias";
        String string5 = properties.getProperty(string4);
        while (string5 != null) {
            String string6 = string5.trim();
            Vector vector2 = new Vector();
            Vector vector3 = new Vector();
            string4 = string3 + ".Principals";
            string5 = properties.getProperty(string4);
            if (string5 != null) {
                vector3 = this.propertyEntriesFromString(string5.trim());
            } else {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string4}));
            }
            vector.addElement(string6);
            hashtable.put(string6, new TrustLevelEntry_(string6, n, vector3));
            string3 = string2 + ++n;
            string4 = string3 + ".Alias";
            string5 = properties.getProperty(string4);
        }
        this.myTrustLevelOrder = vector;
        return hashtable;
    }

    private String servicesToString(Vector vector) {
        return this.propertyEntriesToString(vector);
    }

    private Vector servicesFromString(String string) {
        return this.propertyEntriesFromString(string);
    }

    private void serviceListToProperties(Properties properties, Vector vector, Hashtable hashtable) {
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            ServiceEntry_ serviceEntry_ = (ServiceEntry_)hashtable.get(string);
            properties.setProperty(string + ".AgentPool", serviceEntry_.getAgentPoolAlias());
            properties.setProperty(string + ".Factory", serviceEntry_.getFactoryClassName());
            properties.setProperty(string + ".Persistence", serviceEntry_.getPersistenceFlag() ? "on" : "off");
            properties.setProperty(string + ".PersistenceDatabase", serviceEntry_.getPersistenceDatabase());
            properties.setProperty(string + ".PersistenceTable", serviceEntry_.getPersistenceTable());
            properties.setProperty(string + ".PersistenceSchema", serviceEntry_.getPersistenceSchema());
            properties.setProperty(string + ".PersistenceRetry", Long.toString(serviceEntry_.getPersistenceRetry()));
            HashMap hashMap = serviceEntry_.getServiceProperties();
            if (hashMap == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            Set set = hashMap.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string2 = entry.getKey() + ":" + entry.getValue() + (iterator.hasNext() ? "," : "");
                stringBuffer.append(string2);
            }
            properties.setProperty(string + ".Properties", stringBuffer.toString());
        }
    }

    private Hashtable serviceListFromProperties(Properties properties, Vector vector) {
        String string = "serviceListFromProperties(Properties)";
        Hashtable<String, ServiceEntry_> hashtable = new Hashtable<String, ServiceEntry_>();
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.elementAt(i);
            String string3 = "";
            String string4 = "";
            boolean bl = false;
            String string5 = "";
            String string6 = "";
            String string7 = "";
            long l = 60000L;
            HashMap<String, String> hashMap = null;
            String string8 = string2 + ".AgentPool";
            String string9 = properties.getProperty(string8);
            if (string9 != null) {
                string3 = string9.trim();
            } else {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string8}));
            }
            string8 = string2 + ".Factory";
            string9 = properties.getProperty(string8);
            if (string9 != null) {
                string4 = string9.trim();
            } else {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string8}));
            }
            string8 = string2 + ".Persistence";
            string9 = properties.getProperty(string8);
            if (string9 != null) {
                bl = string9.trim().equalsIgnoreCase("on");
            } else {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string8}));
            }
            string8 = string2 + ".PersistenceDatabase";
            string9 = properties.getProperty(string8);
            if (string9 != null) {
                string5 = string9.trim();
            } else if (bl) {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string8}));
            }
            string8 = string2 + ".PersistenceTable";
            string9 = properties.getProperty(string8);
            if (string9 != null) {
                string6 = string9.trim();
            } else if (bl) {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string8}));
            }
            string8 = string2 + ".PersistenceSchema";
            string9 = properties.getProperty(string8);
            if (string9 != null) {
                string7 = string9.trim();
            } else if (bl) {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string8}));
            }
            string8 = string2 + ".PersistenceRetry";
            string9 = properties.getProperty(string8);
            if (string9 != null) {
                try {
                    l = Long.parseLong(string9.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    l = 60000L;
                    if (bl) {
                        Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyNotANumber", new Object[]{string9.trim(), string8}));
                    }
                }
            } else if (bl) {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string8}));
            }
            if ((string9 = properties.getProperty(string8 = string2 + ".Properties")) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string9.trim(), ",");
                String string10 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string10 = stringTokenizer.nextToken().trim();
                    int n = string10.indexOf(58);
                    String string11 = string10.substring(0, n).trim();
                    String string12 = string10.substring(n + 1).trim();
                    if (hashMap == null) {
                        hashMap = new HashMap<String, String>();
                    }
                    hashMap.put(string11, string12);
                }
            }
            hashtable.put(string2, new ServiceEntry_(string2, string3, string4, bl, string5, string6, string7, l, hashMap));
        }
        return hashtable;
    }

    private void permittedAgentsToProperties(Properties properties, Vector vector, Hashtable hashtable) {
        String string = "Agent.";
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = string + (i + 1);
            String string3 = (String)vector.elementAt(i);
            AbleAgentClassDescription ableAgentClassDescription = (AbleAgentClassDescription)hashtable.get(string3);
            properties.setProperty(string2 + ".Alias", ableAgentClassDescription.getAgentAlias());
            properties.setProperty(string2 + ".AutonomyLevel", this.autonomyLevelToPrefKywd(ableAgentClassDescription.getAutonomyLevel()));
            properties.setProperty(string2 + ".ClassName", ableAgentClassDescription.getClassName());
            properties.setProperty(string2 + ".ConstructorArgs", this.argEntriesToString(ableAgentClassDescription.getConstructorArgs()));
            properties.setProperty(string2 + ".EligiblePrincipals", this.propertyPrincipalsToString(ableAgentClassDescription.getEligiblePrincipals()));
            properties.setProperty(string2 + ".EligibleAgentPools", this.propertyAgentPoolsToString(ableAgentClassDescription.getEligibleAgentPools()));
            properties.setProperty(string2 + ".InitArgs", this.argEntriesToString(ableAgentClassDescription.getInitArgs()));
            properties.setProperty(string2 + ".LastChangedDate", ableAgentClassDescription.getLastChangedDate());
            properties.setProperty(string2 + ".Type", ableAgentClassDescription.getType());
            properties.setProperty(string2 + ".Vendor", ableAgentClassDescription.getVendor());
            properties.setProperty(string2 + ".Version", ableAgentClassDescription.getVersion());
            HashMap hashMap = ableAgentClassDescription.getAgentProperties();
            if (hashMap == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            Set set = hashMap.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string4 = entry.getKey() + ":" + entry.getValue() + (iterator.hasNext() ? "," : "");
                stringBuffer.append(string4);
            }
            properties.setProperty(string2 + ".Properties", stringBuffer.toString());
        }
    }

    private int autonomyLevelFromPrefKywd(String string) {
        if (string.equalsIgnoreCase("Custom")) {
            return 0;
        }
        if (string.equalsIgnoreCase("High")) {
            return 1;
        }
        if (string.equalsIgnoreCase("Medium")) {
            return 2;
        }
        if (string.equalsIgnoreCase("Low")) {
            return 3;
        }
        return 3;
    }

    private String autonomyLevelToPrefKywd(int n) {
        switch (n) {
            case 0: {
                return "Custom";
            }
            case 1: {
                return "High";
            }
            case 2: {
                return "Medium";
            }
            case 3: {
                return "Low";
            }
        }
        return "Low";
    }

    private Hashtable permittedAgentsFromProperties(Properties properties) {
        String string = "permittedAgentsFromProperties(Properties)";
        String string2 = "Agent.";
        Vector<String> vector = new Vector<String>();
        Hashtable<String, AbleAgentClassDescription> hashtable = new Hashtable<String, AbleAgentClassDescription>();
        int n = 1;
        String string3 = string2 + n;
        String string4 = string3 + ".Alias";
        String string5 = properties.getProperty(string4);
        while (string5 != null) {
            Object object;
            Serializable serializable;
            String string6;
            StringTokenizer stringTokenizer;
            String string7 = string5.trim();
            int n2 = 3;
            String string8 = "";
            String string9 = "";
            String string10 = "";
            String string11 = "";
            String string12 = "";
            String string13 = "-Unspecified-";
            String string14 = "-Unspecified-";
            String string15 = "-Unspecified-";
            String string16 = "-Unspecified-";
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            Vector<Object> vector2 = new Vector<Object>();
            Vector<PrincipalEntry_> vector3 = new Vector<PrincipalEntry_>();
            Vector<PrincipalEntry_> vector4 = new Vector<PrincipalEntry_>();
            Vector<Object> vector5 = new Vector<Object>();
            string4 = string3 + ".AutonomyLevel";
            string5 = properties.getProperty(string4);
            if (string5 != null) {
                n2 = this.autonomyLevelFromPrefKywd(string5.trim());
            } else {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string4}));
            }
            string4 = string3 + ".ClassName";
            string5 = properties.getProperty(string4);
            if (string5 != null) {
                string8 = string5.trim();
            } else {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string4}));
            }
            string4 = string3 + ".ConstructorArgs";
            string5 = properties.getProperty(string4);
            if (string5 != null) {
                string9 = string5.trim();
                stringTokenizer = new StringTokenizer(string9, ",");
                string6 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string6 = stringTokenizer.nextToken().trim();
                    vector2.add(this.extractArg(string6));
                }
            } else {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string4}));
            }
            if ((string5 = properties.getProperty(string4 = string3 + ".EligiblePrincipals")) != null) {
                string10 = string5.trim();
                stringTokenizer = new StringTokenizer(string10, ",");
                string6 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string6 = stringTokenizer.nextToken().trim();
                    serializable = this.getPrincipalEntry(string6);
                    if (serializable == null) continue;
                    object = new PrincipalEntry_((PrincipalEntry_)serializable);
                    vector3.add((PrincipalEntry_)object);
                }
            } else {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string4}));
            }
            if ((string5 = properties.getProperty(string4 = string3 + ".EligibleAgentPools")) != null) {
                string11 = string5.trim();
                stringTokenizer = new StringTokenizer(string11, ",");
                string6 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string6 = stringTokenizer.nextToken().trim();
                    serializable = this.getAgentPool(string6);
                    if (serializable == null) continue;
                    object = new AgentPoolEntry_((AgentPoolEntry_)serializable);
                    vector4.add((PrincipalEntry_)object);
                }
            } else {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string4}));
            }
            if ((string5 = properties.getProperty(string4 = string3 + ".InitArgs")) != null) {
                string12 = string5.trim();
                stringTokenizer = new StringTokenizer(string12, ",");
                string6 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string6 = stringTokenizer.nextToken().trim();
                    vector5.add(this.extractArg(string6));
                }
            } else {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string4}));
            }
            if ((string5 = properties.getProperty(string4 = string3 + ".LastChangedDate")) != null) {
                string13 = string5.trim();
            } else {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string4}));
            }
            string4 = string3 + ".Type";
            string5 = properties.getProperty(string4);
            if (string5 != null) {
                string14 = string5.trim();
            } else {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string4}));
            }
            string4 = string3 + ".Vendor";
            string5 = properties.getProperty(string4);
            if (string5 != null) {
                string15 = string5.trim();
            } else {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string4}));
            }
            string4 = string3 + ".Version";
            string5 = properties.getProperty(string4);
            if (string5 != null) {
                string16 = string5.trim();
            } else {
                Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("Pref_PropertyEmpty", new Object[]{string4}));
            }
            string4 = string3 + ".Properties";
            string5 = properties.getProperty(string4);
            if (string5 != null) {
                stringTokenizer = new StringTokenizer(string5.trim(), ",");
                string6 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string6 = stringTokenizer.nextToken().trim();
                    int n3 = string6.indexOf(58);
                    object = string6.substring(0, n3).trim();
                    String string17 = string6.substring(n3 + 1).trim();
                    if (hashMap == null) {
                        hashMap = new HashMap();
                    }
                    hashMap.put(object, string17);
                }
            }
            vector.addElement(string7);
            hashtable.put(string7, new AbleAgentClassDescription(string7, string8, string15, string16, string14, string13, n2, vector2, vector5, vector4, vector3, hashMap));
            string3 = string2 + ++n;
            string4 = string3 + ".Alias";
            string5 = properties.getProperty(string4);
        }
        this.myPermittedAgentOrder = vector;
        return hashtable;
    }

    private Object extractArg(String string) {
        String string2 = "extractArg";
        Object object = null;
        int n = string.indexOf(58);
        String string3 = string.substring(0, n).trim();
        String string4 = string.substring(n + 1).trim();
        if (string3.equalsIgnoreCase("String")) {
            object = new String(string4);
        } else if (string3.equalsIgnoreCase("Boolean")) {
            object = new Boolean(string4);
        } else if (string3.equalsIgnoreCase("Byte")) {
            try {
                object = new Byte(string4);
            }
            catch (NumberFormatException numberFormatException) {
                if (Able.TraceLog != null && Able.TraceLog.isLogging()) {
                    Able.TraceLog.exception(262144L, (Object)this, string2, (Throwable)numberFormatException);
                }
                Able.MessageLog.text(4L, (Object)this, string2, numberFormatException.getLocalizedMessage());
                object = new Byte(0);
            }
        } else if (string3.equalsIgnoreCase("Character")) {
            object = new Character(string4.charAt(0));
        } else if (string3.equalsIgnoreCase("Double")) {
            try {
                object = new Double(string4);
            }
            catch (NumberFormatException numberFormatException) {
                if (Able.TraceLog != null && Able.TraceLog.isLogging()) {
                    Able.TraceLog.exception(262144L, (Object)this, string2, (Throwable)numberFormatException);
                }
                Able.MessageLog.text(4L, (Object)this, string2, numberFormatException.getLocalizedMessage());
                object = new Double(Double.NaN);
            }
        } else if (string3.equalsIgnoreCase("Float")) {
            try {
                object = new Float(string4);
            }
            catch (NumberFormatException numberFormatException) {
                if (Able.TraceLog != null && Able.TraceLog.isLogging()) {
                    Able.TraceLog.exception(262144L, (Object)this, string2, (Throwable)numberFormatException);
                }
                Able.MessageLog.text(4L, (Object)this, string2, numberFormatException.getLocalizedMessage());
                object = new Float(Float.NaN);
            }
        } else if (string3.equalsIgnoreCase("Integer")) {
            try {
                object = new Integer(string4);
            }
            catch (NumberFormatException numberFormatException) {
                if (Able.TraceLog != null && Able.TraceLog.isLogging()) {
                    Able.TraceLog.exception(262144L, (Object)this, string2, (Throwable)numberFormatException);
                }
                Able.MessageLog.text(4L, (Object)this, string2, numberFormatException.getLocalizedMessage());
                object = new Integer(0);
            }
        } else if (string3.equalsIgnoreCase("Long")) {
            try {
                object = new Long(string4);
            }
            catch (NumberFormatException numberFormatException) {
                if (Able.TraceLog != null && Able.TraceLog.isLogging()) {
                    Able.TraceLog.exception(262144L, (Object)this, string2, (Throwable)numberFormatException);
                }
                Able.MessageLog.text(4L, (Object)this, string2, numberFormatException.getLocalizedMessage());
                object = new Long(0L);
            }
        } else if (string3.equalsIgnoreCase("Short")) {
            try {
                object = new Short(string4);
            }
            catch (NumberFormatException numberFormatException) {
                if (Able.TraceLog != null && Able.TraceLog.isLogging()) {
                    Able.TraceLog.exception(262144L, (Object)this, string2, (Throwable)numberFormatException);
                }
                Able.MessageLog.text(4L, (Object)this, string2, numberFormatException.getLocalizedMessage());
                object = new Short(0);
            }
        }
        return object;
    }

    private String argEntriesToString(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Object e = vector.elementAt(i);
            if (e instanceof String) {
                stringBuffer.append("String:");
            } else if (e instanceof Boolean) {
                stringBuffer.append("Boolean:");
            } else if (e instanceof Byte) {
                stringBuffer.append("Byte:");
            } else if (e instanceof Character) {
                stringBuffer.append("Character:");
            } else if (e instanceof Double) {
                stringBuffer.append("Double:");
            } else if (e instanceof Float) {
                stringBuffer.append("Float:");
            } else if (e instanceof Integer) {
                stringBuffer.append("Integer:");
            } else if (e instanceof Long) {
                stringBuffer.append("Long:");
            } else if (e instanceof Short) {
                stringBuffer.append("Short:");
            }
            stringBuffer.append(e.toString());
            if (i >= n - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private String propertyPrincipalsToString(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            PrincipalEntry_ principalEntry_ = (PrincipalEntry_)vector.elementAt(i);
            stringBuffer.append(principalEntry_.getPrincipalAlias());
            if (i >= n - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private String propertyAgentPoolsToString(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            AgentPoolEntry_ agentPoolEntry_ = (AgentPoolEntry_)vector.elementAt(i);
            stringBuffer.append(agentPoolEntry_.getAgentPoolAlias());
            if (i >= n - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private String propertyEntriesToString(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(vector.elementAt(i));
            if (i >= n - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private Vector propertyEntriesFromString(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            vector.add(string2);
        }
        return vector;
    }

    private void debugTrace(String string) {
        try {
            System.err.println("++" + this.getClass().getName() + ": " + string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    public final class ServiceEntry_
    implements Serializable {
        static final long serialVersionUID = 2002080100000000001L;
        private String myServiceAlias = "";
        private String myServiceType = "";
        private String myFactoryClassName = "";
        private String myAgentPoolAlias = "";
        private AgentPoolEntry_ myAgentPoolEntry = null;
        private boolean myPersistenceFlag = false;
        private String myPersistenceDatabase = "";
        private String myPersistenceTable = "";
        private String myPersistenceSchema = "";
        private long myPersistenceRetry = 60000L;
        private HashMap myServiceProperties = null;

        public ServiceEntry_(String string, String string2, String string3, boolean bl, String string4, String string5, String string6, long l, HashMap hashMap) {
            this.myServiceAlias = string;
            this.myServiceType = string;
            this.myFactoryClassName = string3;
            this.myAgentPoolAlias = string2;
            this.myAgentPoolEntry = AblePlatformPreferences.this.getAgentPool(string2);
            this.myPersistenceFlag = bl;
            this.myPersistenceDatabase = string4;
            this.myPersistenceTable = string5;
            this.myPersistenceSchema = string6;
            this.myPersistenceRetry = l;
            this.myServiceProperties = hashMap;
        }

        public ServiceEntry_(ServiceEntry_ serviceEntry_) {
            this.myServiceAlias = serviceEntry_.getServiceAlias();
            this.myServiceType = serviceEntry_.getServiceType();
            this.myFactoryClassName = serviceEntry_.getFactoryClassName();
            this.myAgentPoolAlias = serviceEntry_.getAgentPoolAlias();
            this.myAgentPoolEntry = new AgentPoolEntry_(AblePlatformPreferences.this.getAgentPool(this.myAgentPoolAlias));
            this.myPersistenceFlag = serviceEntry_.getPersistenceFlag();
            this.myPersistenceDatabase = serviceEntry_.getPersistenceDatabase();
            this.myPersistenceTable = serviceEntry_.getPersistenceTable();
            this.myPersistenceSchema = serviceEntry_.getPersistenceSchema();
            this.myPersistenceRetry = serviceEntry_.getPersistenceRetry();
            this.myServiceProperties = serviceEntry_.getServiceProperties();
        }

        public String getServiceAlias() {
            return this.myServiceAlias;
        }

        public String getServiceType() {
            return this.myServiceType;
        }

        public String getFactoryClassName() {
            return this.myFactoryClassName;
        }

        public String getAgentPoolAlias() {
            return this.myAgentPoolAlias;
        }

        public AgentPoolEntry_ getAgentPoolInfo() {
            return this.myAgentPoolEntry;
        }

        public boolean getPersistenceFlag() {
            return this.myPersistenceFlag;
        }

        public String getPersistenceDatabase() {
            return this.myPersistenceDatabase;
        }

        public String getPersistenceTable() {
            return this.myPersistenceTable;
        }

        public String getPersistenceSchema() {
            return this.myPersistenceSchema;
        }

        public long getPersistenceRetry() {
            return this.myPersistenceRetry;
        }

        public HashMap getServiceProperties() {
            return this.myServiceProperties;
        }
    }

    public final class AgentPoolEntry_
    implements Serializable {
        static final long serialVersionUID = 2002080100000000001L;
        private String myAgentPoolAlias = "";
        private String myIpAddress = "";
        private String myPort = "";
        private String myPrincipalAlias = "";

        public AgentPoolEntry_(String string, String string2, String string3, String string4) {
            this.myAgentPoolAlias = string;
            this.myIpAddress = string2;
            this.myPort = string3;
            this.myPrincipalAlias = string4;
        }

        public AgentPoolEntry_(AgentPoolEntry_ agentPoolEntry_) {
            this.myAgentPoolAlias = agentPoolEntry_.getAgentPoolAlias();
            this.myIpAddress = agentPoolEntry_.getIpAddress();
            this.myPort = agentPoolEntry_.getPort();
            this.myPrincipalAlias = agentPoolEntry_.getPrincipalAlias();
        }

        public String getAgentPoolAlias() {
            return this.myAgentPoolAlias;
        }

        public String getIpAddress() {
            return this.myIpAddress;
        }

        public String getPort() {
            return this.myPort;
        }

        public String getPrincipalAlias() {
            return this.myPrincipalAlias;
        }

        public String getPrincipal() {
            return this.myPrincipalAlias.trim().length() != 0 ? ((PrincipalEntry_)AblePlatformPreferences.this.myPrincipals.get(this.myPrincipalAlias)).getPrincipal() : "";
        }

        public String prettyPrint() {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append("\n\tAgentPool alias...\t");
            stringBuffer.append(this.myAgentPoolAlias);
            stringBuffer.append("\n\tIpAddress.........\t");
            stringBuffer.append(this.myIpAddress);
            stringBuffer.append("\n\tPort..............\t");
            stringBuffer.append(this.myPort);
            stringBuffer.append("\n\tPrincipalAlias....\t");
            stringBuffer.append(this.myPrincipalAlias);
            stringBuffer.append("\n\tPrincipal.........\t");
            stringBuffer.append(this.myPrincipalAlias.trim().length() != 0 ? ((PrincipalEntry_)AblePlatformPreferences.this.myPrincipals.get(this.myPrincipalAlias)).getPrincipal() : "");
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }

    public final class TrustLevelEntry_
    implements Serializable {
        static final long serialVersionUID = 2002080100000000001L;
        private String myTrustLevelAlias = "";
        private int myTrustLevelRank = -1;
        private Vector myPrincipalAliases = new Vector();

        public TrustLevelEntry_(String string, int n, Vector vector) {
            this.myTrustLevelAlias = string;
            this.myTrustLevelRank = n;
            this.myPrincipalAliases = vector;
        }

        public TrustLevelEntry_(TrustLevelEntry_ trustLevelEntry_) {
            this.myTrustLevelAlias = trustLevelEntry_.getTrustLevelAlias();
            this.myTrustLevelRank = trustLevelEntry_.getTrustLevelRank();
            this.myPrincipalAliases = trustLevelEntry_.getPrincipalAliases();
        }

        public String getTrustLevelAlias() {
            return this.myTrustLevelAlias;
        }

        public int getTrustLevelRank() {
            return this.myTrustLevelRank;
        }

        public Vector getPrincipalAliases() {
            return this.myPrincipalAliases;
        }

        public String getPrincipal(String string) {
            return ((PrincipalEntry_)AblePlatformPreferences.this.myPrincipals.get(string)).getPrincipal();
        }

        public String prettyPrint() {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append("\n\tTrustLevel alias.......\t");
            stringBuffer.append(this.myTrustLevelAlias);
            stringBuffer.append("\n\tTrustLevel rank........\t");
            stringBuffer.append(this.myTrustLevelRank);
            stringBuffer.append("\n\tPrincipal aliases......\t");
            stringBuffer.append(this.myPrincipalAliases);
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }

    public final class PrincipalEntry_
    implements Serializable {
        static final long serialVersionUID = 2002080100000000001L;
        private String myPrincipalAlias = "";
        private String myPrincipal = "";

        public PrincipalEntry_(String string, String string2) {
            this.myPrincipalAlias = string;
            this.myPrincipal = string2;
        }

        public PrincipalEntry_(PrincipalEntry_ principalEntry_) {
            this.myPrincipalAlias = principalEntry_.getPrincipalAlias();
            this.myPrincipal = principalEntry_.getPrincipal();
        }

        public String getPrincipalAlias() {
            return this.myPrincipalAlias;
        }

        public String getPrincipal() {
            return this.myPrincipal;
        }

        public String prettyPrint() {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append("\n\tPrincipal alias...\t");
            stringBuffer.append(this.myPrincipalAlias);
            stringBuffer.append("\n\tPrincipal.........\t");
            stringBuffer.append(this.myPrincipal);
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }
}

