/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.platform;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.AbleMessageContainer;
import com.ibm.able.AbleRemoteDefaultAgent;
import com.ibm.able.AbleState;
import com.ibm.able.AbleUserDefinedFunction;
import com.ibm.able.platform.AbleAgentCapability;
import com.ibm.able.platform.AbleAgentSituation;
import com.ibm.able.platform.AbleAgentSituationReport;
import com.ibm.able.platform.AbleJasMessageListener;
import com.ibm.able.platform.AblePlatform;
import com.ibm.able.platform.AblePlatformAgent;
import com.ibm.able.platform.AbleSecureKey;
import com.ibm.able.platform.AbleSecuritySupport;
import com.ibm.able.platform.AgentLoggingException;
import com.ibm.able.platform.AgentLoggingService;
import com.ibm.able.platform.VerifiableAgentDirectoryService;
import com.ibm.able.platform.VerifiableAgentName;
import com.ibm.able.platform.VerifiableAgentNamingService;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.KeyPair;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.agent.AgentName;
import javax.agent.Envelope;
import javax.agent.JasBean;
import javax.agent.Locator;
import javax.agent.Payload;
import javax.agent.TransportMessage;
import javax.agent.service.ServiceRoot;
import javax.agent.service.directory.AgentDescription;
import javax.agent.service.directory.AgentDirectoryService;
import javax.agent.service.directory.AlreadyRegisteredException;
import javax.agent.service.directory.DirectoryFailure;
import javax.agent.service.directory.NotRegisteredException;
import javax.agent.service.directory.SearchException;
import javax.agent.service.naming.AgentNamingService;
import javax.agent.service.naming.NamingException;
import javax.agent.service.naming.NamingFailure;
import javax.agent.service.transport.MessageListener;
import javax.agent.service.transport.MessageReceiver;
import javax.agent.service.transport.MessageTransportService;
import javax.agent.service.transport.NotLocatableException;
import javax.agent.service.transport.TransportFailure;
import javax.agent.service.transport.TransportSystem;
import org.jagent.acr.AclMessage;
import org.jagent.acr.AcrAgentName;
import org.jagent.acr.AcrElementHelper;
import org.jagent.acr.AcrEnvelope;
import org.jagent.acr.AcrNode;
import org.jagent.acr.AcrObject;
import org.jagent.acr.AcrPayload;
import org.jagent.acr.AcrString;

public class AblePlatformDefaultAgent
extends AbleRemoteDefaultAgent
implements AblePlatformAgent,
MessageListener,
Serializable {
    static final long serialVersionUID = 2002080100000000001L;
    private String myAgentNameUniqueID = null;
    private boolean myRestartedFromPersistence = false;
    private int agentAutonomyLevel = 3;
    protected Date agentLastUpdate = new Date();
    protected String agentStatus = "Initialized";
    protected AbleMessageContainer agentSummary = new AbleMessageContainer("--No summary available--");
    protected String agentType = "-Other-";
    protected String agentVendor = "";
    protected String agentVersion = "";
    protected boolean agentToAutoRegister = true;
    protected boolean agentToBindToRmi = false;
    protected boolean agentMovable = false;
    protected Hashtable myJasAgentAttributes = new Hashtable();
    protected Vector myAgentInboxes = new Vector();
    protected String myPrincipal = "";
    protected ServiceRoot myJasServiceRoot = null;
    protected AgentDirectoryService myJasAgentDirectoryService = null;
    protected VerifiableAgentDirectoryService myJasVerifiableDirectoryService = null;
    protected AgentNamingService myJasAgentNamingService = null;
    protected VerifiableAgentNamingService myJasVerifiableNamingService = null;
    protected TransportSystem myJasTransportSystem = null;
    protected AgentName myJasAgentName = null;
    protected VerifiableAgentName myVerifiableAgentName = null;
    protected String myTrustLevel = "";
    protected AgentDescription myJasAgentDescription = null;
    protected MessageTransportService myJasMessageTransportService = null;
    protected Locator myJasDefaultLocator = null;
    protected Locator myJasAbleLocator = null;
    protected AbleUserDefinedFunction myReceiveMessageMethod = null;
    protected KeyPair myKeyPair = null;
    protected AbleSecureKey myRequestKey = null;
    protected transient AbleSecuritySupport mySecSppt = null;
    private boolean agentIsRegistered = false;
    private boolean agentIsBoundToRmi = false;
    protected AgentLoggingService myAgentLoggingService = null;
    protected Map myCapabilities = new HashMap();
    protected Vector myCapabilityOrder = new Vector();
    protected Map myHighCapabilityAutonomyLevels = new HashMap();
    protected Map myMediumCapabilityAutonomyLevels = new HashMap();
    protected Map myLowCapabilityAutonomyLevels = new HashMap();
    protected Map myCustomCapabilityAutonomyLevels = new HashMap();
    static /* synthetic */ Class class$javax$agent$TransportMessage;

    public int getAgentAutonomyLevel() throws AbleException {
        return this.agentAutonomyLevel;
    }

    public void setAgentAutonomyLevel(int n, AbleSecureKey ableSecureKey) throws AbleException {
        String string = "setAgentAutonomyLevel(int, AbleSecureKey)";
        this.verifyKey(ableSecureKey, string);
        this.authorizeCapabilityChangeRequest(ableSecureKey);
        this.setAgentAutonomyLevel(n);
    }

    private void setAgentAutonomyLevel(int n) throws AbleException {
        String string = "setAgentAutonomyLevel(int)";
        if (this.agentAutonomyLevel == n) {
            return;
        }
        switch (n) {
            case 3: {
                this.agentAutonomyLevel = n;
                this.updateCapabilitiesWithMap(this.myLowCapabilityAutonomyLevels, false);
                break;
            }
            case 2: {
                this.agentAutonomyLevel = n;
                this.updateCapabilitiesWithMap(this.myMediumCapabilityAutonomyLevels, false);
                break;
            }
            case 1: {
                this.agentAutonomyLevel = n;
                this.updateCapabilitiesWithMap(this.myHighCapabilityAutonomyLevels, false);
                break;
            }
            case 0: {
                this.agentAutonomyLevel = n;
                this.updateCapabilitiesWithMap(this.myCustomCapabilityAutonomyLevels, false);
                break;
            }
            default: {
                throw new AbleException(AblePlatform.NlsMsg("UnableToSetAutonomyLevel", new Object[]{Integer.toString(n)}));
            }
        }
        if (this.myJasAgentDescription != null) {
            this.myJasAgentDescription.set("com.ibm.able.platform.agent-autonomy-level", (Object)new Integer(n));
            this.updateDescriptionWithAgentDirectoryService();
        }
    }

    private Date setAgentLastUpdate() {
        this.agentLastUpdate = new Date();
        return this.agentLastUpdate;
    }

    public Date getAgentLastUpdate() throws AbleException {
        return this.agentLastUpdate;
    }

    public String getAgentStatus() throws AbleException {
        return AbleState.State((int)this.getState());
    }

    public void setAgentSummary(AbleMessageContainer ableMessageContainer) {
        this.agentSummary = ableMessageContainer;
    }

    public AbleMessageContainer getAgentSummary() throws AbleException {
        return this.agentSummary;
    }

    public void setAgentType(String string) {
        this.agentType = string;
    }

    public String getAgentType() throws AbleException {
        return this.agentType;
    }

    public void setAgentVendor(String string) {
        this.agentVendor = string;
    }

    public String getAgentVendor() throws AbleException {
        return this.agentVendor;
    }

    public void setAgentVersion(String string) {
        this.agentVersion = string;
    }

    public String getAgentVersion() throws AbleException {
        return this.agentVersion;
    }

    public void setAgentToAutoRegister(boolean bl) {
        this.agentToAutoRegister = bl;
    }

    public boolean isAgentToAutoRegister() throws AbleException {
        return this.agentToAutoRegister;
    }

    public void setAgentToBindToRmi(boolean bl) {
        this.agentToBindToRmi = bl;
    }

    public boolean isAgentToBindToRmi() throws AbleException {
        return this.agentToBindToRmi;
    }

    public void setAgentMovable(boolean bl) {
        this.agentMovable = bl;
    }

    public boolean isAgentMovable() throws AbleException {
        return this.agentMovable;
    }

    public void addJasAgentAttribute(String string, Object object) {
        this.myJasAgentAttributes.put(string, object);
    }

    public void removeJasAgentAttribute(String string) {
        this.myJasAgentAttributes.remove(string);
    }

    public Hashtable getJasAgentAttributes() throws AbleException {
        return (Hashtable)this.myJasAgentAttributes.clone();
    }

    public String getJasAgentName() throws AbleException {
        return this.myJasAgentName != null ? this.myJasAgentName.toString() : null;
    }

    public AgentName getPlatformAgentName() throws AbleException {
        return this.myJasAgentName;
    }

    public Vector getAgentInboxes() {
        return (Vector)this.myAgentInboxes.clone();
    }

    public void addAgentInbox(Object[] objectArray) {
        this.myAgentInboxes.add(objectArray);
    }

    public void removeAgentInbox(Object[] objectArray) {
        this.myAgentInboxes.remove(objectArray);
    }

    public void removeAgentInboxes() {
        this.myAgentInboxes.removeAllElements();
    }

    public void setPrincipal(String string) {
        this.myPrincipal = string;
    }

    public String getPrincipal() {
        return this.myPrincipal;
    }

    public AblePlatformDefaultAgent() throws RemoteException, AbleException {
        this.ctorHelper();
    }

    public AblePlatformDefaultAgent(String string) throws RemoteException, AbleException {
        super(string);
        this.ctorHelper();
    }

    public AblePlatformDefaultAgent(String string, String string2) throws RemoteException, AbleException {
        super(string, string2);
        this.ctorHelper();
    }

    private void ctorHelper() throws AbleException {
        this.setReceiveMessageMethod();
        if (Able.Preferences.isSecure()) {
            this.myKeyPair = AblePlatform.generateKeyPair();
        }
    }

    public void preInit() throws AbleException {
        if (this.myJasServiceRoot == null) {
            this.getAndValidateServiceRoot();
            this.getAndSetAgentNames();
        } else if (this.myJasAgentName == null) {
            this.getAndSetAgentNames();
        }
    }

    public void preInit(String string) throws AbleException {
        this.myAgentNameUniqueID = string;
        this.myRestartedFromPersistence = true;
        this.preInit();
        try {
            AgentDescription agentDescription = this.myJasAgentDirectoryService.createAgentDescription();
            agentDescription.setAgentName(this.myJasAgentName);
            if (Able.Preferences.isSecure()) {
                AbleSecureKey ableSecureKey = this.mySecSppt.generateKey();
                this.myJasVerifiableDirectoryService.deregister(agentDescription, ableSecureKey);
            } else {
                this.myJasAgentDirectoryService.deregister(agentDescription);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
        }
        catch (Exception exception) {
            throw new AbleException(AblePlatform.NlsMsg("UnableToDeregisterInPreinit", new Object[]{exception.getLocalizedMessage()}));
        }
    }

    public void setAgentNameUniqueID(String string) throws AbleException {
        if (this.myAgentNameUniqueID == null && this.myVerifiableAgentName == null) {
            this.myAgentNameUniqueID = string;
        }
    }

    public void setRestartedFromPersistence(boolean bl) throws AbleException {
        this.myRestartedFromPersistence = bl;
    }

    public void initializeAgent(AbleSecureKey ableSecureKey) throws AbleException, NamingException {
        String string = "initializeAgent(AbleSecureKey)";
        if (Able.Preferences.isSecure()) {
            this.mySecSppt.verifyKey(ableSecureKey);
            this.mySecSppt.verifyTrustLevel(ableSecureKey, string);
        }
        this._init();
    }

    public void initializeAgent(Object object, AbleSecureKey ableSecureKey) throws AbleException, NamingException {
        String string = "initializeAgent(AbleSecureKey,Object)";
        if (Able.Preferences.isSecure()) {
            this.mySecSppt.verifyKey(ableSecureKey);
            this.mySecSppt.verifyTrustLevel(ableSecureKey, string);
        }
        this._init(object);
    }

    public void quitAgent(AbleSecureKey ableSecureKey) throws AbleException, NamingException {
        String string = "quitAgent(AbleSecureKey)";
        if (Able.Preferences.isSecure()) {
            this.mySecSppt.verifyKey(ableSecureKey);
            this.mySecSppt.verifyTrustLevel(ableSecureKey, string);
        }
        this._quitAll();
    }

    public void suspendAgent(AbleSecureKey ableSecureKey) throws AbleException, NamingException {
        String string = "suspendAgent(AbleSecureKey)";
        if (Able.Preferences.isSecure()) {
            this.mySecSppt.verifyKey(ableSecureKey);
            this.mySecSppt.verifyTrustLevel(ableSecureKey, string);
        }
        this._suspendAll();
    }

    public void resumeAgent(AbleSecureKey ableSecureKey) throws AbleException, NamingException {
        String string = "resumeAgent(AbleSecureKey)";
        if (Able.Preferences.isSecure()) {
            this.mySecSppt.verifyKey(ableSecureKey);
            this.mySecSppt.verifyTrustLevel(ableSecureKey, string);
        }
        this._resumeAll();
    }

    public void resetAgent(AbleSecureKey ableSecureKey) throws AbleException, NamingException {
        String string = "resetAgent(AbleSecureKey)";
        if (Able.Preferences.isSecure()) {
            this.mySecSppt.verifyKey(ableSecureKey);
            this.mySecSppt.verifyTrustLevel(ableSecureKey, string);
        }
        this._reset();
    }

    public AgentDescription getAgentDescription() {
        return this.myJasAgentDescription;
    }

    public void receiveMessage(TransportMessage transportMessage) {
        String string = "receiveMessage(TransportMessage)";
        try {
            this.process(transportMessage);
        }
        catch (AbleException ableException) {
            this.logException(string, (Exception)((Object)ableException));
        }
    }

    public void init() throws AbleException {
        String string = "init()";
        if (Able.Preferences.isSecure()) {
            Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("SecOn_UseNotPermitted"));
            return;
        }
        this._init();
    }

    public void init(Object object) throws AbleException {
        String string = "init(Object)";
        if (Able.Preferences.isSecure()) {
            Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("SecOn_UseNotPermitted"));
            return;
        }
        this._init(object);
    }

    public void reset() throws AbleException {
        String string = "reset()";
        if (Able.Preferences.isSecure()) {
            Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("SecOn_UseNotPermitted"));
            return;
        }
        this._reset();
    }

    public Object process(Object object) throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.text(262144L, (Object)this, "process(Object)", "ABLE platform default agent processing message: \n" + object);
        }
        return object;
    }

    public void quitAll() throws AbleException {
        String string = "quitAll()";
        if (Able.Preferences.isSecure()) {
            Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("SecOn_UseNotPermitted"));
            return;
        }
        this._quitAll();
    }

    public void suspendAll() throws AbleException {
        String string = "suspendAll()";
        if (Able.Preferences.isSecure()) {
            Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("SecOn_UseNotPermitted"));
            return;
        }
        this._suspendAll();
    }

    public void resumeAll() throws AbleException {
        String string = "resumeAll()";
        if (Able.Preferences.isSecure()) {
            Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("SecOn_UseNotPermitted"));
            return;
        }
        this._resumeAll();
    }

    protected void _init() throws AbleException {
        this._init2();
        super.init();
        this.updateAgentDescription();
        this.initCommonCode(null);
    }

    protected void _init(Object object) throws AbleException {
        this._init2();
        super.init(object);
        this.updateAgentDescription();
        this.initCommonCode(object);
    }

    private void _init2() throws AbleException {
        String string = "_init2()";
        this.preInit();
        this.getAndSetAgentDescription();
        this.getAndSetTransportServices();
        this.loadAgentDescriptionWithBaseLocators();
        this.loadAgentDescriptionWithAbleLocator();
        this.maybeRegisterWithAgentDirectoryService(this.agentToAutoRegister);
        this.maybeRebindToRmi(this.agentToBindToRmi);
        this.updateAgentDescription();
    }

    protected void _reset() throws AbleException {
        String string = "_reset()";
        super.reset();
        this.updateAgentDescription();
    }

    protected void _quitAll() {
        String string = "_quitAll()";
        if (this.myAgentLoggingService != null) {
            AbleSecureKey ableSecureKey = null;
            try {
                if (Able.Preferences.isSecure()) {
                    ableSecureKey = this.mySecSppt.generateKey();
                }
                this.myAgentLoggingService.removeAgentLogs(this.myJasAgentName, ableSecureKey);
            }
            catch (NamingException namingException) {
                this.logException(string, (Exception)((Object)namingException));
            }
            catch (AgentLoggingException agentLoggingException) {
                this.logException(string, (Exception)((Object)agentLoggingException));
            }
        }
        try {
            super.quitAll();
            this.maybeDeregisterWithAgentDirectoryService();
            this.maybeUnbindFromRmi();
        }
        catch (AbleException ableException) {
            this.logException(string, (Exception)((Object)ableException));
        }
        if (Able.Preferences.isSecure()) {
            try {
                this.myJasVerifiableNamingService.closeConversation(this.myPrincipal, this.mySecSppt.generateKey());
                this.myJasVerifiableNamingService.releaseAgentName(this.mySecSppt.generateKey());
            }
            catch (NamingException namingException) {
                this.logException(string, (Exception)((Object)namingException));
            }
        }
        this.myJasServiceRoot = null;
        this.myJasAgentDirectoryService = null;
        this.myJasVerifiableDirectoryService = null;
        this.myJasAgentNamingService = null;
        this.myJasVerifiableNamingService = null;
        this.myJasTransportSystem = null;
        this.myJasAgentName = null;
        this.myVerifiableAgentName = null;
        this.myTrustLevel = null;
        this.myJasAgentDescription = null;
        this.myJasAgentAttributes = null;
        this.myAgentInboxes = null;
        this.myPrincipal = null;
        this.myJasMessageTransportService = null;
        this.myJasDefaultLocator = null;
        this.myJasAbleLocator = null;
        this.myReceiveMessageMethod = null;
        this.myKeyPair = null;
        this.myRequestKey = null;
        this.state.setState(1020);
    }

    protected void _suspendAll() throws AbleException {
        String string = "_suspendAll()";
        super.suspendAll();
        this.updateAgentDescription();
    }

    protected void _resumeAll() throws AbleException {
        String string = "_resumeAll()";
        super.resumeAll();
        this.updateAgentDescription();
    }

    private void updateAgentDescription() throws AbleException {
        if (this.agentIsRegistered) {
            this.myJasAgentDescription.set("com.ibm.able.platform.agent-status", (Object)this.getAgentStatus());
            this.updateDescriptionWithAgentDirectoryService();
        }
    }

    protected void getAndValidateServiceRoot() throws AbleException {
        String string = "getAndValidateServiceRoot()";
        this.myJasServiceRoot = AblePlatform.getServiceRoot(null);
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, string, "ABLE platform default agent obtained ServiceRoot <" + this.myJasServiceRoot + ">.");
        }
        this.myJasAgentNamingService = this.myJasServiceRoot.getAgentNamingService();
        if (this.myJasAgentNamingService == null) {
            this.logger.text(4L, (Object)this, string, AblePlatform.NlsMsg("UnableToObtainService", new Object[]{"AgentNamingService"}));
            throw new AbleException(AblePlatform.NlsMsg("UnableToObtainService", new Object[]{"AgentNamingService"}));
        }
        this.myJasAgentDirectoryService = this.myJasServiceRoot.getAgentDirectoryService();
        if (this.myJasAgentDirectoryService == null) {
            this.logger.text(4L, (Object)this, string, AblePlatform.NlsMsg("UnableToObtainService", new Object[]{"AgentDirectoryService"}));
            throw new AbleException(AblePlatform.NlsMsg("UnableToObtainService", new Object[]{"AgentDirectoryService"}));
        }
        this.myJasTransportSystem = this.myJasServiceRoot.getTransportSystem();
        if (this.myJasTransportSystem == null) {
            this.logger.text(4L, (Object)this, string, AblePlatform.NlsMsg("UnableToObtainService", new Object[]{"TransportSystem"}));
            throw new AbleException(AblePlatform.NlsMsg("UnableToObtainService", new Object[]{"TransportSystem"}));
        }
        if (Able.Preferences.isSecure()) {
            this.myJasVerifiableNamingService = (VerifiableAgentNamingService)this.myJasAgentNamingService;
            this.myJasVerifiableDirectoryService = (VerifiableAgentDirectoryService)this.myJasAgentDirectoryService;
        }
    }

    protected void getAndSetAgentNames() throws AbleException {
        String string = "getAndSetAgentNames()";
        try {
            if (Able.Preferences.isSecure()) {
                if (this.myRequestKey != null) {
                    this.myJasAgentName = this.myJasVerifiableNamingService.createAgentName(this.myKeyPair.getPublic(), this.myPrincipal, this.myAgentNameUniqueID, this.myRequestKey);
                    this.myVerifiableAgentName = (VerifiableAgentName)this.myJasAgentName;
                    this.myTrustLevel = this.myVerifiableAgentName.getLevel();
                    this.myPrincipal = this.myVerifiableAgentName.getKerbPrincipal();
                    this.mySecSppt = new AbleSecuritySupport(this.myKeyPair, this.myVerifiableAgentName, this.myJasVerifiableNamingService, this.logger, this.trace);
                    if (this.trace.isLogging()) {
                        this.trace.text(0x100000L, (Object)this, string, "Just got a VerifiableAgentName using an AbleSecureKey. Principal = <" + this.myPrincipal + ">;  level = <" + this.myVerifiableAgentName.getLevel() + ">.");
                    }
                } else {
                    String string2 = "";
                    if (this.myPrincipal.trim().length() == 0) {
                        throw new AbleException(AblePlatform.NlsMsg("SecOn_DefaultAgentHasNoPrincipal"));
                    }
                    string2 = this.myPrincipal;
                    this.myJasAgentName = this.myJasVerifiableNamingService.createAgentName(this.myKeyPair.getPublic(), this.myPrincipal, this.myAgentNameUniqueID);
                    this.myVerifiableAgentName = (VerifiableAgentName)this.myJasAgentName;
                    this.myTrustLevel = this.myVerifiableAgentName.getLevel();
                    this.mySecSppt = new AbleSecuritySupport(this.myKeyPair, this.myVerifiableAgentName, this.myJasVerifiableNamingService, this.logger, this.trace);
                    if (this.trace.isLogging()) {
                        this.trace.text(0x100000L, (Object)this, string, "AblePlatformDefaultAgent obtained a VerifiableAgentName. Principal is = <" + this.myPrincipal + ">.");
                    }
                }
            } else {
                this.myJasAgentName = this.myRestartedFromPersistence ? new AcrAgentName(this.myAgentNameUniqueID) : this.myJasAgentNamingService.createAgentName();
                if (this.trace.isLogging()) {
                    this.trace.text(0x100000L, (Object)this, string, "AblePlatformDefaultAgent obtained a (nonverifiable) AgentName.");
                }
            }
        }
        catch (NamingException namingException) {
            this.logException(string, (Exception)((Object)namingException));
            throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_ExceptionGettingGUID"), (Throwable)namingException);
        }
        catch (NamingFailure namingFailure) {
            this.logException(string, (Exception)((Object)namingFailure));
            throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_ExceptionGettingGUID"), (Throwable)namingFailure);
        }
    }

    protected void getAndSetAgentDescription() throws AbleException {
        String string = "getAndSetAgentDescription()";
        this.getNewAgentDescription();
        this.loadAgentDescriptionWithAgentName();
        this.loadAgentDescriptionWithPublicKey();
        this.loadAgentDescriptionWithAbleAttributes();
        this.loadAgentDescriptionWithUserAttributes();
    }

    protected void getNewAgentDescription() throws AbleException {
        String string = "getNewAgentDescription()";
        this.myJasAgentDescription = this.myJasAgentDirectoryService.createAgentDescription();
    }

    protected void loadAgentDescriptionWithAgentName() throws AbleException {
        String string = "loadAgentDescriptionWithAgentName()";
        this.myJasAgentDescription.setAgentName(this.myJasAgentName);
    }

    protected void loadAgentDescriptionWithPublicKey() {
        String string = "loadAgentDescriptionWithPublicKey()";
        if (Able.Preferences.isSecure()) {
            this.myJasAgentDescription.set("com.ibm.able.platform.agent-public-key", (Object)this.myKeyPair.getPublic());
        }
    }

    protected void loadAgentDescriptionWithAbleAttributes() throws AbleException {
        String string = "loadAgentDescriptionWithAbleAttributes()";
        String string2 = AblePlatform.Preferences.aliasOfLocalAgentPool();
        String string3 = AblePlatform.Preferences.getAgentPool(string2).getIpAddress();
        this.myJasAgentDescription.set("com.ibm.able.platform.agent-autonomy-level", (Object)new Integer(this.agentAutonomyLevel));
        this.myJasAgentDescription.set("javax.agent.agent-display-name", (Object)this.getName());
        this.myJasAgentDescription.set("com.ibm.able.platform.agent-description", (Object)this.getComment());
        this.myJasAgentDescription.set("com.ibm.able.platform.agent-movable", (Object)new Boolean(this.agentMovable));
        this.myJasAgentDescription.set("com.ibm.able.platform.agent-last-update", (Object)this.getAgentLastUpdate());
        this.myJasAgentDescription.set("com.ibm.able.platform.agent-rmi-address", (Object)this.getAgentAddr());
        this.myJasAgentDescription.set("com.ibm.able.platform.agent-rmi-host", (Object)this.getAgentHost());
        this.myJasAgentDescription.set("com.ibm.able.platform.agent-rmi-name", (Object)this.getAgentName());
        this.myJasAgentDescription.set("com.ibm.able.platform.agent-status", (Object)this.getAgentStatus());
        this.myJasAgentDescription.set("com.ibm.able.platform.agent-summary", (Object)this.agentSummary);
        this.myJasAgentDescription.set("com.ibm.able.platform.agent-type", (Object)this.agentType);
        this.myJasAgentDescription.set("com.ibm.able.platform.agent-vendor", (Object)this.agentVendor);
        this.myJasAgentDescription.set("com.ibm.able.platform.agent-version", (Object)this.agentVersion);
        this.myJasAgentDescription.set("com.ibm.able.platform.agent-agent-pool", (Object)string2);
        this.myJasAgentDescription.set("com.ibm.able.platform.agent-pool-system", (Object)string3);
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, string, "ABLE platform default agent AgentDescription: \n" + this.myJasAgentDescription);
        }
    }

    protected void loadAgentDescriptionWithUserAttributes() throws AbleException {
        String string = "loadAgentDescriptionWithUserAttributes()";
        Enumeration enumeration = this.myJasAgentAttributes.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            this.myJasAgentDescription.set(string2, this.myJasAgentAttributes.get(string2));
        }
    }

    protected void getAndSetTransportServices() throws AbleException {
        String string = "getAndSetTransportServices()";
        MessageTransportService[] messageTransportServiceArray = null;
        try {
            messageTransportServiceArray = this.myJasTransportSystem.getMessageTransportServices();
        }
        catch (TransportFailure transportFailure) {
            this.logException(string, (Exception)((Object)transportFailure));
            throw new AbleException(transportFailure.getLocalizedMessage(), (Throwable)transportFailure);
        }
        if (messageTransportServiceArray.length == 0) {
            this.logger.text(4L, (Object)this, string, AblePlatform.NlsMsg("Ex_APDA_NoMessageTransportService"));
            throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_NoMessageTransportService"));
        }
        for (int i = 0; i < messageTransportServiceArray.length; ++i) {
            if (!this.trace.isLogging()) continue;
            this.trace.text(0x100000L, (Object)this, string, "mts: " + i + " : " + messageTransportServiceArray[i]);
        }
        this.myJasMessageTransportService = messageTransportServiceArray[0];
    }

    protected void loadAgentDescriptionWithBaseLocators() throws AbleException {
        String string = "loadAgentDescriptionWithBaseLocators()";
        Locator locator = null;
        if (this.myAgentInboxes.isEmpty()) {
            locator = this.createLocatorAndBindToMethod("", this.myReceiveMessageMethod);
            this.myJasAgentDescription.addLocator(locator);
            this.myJasDefaultLocator = locator;
        } else {
            for (int i = 0; i < this.myAgentInboxes.size(); ++i) {
                Object[] objectArray = (Object[])this.myAgentInboxes.elementAt(i);
                locator = this.createLocatorAndBindToMethod((String)objectArray[0], (AbleUserDefinedFunction)objectArray[1]);
                this.myJasAgentDescription.addLocator(locator);
                if (i != 0) continue;
                this.myJasDefaultLocator = locator;
            }
        }
    }

    protected Locator createLocatorAndBindToMethod(String string, AbleUserDefinedFunction ableUserDefinedFunction) throws AbleException {
        String string2 = "createLocatorAndBindToMethod(String, AbleUserDefinedFunction)";
        MessageReceiver messageReceiver = null;
        Locator locator = null;
        String string3 = AblePlatform.Preferences.portOfLocalAgentPool();
        try {
            locator = this.myJasMessageTransportService.newLocalLocator(string3);
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, string2, "Obtained Locator for port <" + string3 + ">: " + locator);
            }
        }
        catch (TransportFailure transportFailure) {
            this.logException(string2, (Exception)((Object)transportFailure));
            throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_NoRmiLocator"), (Throwable)transportFailure);
        }
        try {
            messageReceiver = this.myJasMessageTransportService.newMessageReceiver();
        }
        catch (TransportFailure transportFailure) {
            this.logException(string2, (Exception)((Object)transportFailure));
            throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_NoMessageReceiver"), (Throwable)transportFailure);
        }
        try {
            messageReceiver.addMessageListener((MessageListener)new AbleJasMessageListener(this, string, ableUserDefinedFunction));
        }
        catch (TransportFailure transportFailure) {
            this.logException(string2, (Exception)((Object)transportFailure));
            throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_CannotAddSelfAsMessageListener"), (Throwable)transportFailure);
        }
        try {
            messageReceiver.bindToLocalLocator(locator);
        }
        catch (NotLocatableException notLocatableException) {
            this.logException(string2, (Exception)((Object)notLocatableException));
            throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_CannotBindReceiverToLocator"), (Throwable)notLocatableException);
        }
        catch (TransportFailure transportFailure) {
            this.logException(string2, (Exception)((Object)transportFailure));
            throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_CannotBindReceiverToLocator"), (Throwable)transportFailure);
        }
        locator.set("com.ibm.able.platform.able-locator-protocol", (Object)string);
        return locator;
    }

    protected void loadAgentDescriptionWithAbleLocator() throws AbleException {
        String string = "loadAgentDescriptionWithAbleLocator()";
        String string2 = AblePlatform.Preferences.portOfLocalAgentPool();
        try {
            this.myJasAbleLocator = this.myJasMessageTransportService.newLocalLocator(string2);
        }
        catch (TransportFailure transportFailure) {
            this.logException(string, (Exception)((Object)transportFailure));
            throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_NoAbleLocator"), (Throwable)transportFailure);
        }
        this.myJasAbleLocator.setType("com.ibm.able.platform.able-direct-locator");
        this.myJasAbleLocator.set("com.ibm.able.platform.able-direct-object", (Object)this.myRemoteStub);
        this.myJasAgentDescription.addLocator(this.myJasAbleLocator);
    }

    protected void maybeRegisterWithAgentDirectoryService(boolean bl) throws AbleException {
        String string = "maybeRegisterWithAgentDirectoryService(boolean)";
        if (bl) {
            try {
                if (Able.Preferences.isSecure()) {
                    AbleSecureKey ableSecureKey = this.mySecSppt.generateKey();
                    this.myJasVerifiableDirectoryService.register(this.myJasAgentDescription, ableSecureKey);
                } else {
                    this.myJasAgentDirectoryService.register(this.myJasAgentDescription);
                }
                this.agentIsRegistered = true;
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                this.logException(string, (Exception)((Object)alreadyRegisteredException));
                throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_CannotRegisterWithADS"), (Throwable)alreadyRegisteredException);
            }
            catch (DirectoryFailure directoryFailure) {
                this.logException(string, (Exception)((Object)directoryFailure));
                throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_CannotRegisterWithADS"), (Throwable)directoryFailure);
            }
            catch (NamingException namingException) {
                this.logException(string, (Exception)((Object)namingException));
                throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_CannotRegisterWithADS"), (Throwable)namingException);
            }
        }
    }

    protected void maybeDeregisterWithAgentDirectoryService() throws AbleException {
        String string = "maybeDeregisterWithAgentDirectoryService()";
        if (this.agentIsRegistered) {
            try {
                if (Able.Preferences.isSecure()) {
                    AbleSecureKey ableSecureKey = this.mySecSppt.generateKey();
                    this.myJasVerifiableDirectoryService.deregister(this.myJasAgentDescription, ableSecureKey);
                } else {
                    this.myJasAgentDirectoryService.deregister(this.myJasAgentDescription);
                }
                this.agentIsRegistered = false;
            }
            catch (NotRegisteredException notRegisteredException) {
                this.logException(string, (Exception)((Object)notRegisteredException));
            }
            catch (DirectoryFailure directoryFailure) {
                this.logException(string, (Exception)((Object)directoryFailure));
                throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_CannotDeregisterFromADS"), (Throwable)directoryFailure);
            }
            catch (NamingException namingException) {
                this.logException(string, (Exception)((Object)namingException));
                throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_CannotDeregisterFromADS"), (Throwable)namingException);
            }
        }
    }

    protected void updateDescriptionWithAgentDirectoryService() throws AbleException {
        String string = "updateDescriptionWithAgentDirectoryService()";
        if (this.agentIsRegistered) {
            try {
                this.setAgentLastUpdate();
                this.myJasAgentDescription.set("com.ibm.able.platform.agent-last-update", (Object)this.getAgentLastUpdate());
                if (Able.Preferences.isSecure()) {
                    AbleSecureKey ableSecureKey = this.mySecSppt.generateKey();
                    this.myJasVerifiableDirectoryService.modify(this.myJasAgentDescription, ableSecureKey);
                } else {
                    this.myJasAgentDirectoryService.modify(this.myJasAgentDescription);
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                this.logException(string, (Exception)((Object)notRegisteredException));
                throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_CannotUpdateDescriptionWithADS"), (Throwable)notRegisteredException);
            }
            catch (DirectoryFailure directoryFailure) {
                this.logException(string, (Exception)((Object)directoryFailure));
                throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_CannotUpdateDescriptionWithADS"), (Throwable)directoryFailure);
            }
            catch (NamingException namingException) {
                this.logException(string, (Exception)((Object)namingException));
                throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_CannotUpdateDescriptionWithADS"), (Throwable)namingException);
            }
        }
    }

    protected void maybeRebindToRmi(boolean bl) throws AbleException {
        String string = "maybeRebindToRmi(boolean)";
        if (bl) {
            String string2 = this.myJasDefaultLocator.getAddress();
            try {
                Naming.rebind(string2, (Remote)((Object)this));
                this.agentIsBoundToRmi = true;
                if (this.trace.isLogging()) {
                    this.trace.text(0x100000L, (Object)this, string, "ABLE platform default agent (re)bound to RMI Naming at <" + string2 + ">.");
                }
            }
            catch (MalformedURLException malformedURLException) {
                String string3 = Able.NlsMsg((String)"EX_NAMING_REBIND", (Object[])new Object[]{string2, ""});
                this.logger.text(4L, (Object)this, string, string3);
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, (Object)this, string, (Throwable)malformedURLException);
                }
                throw new AbleException(this.clsNm() + "." + string + "(): " + string3, (Throwable)malformedURLException);
            }
            catch (RemoteException remoteException) {
                String string4 = Able.NlsMsg((String)"EX_NAMING_REBIND", (Object[])new Object[]{string2, ""});
                this.logger.text(4L, (Object)this, string, string4);
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, (Object)this, string, (Throwable)remoteException);
                }
                throw new AbleException(this.clsNm() + "." + string + "(): " + string4, (Throwable)remoteException);
            }
        }
    }

    protected void maybeUnbindFromRmi() throws AbleException {
        String string = "maybeUnbindFromRmi()";
        if (this.agentIsBoundToRmi) {
            String string2 = this.myJasDefaultLocator.getAddress();
            try {
                Naming.unbind(string2);
                this.agentIsBoundToRmi = false;
                if (this.trace.isLogging()) {
                    this.trace.text(0x100000L, (Object)this, string, "ABLE platform default agent <" + string2 + "> unbound from RMI Naming.");
                }
            }
            catch (NotBoundException notBoundException) {
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, (Object)this, string, (Throwable)notBoundException);
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, (Object)this, string, (Throwable)malformedURLException);
                }
                throw new AbleException(this.clsNm() + "." + string + "(): ", (Throwable)malformedURLException);
            }
            catch (RemoteException remoteException) {
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, (Object)this, string, (Throwable)remoteException);
                }
                throw new AbleException(this.clsNm() + "." + string + "(): ", (Throwable)remoteException);
            }
        }
    }

    protected AgentDescription[] lookUpAgent(String string, Object object) throws AbleException {
        String string2 = "lookUpAgent(String,Object)";
        AgentDescription agentDescription = null;
        AgentDescription[] agentDescriptionArray = null;
        agentDescription = this.myJasAgentDirectoryService.createAgentDescription();
        agentDescription.set(string, object);
        try {
            agentDescriptionArray = this.myJasAgentDirectoryService.search(agentDescription);
        }
        catch (SearchException searchException) {
            this.logException(string2, (Exception)((Object)searchException));
            throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_ErrorSearchingADS"), (Throwable)searchException);
        }
        catch (DirectoryFailure directoryFailure) {
            this.logException(string2, (Exception)((Object)directoryFailure));
            throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_ErrorSearchingADS"), (Throwable)directoryFailure);
        }
        return agentDescriptionArray;
    }

    protected AgentDescription[] lookUpAgent(Hashtable hashtable) throws AbleException {
        String string = "lookUpAgent(Hashtable)";
        AgentDescription agentDescription = null;
        AgentDescription[] agentDescriptionArray = null;
        agentDescription = this.myJasAgentDirectoryService.createAgentDescription();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            agentDescription.set(string2, hashtable.get(string2));
        }
        try {
            agentDescriptionArray = this.myJasAgentDirectoryService.search(agentDescription);
        }
        catch (SearchException searchException) {
            this.logException(string, (Exception)((Object)searchException));
            throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_ErrorSearchingADS"), (Throwable)searchException);
        }
        catch (DirectoryFailure directoryFailure) {
            this.logException(string, (Exception)((Object)directoryFailure));
            throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_ErrorSearchingADS"), (Throwable)directoryFailure);
        }
        return agentDescriptionArray;
    }

    protected void logException(String string, Exception exception) {
        this.logger.text(4L, (Object)this, string, exception.getLocalizedMessage());
        if (this.trace.isLogging()) {
            this.trace.exception(262144L, (Object)this, string, (Throwable)exception);
        }
    }

    protected void broadcastTransportMessage(Vector vector, Object object) throws AbleException {
        String string = "broadcastTransportMessage(Vector,Object)";
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.elementAt(i);
            Locator locator = (Locator)vector2.elementAt(0);
            AgentName agentName = (AgentName)vector2.elementAt(1);
            this.sendTransportMessage(this.myJasDefaultLocator, locator, agentName, object);
        }
    }

    protected void sendTransportMessage(Locator locator, AgentName agentName, Object object) throws AbleException {
        String string = "sendTransportMessage(Locator,AgentName,Object)";
        this.sendTransportMessage(this.myJasDefaultLocator, locator, agentName, object);
    }

    protected void sendTransportMessage(Locator locator, Locator locator2, AgentName agentName, Object object) throws AbleException {
        AcrAgentName acrAgentName;
        AcrElementHelper acrElementHelper;
        String string = "sendTransportMessage(Locator,Locator,AgentName,Object)";
        if (this.myJasMessageTransportService == null) {
            throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_CannotSendMsgNoTransportService"));
        }
        if (this.myJasDefaultLocator == null) {
            throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_CannotSendMsgNoLocator"));
        }
        AcrEnvelope acrEnvelope = new AcrEnvelope();
        acrEnvelope.setReceiver(locator2);
        acrEnvelope.setSender(locator);
        acrEnvelope.set("com.ibm.able.platform.able-envelope-displayName", (Object)this.getAgentName());
        acrEnvelope.addProperty("com.ibm.able.platform.able-envelope-nestedName", (AcrNode)new AcrString(this.getAgentName()));
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, string, "Envelope is <" + acrEnvelope + ">.");
        }
        AclMessage aclMessage = null;
        if (object instanceof AclMessage) {
            aclMessage = (AclMessage)object;
        } else {
            acrElementHelper = AcrElementHelper.newInstance();
            acrAgentName = acrElementHelper.narrowAgentName(agentName);
            AcrAgentName acrAgentName2 = acrElementHelper.narrowAgentName(this.myJasAgentName);
            aclMessage = new AclMessage();
            aclMessage.setPerformative("org.fipa.acl.inform");
            aclMessage.setSender(acrAgentName2);
            aclMessage.addReceiver(acrAgentName);
            if (object instanceof String) {
                aclMessage.setContent((String)object);
            } else {
                aclMessage.setContent((AcrNode)new AcrObject(object));
            }
        }
        acrElementHelper = new AcrPayload();
        acrElementHelper.setMessage((AcrNode)aclMessage);
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, string, "Envelope is <" + acrElementHelper + ">.");
        }
        acrAgentName = this.myJasMessageTransportService.createTransportMessage();
        acrAgentName.setEnvelope((Envelope)acrEnvelope);
        acrAgentName.setPayload((Payload)acrElementHelper);
        try {
            this.myJasMessageTransportService.sendMessage((TransportMessage)acrAgentName);
        }
        catch (NotLocatableException notLocatableException) {
            this.logException(string, (Exception)((Object)notLocatableException));
            throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_CannotSendMsgTransportError"), (Throwable)notLocatableException);
        }
        catch (TransportFailure transportFailure) {
            this.logException(string, (Exception)((Object)transportFailure));
            throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_CannotSendMsgTransportError"), (Throwable)transportFailure);
        }
    }

    private void setReceiveMessageMethod() throws AbleException {
        String string = "setReceiveMessageMethod()";
        Class<?> clazz = this.getClass();
        Method method = null;
        try {
            method = clazz.getMethod("receiveMessage", class$javax$agent$TransportMessage == null ? (class$javax$agent$TransportMessage = AblePlatformDefaultAgent.class$("javax.agent.TransportMessage")) : class$javax$agent$TransportMessage);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.logger.text(4L, (Object)this, string, noSuchMethodException.getLocalizedMessage());
            this.trace.exception(262144L, (Object)this, string, (Throwable)noSuchMethodException);
            throw new AbleException(AblePlatform.NlsMsg("Ex_APDA_CannotSentReceiveMethod"), (Throwable)noSuchMethodException);
        }
        this.myReceiveMessageMethod = new AbleUserDefinedFunction("receiveMessage", (Object)this, method);
    }

    protected Object getTransportMessageContent(TransportMessage transportMessage) throws AbleException {
        String string = "getTransportMessageContent(TransportMessage)";
        AcrPayload acrPayload = null;
        AclMessage aclMessage = null;
        AcrNode acrNode = null;
        Object object = null;
        acrPayload = (AcrPayload)transportMessage.getPayload();
        if (acrPayload == null) {
            Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("InvalidMsg_NoPayload"));
            return null;
        }
        aclMessage = (AclMessage)acrPayload.getMessage();
        if (aclMessage == null) {
            Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("InvalidMsg_PayloadHasNoAclMsg"));
            return null;
        }
        acrNode = aclMessage.getContent();
        if (acrNode == null) {
            Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("InvalidMsg_AclMsgHasNoContent"));
            return null;
        }
        if (acrNode instanceof AcrString) {
            object = ((AcrString)acrNode).getString();
        } else if (acrNode instanceof AcrObject) {
            object = ((AcrObject)acrNode).getObject();
        } else {
            Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("InvalidMsg_UnsupportedContentType"));
            object = acrNode;
        }
        if (this.trace.isLogging()) {
            this.trace.text(262144L, (Object)this, string, "Transport Message's payload's ACL Message's content is: \n" + object);
        }
        return object;
    }

    protected Object getTransportMessageContent2(TransportMessage transportMessage) throws AbleException {
        String string = "getTransportMessageContent2(TransportMessage)";
        Payload payload = null;
        JasBean jasBean = null;
        JasBean jasBean2 = null;
        Object object = null;
        Object object2 = null;
        payload = transportMessage.getPayload();
        if (payload == null) {
            Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("InvalidMsg_NoPayload"));
            return null;
        }
        if (payload.containsKey("jas.acr.node")) {
            jasBean = (JasBean)payload.get("jas.acr.node");
            if (jasBean == null) {
                Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("InvalidMsg_PayloadHasNoAclMsg"));
                return null;
            }
        } else {
            Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("InvalidMsg_PayloadHasNoAcrNode"));
            return null;
        }
        if (jasBean.containsKey("org.fipa.acl.content")) {
            jasBean2 = (JasBean)jasBean.get("org.fipa.acl.content");
            if (jasBean2 == null) {
                Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("InvalidMsg_AcrNodeHasNoContent"));
                return null;
            }
        } else {
            Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("InvalidMsg_AcrNodeHasNoFipaAclContent"));
            return null;
        }
        if (jasBean2.containsKey("jas.acr.object")) {
            object = jasBean2.get("jas.acr.object");
            if (object == null) {
                Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("InvalidMsg_AclContentHasNoObjectContent"));
                return null;
            }
            object2 = object;
        } else if (jasBean2.containsKey("jas.acr.string")) {
            object = jasBean2.get("jas.acr.string");
            if (object == null) {
                Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("InvalidMsg_AclContentHasNoStringContent"));
                return null;
            }
            object2 = object;
        } else {
            Able.MessageLog.text(2L, (Object)this, string, AblePlatform.NlsMsg("InvalidMsg_UnsupportedContentType"));
            object2 = jasBean2;
        }
        return object2;
    }

    public void setRequestKey(AbleSecureKey ableSecureKey) {
        this.myRequestKey = ableSecureKey;
    }

    public static void main(String[] stringArray) throws AbleException {
        try {
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(0x100000L, (Object)"com.ibm.able.platform.AblePlatformDefaultAgent", "main", "Creating ABLE Platform default agent.");
            }
            AblePlatformDefaultAgent ablePlatformDefaultAgent = new AblePlatformDefaultAgent();
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(0x100000L, (Object)"com.ibm.able.platform.AblePlatformDefaultAgent", "main", "Initing ABLE Platform default agent.");
            }
            ablePlatformDefaultAgent._init();
        }
        catch (Exception exception) {
            Able.MessageLog.text(4L, (Object)"com.ibm.able.platform.AblePlatformDefaultAgent", "main", exception.getLocalizedMessage());
            Able.TraceLog.exception(262144L, (Object)"com.ibm.able.platform.AblePlatformDefaultAgent", "main", (Throwable)exception);
            throw new AbleException(exception.toString());
        }
    }

    public String toString() {
        String string = "";
        String string2 = "";
        String string3 = this.getClass().getName();
        for (int i = 0; i < Able.IndentLevel; ++i) {
            string = string + " ";
        }
        Able.IndentLevel += 2;
        string2 = string2 + super.toString() + "\n";
        string2 = string2 + string + string3 + "------------------------------\n";
        string2 = string2 + string + "  Name       : \t" + this.name + "\n";
        string2 = string2 + string + "  Comment    : \t" + this.comment + "\n";
        string2 = string2 + string + "--End " + string3 + "------------------------------\n";
        Able.IndentLevel -= 2;
        return string2;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    public AbleAgentCapability getCapability(Object object) throws AbleException {
        return (AbleAgentCapability)this.myCapabilities.get(object);
    }

    public Map getCapabilities() throws AbleException {
        return this.myCapabilities;
    }

    public void setCapabilityAutonomyLevel(Object object, int n, AbleSecureKey ableSecureKey) throws AbleException {
        String string = "setCapabilityAutonomyLevel";
        this.verifyKey(ableSecureKey, string);
        this.authorizeCapabilityChangeRequest(ableSecureKey);
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        hashMap.put(object, new Integer(n));
        this.updateCapabilitiesWithMap(hashMap, true);
    }

    public void setCapabilityAutonomyLevels(Map map, AbleSecureKey ableSecureKey) throws AbleException {
        String string = "setCapabilityAutonomyLevels";
        this.verifyKey(ableSecureKey, string);
        this.authorizeCapabilityChangeRequest(ableSecureKey);
        this.updateCapabilitiesWithMap(map, true);
    }

    public Map getCapabilityAutonomyLevels() throws AbleException {
        switch (this.getAgentAutonomyLevel()) {
            case 1: {
                return this.myHighCapabilityAutonomyLevels;
            }
            case 2: {
                return this.myMediumCapabilityAutonomyLevels;
            }
            case 3: {
                return this.myLowCapabilityAutonomyLevels;
            }
            case 0: {
                return this.myCustomCapabilityAutonomyLevels;
            }
        }
        return null;
    }

    public AbleMessageContainer getCapabilitySummaryByAgentAutonomyLevel(int n) throws AbleException {
        switch (n) {
            case 1: {
                return this.makeCapabilityAutonomyLevelsSummary(this.myHighCapabilityAutonomyLevels);
            }
            case 2: {
                return this.makeCapabilityAutonomyLevelsSummary(this.myMediumCapabilityAutonomyLevels);
            }
            case 3: {
                return this.makeCapabilityAutonomyLevelsSummary(this.myLowCapabilityAutonomyLevels);
            }
            case 0: {
                return this.makeCapabilityAutonomyLevelsSummary(this.myCustomCapabilityAutonomyLevels);
            }
        }
        return null;
    }

    public AbleMessageContainer getCapabilitySummaryByCapabilityAutonomyLevels(Map map) throws AbleException {
        if (map == null) {
            map = this.getCapabilityAutonomyLevels();
        }
        return this.makeCapabilityAutonomyLevelsSummary(map);
    }

    public Map[] getCapabilityPresets() throws AbleException {
        return new HashMap[]{(HashMap)this.myHighCapabilityAutonomyLevels, (HashMap)this.myMediumCapabilityAutonomyLevels, (HashMap)this.myLowCapabilityAutonomyLevels, (HashMap)this.myCustomCapabilityAutonomyLevels};
    }

    public Vector getCapabilityOrder() throws AbleException {
        return this.myCapabilityOrder;
    }

    public final void handleAnsweredRequest(AbleAgentSituationReport ableAgentSituationReport, AbleSecureKey ableSecureKey) throws AbleException {
        String string = "handleAnsweredRequest";
        this.validateAnsweredRequest(ableAgentSituationReport);
        this.authenticateAndAuthorizeCaller(ableAgentSituationReport, ableSecureKey);
        AnsweredRequestProcessThread_ answeredRequestProcessThread_ = new AnsweredRequestProcessThread_(ableAgentSituationReport, this, ableSecureKey);
        answeredRequestProcessThread_.start();
    }

    public Serializable getAboutDataBean() throws AbleException {
        return null;
    }

    public void setCustomizerDataBean(Serializable serializable, AbleSecureKey ableSecureKey) throws AbleException {
    }

    public Serializable getCustomizerDataBean() throws AbleException {
        return null;
    }

    public String[] getCustomizerInfo() throws AbleException {
        return null;
    }

    protected void initCommonCode(Object object) throws AbleException {
        String string = "initCommonCode(Object)";
        if (!this.myCapabilities.isEmpty()) {
            if (this.myAgentLoggingService == null) {
                this.getAgentLoggingService("UnableToObtainService", new Object[]{"AgentLoggingService"}, string);
            }
            this.verifyCapabilities();
        }
        if (object == null) {
            return;
        }
        if (object instanceof Map[] && ((Map[])object).length == 4) {
            this.initAgentCapabilities((Map[])object);
        }
    }

    protected void initAgentCapabilities(Map[] mapArray) throws AbleException {
        String string = "initAgentCapabilities(Map[])";
        if (!this.myCapabilities.isEmpty()) {
            if (this.myAgentLoggingService == null) {
                this.getAgentLoggingService("UnableToObtainService", new Object[]{"AgentLoggingService"}, string);
            }
            this.verifyCapabilities();
        }
        if (mapArray == null) {
            return;
        }
        if (this.myAgentLoggingService == null) {
            this.getAgentLoggingService("UnableToObtainService", new Object[]{"AgentLoggingService"}, string);
        }
        if (mapArray.length == 4) {
            try {
                this.myCapabilities.clear();
                this.myCapabilities.putAll(mapArray[0]);
                this.myHighCapabilityAutonomyLevels.clear();
                this.myHighCapabilityAutonomyLevels.putAll(mapArray[1]);
                this.myMediumCapabilityAutonomyLevels.clear();
                this.myMediumCapabilityAutonomyLevels.putAll(mapArray[2]);
                this.myLowCapabilityAutonomyLevels.clear();
                this.myLowCapabilityAutonomyLevels.putAll(mapArray[3]);
                this.myCustomCapabilityAutonomyLevels.clear();
            }
            catch (Exception exception) {
                if (Able.TraceLog.isLogging()) {
                    this.logger.text(4L, (Object)this, string, "Error setting capabilites as init args: " + exception);
                }
            }
        } else {
            String string2 = "AblePlatformDefaultAgent init args are of wrong type.  A java.util.Map[4] is expected.";
            AbleMessageContainer ableMessageContainer = new AbleMessageContainer(string2);
            if (Able.TraceLog.isLogging()) {
                this.logger.text(4L, (Object)this, string, string2);
            }
            throw new AbleException(ableMessageContainer, string2);
        }
        this.verifyCapabilities();
    }

    protected void verifyCapabilities() throws AbleException {
        String string = "verifyCapabilities";
        if (this.myCapabilities == null || this.myHighCapabilityAutonomyLevels == null || this.myMediumCapabilityAutonomyLevels == null || this.myLowCapabilityAutonomyLevels == null || this.myCapabilityOrder == null) {
            this.logErrorAndThrow("AESDA_VerifyCapabilitiesFailed", null, string, null);
        }
        this.presetKeysMatchCapabilityKeys(this.myHighCapabilityAutonomyLevels, "highCapabilityAutonomyLevels");
        this.presetKeysMatchCapabilityKeys(this.myMediumCapabilityAutonomyLevels, "mediumCapabilityAutonomyLevels");
        this.presetKeysMatchCapabilityKeys(this.myLowCapabilityAutonomyLevels, "lowCapabilityAutonomyLevels");
        Vector vector = new Vector();
        for (int i = 0; i < this.myCapabilityOrder.size(); ++i) {
            Object e = this.myCapabilityOrder.get(i);
            if (!this.myCapabilities.containsKey(e)) {
                this.logErrorAndThrow("AESDA_VerifyCapabilitiesOrderSetWrong", new Object[]{e}, string, null);
            }
            if (vector.contains(e)) {
                String string2 = "Agent Capability order settings contain a duplicate capability: " + e + ".";
                AbleMessageContainer ableMessageContainer = new AbleMessageContainer(string2);
                if (Able.TraceLog.isLogging()) {
                    this.logger.text(4L, (Object)this, string, string2);
                }
                throw new AbleException(ableMessageContainer, string2);
            }
            vector.add(e);
        }
        if (this.myCustomCapabilityAutonomyLevels.size() != this.myCapabilities.size()) {
            this.resaveCustomCapabilities();
        }
        this.resetAutonomyLevel();
    }

    private void presetKeysMatchCapabilityKeys(Map map, String string) throws AbleException {
        String string2 = "presetKeysMatchCapabilityKeys";
        Iterator iterator = this.myCapabilities.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!map.containsKey(k)) {
                this.logErrorAndThrow("AESDA_PresetMustHaveSameKeysAsCapabilities", new Object[]{k, string}, string2, null);
            }
            if (map.get(k) instanceof Integer) continue;
            this.logErrorAndThrow("AESDA_PresetSettingMustBeAnInteger", new Object[]{k, string, map.get(k).getClass()}, string2, null);
        }
    }

    protected void authorizeCapabilityChangeRequest(AbleSecureKey ableSecureKey) throws AbleException {
        String string = "authorizeCapabilityChangeRequest";
        if (Able.Preferences.isSecure()) {
            this.mySecSppt.verifyTrustLevel(ableSecureKey, string);
        }
    }

    protected AbleMessageContainer makeCapabilityAutonomyLevelsSummary(Map map) throws AbleException {
        Object object;
        String string = "makeCapabilityAutonomyLevelsSummary";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Iterator iterator = this.myCapabilities.keySet().iterator();
        block5: while (iterator.hasNext()) {
            object = iterator.next();
            Object v = map.get(object);
            if (v == null || !(v instanceof Integer)) {
                this.logErrorAndThrow("AESDA_UnableToCreateSummaryString", new Object[]{object}, string, null);
            }
            switch ((Integer)map.get(object)) {
                case 1: {
                    ++n;
                    continue block5;
                }
                case 2: {
                    ++n3;
                    continue block5;
                }
                case 3: {
                    ++n2;
                    continue block5;
                }
            }
        }
        object = new Object[]{new Integer(n), new Integer(n2), new Integer(n3)};
        return new AbleMessageContainer("AESDA_CapabilitiesSummaryString", object, "com.ibm.able.platform.AblePlatformMessageBundle");
    }

    private void updateCapabilitiesWithMap(Map map, boolean bl) throws AbleException {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!this.myCapabilities.containsKey(k)) continue;
            AbleAgentCapability ableAgentCapability = (AbleAgentCapability)this.myCapabilities.get(k);
            int n = (Integer)map.get(k);
            ableAgentCapability.setAutonomyLevel(n);
            this.myCapabilities.put(k, ableAgentCapability);
        }
        if (bl) {
            this.resetAutonomyLevel();
            if (this.getAgentAutonomyLevel() == 0) {
                this.resaveCustomCapabilities();
            }
        }
    }

    private void resetAutonomyLevel() throws AbleException {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        Iterator iterator = this.myCapabilities.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            int n = ((AbleAgentCapability)this.myCapabilities.get(k)).getAutonomyLevel();
            if (bl && (Integer)this.myHighCapabilityAutonomyLevels.get(k) != n) {
                bl = false;
            }
            if (bl2 && (Integer)this.myMediumCapabilityAutonomyLevels.get(k) != n) {
                bl2 = false;
            }
            if (!bl3 || (Integer)this.myLowCapabilityAutonomyLevels.get(k) == n) continue;
            bl3 = false;
        }
        int n = this.getAgentAutonomyLevel();
        if (bl || bl2 || bl3) {
            if (n == 1 && bl || n == 2 && bl2 || n == 3 && bl3) {
                return;
            }
            if (bl) {
                this.setAgentAutonomyLevel(1);
                return;
            }
            if (bl2) {
                this.setAgentAutonomyLevel(2);
                return;
            }
            if (bl3) {
                this.setAgentAutonomyLevel(3);
                return;
            }
        }
        this.setAgentAutonomyLevel(0);
        if (this.myJasAgentDescription != null && n != this.getAgentAutonomyLevel()) {
            this.myJasAgentDescription.set("com.ibm.able.platform.agent-autonomy-level", (Object)new Integer(this.getAgentAutonomyLevel()));
            this.updateDescriptionWithAgentDirectoryService();
        }
    }

    private void resaveCustomCapabilities() {
        this.myCustomCapabilityAutonomyLevels.clear();
        Iterator iterator = this.myCapabilities.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            AbleAgentCapability ableAgentCapability = (AbleAgentCapability)this.myCapabilities.get(k);
            this.myCustomCapabilityAutonomyLevels.put(k, new Integer(ableAgentCapability.getAutonomyLevel()));
        }
    }

    protected void validateAnsweredRequest(AbleAgentSituationReport ableAgentSituationReport) throws AbleException {
    }

    protected void authenticateAndAuthorizeCaller(AbleAgentSituationReport ableAgentSituationReport, AbleSecureKey ableSecureKey) throws AbleException {
    }

    protected void processAnsweredRequest(AbleAgentSituationReport ableAgentSituationReport, AbleSecureKey ableSecureKey) {
    }

    protected void logHistory(AbleMessageContainer ableMessageContainer, AbleMessageContainer ableMessageContainer2, AbleMessageContainer ableMessageContainer3) throws AbleException {
        AbleAgentSituationReport ableAgentSituationReport = new AbleAgentSituationReport(new AbleAgentSituation(null, ableMessageContainer, 0, null, null), ableMessageContainer2, ableMessageContainer3, this.myJasAgentName, this.getAgentName(), System.currentTimeMillis(), (String)this.myJasAgentDescription.get("com.ibm.able.platform.agent-pool-system"), new Integer(this.getAgentAutonomyLevel()));
        this.logAgentSituationReport(ableAgentSituationReport);
    }

    protected AbleAgentSituationReport createAgentSituationReport(Serializable serializable, AbleAgentCapability ableAgentCapability, AbleAgentSituation ableAgentSituation, AbleMessageContainer ableMessageContainer, AbleMessageContainer ableMessageContainer2, AbleMessageContainer ableMessageContainer3, boolean bl) throws AbleException {
        return new AbleAgentSituationReport(serializable, ableAgentCapability, ableAgentSituation, ableMessageContainer, ableMessageContainer2, ableMessageContainer3, bl, this.myJasAgentName, this.getName(), System.currentTimeMillis(), this.getAgentHost(), new Integer(this.getAgentAutonomyLevel()));
    }

    protected void logAgentSituationReport(AbleAgentSituationReport ableAgentSituationReport) throws AbleException {
        String string = "logAgentSituationReport";
        if (this.myAgentLoggingService == null) {
            this.getAgentLoggingService("AESDA_UnableToLog", null, string);
        }
        try {
            AbleSecureKey ableSecureKey = null;
            if (Able.Preferences.isSecure()) {
                ableSecureKey = this.mySecSppt.generateKey();
            }
            this.myAgentLoggingService.logAgentSituationReport(ableAgentSituationReport, ableSecureKey);
        }
        catch (Exception exception) {
            this.logErrorAndThrow("AESDA_ErrorWhileLogging", null, string, exception);
        }
    }

    protected void updateAgentSituationReport(AbleAgentSituationReport ableAgentSituationReport, AbleAgentSituationReport ableAgentSituationReport2) throws AbleException {
        String string = "updateAgentSituationReport";
        if (this.myAgentLoggingService == null) {
            this.getAgentLoggingService("AESDA_UnableToUpdate", null, string);
        }
        try {
            AbleSecureKey ableSecureKey = null;
            if (Able.Preferences.isSecure()) {
                ableSecureKey = this.mySecSppt.generateKey();
            }
            this.myAgentLoggingService.updateAgentSituationReport(ableAgentSituationReport, ableAgentSituationReport2, ableSecureKey);
        }
        catch (Exception exception) {
            this.logErrorAndThrow("AESDA_ErrorWhileUpdating", null, string, exception);
        }
    }

    protected void removeAgentSituationReports(Vector vector) throws AbleException {
        String string = "removeAgentSituationReports";
        if (this.myAgentLoggingService == null) {
            this.getAgentLoggingService("AESDA_UnableToRemove", null, string);
        }
        try {
            AbleSecureKey ableSecureKey = null;
            if (Able.Preferences.isSecure()) {
                ableSecureKey = this.mySecSppt.generateKey();
            }
            this.myAgentLoggingService.removeAgentSituationReports(vector, ableSecureKey);
        }
        catch (Exception exception) {
            this.logErrorAndThrow("AESDA_ErrorWhileRemoving", null, string, exception);
        }
    }

    protected final void verifyKey(AbleSecureKey ableSecureKey, String string) throws AbleException {
        if (Able.Preferences.isSecure()) {
            try {
                this.mySecSppt.verifyKey(ableSecureKey);
            }
            catch (NamingException namingException) {
                this.logErrorAndThrow("SecOn_UnableToVerifyKey", new Object[]{ableSecureKey == null ? "null" : ableSecureKey.getVan().getName(), ableSecureKey == null ? "null" : ableSecureKey.getExpriationID()}, string, (Exception)((Object)namingException));
            }
        }
    }

    protected final void getAgentLoggingService(String string, Object[] objectArray, String string2) throws AbleException {
        if (this.myAgentLoggingService != null) {
            return;
        }
        this.myAgentLoggingService = (AgentLoggingService)this.myJasServiceRoot.getService("agent-logging-service");
        if (this.myAgentLoggingService == null) {
            if (Able.TraceLog.isLogging()) {
                String string3 = AblePlatform.NlsMsg("UnableToObtainService", new Object[]{"AgentLoggingService"});
                this.logger.text(4L, (Object)this, string2, string3);
            }
            this.logErrorAndThrow(string, objectArray, string2, null);
        }
    }

    private String logErrorAndThrow(String string, Object[] objectArray, String string2, Exception exception) throws AbleException {
        AbleMessageContainer ableMessageContainer = new AbleMessageContainer(string, objectArray, "com.ibm.able.platform.AblePlatformMessageBundle");
        String string3 = objectArray == null ? AblePlatform.NlsMsg(ableMessageContainer.getMessageID()) : AblePlatform.NlsMsg(ableMessageContainer.getMessageID(), ableMessageContainer.getSubText());
        if (Able.TraceLog.isLogging()) {
            this.logger.text(4L, (Object)this, string2, string3);
        }
        if (exception == null) {
            throw new AbleException(ableMessageContainer, string3);
        }
        Able.MessageLog.text(4L, (Object)this, string2, string3);
        this.logException(string2, exception);
        throw new AbleException(ableMessageContainer, string3, (Throwable)exception);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class AnsweredRequestProcessThread_
    extends Thread {
        private final AbleAgentSituationReport myAnsweredAgentSituationReport;
        private final AblePlatformDefaultAgent myAgent;
        private final AbleSecureKey mySecureKey;

        public AnsweredRequestProcessThread_(AbleAgentSituationReport ableAgentSituationReport, AblePlatformDefaultAgent ablePlatformDefaultAgent2, AbleSecureKey ableSecureKey) {
            this.myAnsweredAgentSituationReport = ableAgentSituationReport;
            this.myAgent = ablePlatformDefaultAgent2;
            this.mySecureKey = ableSecureKey;
        }

        public void run() {
            this.myAgent.processAnsweredRequest(this.myAnsweredAgentSituationReport, this.mySecureKey);
        }
    }
}

