/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.platform;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.AbleMessageContainer;
import com.ibm.able.platform.AblePlatformAgent;
import com.ibm.able.platform.AblePlatformMessageBundle;
import com.ibm.able.platform.AblePlatformPreferences;
import java.io.Serializable;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.agent.Locator;
import javax.agent.service.Service;
import javax.agent.service.ServiceException;
import javax.agent.service.ServiceProperties;
import javax.agent.service.ServiceRoot;
import javax.agent.service.directory.AgentDescription;
import org.jagent.service.DefaultServiceRoot;
import org.jagent.service.ServicePropertiesImpl;
import org.jagent.service.spi.ServiceManager;

public final class AblePlatform
implements Serializable {
    static final long serialVersionUID = 2002110800000000001L;
    private static final String lclC = "com.ibm.able.platform.AblePlatform";
    public static final String PlatformSupportName = "AblePlatformSupport";
    static final String PropertiesFileHeader = "IBM ABLE Platform Preferences File";
    static final String PropertiesFileName = "ableplatform.preferences";
    public static final String PlatformMessageBundle = "com.ibm.able.platform.AblePlatformMessageBundle";
    public static final String AbleAgentAutonomyLevel = "com.ibm.able.platform.agent-autonomy-level";
    public static final String AbleAgentDescription = "com.ibm.able.platform.agent-description";
    public static final String AbleAgentLastUpdate = "com.ibm.able.platform.agent-last-update";
    public static final String AbleAgentMovable = "com.ibm.able.platform.agent-movable";
    public static final String AbleAgentRmiAddress = "com.ibm.able.platform.agent-rmi-address";
    public static final String AbleAgentRmiHost = "com.ibm.able.platform.agent-rmi-host";
    public static final String AbleAgentRmiName = "com.ibm.able.platform.agent-rmi-name";
    public static final String AbleAgentStatus = "com.ibm.able.platform.agent-status";
    public static final String AbleAgentSummary = "com.ibm.able.platform.agent-summary";
    public static final String AbleAgentType = "com.ibm.able.platform.agent-type";
    public static final String AbleAgentVendor = "com.ibm.able.platform.agent-vendor";
    public static final String AbleAgentVersion = "com.ibm.able.platform.agent-version";
    public static final String AbleAgentAgentPool = "com.ibm.able.platform.agent-agent-pool";
    public static final String AbleAgentPoolSystem = "com.ibm.able.platform.agent-pool-system";
    public static final String AbleDirectLocatorType = "com.ibm.able.platform.able-direct-locator";
    public static final String AbleDirectLocatorObject = "com.ibm.able.platform.able-direct-object";
    public static final String AbleEnvelopeDisplayName = "com.ibm.able.platform.able-envelope-displayName";
    public static final String AbleEnvelopeNestedName = "com.ibm.able.platform.able-envelope-nestedName";
    public static final String AbleLocatorProtocol = "com.ibm.able.platform.able-locator-protocol";
    public static final int CustomAutonomy = 0;
    public static final int HighAutonomy = 1;
    public static final int MediumAutonomy = 2;
    public static final int LowAutonomy = 3;
    public static final String DefaultPlatformName = "ABLE default platform";
    private static KeyPairGenerator wrkKeyGenerator;
    static ListResourceBundle NlsMsgs;
    public static final AblePlatformPreferences Preferences;
    public static final KeyPairGenerator KeyGenerator;

    public static final AbleMessageContainer AutonomyLevel(int n) {
        String string = PlatformMessageBundle;
        switch (n) {
            case 0: {
                return new AbleMessageContainer("AutonomyLevel_Custom", string);
            }
            case 1: {
                return new AbleMessageContainer("AutonomyLevel_High", string);
            }
            case 2: {
                return new AbleMessageContainer("AutonomyLevel_Medium", string);
            }
            case 3: {
                return new AbleMessageContainer("AutonomyLevel_Low", string);
            }
        }
        return new AbleMessageContainer("AutonomyLevel_Unrecognised", new Object[]{Integer.toString(n)}, string);
    }

    public static final KeyPair generateKeyPair() {
        String string = "generateKeyPair";
        if (KeyGenerator != null) {
            return KeyGenerator.generateKeyPair();
        }
        Able.MessageLog.text(4L, (Object)lclC, string, AblePlatform.NlsMsg("Do_not_have_access_to_a_KeyPairGenerator"));
        return null;
    }

    public static String getPlatformCryptographyAlgorithm() {
        return Preferences.getCryptographyAlgorithm();
    }

    public static String getPlatformCryptographyProvider() {
        return Preferences.getCryptographyProvider();
    }

    public static String getPlatformName() {
        return Preferences.getPlatformName();
    }

    public static boolean getPlatformSecurity() {
        return Able.Preferences.getSecurity();
    }

    public static ServiceRoot getPlatformServiceRoot(String string) {
        return AblePlatform.getServiceRoot(string);
    }

    public static ServiceRoot getServiceRoot(String string) {
        String string2 = "getServiceRoot";
        DefaultServiceRoot defaultServiceRoot = (DefaultServiceRoot)DefaultServiceRoot.getInstance();
        Vector vector = Preferences.configuredServices();
        if (!vector.isEmpty()) {
            for (int i = 0; i < vector.size(); ++i) {
                Service service = null;
                AblePlatformPreferences.ServiceEntry_ serviceEntry_ = null;
                AblePlatformPreferences.AgentPoolEntry_ agentPoolEntry_ = null;
                serviceEntry_ = (AblePlatformPreferences.ServiceEntry_)vector.elementAt(i);
                String string3 = serviceEntry_.getServiceAlias();
                String string4 = serviceEntry_.getFactoryClassName();
                agentPoolEntry_ = serviceEntry_.getAgentPoolInfo();
                HashMap hashMap = serviceEntry_.getServiceProperties();
                String string5 = agentPoolEntry_.getIpAddress();
                String string6 = agentPoolEntry_.getPort();
                String string7 = agentPoolEntry_.getPrincipal();
                ServicePropertiesImpl servicePropertiesImpl = new ServicePropertiesImpl();
                servicePropertiesImpl.set("javax.agent.service.service-factory", (Object)string4);
                servicePropertiesImpl.set("javax.agent.service.ip.service-port", (Object)string6);
                servicePropertiesImpl.set("javax.agent.service.ip.service-host", (Object)string5);
                servicePropertiesImpl.set("com.ibm.able.platform.principal-of-local-host", (Object)string7);
                servicePropertiesImpl.set("com.ibm.able.platform.requestors-port", (Object)string);
                if (Able.GetSocketFactory() != null) {
                    servicePropertiesImpl.set("platform-socket-factory", (Object)Able.GetSocketFactory());
                }
                if (hashMap != null) {
                    Set set = hashMap.entrySet();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String string8 = (String)entry.getKey();
                        String string9 = (String)entry.getValue();
                        servicePropertiesImpl.set(string8, (Object)string9);
                    }
                }
                try {
                    Able.MessageLog.text(1L, (Object)lclC, string2, AblePlatform.NlsMsg("Locating_service", new Object[]{string3, string4}));
                    service = ServiceManager.getService((ServiceProperties)servicePropertiesImpl);
                    defaultServiceRoot.setService(string3.toLowerCase(), service);
                    Able.MessageLog.text(1L, (Object)lclC, string2, AblePlatform.NlsMsg("Service_located_on", new Object[]{string5, string6}));
                    continue;
                }
                catch (ServiceException serviceException) {
                    Able.MessageLog.text(4L, (Object)lclC, string2, AblePlatform.NlsMsg("Could_not_locate_service", new Object[]{string3, string4}));
                    Able.MessageLog.text(4L, (Object)lclC, string2, serviceException.getLocalizedMessage());
                    if (Able.TraceLog.isLogging()) {
                        Able.TraceLog.exception(262144L, (Object)lclC, string2, (Throwable)serviceException);
                    }
                    defaultServiceRoot.removeService(string3.toLowerCase());
                }
            }
        } else {
            Able.MessageLog.text(2L, (Object)lclC, string2, AblePlatform.NlsMsg("No_services_configured"));
        }
        return defaultServiceRoot;
    }

    public static Service getService(String string, String string2) throws AbleException {
        String string3 = "getService(String,String)";
        Vector vector = Preferences.configuredServices();
        if (!vector.isEmpty()) {
            for (int i = 0; i < vector.size(); ++i) {
                Service service = null;
                String string4 = null;
                AblePlatformPreferences.ServiceEntry_ serviceEntry_ = null;
                AblePlatformPreferences.AgentPoolEntry_ agentPoolEntry_ = null;
                serviceEntry_ = (AblePlatformPreferences.ServiceEntry_)vector.elementAt(i);
                string4 = serviceEntry_.getServiceAlias();
                if (!string4.equalsIgnoreCase(string2)) continue;
                String string5 = serviceEntry_.getFactoryClassName();
                agentPoolEntry_ = serviceEntry_.getAgentPoolInfo();
                String string6 = agentPoolEntry_.getIpAddress();
                String string7 = agentPoolEntry_.getPort();
                String string8 = agentPoolEntry_.getPrincipal();
                ServicePropertiesImpl servicePropertiesImpl = new ServicePropertiesImpl();
                servicePropertiesImpl.set("javax.agent.service.service-factory", (Object)string5);
                servicePropertiesImpl.set("javax.agent.service.ip.service-port", (Object)string7);
                servicePropertiesImpl.set("javax.agent.service.ip.service-host", (Object)string6);
                servicePropertiesImpl.set("com.ibm.able.platform.principal-of-local-host", (Object)string8);
                servicePropertiesImpl.set("com.ibm.able.platform.requestors-port", (Object)string);
                try {
                    Able.MessageLog.text(1L, (Object)lclC, string3, AblePlatform.NlsMsg("Locating_service", new Object[]{string4, string5}));
                    service = ServiceManager.getService((ServiceProperties)servicePropertiesImpl);
                    Able.MessageLog.text(1L, (Object)lclC, string3, AblePlatform.NlsMsg("Service_located_on", new Object[]{string6, string7}));
                    return service;
                }
                catch (ServiceException serviceException) {
                    Able.MessageLog.text(4L, (Object)lclC, string3, AblePlatform.NlsMsg("Could_not_locate_service", new Object[]{string4, string5}));
                    Able.MessageLog.text(4L, (Object)lclC, string3, serviceException.getLocalizedMessage());
                    if (Able.TraceLog.isLogging()) {
                        Able.TraceLog.exception(262144L, (Object)lclC, string3, (Throwable)serviceException);
                    }
                    throw new AbleException(serviceException.getLocalizedMessage());
                }
            }
        } else {
            String string9 = AblePlatform.NlsMsg("No_services_configured");
            Able.MessageLog.text(2L, (Object)lclC, string3, string9);
            throw new AbleException(string9);
        }
        throw new AbleException(AblePlatform.NlsMsg("SpecifiedServiceNotLocated", new Object[]{string2, string}));
    }

    public static Locator getLocatorForType(AgentDescription agentDescription, String string) {
        Locator locator = null;
        Locator[] locatorArray = agentDescription.getLocators();
        for (int i = 0; i < locatorArray.length; ++i) {
            if (!locatorArray[i].getType().equalsIgnoreCase(string)) continue;
            locator = locatorArray[i];
            break;
        }
        return locator;
    }

    public static Locator getLocatorForInbox(AgentDescription agentDescription, String string) {
        Locator locator = null;
        Locator[] locatorArray = agentDescription.getLocators();
        for (int i = 0; i < locatorArray.length; ++i) {
            String string2 = AbleLocatorProtocol;
            Object object = locatorArray[i].get(string2);
            if (!string.equals(object)) continue;
            locator = locatorArray[i];
            break;
        }
        return locator;
    }

    public static String NlsMsg(String string) {
        try {
            return NlsMsgs.getString(string);
        }
        catch (Exception exception) {
            return new String("ABLE Platform: Unknown message key <" + string + ">.");
        }
    }

    public static String NlsMsg(String string, Object[] objectArray) {
        try {
            String string2 = NlsMsgs.getString(string);
            String string3 = MessageFormat.format(string2, objectArray);
            return string3;
        }
        catch (Exception exception) {
            if (NlsMsgs == null) {
                System.out.println("\n++ NlsMsgs is NULL ++\n");
                exception.printStackTrace();
            }
            StringBuffer stringBuffer = new StringBuffer("ABLE Platform: Unknown message key <" + string + ">.  Inserts: ");
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append("<{" + i + "}>  ");
            }
            return MessageFormat.format(stringBuffer.toString(), objectArray);
        }
    }

    public static AblePlatformAgent getAgentReference(AgentDescription agentDescription) {
        Locator locator = null;
        Object object = null;
        AblePlatformAgent ablePlatformAgent = null;
        if (agentDescription != null && (locator = AblePlatform.getLocatorForType(agentDescription, AbleDirectLocatorType)) != null && (object = locator.get(AbleDirectLocatorObject)) != null && object instanceof AblePlatformAgent) {
            ablePlatformAgent = (AblePlatformAgent)object;
        }
        return ablePlatformAgent;
    }

    private AblePlatform() {
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static {
        String string = "static initializer";
        if (Locale.getDefault().getLanguage().equals("ja")) {
            String string2 = "Ja_" + Locale.getDefault().getCountry();
        } else {
            String string3 = Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry();
        }
        try {
            NlsMsgs = (AblePlatformMessageBundle)ResourceBundle.getBundle(PlatformMessageBundle);
        }
        catch (MissingResourceException missingResourceException) {
            Able.TraceLog.exception(262144L, (Object)lclC, "STATIC", (Throwable)missingResourceException);
            Able.MessageLog.exception(4L, (Object)lclC, "STATIC", (Throwable)missingResourceException);
        }
        Preferences = new AblePlatformPreferences();
        String string4 = Preferences.getCryptographyAlgorithm();
        String string5 = Preferences.getCryptographyProvider();
        try {
            wrkKeyGenerator = string5.trim().length() == 0 ? KeyPairGenerator.getInstance(string4) : KeyPairGenerator.getInstance(string4, string5);
            wrkKeyGenerator.initialize(1024);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Able.MessageLog.text(4L, (Object)lclC, string, "Could not create key-pair generator using specified algorithm <" + string4 + ">.");
            Able.MessageLog.text(4L, (Object)lclC, string, noSuchAlgorithmException.getLocalizedMessage());
            Able.TraceLog.exception(262144L, (Object)lclC, string, (Throwable)noSuchAlgorithmException);
            wrkKeyGenerator = null;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            Able.MessageLog.text(4L, (Object)lclC, string, "Could not create key-pair generator using specified provider <" + string5 + ">.");
            Able.MessageLog.text(4L, (Object)lclC, string, noSuchProviderException.getLocalizedMessage());
            Able.TraceLog.exception(262144L, (Object)lclC, string, (Throwable)noSuchProviderException);
            wrkKeyGenerator = null;
        }
        KeyGenerator = wrkKeyGenerator;
    }
}

