/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.platform;

import com.ibm.able.Able;
import com.ibm.able.AbleEvent;
import com.ibm.able.AbleEventQueue;
import com.ibm.able.AbleEventQueueProcessor;
import com.ibm.able.AbleException;
import com.ibm.able.AbleLogger;
import com.ibm.able.platform.AblePersistenceSupportProcessor;
import com.ibm.able.platform.AblePlatform;
import com.ibm.able.platform.AbleSecureKey;
import com.ibm.able.platform.AbleSecuritySupport;
import com.ibm.able.platform.PlatformPersistenceException;
import com.ibm.able.platform.PlatformPersistenceService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.agent.service.naming.NamingException;
import org.jagent.service.DefaultServiceRoot;

public final class AblePersistenceSupport
implements AbleEventQueueProcessor {
    public static final int PERSIST_ACTION_ADD = 1;
    public static final int PERSIST_ACTION_UPDATE_MAP = 2;
    public static final int PERSIST_ACTION_REMOVE_STRING = 3;
    public static final int PERSIST_ACTION_REMOVE_MAP = 4;
    private static final String lclC = "com.ibm.able.platform.AblePersistenceSupport";
    private final AblePersistenceSupportProcessor myAblePersistenceSupportProcessor;
    private Vector missedPersistActions = new Vector();
    private PlatformPersistenceService myPlatformPersistenceService = null;
    private final String persistenceDatabaseName;
    private final String persistenceTableName;
    private final String persistenceSchema;
    private final String[] persistenceTableColumnNames;
    private final String[] persistenceTableColumnTypes;
    private final AbleEventQueue eventQueue;
    private final long PPSIntervalCheckTime;
    private boolean isFirstPPSConnection = true;
    private final AbleSecuritySupport mySecSppt;
    private int historyLogTextRow = -1;
    private boolean myWriteOnlyFlag = false;

    public AblePersistenceSupport(String string, String string2, String string3, String[] stringArray, String[] stringArray2, long l, AblePersistenceSupportProcessor ablePersistenceSupportProcessor, AbleSecuritySupport ableSecuritySupport) {
        this(string, string2, string3, stringArray, stringArray2, l, ablePersistenceSupportProcessor, ableSecuritySupport, false);
    }

    public AblePersistenceSupport(String string, String string2, String string3, String[] stringArray, String[] stringArray2, long l, AblePersistenceSupportProcessor ablePersistenceSupportProcessor, AbleSecuritySupport ableSecuritySupport, boolean bl) {
        this.persistenceDatabaseName = string;
        this.persistenceTableName = string2;
        this.persistenceSchema = string3;
        this.persistenceTableColumnNames = stringArray;
        this.persistenceTableColumnTypes = stringArray2;
        this.PPSIntervalCheckTime = l;
        this.myAblePersistenceSupportProcessor = ablePersistenceSupportProcessor;
        this.mySecSppt = ableSecuritySupport;
        this.myWriteOnlyFlag = bl;
        this.eventQueue = new AbleEventQueue((AbleEventQueueProcessor)this);
        this.eventQueue.setSleepTime(this.PPSIntervalCheckTime);
        this.eventQueue.setTimerEventProcessingEnabled(false);
        this.eventQueue.setTimerEventProcessingEnabled(true);
        this.eventQueue.startProcessingEvents();
    }

    public void processAbleEvent(AbleEvent ableEvent) throws AbleException {
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.entry(0x100000L, (Object)this, "processAbleEvent");
        }
    }

    public void processTimerEvent() throws AbleException {
        if (this.isPlatformPersistenceServiceReady()) {
            this.processCachedPersistActions();
        }
    }

    public void processNoEventProcessingEnabledSituation() throws AbleException {
    }

    public void setState(int n) throws AbleException {
    }

    public int getState() throws AbleException {
        return 0;
    }

    public AbleLogger getLogger() throws AbleException {
        return Able.TraceLog;
    }

    public final String getDatabaseName() {
        return this.persistenceDatabaseName;
    }

    public final String getTableName() {
        return this.persistenceTableName;
    }

    public final String[] getTableColumnNames() {
        return this.persistenceTableColumnNames;
    }

    public final String[] getTableColumnTypes() {
        return this.persistenceTableColumnTypes;
    }

    private boolean isPlatformPersistenceServiceReady() {
        String string = "isPlatformPersistenceServiceReady: " + this.myAblePersistenceSupportProcessor;
        try {
            this.myPlatformPersistenceService = (PlatformPersistenceService)AblePlatform.getService(null, "persistence-service");
            if (this.myPlatformPersistenceService == null) {
                String string2 = AblePlatform.NlsMsg("PPSO_UnableToConnectToPPS");
                Able.MessageLog.text(4L, (Object)this, string, string2);
                if (Able.TraceLog.isLogging()) {
                    Able.TraceLog.text(262144L, (Object)this, string, string2);
                }
                throw new Exception(string2);
            }
            AbleSecureKey ableSecureKey = null;
            if (Able.Preferences.isSecure()) {
                ableSecureKey = this.mySecSppt.generateKey();
            }
            this.myPlatformPersistenceService.createTableConnection(this.persistenceDatabaseName, this.persistenceTableName, this.persistenceSchema, this.persistenceTableColumnNames, this.persistenceTableColumnTypes, ableSecureKey, this.myWriteOnlyFlag);
            if (this.isFirstPPSConnection && !this.myWriteOnlyFlag) {
                AbleSecureKey ableSecureKey2 = null;
                if (Able.Preferences.isSecure()) {
                    ableSecureKey2 = this.mySecSppt.generateKey();
                }
                Object[] objectArray = this.myPlatformPersistenceService.select(this.persistenceDatabaseName, this.persistenceTableName, "*", "", ableSecureKey2);
                this.myAblePersistenceSupportProcessor.refreshLocalFromPersistence(this, objectArray);
                this.isFirstPPSConnection = false;
            }
        }
        catch (Exception exception) {
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.exception(0x100000L, (Object)this, string, (Throwable)exception);
            }
            Able.MessageLog.text(1L, (Object)this, string, exception.getLocalizedMessage());
            if (!this.eventQueue.isTimerEventProcessingEnabled()) {
                this.eventQueue.setTimerEventProcessingEnabled(true);
                this.eventQueue.startProcessingEvents();
            }
            return false;
        }
        return true;
    }

    public boolean insert(Serializable[] serializableArray) {
        return this.insert(serializableArray, false);
    }

    private synchronized boolean insert(Serializable[] serializableArray, boolean bl) {
        String string = "insert: " + this.myAblePersistenceSupportProcessor;
        if (!bl && this.missedPersistActions.size() > 0) {
            this.missedPersistActions.add(new MissedPersistAction_(1, serializableArray, null));
            return false;
        }
        try {
            AbleSecureKey ableSecureKey = null;
            if (Able.Preferences.isSecure()) {
                ableSecureKey = this.mySecSppt.generateKey();
            }
            this.myPlatformPersistenceService.insert(this.persistenceDatabaseName, this.persistenceTableName, serializableArray, ableSecureKey);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < serializableArray.length; ++i) {
                stringBuffer.append(serializableArray[i] + " ");
            }
            Able.MessageLog.text(1L, (Object)this, string, AblePlatform.NlsMsg("PPSO_Inserting", new Object[]{stringBuffer.toString(), this.persistenceTableName, this.persistenceDatabaseName}));
        }
        catch (Exception exception) {
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(0x100000L, (Object)this, string, "The insert into " + this.persistenceDatabaseName + ":" + this.persistenceTableName + " failed because of the following exception: " + exception);
            }
            if (bl) {
                this.missedPersistActions.add(0, new MissedPersistAction_(1, serializableArray, null));
            } else {
                this.missedPersistActions.add(new MissedPersistAction_(1, serializableArray, null));
            }
            this.handlePersistFailure(string);
            return false;
        }
        return true;
    }

    public boolean update(Map map, Map map2) {
        return this.update(map, map2, false);
    }

    private synchronized boolean update(Map map, Map map2, boolean bl) {
        String string = "update(Map, Map): " + this.myAblePersistenceSupportProcessor;
        if (!bl && this.missedPersistActions.size() > 0) {
            this.missedPersistActions.add(new MissedPersistAction_(2, map, map2));
            return false;
        }
        try {
            AbleSecureKey ableSecureKey = null;
            if (Able.Preferences.isSecure()) {
                ableSecureKey = this.mySecSppt.generateKey();
            }
            this.myPlatformPersistenceService.update(this.persistenceDatabaseName, this.persistenceTableName, map, map2, ableSecureKey);
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString() + " ");
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer2.append(iterator.next().toString() + " ");
            }
            Able.MessageLog.text(1L, (Object)this, string, AblePlatform.NlsMsg("PPSO_Updating", new Object[]{stringBuffer.toString(), this.persistenceTableName, this.persistenceDatabaseName, stringBuffer2.toString()}));
        }
        catch (Exception exception) {
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(0x100000L, (Object)this, string, "The update of " + this.persistenceDatabaseName + ":" + this.persistenceTableName + " failed because of the following exception: " + exception);
            }
            if (bl) {
                this.missedPersistActions.add(0, new MissedPersistAction_(2, map, map2));
            } else {
                this.missedPersistActions.add(new MissedPersistAction_(2, map, map2));
            }
            this.handlePersistFailure(string);
            return false;
        }
        return true;
    }

    public boolean delete(String string) {
        return this.delete(string, false);
    }

    private synchronized boolean delete(String string, boolean bl) {
        String string2 = "delete(String): " + this.myAblePersistenceSupportProcessor;
        if (!bl && this.missedPersistActions.size() > 0) {
            this.missedPersistActions.add(new MissedPersistAction_(3, null, string));
            return false;
        }
        try {
            AbleSecureKey ableSecureKey = null;
            if (Able.Preferences.isSecure()) {
                ableSecureKey = this.mySecSppt.generateKey();
            }
            this.myPlatformPersistenceService.delete(this.persistenceDatabaseName, this.persistenceTableName, string, ableSecureKey);
            Able.MessageLog.text(1L, (Object)this, string2, AblePlatform.NlsMsg("PPSO_Deleting", new Object[]{this.persistenceTableName, this.persistenceDatabaseName, string}));
        }
        catch (Exception exception) {
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(0x100000L, (Object)this, string2, "The delete from " + this.persistenceDatabaseName + ":" + this.persistenceTableName + " failed because of the following exception: " + exception);
            }
            if (bl) {
                this.missedPersistActions.add(0, new MissedPersistAction_(3, null, string));
            } else {
                this.missedPersistActions.add(new MissedPersistAction_(3, null, string));
            }
            this.handlePersistFailure(string2);
            return false;
        }
        return true;
    }

    public boolean delete(Map map) {
        return this.delete(map, false);
    }

    private synchronized boolean delete(Map map, boolean bl) {
        String string = "delete(Map): " + this.myAblePersistenceSupportProcessor;
        if (this.missedPersistActions != null && this.missedPersistActions.size() > 0 && !bl && this.missedPersistActions.size() > 0) {
            this.missedPersistActions.add(new MissedPersistAction_(4, null, map));
            return false;
        }
        try {
            AbleSecureKey ableSecureKey = null;
            if (Able.Preferences.isSecure()) {
                ableSecureKey = this.mySecSppt.generateKey();
            }
            this.myPlatformPersistenceService.delete(this.persistenceDatabaseName, this.persistenceTableName, map, ableSecureKey);
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString() + " ");
            }
            Able.MessageLog.text(1L, (Object)this, string, AblePlatform.NlsMsg("PPSO_Deleting", new Object[]{this.persistenceTableName, this.persistenceDatabaseName, stringBuffer.toString()}));
        }
        catch (Exception exception) {
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(0x100000L, (Object)this, string, "The delete from " + this.persistenceDatabaseName + ":" + this.persistenceTableName + " failed because of the following exception: " + exception);
            }
            if (bl) {
                this.missedPersistActions.add(0, new MissedPersistAction_(4, null, map));
            } else {
                this.missedPersistActions.add(new MissedPersistAction_(4, null, map));
            }
            this.handlePersistFailure(string);
            return false;
        }
        return true;
    }

    private void handlePersistFailure(String string) {
        block3: {
            this.myPlatformPersistenceService = null;
            try {
                DefaultServiceRoot defaultServiceRoot = (DefaultServiceRoot)DefaultServiceRoot.getInstance();
                defaultServiceRoot.removeService("persistence-service");
            }
            catch (Exception exception) {
                String string2 = AblePlatform.NlsMsg("PPSO_ErrorPersisting", new Object[]{new Long(this.PPSIntervalCheckTime)});
                Able.MessageLog.text(1L, (Object)this, string, string2);
                Able.MessageLog.text(1L, (Object)this, string, exception.getLocalizedMessage());
                if (!Able.TraceLog.isLogging()) break block3;
                Able.TraceLog.exception(262144L, (Object)this, string, (Throwable)exception);
            }
        }
        if (!this.eventQueue.isTimerEventProcessingEnabled()) {
            this.eventQueue.setTimerEventProcessingEnabled(true);
            this.eventQueue.startProcessingEvents();
        }
    }

    public void quitAll() {
        block7: {
            String string = "quitAll: " + this.myAblePersistenceSupportProcessor;
            try {
                this.eventQueue.setTimerEventProcessingEnabled(false);
                this.eventQueue.stopProcessingEvents();
                if (this.myPlatformPersistenceService != null) {
                    this.processCachedPersistActions();
                }
                if (this.myPlatformPersistenceService != null) {
                    AbleSecureKey ableSecureKey = null;
                    if (Able.Preferences.isSecure()) {
                        ableSecureKey = this.mySecSppt.generateKey();
                    }
                    this.myPlatformPersistenceService.close(this.persistenceDatabaseName, this.persistenceTableName, ableSecureKey);
                }
            }
            catch (NamingException namingException) {
                Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("SecOn_SecureKeyNotGenerated"));
                Able.MessageLog.text(4L, (Object)this, string, namingException.getLocalizedMessage());
                if (Able.TraceLog.isLogging()) {
                    Able.TraceLog.exception(262144L, (Object)this, string, (Throwable)namingException);
                }
            }
            catch (PlatformPersistenceException platformPersistenceException) {
                Able.MessageLog.text(4L, (Object)this, string, AblePlatform.NlsMsg("PPSO_ErrorClosingConnection"));
                Able.MessageLog.text(4L, (Object)this, string, platformPersistenceException.getLocalizedMessage());
                if (!Able.TraceLog.isLogging()) break block7;
                Able.TraceLog.exception(262144L, (Object)this, string, (Throwable)((Object)platformPersistenceException));
            }
        }
    }

    private void processCachedPersistActions() {
        String string = "processCachedPersistActions: " + this.myAblePersistenceSupportProcessor;
        while (this.missedPersistActions != null && this.missedPersistActions.size() > 0) {
            MissedPersistAction_ missedPersistAction_ = (MissedPersistAction_)this.missedPersistActions.remove(0);
            switch (missedPersistAction_.getAction()) {
                case 1: {
                    if (this.insert((Serializable[])missedPersistAction_.getRow(), true)) break;
                    return;
                }
                case 2: {
                    if (this.update((Map)missedPersistAction_.getRow(), (Map)missedPersistAction_.getWhere(), true)) break;
                    return;
                }
                case 3: {
                    if (this.delete((String)missedPersistAction_.getWhere(), true)) break;
                    return;
                }
                case 4: {
                    if (this.delete((Map)missedPersistAction_.getWhere(), true)) break;
                    return;
                }
            }
        }
        this.eventQueue.setTimerEventProcessingEnabled(false);
    }

    public static boolean isBaseSQLObject(Object object) {
        return object instanceof Array || object instanceof BigDecimal || object instanceof Blob || object instanceof Clob || object instanceof Date || object instanceof Ref || object instanceof String || object instanceof Time || object instanceof Timestamp || object instanceof URL || object instanceof Boolean || object instanceof Byte || object instanceof Double || object instanceof Float || object instanceof Long || object instanceof Integer || object instanceof Short;
    }

    public static byte[] Serialize(Serializable serializable) throws AbleException {
        String string = "Serialize";
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            String string2 = AblePlatform.NlsMsg("PPSO_UnableToSerialize", new Object[]{serializable.getClass().toString()});
            Able.MessageLog.text(4L, (Object)lclC, string, string2);
            Able.MessageLog.text(4L, (Object)lclC, string, throwable.getLocalizedMessage());
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.exception(262144L, (Object)lclC, string, throwable);
            }
            throw new AbleException(string2, throwable);
        }
        return byArray;
    }

    public static Serializable Deserialize(byte[] byArray) throws AbleException {
        String string = "Deserialize";
        Object object = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
            object = objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Throwable throwable) {
            String string2 = AblePlatform.NlsMsg("PPSO_UnableToDeserialize", new Object[]{object.getClass().toString()});
            Able.MessageLog.text(4L, (Object)lclC, string, string2);
            Able.MessageLog.text(4L, (Object)lclC, string, throwable.getLocalizedMessage());
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.exception(262144L, (Object)lclC, string, throwable);
            }
            throw new AbleException(string2, throwable);
        }
        return (Serializable)object;
    }

    public synchronized Serializable nextId(String string) {
        AbleSecureKey ableSecureKey = null;
        try {
            Object[] objectArray;
            Object[] objectArray2;
            if (Able.Preferences.isSecure()) {
                ableSecureKey = this.mySecSppt.generateKey();
            }
            if (this.myPlatformPersistenceService == null) {
                return new Integer(-1);
            }
            if (this.historyLogTextRow == -1 && (objectArray2 = this.myPlatformPersistenceService.select(this.persistenceDatabaseName, this.persistenceTableName, "MAX(" + string + ")", null, ableSecureKey)) != null && objectArray2.length > 0 && (objectArray = (Object[])objectArray2[0]) != null && objectArray.length > 0 && objectArray[0] != null && objectArray[0] instanceof Number) {
                this.historyLogTextRow = ((Number)objectArray[0]).intValue();
            }
        }
        catch (NamingException namingException) {
            System.out.println("NamingException getting nextid");
            namingException.printStackTrace();
            return new Integer(-1);
        }
        catch (PlatformPersistenceException platformPersistenceException) {
            System.out.println("PlatformPersistenceException getting nextid");
            platformPersistenceException.printStackTrace();
            return new Integer(-1);
        }
        ++this.historyLogTextRow;
        return new Integer(this.historyLogTextRow);
    }

    private class MissedPersistAction_ {
        private final int action;
        private final Object row;
        private final Object where;

        public MissedPersistAction_(int n, Object object, Object object2) {
            this.action = n;
            this.row = object;
            this.where = object2;
        }

        public int getAction() {
            return this.action;
        }

        public Object getRow() {
            return this.row;
        }

        public Object getWhere() {
            return this.where;
        }
    }
}

