/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.platform;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleException;
import com.ibm.able.AbleLogger;
import com.ibm.able.platform.AblePersistenceSupport;
import com.ibm.able.platform.AblePlatform;
import com.ibm.able.platform.AblePlatformServiceEvent;
import com.ibm.able.platform.AblePlatformServiceEventListener;
import com.ibm.able.platform.AbleSecureKey;
import com.ibm.able.platform.AbleSecuritySupport;
import com.ibm.able.platform.RMIVerifiableNamingProxy;
import com.ibm.able.platform.RMIVerifiableNamingService;
import com.ibm.able.platform.RmiAblePlatformService;
import com.ibm.able.platform.VerifiableAgentName;
import com.ibm.able.platform.VerifiableAgentNamingService;
import java.security.KeyPair;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.agent.service.ServiceException;
import javax.agent.service.ServiceFailure;
import javax.agent.service.ServiceProperties;
import javax.agent.service.naming.NamingException;
import org.jagent.service.DefaultServiceRoot;
import org.jagent.service.util.RMIBasicService;

public abstract class AbleBasicService
extends RMIBasicService
implements RmiAblePlatformService {
    public static final String ANS_PRINCIPAL = "com.ibm.able.platform.principal-of-ans-host";
    public static final String LOCAL_PRINCIPAL = "com.ibm.able.platform.principal-of-local-host";
    public static final String REQUESTORS_PORT = "com.ibm.able.platform.requestors-port";
    public static final String SOCKET_FACTORY = "platform-socket-factory";
    public static final int Unknown = 1;
    public static final int Running = 2;
    public static final int Refreshing = 3;
    public static final int Terminated = 4;
    private static final String lclC = "com.ibm.able.platform.AbleBasicService";
    protected final Vector myServiceEventListeners = new Vector();
    private int myState = 1;
    protected KeyPair myKeyPair = null;
    protected VerifiableAgentName myVerifiableAgentName = null;
    protected String myTrustLevel = "";
    protected VerifiableAgentNamingService myVerifiableNamingService = null;
    protected String myPrincipal = null;
    protected String myAnsPrincipal = null;
    protected ServiceProperties myServiceProperties = null;
    protected AbleSecuritySupport mySecSppt = null;
    protected AbleLogger myMsgLog = null;
    protected AbleLogger myTrcLog = null;

    public AbleBasicService() throws Exception {
        this.myPrincipal = AblePlatform.Preferences.principalOfLocalAgentPool();
        this.myAnsPrincipal = AblePlatform.Preferences.principalOfService("agent-naming-service");
        this.ctorHelper();
    }

    public AbleBasicService(ServiceProperties serviceProperties) throws Exception {
        super(serviceProperties);
        this.myServiceProperties = serviceProperties;
        this.myPrincipal = (String)serviceProperties.get(LOCAL_PRINCIPAL);
        this.myAnsPrincipal = (String)serviceProperties.get(ANS_PRINCIPAL);
        this.ctorHelper();
    }

    private void ctorHelper() throws Exception {
        String string = "ctorHelper";
        this.myMsgLog = Able.MessageLog;
        this.myTrcLog = Able.TraceLog;
        if (Able.Preferences.isSecure()) {
            this.myKeyPair = AblePlatform.generateKeyPair();
            if (this instanceof RMIVerifiableNamingService) {
                this.myVerifiableNamingService = new RMIVerifiableNamingProxy((RMIVerifiableNamingService)((Object)this), this.myAnsPrincipal, null, null);
            } else {
                this.myVerifiableNamingService = (VerifiableAgentNamingService)AblePlatform.getService((String)this.myServiceProperties.get("javax.agent.service.ip.service-port"), "agent-naming-service");
                this.myVerifiableAgentName = this.myVerifiableNamingService.createAgentName(this.myKeyPair.getPublic(), this.myPrincipal, this.getBindingName());
                this.myTrustLevel = this.myVerifiableAgentName.getLevel();
                this.mySecSppt = new AbleSecuritySupport(this.myKeyPair, this.myVerifiableAgentName, this.myVerifiableNamingService, this.myMsgLog, this.myTrcLog);
                this.myMsgLog.text(1L, (Object)this, string, AblePlatform.NlsMsg("SuccessfullyReceivedVAN", new Object[]{this.myPrincipal}));
            }
        }
    }

    public void terminateService(AbleSecureKey ableSecureKey) throws AbleException, NamingException {
        String string = "terminateService";
        this.setState(4);
        if (Able.Preferences.isSecure()) {
            this.mySecSppt.verifyKey(ableSecureKey);
            this.mySecSppt.verifyTrustLevel(ableSecureKey, string);
            this.myVerifiableNamingService.closeConversation(this.myPrincipal, this.mySecSppt.generateKey());
            this.myVerifiableNamingService.releaseAgentName(this.mySecSppt.generateKey());
        }
        try {
            DefaultServiceRoot defaultServiceRoot = (DefaultServiceRoot)DefaultServiceRoot.getInstance();
            defaultServiceRoot.removeService(this.getBindingName());
            this.shutdown();
        }
        catch (Exception exception) {
            String string2 = AblePlatform.NlsMsg("ABS_ErrorTerminatingService");
            this.myMsgLog.text(4L, (Object)this, string, string2);
            this.myMsgLog.text(4L, (Object)this, string, exception.getLocalizedMessage());
            this.myTrcLog.exception(262144L, (Object)this, string, (Throwable)exception);
            this.terminateZapInternals();
            throw new AbleException(string2);
        }
        this.terminateZapInternals();
    }

    private void terminateZapInternals() {
        this.myServiceEventListeners.removeAllElements();
        this.myKeyPair = null;
        this.myVerifiableAgentName = null;
        this.myTrustLevel = null;
        this.myVerifiableNamingService = null;
        this.myPrincipal = null;
        this.myAnsPrincipal = null;
        this.myServiceProperties = null;
        this.mySecSppt = null;
        this.myMsgLog = null;
        this.myTrcLog = null;
    }

    public int getState() throws AbleException {
        return this.myState;
    }

    public void addAblePlatformServiceEventListener(AblePlatformServiceEventListener ablePlatformServiceEventListener) throws AbleException {
        String string = "addAblePlatformServiceEventListener";
        if (ablePlatformServiceEventListener == null) {
            String string2 = "Unable to add null service event listener";
            this.myMsgLog.text(4L, (Object)this, string, string2);
            this.myTrcLog.text(262144L, (Object)this, string, string2);
            throw new AbleException(string2);
        }
        this.myServiceEventListeners.addElement(ablePlatformServiceEventListener);
    }

    public void removeAblePlatformServiceEventListener(AblePlatformServiceEventListener ablePlatformServiceEventListener) throws AbleException {
        String string = "removeAblePlatformServiceEventListener";
        if (ablePlatformServiceEventListener == null) {
            String string2 = "Unable to remove null service event listener";
            this.myMsgLog.text(4L, (Object)this, string, string2);
            this.myTrcLog.text(262144L, (Object)this, string, string2);
            throw new AbleException(string2);
        }
        this.myServiceEventListeners.removeElement(ablePlatformServiceEventListener);
    }

    public Vector getAblePlatformServiceEventListeners() throws AbleException {
        String string = "getAblePlatformServiceEventListeners";
        return (Vector)this.myServiceEventListeners.clone();
    }

    protected void thenNotifyAblePlatformServiceEventListeners(String string, int n, String string2, Object object, Object object2, AblePersistenceSupport ablePersistenceSupport, String string3) {
        try {
            this.notifyAblePlatformServiceEventListeners(new AblePlatformServiceEvent(this, n, string2, object, object2), ablePersistenceSupport, string3);
        }
        catch (ServiceException serviceException) {
            this.myMsgLog.text(4L, (Object)this, string, serviceException.getLocalizedMessage());
            this.myTrcLog.exception(262144L, (Object)this, string, (Throwable)serviceException);
        }
        catch (ServiceFailure serviceFailure) {
            this.myMsgLog.text(4L, (Object)this, string, serviceFailure.getLocalizedMessage());
            this.myTrcLog.exception(262144L, (Object)this, string, (Throwable)serviceFailure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyAblePlatformServiceEventListeners(AblePlatformServiceEvent ablePlatformServiceEvent, AblePersistenceSupport ablePersistenceSupport, String string) throws ServiceException, ServiceFailure {
        Vector vector;
        String string2 = "notifyAblePlatformServiceEventListeners";
        StringBuffer stringBuffer = null;
        Vector<ServiceException> vector2 = null;
        AbleBasicService ableBasicService = this;
        synchronized (ableBasicService) {
            vector = (Vector)this.myServiceEventListeners.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            AblePlatformServiceEventListener ablePlatformServiceEventListener = (AblePlatformServiceEventListener)vector.elementAt(i);
            try {
                ablePlatformServiceEventListener.handleAblePlatformServiceEvent(ablePlatformServiceEvent);
                continue;
            }
            catch (Exception exception) {
                Object object;
                this.myServiceEventListeners.removeElement(ablePlatformServiceEventListener);
                if (ablePersistenceSupport != null) {
                    object = new HashMap();
                    ((HashMap)object).put(string, ablePlatformServiceEventListener);
                    ablePersistenceSupport.delete((Map)object);
                }
                object = ablePlatformServiceEventListener.getClass().getName();
                if (ablePlatformServiceEventListener instanceof AbleBean) {
                    object = ((AbleBean)ablePlatformServiceEventListener).getName();
                }
                String string3 = Able.NlsMsg((String)"EX_CANT_NOTIFY_LISTENER", (Object[])new Object[]{object}) + Able.LS + Able.NlsMsg((String)"EX_MESSAGE_CONTENT", (Object[])new Object[]{exception.getLocalizedMessage()});
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string3);
                } else {
                    stringBuffer.append(Able.LS + string3);
                }
                if (vector2 == null) {
                    vector2 = new Vector<ServiceException>();
                }
                vector2.add(new ServiceException(string3, exception));
                this.myMsgLog.text(4L, (Object)this, string2, string3);
                this.myTrcLog.exception(262144L, (Object)this, string2, (Throwable)exception);
            }
        }
        if (stringBuffer != null) {
            throw new ServiceException(stringBuffer.toString());
        }
    }

    protected void setState(int n) {
        String string = "setState";
        if (this.myState != 4) {
            switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.myState = n;
                    break;
                }
            }
        } else {
            String string2 = "The state of a service may not be set to " + n + " once it is set to AbleBasicService.Terminated";
            this.myMsgLog.text(4L, (Object)this, string, string2);
            this.myTrcLog.text(262144L, (Object)this, string, string2);
        }
    }
}

