/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.platform;

import com.ibm.able.AbleException;
import com.ibm.able.AbleMessageContainer;
import com.ibm.able.platform.AblePlatform;
import java.io.Serializable;
import java.text.MessageFormat;

public class AbleAgentSituation
implements Serializable {
    static final long serialVersionUID = 2003052100000000001L;
    public static final int LOW_SEVERITY = 0;
    public static final int MEDIUM_SEVERITY = 1;
    public static final int HIGH_SEVERITY = 2;
    public static final AbleMessageContainer LOW_SEVERITY_STRING = new AbleMessageContainer("AESDA_SeverityLow", null, "com.ibm.able.platform.AblePlatformMessageBundle");
    public static final AbleMessageContainer MEDIUM_SEVERITY_STRING = new AbleMessageContainer("AESDA_SeverityMedium", null, "com.ibm.able.platform.AblePlatformMessageBundle");
    public static final AbleMessageContainer HIGH_SEVERITY_STRING = new AbleMessageContainer("AESDA_SeverityHigh", null, "com.ibm.able.platform.AblePlatformMessageBundle");
    public static final AbleMessageContainer PERMISSION_REQUEST = new AbleMessageContainer("ASR_Permission", null, "com.ibm.able.platform.AblePlatformMessageBundle");
    public static final AbleMessageContainer FAILURE_REQUEST = new AbleMessageContainer("ASR_Failure", null, "com.ibm.able.platform.AblePlatformMessageBundle");
    public static final AbleMessageContainer INFO_SITUATION = new AbleMessageContainer("ASR_Information", null, "com.ibm.able.platform.AblePlatformMessageBundle");
    private final Serializable mySituationIdentifier;
    private AbleMessageContainer mySituationName;
    private final int mySeverityLevel;
    private final AbleMessageContainer mySituationType;
    private final AbleMessageContainer[] myResponses;
    private AbleMessageContainer myYesResponse;
    private AbleMessageContainer myNoResponse;

    public AbleAgentSituation(Serializable serializable, AbleMessageContainer ableMessageContainer, int n, AbleMessageContainer ableMessageContainer2, AbleMessageContainer[] ableMessageContainerArray) {
        this.mySituationIdentifier = serializable;
        this.mySituationName = ableMessageContainer;
        this.mySeverityLevel = n;
        this.mySituationType = ableMessageContainer2;
        if (ableMessageContainerArray != null) {
            this.myResponses = new AbleMessageContainer[ableMessageContainerArray.length];
            System.arraycopy(ableMessageContainerArray, 0, this.myResponses, 0, this.myResponses.length);
        } else {
            this.myResponses = null;
        }
        this.myYesResponse = this.myResponses != null && this.myResponses.length > 0 ? this.myResponses[0] : null;
        this.myNoResponse = this.myResponses != null && this.myResponses.length > 0 ? this.myResponses[this.myResponses.length - 1] : null;
    }

    public AbleAgentSituation(AbleAgentSituation ableAgentSituation) {
        this.mySituationIdentifier = ableAgentSituation.mySituationIdentifier;
        this.mySituationName = ableAgentSituation.mySituationName;
        this.mySeverityLevel = ableAgentSituation.mySeverityLevel;
        this.mySituationType = ableAgentSituation.mySituationType;
        if (ableAgentSituation.myResponses != null) {
            this.myResponses = new AbleMessageContainer[ableAgentSituation.myResponses.length];
            System.arraycopy(ableAgentSituation.myResponses, 0, this.myResponses, 0, this.myResponses.length);
        } else {
            this.myResponses = null;
        }
        this.myYesResponse = ableAgentSituation.myYesResponse;
        this.myNoResponse = ableAgentSituation.myNoResponse;
    }

    public Serializable getSituationIdentifier() {
        return this.mySituationIdentifier;
    }

    public AbleMessageContainer getName() {
        return this.mySituationName;
    }

    public int getSeverityLevel() {
        return this.mySeverityLevel;
    }

    public AbleMessageContainer getSeverityLevelString() {
        switch (this.mySeverityLevel) {
            case 2: {
                return HIGH_SEVERITY_STRING;
            }
            case 1: {
                return MEDIUM_SEVERITY_STRING;
            }
            case 0: {
                return LOW_SEVERITY_STRING;
            }
        }
        return null;
    }

    public AbleMessageContainer getSituationType() {
        return this.mySituationType;
    }

    public AbleMessageContainer[] getResponses() {
        return this.myResponses;
    }

    public AbleMessageContainer getResponse(int n) {
        return this.myResponses[n];
    }

    public AbleMessageContainer getYesResponse() {
        return this.myYesResponse;
    }

    public AbleMessageContainer getNoResponse() {
        return this.myNoResponse;
    }

    public void formatSituationName(Object[] objectArray) {
        if (this.mySituationName != null) {
            this.mySituationName = this.mySituationName.getMessage() != null ? new AbleMessageContainer(MessageFormat.format(this.mySituationName.getMessage(), objectArray)) : new AbleMessageContainer(this.mySituationName.getMessageID(), objectArray, this.mySituationName.getResourceBundle());
        }
    }

    public void formatResponse(int n, Object[] objectArray) {
        if (this.myResponses != null && this.myResponses[n] != null) {
            AbleMessageContainer ableMessageContainer = null;
            try {
                ableMessageContainer = new AbleMessageContainer(this.myResponses[n]);
            }
            catch (AbleException ableException) {
                // empty catch block
            }
            this.myResponses[n] = this.myResponses[n].getMessage() != null ? new AbleMessageContainer(MessageFormat.format(this.myResponses[n].getMessage(), objectArray)) : new AbleMessageContainer(this.myResponses[n].getMessageID(), objectArray, this.myResponses[n].getResourceBundle());
            if (this.myNoResponse.equals((Object)ableMessageContainer)) {
                this.myNoResponse = this.myResponses[n];
            }
            if (this.myYesResponse.equals((Object)ableMessageContainer)) {
                this.myYesResponse = this.myResponses[n];
            }
        }
    }

    public String debugString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(AblePlatform.NlsMsg("ASR_SituationIdentifier", new Object[]{this.mySituationIdentifier}));
        stringBuffer.append(AblePlatform.NlsMsg("ASR_SituationName", new Object[]{this.mySituationName == null ? null : this.mySituationName.debugString()}));
        stringBuffer.append(AblePlatform.NlsMsg("ASR_SeverityLevel", new Object[]{new Integer(this.mySeverityLevel)}));
        stringBuffer.append(AblePlatform.NlsMsg("ASR_SituationType", new Object[]{this.mySituationType == null ? null : this.mySituationType.debugString()}));
        if (this.myResponses != null) {
            for (int i = 0; i < this.myResponses.length; ++i) {
                AbleMessageContainer ableMessageContainer = this.myResponses[i];
                stringBuffer.append(AblePlatform.NlsMsg("ASR_Response", new Object[]{ableMessageContainer == null ? null : ableMessageContainer.debugString()}));
            }
        }
        stringBuffer.append(AblePlatform.NlsMsg("ASR_YesResponse", new Object[]{this.myYesResponse == null ? null : this.myYesResponse.debugString()}));
        stringBuffer.append(AblePlatform.NlsMsg("ASR_NoResponse", new Object[]{this.myNoResponse == null ? null : this.myNoResponse.debugString()}));
        return stringBuffer.toString();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    public boolean equals(Object object) {
        AbleAgentSituation ableAgentSituation = null;
        if (!(object instanceof AbleAgentSituation)) {
            return false;
        }
        ableAgentSituation = (AbleAgentSituation)object;
        if (ableAgentSituation != null && (this.mySituationName == null ? ableAgentSituation.getName() == null : this.mySituationName.equals((Object)ableAgentSituation.getName())) && (this.mySituationIdentifier == null ? ableAgentSituation.getSituationIdentifier() == null : this.mySituationIdentifier.equals(ableAgentSituation.getSituationIdentifier())) && (this.myNoResponse == null ? ableAgentSituation.getNoResponse() == null : this.myNoResponse.equals((Object)ableAgentSituation.getNoResponse())) && (this.myYesResponse == null ? ableAgentSituation.getYesResponse() == null : this.myYesResponse.equals((Object)ableAgentSituation.getYesResponse())) && (this.mySituationType == null ? ableAgentSituation.getSituationType() == null : this.mySituationType.equals((Object)ableAgentSituation.getSituationType())) && this.mySeverityLevel == ableAgentSituation.getSeverityLevel() && (this.myResponses == null ? ableAgentSituation.getResponses() == null : ableAgentSituation.getResponses() != null)) {
            if (this.myResponses != null) {
                AbleMessageContainer[] ableMessageContainerArray = ableAgentSituation.getResponses();
                if (ableMessageContainerArray.length != this.myResponses.length) {
                    return false;
                }
                for (int i = 0; i < this.myResponses.length; ++i) {
                    if (this.myResponses[i] != null ? this.myResponses[i].equals((Object)ableMessageContainerArray[i]) : ableMessageContainerArray[i] == null) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        if (this.myResponses != null) {
            for (int i = 0; i < this.myResponses.length; ++i) {
                if (this.myResponses[i] == null) continue;
                n += this.myResponses[i].hashCode();
            }
        }
        if (this.mySituationName != null) {
            n += this.mySituationName.hashCode();
        }
        n += this.mySeverityLevel;
        if (this.mySituationType != null) {
            n += this.mySituationType.hashCode();
        }
        if (this.myYesResponse != null) {
            n += this.myYesResponse.hashCode();
        }
        if (this.myNoResponse != null) {
            n += this.myNoResponse.hashCode();
        }
        return n;
    }

    public String toString() {
        return "AgentSituation: Identifier = " + this.mySituationIdentifier + "; Name = " + this.mySituationName;
    }
}

