/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.platform;

import com.ibm.able.AbleMessageContainer;
import com.ibm.able.platform.AbleAgentSituation;
import com.ibm.able.platform.AblePlatform;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;

public class AbleAgentCapability
implements Serializable {
    static final long serialVersionUID = 2003052100000000001L;
    public static final int YES_CAPABILITY = 1;
    public static final int NO_CAPABILITY = 2;
    public static final int ASK_CAPABILITY = 3;
    private final Serializable myCapabilityIdentifier;
    private final AbleMessageContainer myCapabilityName;
    private int myAutonomyLevel = 2;
    private final HashMap mySituations;

    public AbleAgentCapability(Serializable serializable, AbleMessageContainer ableMessageContainer, int n, HashMap hashMap) {
        this.myCapabilityIdentifier = serializable;
        this.myCapabilityName = ableMessageContainer;
        this.myAutonomyLevel = n;
        this.mySituations = hashMap != null ? (HashMap)hashMap.clone() : new HashMap();
    }

    public AbleAgentCapability(AbleAgentCapability ableAgentCapability) {
        this.myCapabilityIdentifier = ableAgentCapability.myCapabilityIdentifier;
        this.myCapabilityName = ableAgentCapability.myCapabilityName;
        this.myAutonomyLevel = ableAgentCapability.myAutonomyLevel;
        this.mySituations = (HashMap)ableAgentCapability.mySituations.clone();
    }

    public Serializable getCapabilityIdentifier() {
        return this.myCapabilityIdentifier;
    }

    public AbleMessageContainer getName() {
        return this.myCapabilityName;
    }

    public void setAutonomyLevel(int n) {
        this.myAutonomyLevel = n;
    }

    public int getAutonomyLevel() {
        return this.myAutonomyLevel;
    }

    public HashMap getSituations() {
        return this.mySituations;
    }

    public AbleAgentSituation getSituation(Serializable serializable) {
        return (AbleAgentSituation)this.mySituations.get(serializable);
    }

    public String debugString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(AblePlatform.NlsMsg("ASR_CapabilityIdentifier", new Object[]{this.myCapabilityIdentifier}));
        stringBuffer.append(AblePlatform.NlsMsg("ASR_CapabilityName", new Object[]{this.myCapabilityName == null ? null : this.myCapabilityName.debugString()}));
        stringBuffer.append(AblePlatform.NlsMsg("ASR_CapabilityLevel", new Object[]{new Integer(this.myAutonomyLevel)}));
        Iterator iterator = this.mySituations.keySet().iterator();
        while (iterator.hasNext()) {
            AbleAgentSituation ableAgentSituation = (AbleAgentSituation)this.mySituations.get(iterator.next());
            stringBuffer.append(ableAgentSituation == null ? null : ableAgentSituation.debugString());
        }
        return stringBuffer.toString();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbleAgentCapability)) {
            return false;
        }
        AbleAgentCapability ableAgentCapability = (AbleAgentCapability)object;
        if (ableAgentCapability != null && (this.myCapabilityIdentifier == null ? ableAgentCapability.getCapabilityIdentifier() == null : this.myCapabilityIdentifier.equals(ableAgentCapability.getCapabilityIdentifier())) && (this.myCapabilityName == null ? ableAgentCapability.getName() == null : this.myCapabilityName.equals((Object)ableAgentCapability.getName())) && this.myAutonomyLevel == ableAgentCapability.getAutonomyLevel()) {
            HashMap hashMap = ableAgentCapability.getSituations();
            if (this.mySituations.size() == hashMap.size()) {
                Iterator iterator = this.mySituations.keySet().iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    if (((AbleAgentSituation)this.mySituations.get(k)).equals((AbleAgentSituation)hashMap.get(k))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        if (this.myCapabilityIdentifier != null) {
            n += this.myCapabilityIdentifier.hashCode();
        }
        if (this.myCapabilityName != null) {
            n += this.myCapabilityName.hashCode();
        }
        n += this.myAutonomyLevel;
        if (this.mySituations != null) {
            n += this.mySituations.hashCode();
        }
        return n;
    }

    public String toString() {
        return "AgentCapability: Identifier = " + this.myCapabilityIdentifier + "; Name = " + this.myCapabilityName;
    }
}

