/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.conversation;

import com.ibm.able.AbleBean;
import com.ibm.able.conversation.AbleOwned;
import com.ibm.conversation.Conversation;
import com.ibm.conversation.ConversationMetaData;
import com.ibm.conversation.MessageHandle;
import com.ibm.conversation.MessageSystemAdapter;
import com.ibm.conversation.base.BasicMessageHandle;
import com.ibm.conversation.jas.JasConversationMetaData;
import javax.agent.AgentName;
import javax.agent.Envelope;
import javax.agent.Locator;
import javax.agent.Payload;
import javax.agent.TransportMessage;
import javax.agent.service.transport.MessageTransportService;
import javax.agent.service.transport.NotLocatableException;
import javax.agent.service.transport.TransportFailure;
import org.jagent.acr.AcrEnvelope;
import org.jagent.acr.AcrPayload;

public class AblePlatformMessageSystemAdapter
extends AbleOwned
implements MessageSystemAdapter {
    public static final String SENDER_CONVERSATION_ID = "senderConversationID";
    public static final String RECIPIENT_CONVERSATION_ID = "recipientConversationID";
    private MessageTransportService transportService = null;

    public AblePlatformMessageSystemAdapter() {
    }

    public AblePlatformMessageSystemAdapter(AbleBean ableBean) {
        super(ableBean);
    }

    public AblePlatformMessageSystemAdapter(AbleBean ableBean, MessageTransportService messageTransportService) {
        super(ableBean);
        this.transportService = messageTransportService;
    }

    public MessageTransportService getTransportService() {
        return this.transportService;
    }

    public void setTransportService(MessageTransportService messageTransportService) {
        this.transportService = messageTransportService;
    }

    public static String parseConversationId(TransportMessage transportMessage) {
        Envelope envelope = transportMessage.getEnvelope();
        String string = (String)envelope.get(RECIPIENT_CONVERSATION_ID);
        return string;
    }

    public static MessageHandle makeMessageHandle(TransportMessage transportMessage) {
        BasicMessageHandle basicMessageHandle = new BasicMessageHandle();
        basicMessageHandle.setMessage((Object)transportMessage.getPayload());
        return basicMessageHandle;
    }

    public MessageHandle createMessage() {
        AcrPayload acrPayload = new AcrPayload();
        BasicMessageHandle basicMessageHandle = new BasicMessageHandle((Object)acrPayload);
        return basicMessageHandle;
    }

    public void sendMessage(Conversation conversation, MessageHandle messageHandle) {
        this.sendMessage(conversation.getMetaData(), messageHandle);
    }

    private void sendMessage(ConversationMetaData conversationMetaData, MessageHandle messageHandle) {
        TransportMessage transportMessage = this.createTransportMessage(conversationMetaData, messageHandle);
        try {
            this.transportService.sendMessage(transportMessage);
        }
        catch (NotLocatableException notLocatableException) {
            this.logException("sendMessage", (Exception)((Object)notLocatableException));
            this.logMessage(4L, "sendMessage", "recipient locator = " + transportMessage.getReceiver());
        }
        catch (TransportFailure transportFailure) {
            this.logException("sendMessage", (Exception)((Object)transportFailure));
        }
    }

    protected TransportMessage createTransportMessage(ConversationMetaData conversationMetaData, MessageHandle messageHandle) {
        if (!(conversationMetaData instanceof JasConversationMetaData)) {
            throw new IllegalArgumentException("Expected JasConversationMetaData for meta-data");
        }
        Object object = messageHandle.getMessage();
        if (!(object instanceof Payload)) {
            throw new IllegalArgumentException("Expected Payload for message object");
        }
        TransportMessage transportMessage = this.transportService.createTransportMessage();
        transportMessage.setPayload((Payload)object);
        Envelope envelope = transportMessage.getEnvelope();
        if (envelope == null || !(envelope instanceof AcrEnvelope)) {
            envelope = new AcrEnvelope();
            transportMessage.setEnvelope(envelope);
        }
        this.initEnvelope((JasConversationMetaData)conversationMetaData, (AcrEnvelope)envelope);
        return transportMessage;
    }

    protected void initEnvelope(JasConversationMetaData jasConversationMetaData, AcrEnvelope acrEnvelope) {
        AgentName agentName = jasConversationMetaData.getSelfAgentName();
        Locator locator = jasConversationMetaData.getSelfLocator();
        String string = jasConversationMetaData.getSelfConversationId();
        Locator locator2 = jasConversationMetaData.getPartnerLocator();
        String string2 = jasConversationMetaData.getPartnerConversationId();
        acrEnvelope.setSender(locator);
        acrEnvelope.setReceiver(locator2);
        acrEnvelope.set("com.ibm.able.platform.able-envelope-displayName", (Object)agentName);
        if (string != null) {
            acrEnvelope.set(SENDER_CONVERSATION_ID, (Object)string);
        }
        if (string2 != null) {
            acrEnvelope.set(RECIPIENT_CONVERSATION_ID, (Object)string2);
        }
    }
}

