/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.conversation;

import com.ibm.able.AbleBean;
import com.ibm.able.conversation.AbleOwned;
import com.ibm.conversation.Conversation;
import com.ibm.conversation.ConversationException;
import com.ibm.conversation.ConversationManager;
import com.ibm.conversation.ConversationMetaData;
import com.ibm.conversation.DecisionDataHandle;
import com.ibm.conversation.base.BasicDecisionDataHandle;
import com.ibm.conversation.jas.JasConversationMetaData;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.agent.AgentName;
import javax.agent.Locator;

public class AblePlatformConversationSetupLogic
extends AbleOwned {
    Hashtable rootPolicies = new Hashtable();
    ConversationManager conversationManager = null;

    public AblePlatformConversationSetupLogic() {
    }

    public AblePlatformConversationSetupLogic(AbleBean ableBean) {
        super(ableBean);
    }

    public AblePlatformConversationSetupLogic(AbleBean ableBean, ConversationManager conversationManager) {
        super(ableBean);
        this.conversationManager = conversationManager;
    }

    public ConversationManager getConversationManager() {
        return this.conversationManager;
    }

    public void setConversationManager(ConversationManager conversationManager) {
        this.conversationManager = conversationManager;
    }

    public String getRootPartnerRole(String string) {
        PolicyInfo policyInfo = (PolicyInfo)this.rootPolicies.get(string);
        if (policyInfo != null && policyInfo.selfRole != null && this.conversationManager != null) {
            Collection collection = this.conversationManager.getConversationPolicyHandlerFactory().getRoles(policyInfo.policyName);
            Iterator iterator = collection.iterator();
            String string2 = null;
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                if (policyInfo.selfRole.equals(string2)) continue;
                return string2;
            }
        }
        return null;
    }

    public String getRootSelfRole(String string) {
        PolicyInfo policyInfo = (PolicyInfo)this.rootPolicies.get(string);
        if (policyInfo != null) {
            return policyInfo.selfRole;
        }
        return null;
    }

    public String getRootPolicyName(String string) {
        PolicyInfo policyInfo = (PolicyInfo)this.rootPolicies.get(string);
        if (policyInfo != null) {
            return policyInfo.policyName;
        }
        return null;
    }

    public void setRootPolicy(String string, String string2, String string3) {
        if (!this.isPolicySupported(string2, string3)) {
            throw new IllegalArgumentException("Policy \"" + string2 + "\" role \"" + string3 + "\" not supported.");
        }
        PolicyInfo policyInfo = new PolicyInfo(string2, string3);
        this.rootPolicies.put(string, policyInfo);
    }

    public boolean isPolicySupported(String string, String string2) {
        if (this.conversationManager == null) {
            return false;
        }
        return this.conversationManager.getConversationPolicyHandlerFactory().isPolicySupported(string, string2);
    }

    public boolean isValidPartnerPolicy(String string, String string2, String string3) {
        String string4 = this.getRootPolicyName(string);
        String string5 = this.getRootPartnerRole(string);
        return string4 != null && string4.equals(string2) && string5 != null && string5.equals(string3);
    }

    public void start(Conversation conversation, DecisionDataHandle decisionDataHandle) {
        ConversationMetaData conversationMetaData = conversation.getMetaData();
        if (!(conversationMetaData instanceof JasConversationMetaData)) {
            String string = "Expected JAS meta-data in conversation.";
            this.logMessage(4L, "start", string);
            throw new IllegalArgumentException(string);
        }
        JasConversationMetaData jasConversationMetaData = (JasConversationMetaData)conversationMetaData;
        String string = jasConversationMetaData.getSelfConversationId();
        AgentName agentName = jasConversationMetaData.getSelfAgentName();
        Locator locator = jasConversationMetaData.getSelfLocator();
        String string2 = conversation.getConversationId();
        String string3 = this.getRootPolicyName(string2);
        String string4 = this.getRootSelfRole(string2);
        String string5 = this.getRootPartnerRole(string2);
        if (string3 == null) {
            String string6 = "No root policy for convId \"" + string2 + "\"";
            this.logMessage(4L, "start", string6);
            throw new IllegalArgumentException(string6);
        }
        if (string4 == null) {
            String string7 = "No root policy requestor role for convId \"" + string2 + "\"";
            this.logMessage(4L, "start", string7);
            throw new IllegalArgumentException(string7);
        }
        if (!this.isPolicySupported(string3, string4)) {
            String string8 = "Policy \"" + string3 + "\" role \"" + string4 + "\" not supported.";
            this.logMessage(4L, "start", string8);
            throw new IllegalArgumentException(string8);
        }
        String string9 = "requestConversation";
        Object[] objectArray = new Object[]{string, agentName, locator, string3, string4, string5};
        BasicDecisionDataHandle basicDecisionDataHandle = new BasicDecisionDataHandle();
        basicDecisionDataHandle.setName(string9);
        basicDecisionDataHandle.setArgs(objectArray);
        String string10 = "Opening conversation. rootPolicy=" + string3 + " selfRole=" + string4 + " partnerRole=" + string5;
        this.logMessage(1L, "start", string10);
        try {
            conversation.processDecision((DecisionDataHandle)basicDecisionDataHandle);
        }
        catch (ConversationException conversationException) {
            this.logException("start", (Exception)((Object)conversationException));
        }
    }

    public void conversationRequested(Conversation conversation, DecisionDataHandle decisionDataHandle) {
        String string;
        this.logMessage(1L, "conversationRequested", "");
        String string2 = null;
        AgentName agentName = null;
        Locator locator = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Object[] objectArray = decisionDataHandle.getArgs();
        try {
            string2 = (String)objectArray[0];
            agentName = (AgentName)objectArray[1];
            locator = (Locator)objectArray[2];
            string3 = (String)objectArray[3];
            string4 = (String)objectArray[4];
            string5 = (String)objectArray[5];
        }
        catch (Exception exception) {
            this.logException("conversationRequested", exception);
        }
        ConversationMetaData conversationMetaData = conversation.getMetaData();
        if (!(conversationMetaData instanceof JasConversationMetaData)) {
            String string6 = "Expected JAS meta-data in conversation.";
            this.logMessage(4L, "conversationRequested", string6);
            throw new IllegalArgumentException(string6);
        }
        JasConversationMetaData jasConversationMetaData = (JasConversationMetaData)conversationMetaData;
        jasConversationMetaData.setPartnerConversationId(string2);
        jasConversationMetaData.setPartnerAgentName(agentName);
        jasConversationMetaData.setPartnerLocator(locator);
        String string7 = null;
        Object[] objectArray2 = null;
        String string8 = null;
        boolean bl = true;
        if (!this.isPolicySupported(string3, string5)) {
            bl = false;
            string8 = "Policy not supported";
        } else {
            bl = this.decideAcceptance(agentName, locator, string3, string5);
            if (!bl) {
                string8 = "Chose not to converse";
            }
        }
        if (bl) {
            string = jasConversationMetaData.getSelfConversationId();
            AgentName agentName2 = jasConversationMetaData.getSelfAgentName();
            Locator locator2 = jasConversationMetaData.getSelfLocator();
            String string9 = string3;
            String string10 = string4;
            String string11 = string5;
            string7 = "acceptConversation";
            objectArray2 = new Object[]{string, agentName2, locator2, string9, string10, string11};
        } else {
            string7 = "refuse";
            objectArray2 = new Object[]{string8};
        }
        string = new BasicDecisionDataHandle();
        string.setName(string7);
        string.setArgs(objectArray2);
        try {
            conversation.processDecision((DecisionDataHandle)string);
        }
        catch (ConversationException conversationException) {
            this.logException("conversationRequested", (Exception)((Object)conversationException));
        }
        this.setRootPolicy(conversation.getConversationId(), string3, string5);
    }

    public void conversationAccepted(Conversation conversation, DecisionDataHandle decisionDataHandle) {
        this.logMessage(1L, "conversationAccepted", "start");
        String string = conversation.getActivePolicyRole();
        this.logMessage(1L, "conversationAccepted", "selfRole=" + string);
        if (string.equals("Caller")) {
            this.callerConversationAccepted(conversation, decisionDataHandle);
        } else if (string.equals("Responder")) {
            this.responderConversationAccepted(conversation, decisionDataHandle);
        }
    }

    protected void callerConversationAccepted(Conversation conversation, DecisionDataHandle decisionDataHandle) {
        String string = null;
        AgentName agentName = null;
        Locator locator = null;
        String string2 = null;
        String string3 = null;
        Object[] objectArray = decisionDataHandle.getArgs();
        try {
            string = (String)objectArray[0];
            agentName = (AgentName)objectArray[1];
            locator = (Locator)objectArray[2];
            string2 = (String)objectArray[3];
            string3 = (String)objectArray[5];
        }
        catch (Exception exception) {
            this.logException("conversationAccepted", exception);
        }
        ConversationMetaData conversationMetaData = conversation.getMetaData();
        if (!(conversationMetaData instanceof JasConversationMetaData)) {
            String string4 = "Expected JAS meta-data in conversation.";
            this.logMessage(4L, "conversationRequested", string4);
            throw new IllegalArgumentException(string4);
        }
        JasConversationMetaData jasConversationMetaData = (JasConversationMetaData)conversationMetaData;
        jasConversationMetaData.setPartnerConversationId(string);
        jasConversationMetaData.setPartnerAgentName(agentName);
        jasConversationMetaData.setPartnerLocator(locator);
        if (!this.isValidPartnerPolicy(conversation.getConversationId(), string2, string3)) {
            String string5 = "Partner policy doesn't match! proposedRootPolicy=" + string2 + " proposedAcceptorRole=" + string3;
            this.logMessage(1L, "conversationRequested", string5);
        } else {
            String string6 = this.getRootPolicyName(conversation.getConversationId());
            String string7 = this.getRootSelfRole(conversation.getConversationId());
            conversation.setRootPolicy(string6, string7);
            conversation.start();
        }
    }

    protected void responderConversationAccepted(Conversation conversation, DecisionDataHandle decisionDataHandle) {
        String string = this.getRootPolicyName(conversation.getConversationId());
        String string2 = this.getRootSelfRole(conversation.getConversationId());
        conversation.setRootPolicy(string, string2);
        conversation.start();
    }

    public void conversationOver(Conversation conversation, DecisionDataHandle decisionDataHandle) {
        this.logMessage(1L, "conversationOver", "");
    }

    public boolean decideAcceptance(AgentName agentName, Locator locator, String string, String string2) {
        return true;
    }

    private class PolicyInfo {
        public String policyName = null;
        public String selfRole = null;

        public PolicyInfo(String string, String string2) {
            this.policyName = string;
            this.selfRole = string2;
        }
    }
}

