/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.conversation;

import com.ibm.able.AbleBean;
import com.ibm.able.AbleException;
import com.ibm.able.AbleUserDefinedFunction;
import com.ibm.able.AbleUserDefinedFunctionRemoteManager;
import com.ibm.able.conversation.AbleConversationManager;
import com.ibm.able.conversation.AbleMessageTransformFactory;
import com.ibm.able.conversation.AblePlatformConversationSetupLogic;
import com.ibm.able.conversation.AblePlatformMessageSystemAdapter;
import com.ibm.able.conversation.AbleRemoteUdfDecisionLogicAdapter;
import com.ibm.able.platform.AblePlatformDefaultAgent;
import com.ibm.conversation.Conversation;
import com.ibm.conversation.ConversationException;
import com.ibm.conversation.ConversationManager;
import com.ibm.conversation.ConversationMetaData;
import com.ibm.conversation.ConversationPolicyHandler;
import com.ibm.conversation.ConversationPolicyHandlerFactory;
import com.ibm.conversation.DecisionDataHandle;
import com.ibm.conversation.DecisionLogicAdapter;
import com.ibm.conversation.MessageDescription;
import com.ibm.conversation.MessageHandle;
import com.ibm.conversation.MessageSystemAdapter;
import com.ibm.conversation.base.BasicMessageDescription;
import com.ibm.conversation.jas.JasConversationMetaData;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import javax.agent.AgentName;
import javax.agent.Locator;
import javax.agent.TransportMessage;
import javax.agent.service.directory.AgentDescription;
import javax.agent.service.transport.MessageTransportService;

public class AblePlatformConversationAgent
extends AblePlatformDefaultAgent {
    protected static final long serialVersionUID = 2003050100100500001L;
    public static final String PREFERRED_LOCATOR_TYPE = "rmi";
    public static final String CP_REPOSITORY_PATH_PROPERTY = "com.ibm.conversation.repositoryPath";
    private static final String INITIAL_CP_NAME = "ConversationSetup3";
    private static final String INITIAL_CP_INITIATOR = "Caller";
    private static final String INITIAL_CP_RESPONDER = "Responder";
    protected AblePlatformMessageSystemAdapter messageSystemAdapter = null;
    protected AbleConversationManager conversationManager = null;
    protected AbleRemoteUdfDecisionLogicAdapter decisionLogicAdapter = null;
    AblePlatformConversationSetupLogic setupLogic = null;
    static /* synthetic */ Class class$com$ibm$conversation$Conversation;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$ibm$conversation$MessageHandle;
    static /* synthetic */ Class class$com$ibm$conversation$DecisionDataHandle;
    static /* synthetic */ Class class$javax$agent$TransportMessage;
    static /* synthetic */ Class class$com$ibm$conversation$jas$JasConversationSetupTransform;
    static /* synthetic */ Class class$com$ibm$conversation$jas$JasStringLiteralTransform;
    static /* synthetic */ Class class$com$ibm$conversation$jas$JasLabelledStringTransform;

    public AblePlatformConversationAgent() throws RemoteException, AbleException {
        this.createInstanceVariables();
    }

    public AblePlatformConversationAgent(String string) throws RemoteException, AbleException {
        super(string);
        this.createInstanceVariables();
    }

    private void createInstanceVariables() {
        try {
            this.messageSystemAdapter = new AblePlatformMessageSystemAdapter((AbleBean)this);
            this.decisionLogicAdapter = new AbleRemoteUdfDecisionLogicAdapter((AbleBean)this, (AbleUserDefinedFunctionRemoteManager)this);
            String string = this.getName() + ".conversationManager";
            this.conversationManager = new AbleConversationManager(string);
            this.conversationManager.setDecisionLogicAdapter((DecisionLogicAdapter)this.decisionLogicAdapter);
            this.conversationManager.setMessageSystemAdapter((MessageSystemAdapter)this.messageSystemAdapter);
        }
        catch (Exception exception) {
            this.logger.text(4L, (Object)this, "AblePlatformConversationAgent", exception.getLocalizedMessage());
            this.trace.exception(262144L, (Object)this, "AblePlatformConversationAgent", (Throwable)exception);
        }
        try {
            this.addBean((AbleBean)this.conversationManager);
        }
        catch (Exception exception) {
            this.logger.text(4L, (Object)this, "AblePlatformConversationAgent", exception.getLocalizedMessage());
            this.trace.exception(262144L, (Object)this, "AblePlatformConversationAgent", (Throwable)exception);
        }
        this.setupLogic = new AblePlatformConversationSetupLogic((AbleBean)this, (ConversationManager)this.conversationManager);
    }

    public ConversationManager getConversationManager() {
        return this.conversationManager;
    }

    public String getPartnerRole(String string, String string2) {
        Collection collection = this.conversationManager.getConversationPolicyHandlerFactory().getRoles(string);
        if (collection == null) {
            return null;
        }
        Iterator iterator = collection.iterator();
        String string3 = null;
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            if (string3.equals(string2)) continue;
            return string3;
        }
        return null;
    }

    public void onMessage(TransportMessage transportMessage) {
        JasConversationMetaData jasConversationMetaData;
        String string = null;
        Conversation conversation = null;
        String string2 = AblePlatformMessageSystemAdapter.parseConversationId(transportMessage);
        if (string2 != null) {
            conversation = this.conversationManager.getConversation(string2);
            if (conversation == null) {
                string = "No conversation found for conversation ID \"" + string2 + "\"";
                this.logMessage(2L, "onMessage", string);
            }
        } else {
            jasConversationMetaData = this.createMetaData();
            conversation = this.conversationManager.newConversation((ConversationMetaData)jasConversationMetaData, false);
            if (conversation != null) {
                string2 = conversation.getConversationId();
                jasConversationMetaData.setConnectionStatus(1);
                conversation.start();
            }
        }
        if (conversation != null) {
            jasConversationMetaData = AblePlatformMessageSystemAdapter.makeMessageHandle(transportMessage);
            try {
                conversation.processMessage((MessageHandle)jasConversationMetaData);
            }
            catch (ConversationException conversationException) {
                this.logException("onMessage", (Exception)((Object)conversationException));
            }
        }
    }

    protected JasConversationMetaData createMetaData() {
        JasConversationMetaData jasConversationMetaData = new JasConversationMetaData();
        Locator locator = AblePlatformConversationAgent.getLocatorForInbox(this.myJasAgentDescription, "conversationInbox");
        AgentName agentName = this.myJasAgentName;
        jasConversationMetaData.setSelfLocator(locator);
        jasConversationMetaData.setSelfAgentName(agentName);
        return jasConversationMetaData;
    }

    public void onUnexpectedMessage(Conversation conversation, MessageHandle messageHandle) {
        Object object = messageHandle.getMessage();
        String string = object.getClass().getName();
        String string2 = "\n  ";
        String string3 = "convId=" + conversation.getConversationId() + string2 + "messageClass=" + string + string2 + "context=" + conversation.getContext().toString();
        this.logMessage(1L, "onUnexpectedMessage", string3);
    }

    public void onTimeout(Conversation conversation, String string) {
        String string2 = "\n  ";
        String string3 = "convId=" + conversation.getConversationId() + string2 + "context={" + string2 + conversation.getContext().toString() + string2 + " }" + string2 + "newState=" + string;
        this.logMessage(1L, "onTimeout", string3);
    }

    public void onInboundDecision(Conversation conversation, DecisionDataHandle decisionDataHandle) {
        String string = "\n  ";
        String string2 = "convId=" + conversation.getConversationId() + string + "decision=" + decisionDataHandle.getName() + string + "context={" + string + conversation.getContext().toString() + string + "}";
        this.logMessage(1L, "onInboundDecision", string2);
    }

    public static Locator getLocatorForType(AgentDescription agentDescription, String string) {
        Locator locator = null;
        Locator[] locatorArray = agentDescription.getLocators();
        for (int i = 0; i < locatorArray.length; ++i) {
            if (!locatorArray[i].getType().equalsIgnoreCase(string)) continue;
            locator = locatorArray[i];
            break;
        }
        return locator;
    }

    public static Locator getLocatorForInbox(AgentDescription agentDescription, String string) {
        Locator locator = null;
        Locator[] locatorArray = agentDescription.getLocators();
        for (int i = 0; i < locatorArray.length; ++i) {
            String string2 = "com.ibm.able.platform.able-locator-protocol";
            Object object = locatorArray[i].get(string2);
            if (!string.equals(object)) continue;
            locator = locatorArray[i];
            break;
        }
        return locator;
    }

    public void startConversation(String string, String string2, String string3) {
        String string4 = "javax.agent.agent-display-name";
        String string5 = string;
        AgentDescription[] agentDescriptionArray = null;
        try {
            agentDescriptionArray = this.lookUpAgent(string4, string5);
        }
        catch (Exception exception) {
            this.logException("startConversation", exception);
        }
        if (agentDescriptionArray != null && agentDescriptionArray.length > 0) {
            this.startConversation(agentDescriptionArray[0], string2, string3);
        }
    }

    public void startConversation(AgentName agentName, String string, String string2) {
        String string3 = "javax.agent.agent-name";
        AgentName agentName2 = agentName;
        AgentDescription[] agentDescriptionArray = null;
        try {
            agentDescriptionArray = this.lookUpAgent(string3, agentName2);
        }
        catch (Exception exception) {
            this.logException("startConversation", exception);
        }
        if (agentDescriptionArray != null && agentDescriptionArray.length > 0) {
            this.startConversation(agentDescriptionArray[0], string, string2);
        }
    }

    public void startConversation(AgentDescription agentDescription, String string, String string2) {
        Locator locator = AblePlatformConversationAgent.getLocatorForType(agentDescription, PREFERRED_LOCATOR_TYPE);
        if (locator == null) {
            String string3 = "Locator of type \"rmi\" not found in agent description";
            this.logMessage(4L, "startConversation", string3);
            return;
        }
        AgentName agentName = agentDescription.getAgentName();
        this.startConversation(agentName, locator, string, string2);
    }

    public void startConversation(AgentName agentName, Locator locator, String string, String string2) {
        JasConversationMetaData jasConversationMetaData = this.createMetaData();
        Conversation conversation = this.conversationManager.newConversation((ConversationMetaData)jasConversationMetaData, true);
        jasConversationMetaData.setConnectionStatus(0);
        jasConversationMetaData.setPartnerLocator(locator);
        jasConversationMetaData.setPartnerAgentName(agentName);
        this.setupLogic.setRootPolicy(conversation.getConversationId(), string, string2);
        conversation.start();
    }

    public void installTargetForCp(String string, String string2, Object object) {
        ConversationPolicyHandlerFactory conversationPolicyHandlerFactory = this.conversationManager.getConversationPolicyHandlerFactory();
        ConversationPolicyHandler conversationPolicyHandler = conversationPolicyHandlerFactory.getPolicyHandler(string, string2);
        if (conversationPolicyHandler == null) {
            String string3 = "CP \"" + string + "\" not supported";
            this.logMessage(4L, "installTargetForCp", string3);
        } else {
            Collection collection = conversationPolicyHandler.getDecisionLogicCallbackNames(string2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("CP=\"" + string + "\" role=\"" + string2 + "\" callbacks={");
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("}");
            this.logMessage(4L, "installTargetForCp", stringBuffer.toString());
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                String string4 = (String)iterator2.next();
                try {
                    this.decisionLogicAdapter.createTarget(string, string4, object);
                }
                catch (Exception exception) {
                    this.logException("installTargetForCp", exception);
                }
            }
        }
    }

    public void init() throws AbleException {
        Object object;
        String string;
        this.initInbox();
        super.init();
        MessageTransportService messageTransportService = this.myJasMessageTransportService;
        this.messageSystemAdapter.setTransportService(messageTransportService);
        String string2 = System.getProperty(CP_REPOSITORY_PATH_PROPERTY);
        if (string2 != null) {
            string = "Set CP repository path to \"" + string2 + "\"";
            this.logMessage(1L, "init", string);
            this.conversationManager.setConversationPolicyRepositoryPath(string2);
        } else {
            string = this.conversationManager.getConversationPolicyRepositoryPath();
            object = "CP repository path not found in System properties. Using current path \"" + string + "\"";
            this.logMessage(2L, "init", (String)object);
        }
        this.conversationManager.setInitialPolicy(INITIAL_CP_NAME, INITIAL_CP_INITIATOR, INITIAL_CP_RESPONDER);
        this.installTargetForCp(INITIAL_CP_NAME, INITIAL_CP_INITIATOR, (Object)this.setupLogic);
        this.installTargetForCp(INITIAL_CP_NAME, INITIAL_CP_RESPONDER, (Object)this.setupLogic);
        this.conversationManager.init();
        this.initMessageTransforms();
        string = null;
        object = this;
        String string3 = null;
        Class[] classArray = null;
        string = "timeout";
        string3 = "onTimeout";
        classArray = new Class[]{class$com$ibm$conversation$Conversation == null ? (class$com$ibm$conversation$Conversation = AblePlatformConversationAgent.class$("com.ibm.conversation.Conversation")) : class$com$ibm$conversation$Conversation, class$java$lang$String == null ? (class$java$lang$String = AblePlatformConversationAgent.class$("java.lang.String")) : class$java$lang$String};
        this.createTarget(string, object, string3, classArray);
        this.decisionLogicAdapter.setTimeoutUdfName(string);
        if (!this.containsUserDefinedFunction(string, classArray.length)) {
            String string4 = "Registration of UDF for timeouts failed";
            this.logMessage(4L, "init", string4);
            throw new AbleException(string4);
        }
        string = "unexpectedMessage";
        string3 = "onUnexpectedMessage";
        classArray = new Class[]{class$com$ibm$conversation$Conversation == null ? (class$com$ibm$conversation$Conversation = AblePlatformConversationAgent.class$("com.ibm.conversation.Conversation")) : class$com$ibm$conversation$Conversation, class$com$ibm$conversation$MessageHandle == null ? (class$com$ibm$conversation$MessageHandle = AblePlatformConversationAgent.class$("com.ibm.conversation.MessageHandle")) : class$com$ibm$conversation$MessageHandle};
        this.createTarget(string, object, string3, classArray);
        this.decisionLogicAdapter.setUnexpectedMessageUdfName(string);
        if (!this.containsUserDefinedFunction(string, classArray.length)) {
            String string5 = "Registration of UDF for unexpected messages failed";
            this.logMessage(4L, "init", string5);
            throw new AbleException(string5);
        }
        string = "decision";
        string3 = "onInboundDecision";
        classArray = new Class[]{class$com$ibm$conversation$Conversation == null ? (class$com$ibm$conversation$Conversation = AblePlatformConversationAgent.class$("com.ibm.conversation.Conversation")) : class$com$ibm$conversation$Conversation, class$com$ibm$conversation$DecisionDataHandle == null ? (class$com$ibm$conversation$DecisionDataHandle = AblePlatformConversationAgent.class$("com.ibm.conversation.DecisionDataHandle")) : class$com$ibm$conversation$DecisionDataHandle};
        this.createTarget(string, object, string3, classArray);
        this.decisionLogicAdapter.setDefaultDecisionUdfName(string);
        if (!this.containsUserDefinedFunction(string, classArray.length)) {
            String string6 = "Registration of default UDF for inbound decisions failed";
            this.logMessage(4L, "init", string6);
            throw new AbleException(string6);
        }
    }

    private void initInbox() throws AbleException {
        Class<?> clazz = this.getClass();
        Method method = null;
        try {
            method = clazz.getMethod("onMessage", class$javax$agent$TransportMessage == null ? (class$javax$agent$TransportMessage = AblePlatformConversationAgent.class$("javax.agent.TransportMessage")) : class$javax$agent$TransportMessage);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.logException("initInbox", noSuchMethodException);
            throw new AbleException("ABLE JAS Conversation agent caught NoSuchMethodException.", (Throwable)noSuchMethodException);
        }
        AbleUserDefinedFunction ableUserDefinedFunction = new AbleUserDefinedFunction("receiveMessage", (Object)this, method);
        super.addAgentInbox(new Object[]{"conversationInbox", ableUserDefinedFunction});
    }

    private void initMessageTransforms() {
        AbleMessageTransformFactory ableMessageTransformFactory = (AbleMessageTransformFactory)this.conversationManager.getMessageTransformFactory();
        BasicMessageDescription basicMessageDescription = null;
        basicMessageDescription = new BasicMessageDescription("ConversationSetup", "any");
        ableMessageTransformFactory.addTransform((MessageDescription)basicMessageDescription, class$com$ibm$conversation$jas$JasConversationSetupTransform == null ? (class$com$ibm$conversation$jas$JasConversationSetupTransform = AblePlatformConversationAgent.class$("com.ibm.conversation.jas.JasConversationSetupTransform")) : class$com$ibm$conversation$jas$JasConversationSetupTransform);
        basicMessageDescription = new BasicMessageDescription("StringConstant", "any");
        ableMessageTransformFactory.addTransform((MessageDescription)basicMessageDescription, class$com$ibm$conversation$jas$JasStringLiteralTransform == null ? (class$com$ibm$conversation$jas$JasStringLiteralTransform = AblePlatformConversationAgent.class$("com.ibm.conversation.jas.JasStringLiteralTransform")) : class$com$ibm$conversation$jas$JasStringLiteralTransform);
        basicMessageDescription = new BasicMessageDescription("LabelledString", "any");
        ableMessageTransformFactory.addTransform((MessageDescription)basicMessageDescription, class$com$ibm$conversation$jas$JasLabelledStringTransform == null ? (class$com$ibm$conversation$jas$JasLabelledStringTransform = AblePlatformConversationAgent.class$("com.ibm.conversation.jas.JasLabelledStringTransform")) : class$com$ibm$conversation$jas$JasLabelledStringTransform);
    }

    private AbleUserDefinedFunction createTarget(String string, Object object, String string2, Class[] classArray) {
        Method method = null;
        try {
            method = object.getClass().getMethod(string2, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.logException("createTarget", noSuchMethodException);
        }
        AbleUserDefinedFunction ableUserDefinedFunction = null;
        if (method != null) {
            ableUserDefinedFunction = new AbleUserDefinedFunction(string, object, method);
            this.addUserDefinedFunction(ableUserDefinedFunction);
        }
        return ableUserDefinedFunction;
    }

    public void process() throws AbleException {
        super.process();
        this.conversationManager.process();
    }

    protected void logMessage(long l, String string, String string2) {
        this.getLogger().text(l, (Object)this, string, "[" + this.getName() + "] " + string2);
    }

    protected void logException(String string, Exception exception) {
        this.getLogger().text(4L, (Object)this, string, "[" + this.getName() + "] " + exception.getLocalizedMessage());
        if (this.getTraceLogger().isLogging()) {
            this.getTraceLogger().exception(262144L, (Object)this, string, (Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

